/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.undo.UndoableEditSupport;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelIntLith;
import jsbugs.ChartJPanel;
import jsbugs.InteractiveChartJPanel;
import jsbugs.LithologyJPanel;
import jsbugs.LithologyTransfer;
import model3.Lithology;

public class LithologyTransferHandler
extends TransferHandler {
    static String lithologyMimeType = "application/x-java-jvm-local-objectref;class=model3.Lithology";
    UndoableEditSupport undoSupport = new UndoableEditSupport();

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000000;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof LithologyJPanel) {
            LithologyJPanel panel = (LithologyJPanel)c;
            if (panel.selected.getLithology() != null) {
                return new LithologyTransfer(panel.selected.getLithology());
            }
        }
        return null;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        PanelIntLith panel = this.getPanelIntLith(info);
        if (panel == null) {
            return false;
        }
        try {
            Object o = info.getTransferable().getTransferData(new DataFlavor(lithologyMimeType));
            if (o instanceof Lithology) {
                Lithology lith = (Lithology)o;
                InteractiveChartJPanel chartJPanel = (InteractiveChartJPanel)info.getComponent();
                Point2D.Float point = chartJPanel.getPoint(info.getDropLocation().getDropPoint());
                Point2D.Float panelOrigin = chartJPanel.chart.getMmPanelOrigin(panel, chartJPanel.hMode(), chartJPanel.vMode(), (float)((Point2D)point).getX());
                float ypos = (float)(((Point2D)point).getY() - panelOrigin.getY());
                if (ypos < 0.0f) {
                    return false;
                }
                switch (lith.getCmp()) {
                    case 'A': 
                    case 'S': 
                    case 'Y': {
                        return true;
                    }
                    case 'N': {
                        return panel.canInsertInterval(ypos);
                    }
                }
                assert (false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        if (!this.canImport(info)) {
            return false;
        }
        PanelIntLith panelIntLith = this.getPanelIntLith(info);
        if (panelIntLith == null) {
            return false;
        }
        try {
            Object o = info.getTransferable().getTransferData(new DataFlavor(lithologyMimeType));
            if (o instanceof Lithology) {
                Lithology lith = (Lithology)o;
                InteractiveChartJPanel chartJPanel = (InteractiveChartJPanel)info.getComponent();
                Point2D.Float point = chartJPanel.getPoint(info.getDropLocation().getDropPoint());
                Point2D.Float panelOrigin = chartJPanel.chart.getMmPanelOrigin(panelIntLith, chartJPanel.hMode(), chartJPanel.vMode(), (float)((Point2D)point).getX());
                float ypos = (float)(((Point2D)point).getY() - panelOrigin.getY());
                if (lith.isQual()) {
                    float xpos = (float)(((Point2D)point).getX() - panelOrigin.getX());
                    this.undoSupport.postEdit(panelIntLith.insertQualifier(lith, xpos, ypos));
                } else {
                    double depth = panelIntLith.getBlock().getDepth(ypos);
                    this.undoSupport.postEdit(panelIntLith.getBlock().getWell().insertInterval(lith, depth));
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private PanelIntLith getPanelIntLith(TransferHandler.TransferSupport info) {
        ChartJPanel chartPanel;
        ChartPanel panel;
        Component target = info.getComponent();
        if (target instanceof InteractiveChartJPanel && (panel = chartPanel.chart.getPanel((chartPanel = (ChartJPanel)target).getPoint(info.getDropLocation().getDropPoint()), chartPanel.hMode(), chartPanel.vMode())) instanceof PanelIntLith) {
            PanelIntLith panelIntLith = (PanelIntLith)panel;
            return panelIntLith;
        }
        return null;
    }
}

