/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import jsbchart.core.LithologyPattern;
import jsbchart.graphics.SBGraphics;
import model3.SampleLithology;

public class SampleLithologyCellRenderer
extends JPanel
implements TableCellRenderer {
    List liths = null;
    Border selectedBorder = null;
    private static final Logger LOGGER = Logger.getLogger(SampleLithologyCellRenderer.class.getName());

    @Override
    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        if (object instanceof SampleLithology) {
            this.liths = ((SampleLithology)object).getLithology();
        } else {
            LOGGER.log(Level.WARNING, "No SampleLihology object sent to renderer: " + String.valueOf(object));
        }
        if (isSelected) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(2, 0, 2, 0, table.getSelectionBackground());
            }
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(null);
        }
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.liths != null && this.liths.size() > 0) {
            AffineTransform tnf = new AffineTransform();
            tnf.scale(0.028346456587314606, 0.028346456587314606);
            ((Graphics2D)g).transform(tnf);
            boolean monochrome = false;
            boolean drawOutline = false;
            boolean noPattern = false;
            LithologyPattern.drawList(this.liths, new SBGraphics((Graphics2D)g, null, false, true), 0.0f, 0.0f, (float)this.getWidth() / 2.8346457f, (float)this.getHeight() / 2.8346457f, monochrome, drawOutline, noPattern);
        }
    }
}

