/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import jsbugs.ITaxonSelectionChangedListener;
import jsbugs.TableModelSB;
import jsbugs.TaxonOccurrenceChanges;
import jsbugs.samplesandinterps.TaxonTotalCellEditor;
import jsbugs.samplesandinterps.TaxonTotalCellRenderer;
import jsbugs.table.AnalysisTaxonTotal;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.DateRenderer;
import jsbugs.table.DepthRenderer;
import jsbugs.userconnect.SbugsSession;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.TaxonOccCountUpdate;
import model3.Well;
import model3.WellInterp;
import util.DepthUnits;
import util.SBException;

public class TableModelAnalyses
extends TableModelSB
implements ITaxonSelectionChangedListener {
    char units = (char)77;
    private static Logger log = Logger.getLogger(TableModelAnalyses.class.getName());
    private WellInterp wellInterp = null;
    static String[] columnTitles = new String[]{"Top Depth", "Base Depth", "Type", "Label", "Discipline", "Analyst", "Suite", "Split C/M/F", "Weight", "Created", "Modified", "Status", "Total Count", "Taxa", "Taxon", "Stratigraphy"};
    private static final int[] defaultColumnWidths = new int[]{30, 30, 15, 30, 40, 40, 30, 40, 20, 55, 55, 20, 20, 20, 20, 100};
    static final int COL_TOP = 0;
    static final int COL_BASE = 1;
    static final int COL_TYPE = 2;
    static final int COL_LABEL = 3;
    static final int COL_DISC = 4;
    static final int COL_ANALYST = 5;
    static final int COL_ANALYNO = 6;
    static final int COL_SPLITS = 7;
    static final int COL_WEIGHT = 8;
    static final int COL_CREATED = 9;
    static final int COL_MODIFIED = 10;
    static final int COL_STATUS = 11;
    static final int COL_TOTAL = 12;
    static final int COL_TOTAL_TAXA = 13;
    static final int COL_TOTAL_TAXON = 14;
    static final int COL_STRAT = 15;
    private List<Smpdtl> smpdtls = null;
    private Taxon currentTaxon = null;
    private boolean totExRwCv;

    void setSmpdtls(List<Smpdtl> smpdtls, Observer obs) {
        this.smpdtls = smpdtls;
        if (obs != null) {
            for (Smpdtl s : smpdtls) {
                s.addWeakObserver(obs);
            }
        }
    }

    public void setInterp(Well well, WellInterp interp, SBdb db) throws SQLException, SBException {
        this.wellInterp = interp;
        for (Sample sample : well.getSamples()) {
            sample.getStratigraphy(this.wellInterp, true);
        }
    }

    List<Smpdtl> getSmpdtls() {
        return this.smpdtls;
    }

    @Override
    public String getColumnName(int col) {
        return columnTitles[col] + (String)(switch (col) {
            case 0, 1 -> " (" + DepthUnits.getUnits((char)this.units).getAbr() + ")";
            default -> "";
        });
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.smpdtls == null) {
            return "";
        }
        Smpdtl smpdtl = this.smpdtls.get(row);
        switch (col) {
            case 4: {
                return SBdb.getDiscAbr(smpdtl.getDiscID());
            }
            case 6: {
                return "" + smpdtl.getAnalyNo();
            }
            case 5: {
                try {
                    return smpdtl.getAnalystAbr();
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            case 10: {
                Date modified = null;
                if (smpdtl.getModified() != null && !smpdtl.getModified().equals(smpdtl.getCreated())) {
                    modified = smpdtl.getModified();
                    return modified;
                }
                return modified;
            }
            case 9: {
                Date created = smpdtl.getCreated();
                return created;
            }
            case 0: {
                if (smpdtl.getSample().hasTopDepth()) {
                    return smpdtl.getSample().getTopDepth(this.units);
                }
                return null;
            }
            case 1: {
                if (smpdtl.getSample().hasBaseDepth()) {
                    return smpdtl.getSample().getBaseDepth(this.units);
                }
                return null;
            }
            case 2: {
                return smpdtl.getSample().getType().getAbr();
            }
            case 3: {
                Object label = smpdtl.getSample().getLabel();
                if (smpdtl.getLabel() != null && !smpdtl.getLabel().isBlank()) {
                    if (!((String)label).isBlank()) {
                        label = (String)label + "/";
                    }
                    label = (String)label + smpdtl.getLabel();
                }
                return label;
            }
            case 11: {
                return smpdtl.getAnalysisType().getString();
            }
            case 7: {
                if (smpdtl.getCoarse() > 0.0f || smpdtl.getMedium() > 0.0f || smpdtl.getFine() > 0.0f) {
                    Object split = "";
                    split = smpdtl.getCoarse() - (float)((int)smpdtl.getCoarse()) > 0.0f ? (String)split + smpdtl.getCoarse() : (String)split + (int)smpdtl.getCoarse();
                    split = (String)split + "/";
                    split = smpdtl.getMedium() - (float)((int)smpdtl.getMedium()) > 0.0f ? (String)split + smpdtl.getMedium() : (String)split + (int)smpdtl.getMedium();
                    split = (String)split + "/";
                    split = smpdtl.getFine() - (float)((int)smpdtl.getFine()) > 0.0f ? (String)split + smpdtl.getFine() : (String)split + (int)smpdtl.getFine();
                    return split;
                }
                return "";
            }
            case 8: {
                if (smpdtl.getWeight() > 0.0f) {
                    return Float.valueOf(smpdtl.getWeight());
                }
                return null;
            }
            case 12: {
                return smpdtl.getTotalCount(this.totExRwCv);
            }
            case 13: {
                return smpdtl.getNOccs();
            }
            case 14: {
                if (this.currentTaxon == null) {
                    return null;
                }
                return new AnalysisTaxonTotal(smpdtl, this.currentTaxon, this.getOccurrencesForTaxon(this.currentTaxon, smpdtl), this.getAnalysisAbundanceScheme(smpdtl));
            }
            case 15: {
                try {
                    return smpdtl.getSample().getStratigraphy(this.wellInterp, false);
                }
                catch (Exception ex) {
                    return ex.getMessage();
                }
            }
        }
        return null;
    }

    public List<TaxonOcc> getOccurrencesForTaxon(Taxon taxon, Smpdtl smpdtl) {
        ArrayList<TaxonOcc> occs = new ArrayList<TaxonOcc>();
        for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
            if (taxon.getSpecID() != occ.getSpecID()) continue;
            occs.add(occ);
        }
        return occs;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return Double.class;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 15: {
                return String.class;
            }
            case 14: {
                return AnalysisTaxonTotal.class;
            }
            case 6: {
                return String.class;
            }
            case 9: 
            case 10: {
                return Date.class;
            }
            case 8: {
                return Float.class;
            }
            case 12: 
            case 13: 
        }
        return Integer.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Smpdtl smpdtl = this.smpdtls.get(rowIndex);
        switch (columnIndex) {
            case 14: {
                SbugsSession.getSession();
                SBdb db = SbugsSession.getDb();
                boolean canWrite = false;
                try {
                    canWrite = db.getWell(smpdtl.getSample().getWellID()).canWrite(db, null);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Error checking if user can write to well " + smpdtl.getSample().getWellID(), ex);
                }
                if (canWrite) {
                    return this.getValueAt(rowIndex, columnIndex) != null;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 14: {
                if (this.smpdtls == null) {
                    return;
                }
                try {
                    Smpdtl smpdtl = this.smpdtls.get(rowIndex);
                    if (!(aValue instanceof TaxonOccurrenceChanges)) break;
                    TaxonOccurrenceChanges changes = (TaxonOccurrenceChanges)aValue;
                    for (TaxonOcc toDelete : changes.getDeletions()) {
                        smpdtl.deleteOcc(smpdtl.getSample().getWellID(), toDelete);
                    }
                    for (TaxonOcc.Builder builder : changes.getAdditions()) {
                        smpdtl.insertOccurrence(builder, smpdtl.getSample().getWellID());
                    }
                    for (TaxonOccCountUpdate update : changes.getCountUpdates()) {
                        smpdtl.updateOcc(smpdtl.getSample().getWellID(), update.getOriginal(), update.getOriginal().getSituation(), update.getOriginal().getQuestionable(), update.getOriginal().getSpecType(), update.getOriginal().isMarker(), update.getCoarse(), update.getMedium(), update.getFine(), update.getAbund(), update.getOriginal().getPreservation(), update.getOriginal().getColour(), update.getOriginal().getComment(), update.getOriginal().getImageSetID());
                    }
                    SbugsSession.getDb().commit();
                    smpdtl.notifyObservers();
                    break;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Exception occurred while adding occurrence to analysis.", e);
                }
            }
        }
    }

    private AbundanceScheme getAnalysisAbundanceScheme(Smpdtl analysis) {
        AbundanceScheme abundanceScheme = null;
        int abundanceSchemeId = analysis.getHeader().getAbnSchID();
        try {
            SbugsSession.getSession();
            abundanceScheme = SbugsSession.getDb().getAbundanceSchemeService().findAbundanceScheme(abundanceSchemeId).orElse(null);
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "A database error occurred while trying to retrieve the abundance scheme id " + abundanceSchemeId, e);
        }
        return abundanceScheme;
    }

    @Override
    public int getRowCount() {
        if (this.smpdtls == null) {
            return 0;
        }
        return this.smpdtls.size();
    }

    @Override
    public void setupTable(JTable jTableAnalyses, SBdb sbdb) {
        this.init(jTableAnalyses, sbdb);
        jTableAnalyses.getColumnModel().getColumn(0).setCellRenderer(new DepthRenderer());
        jTableAnalyses.getColumnModel().getColumn(1).setCellRenderer(new DepthRenderer());
        jTableAnalyses.getColumnModel().getColumn(9).setCellRenderer(new DateRenderer());
        jTableAnalyses.getColumnModel().getColumn(10).setCellRenderer(new DateRenderer());
        jTableAnalyses.getColumnModel().getColumn(15).setCellRenderer(new ColouredRenderer(true, new Color(220, 220, 220)));
        jTableAnalyses.setDefaultRenderer(AnalysisTaxonTotal.class, new TaxonTotalCellRenderer());
        jTableAnalyses.setDefaultEditor(AnalysisTaxonTotal.class, new TaxonTotalCellEditor());
        jTableAnalyses.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.restoreColumnOrder(jTableAnalyses);
    }

    @Override
    public String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    public String getPrefString() {
        return "TMANALYSES";
    }

    @Override
    public String getPrefOrderString() {
        return "TOANALYSES";
    }

    @Override
    public final String getAutoResizeString() {
        return "TARANALYSE";
    }

    void setTotExRwCv(boolean b) {
        this.totExRwCv = b;
    }

    @Override
    public void selectedTaxonChanged(Taxon taxon) {
        this.currentTaxon = taxon;
        if (this.getRowCount() > 0) {
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        }
    }

    public Taxon getCurrentTaxon() {
        return this.currentTaxon;
    }
}

