/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import javax.swing.table.AbstractTableModel;
import model3.Casing;
import model3.CasingPoint;
import util.DepthUtils;
import util.MatchData;
import util.SBException;
import util.status.DoubleStatus;
import util.status.SbugsStatus;
import util.status.StringStatus;

class TableModelMatchCasing
extends AbstractTableModel {
    static final int COL_DONOR_DEPTH = 0;
    static final int COL_DONOR_DIAM = 1;
    static final int COL_ARROW = 2;
    static final int COL_HOST_DEPTH = 3;
    static final int COL_HOST_DIAM = 4;
    static final String[] colTitles = new String[]{"Depth", "Diam", "", "Depth", "Diam"};
    static final int[] colWidths = new int[]{30, 40, 20, 30, 40};
    char units;
    MatchData data = new MatchData();

    TableModelMatchCasing() {
    }

    void init(Casing ws, Casing db) throws SBException, SQLException {
        this.data.init(ws.getList(), db != null ? db.getList() : null);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        CasingPoint ws = (CasingPoint)pair.getWs();
        CasingPoint db = (CasingPoint)pair.getDb();
        switch (columnIndex) {
            case 0: {
                return ws != null ? new DoubleStatus(Double.valueOf(DepthUtils.convFromM((double)ws.getDepth(), (char)this.units)), ws.getStatus()) : null;
            }
            case 1: {
                return ws != null ? ws : null;
            }
            case 2: {
                return ws != null && db != null && ws.getStatus() == SbugsStatus.STORED;
            }
            case 3: {
                return db != null ? Double.valueOf(DepthUtils.convFromM((double)db.getDepth(), (char)this.units)) : null;
            }
            case 4: {
                return db != null ? db.toString() : null;
            }
        }
        return "";
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return DoubleStatus.class;
            }
            case 1: {
                return StringStatus.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return String.class;
            }
            default: {
                return CasingPoint.class;
            }
            case 2: 
        }
        return Boolean.class;
    }
}

