/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.TableUtils;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.table.ArrowCellRenderer;
import model3.IGDInterval;
import model3.IGDScheme;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

class TableModelMatchIGD
extends AbstractTableModel {
    static final int COL_DONOR_TYPE = 0;
    static final int COL_DONOR_SCHEME = 1;
    static final int COL_ARROW = 2;
    static final int COL_HOST_SCHEME = 3;
    static final String[] colTitles = new String[]{"Type", "Scheme", "", " Matching Scheme"};
    static final int[] colWidths = new int[]{60, 100, 20, 100};
    List<IGDScheme> list = new LinkedList<IGDScheme>();

    TableModelMatchIGD() {
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IGDScheme scheme = this.list.get(rowIndex);
        try {
            switch (columnIndex) {
                case 0: {
                    return new StringStatus(IGDInterval.getIGDName(scheme.getIGDType()), scheme.getStatus());
                }
                case 1: {
                    return new StringStatus(scheme.toString(), scheme.getStatus());
                }
                case 2: {
                    return scheme.getLink() != null;
                }
                case 3: {
                    return scheme.getLink();
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    @Override
    public void setValueAt(Object object, int rowIndex, int columnIndex) {
        IGDScheme scheme = this.list.get(rowIndex);
        try {
            switch (columnIndex) {
                default: 
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return StringStatus.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return IGDScheme.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    void setUpTable(JTable table) {
        TableUtils.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        columnModel.getColumn(2).setMaxWidth(colWidths[2]);
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        table.getTableHeader().setReorderingAllowed(false);
    }
}

