/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.ComboCellRenderer;
import jsbugs.LithologyCellRenderer;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.ColourRenderer;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.Lithology;
import model3.LithostratUnit;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import util.MatchData;
import util.SB;
import util.SBException;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

class TableModelMatchIGDSchemeUnits
extends AbstractTableModel {
    static final int COL_DONOR_UNIT = 0;
    static final int COL_DONOR_HIER = 1;
    static final int COL_DONOR_TOP = 2;
    static final int COL_DONOR_TOP_REF = 3;
    static final int COL_DONOR_TOP_CONF = 4;
    static final int COL_DONOR_BASE = 5;
    static final int COL_DONOR_BASE_REF = 6;
    static final int COL_DONOR_BASE_CONF = 7;
    static final int COL_DONOR_ABR = 8;
    static final int COL_DONOR_LITH = 9;
    static final int COL_DONOR_COLOUR = 10;
    static final int COL_DONOR_COMMENTS = 11;
    static final int COL_ARROW = 12;
    static final int COL_HOST_UNIT = 13;
    static final int COL_HOST_HIER = 14;
    static final int COL_HOST_TOP = 15;
    static final int COL_HOST_TOP_REF = 16;
    static final int COL_HOST_TOP_CONF = 17;
    static final int COL_HOST_BASE = 18;
    static final int COL_HOST_BASE_REF = 19;
    static final int COL_HOST_BASE_CONF = 20;
    static final int COL_HOST_ABR = 21;
    static final int COL_HOST_LITH = 22;
    static final int COL_HOST_COLOUR = 23;
    static final int COL_HOST_COMMENTS = 24;
    static final int COL_HOST_OCCS = 25;
    static final String[] colTitles = new String[]{"Unit", "Hierarchy", "Youngest", "", "Confidence", "Oldest", "", "Confidence", "Abr.", "Lithology", "Colour", "Comments", "", "Unit", "Hierarchy", "Youngest", "", "Confidence", "Oldest", "", "Confidence", "Abr.", "Lithology", "Colour", "Comments", "Occs"};
    static final int[] colWidths = new int[]{100, 60, 50, 30, 30, 50, 30, 30, 30, 20, 20, 30, 20, 100, 60, 50, 30, 30, 50, 30, 30, 30, 20, 20, 30, 20};
    IGDScheme scheme;
    private MatchData<IGDUnitBase> data;
    private List<IGDUnitBase> list;

    TableModelMatchIGDSchemeUnits() {
    }

    @Override
    public int getRowCount() {
        if (this.data != null) {
            return this.data.size();
        }
        if (this.list != null) {
            return this.list.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    public void clearData() {
        this.data = null;
        this.list = null;
        this.scheme = null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IGDUnitBase db;
        IGDUnitBase ws;
        if (this.data != null) {
            MatchData.MatchPair pair = this.data.get(rowIndex);
            if (pair == null) {
                return "";
            }
            ws = (IGDUnitBase)pair.getWs();
            db = (IGDUnitBase)pair.getDb();
        } else {
            ws = this.list.get(rowIndex);
            db = ws.getLink();
        }
        try {
            switch (columnIndex) {
                case 0: {
                    return ws != null ? new StringStatus(ws.getName(), ws.getStatus()) : null;
                }
                case 1: {
                    return ws != null ? new StringStatus(IGDIntervalZone.getHierName(this.scheme.getIGDType(), ws.getHier()), ws.getStatus()) : null;
                }
                case 2: 
                case 5: {
                    if (ws != null) {
                        Object s;
                        if (ws instanceof LithostratUnit) {
                            int address = columnIndex == 2 ? 0 : 3;
                            s = (float)((LithostratUnit)ws).getAge(address) + "/" + (int)(((LithostratUnit)ws).getX(address) * 100.0f);
                        } else {
                            s = columnIndex == 2 ? (ws.getUage() != null ? SB.floatString((double)ws.getUage(), (int)3) : "") : (ws.getLage() != null ? SB.floatString((double)ws.getLage(), (int)3) : "");
                        }
                        return new StringStatus((String)s, ws.getStatus());
                    }
                    return null;
                }
                case 3: 
                case 6: {
                    if (ws != null) {
                        if (ws instanceof IGDUnit) {
                            int ref = ((IGDUnit)ws).getAgeRef(columnIndex == 3);
                            if (ref > 0) {
                                return new StringStatus(((IGDUnit)ws).getAgePercent(columnIndex == 3) + "%...", ws.getStatus());
                            }
                        } else if (ws instanceof LithostratUnit) {
                            int address = columnIndex == 3 ? 1 : 2;
                            String s = (float)((LithostratUnit)ws).getAge(address) + "/" + (int)(((LithostratUnit)ws).getX(address) * 100.0f);
                            return new StringStatus(s, ws.getStatus());
                        }
                        return new StringStatus("", ws.getStatus());
                    }
                    return null;
                }
                case 4: 
                case 7: {
                    Boundary bnd;
                    if (ws != null) {
                        if (ws instanceof IGDUnit) {
                            return new StringStatus(((IGDUnit)ws).getConfidence(columnIndex == 4).toString(), ws.getStatus());
                        }
                        if (ws instanceof LithostratUnit) {
                            bnd = columnIndex == 4 ? ((LithostratUnit)ws).getUBnd() : ((LithostratUnit)ws).getLBnd();
                            return new StringStatus(bnd.toString(), ws.getStatus());
                        }
                        return new StringStatus("", ws.getStatus());
                    }
                    return null;
                }
                case 9: {
                    if (ws != null && ws instanceof LithostratUnit) {
                        return ((LithostratUnit)ws).getLithology();
                    }
                    return null;
                }
                case 10: {
                    return ws != null ? ws.getColour() : null;
                }
                case 8: {
                    return ws != null ? new StringStatus(ws.getAbr() != null ? ws.getAbr() : "", ws.getStatus()) : null;
                }
                case 11: {
                    if (ws instanceof IGDUnit) {
                        return new StringStatus(((IGDUnit)ws).getComments() != null ? ((IGDUnit)ws).getComments() : "", ws.getStatus());
                    }
                    return null;
                }
                case 12: {
                    return ws != null && db != null;
                }
                case 13: {
                    return db != null ? db.getName() : null;
                }
                case 21: {
                    return db != null ? db.getAbr() : "";
                }
                case 24: {
                    if (db instanceof IGDUnit) {
                        return ((IGDUnit)db).getComments();
                    }
                    return "";
                }
                case 14: {
                    return db != null ? IGDIntervalZone.getHierName(this.scheme.getIGDType(), db.getHier()) : null;
                }
                case 15: 
                case 18: {
                    if (db != null) {
                        if (db instanceof LithostratUnit) {
                            int address = columnIndex == 15 ? 0 : 3;
                            return (float)((LithostratUnit)db).getAge(address) + "/" + (int)(((LithostratUnit)db).getX(address) * 100.0f);
                        }
                        if (columnIndex == 15) {
                            return db.getUage() != null ? SB.floatString((double)db.getUage(), (int)3) : "";
                        }
                        return db.getLage() != null ? SB.floatString((double)db.getLage(), (int)3) : "";
                    }
                    return null;
                }
                case 16: 
                case 19: {
                    if (db != null) {
                        if (db instanceof IGDUnit) {
                            int ref = ((IGDUnit)db).getAgeRef(columnIndex == 16);
                            if (ref > 0) {
                                return ((IGDUnit)db).getAgePercent(columnIndex == 16) + "%...";
                            }
                        } else if (db instanceof LithostratUnit) {
                            int address = columnIndex == 16 ? 1 : 2;
                            return (float)((LithostratUnit)db).getAge(address) + "/" + (int)(((LithostratUnit)db).getX(address) * 100.0f);
                        }
                    }
                    return null;
                }
                case 17: 
                case 20: {
                    Boundary bnd;
                    if (db != null) {
                        if (db instanceof IGDUnit) {
                            return ((IGDUnit)db).getConfidence(columnIndex == 17).toString();
                        }
                        if (db instanceof LithostratUnit) {
                            bnd = columnIndex == 17 ? ((LithostratUnit)db).getUBnd() : ((LithostratUnit)db).getLBnd();
                            return bnd.toString();
                        }
                    }
                    return null;
                }
                case 23: {
                    return db != null ? db.getColour() : null;
                }
                case 25: {
                    return db != null ? Integer.valueOf(db.getNoccs(false)) : null;
                }
                case 22: {
                    if (db != null && db instanceof LithostratUnit) {
                        return ((LithostratUnit)db).getLithology();
                    }
                    return null;
                }
            }
            return "";
        }
        catch (SQLException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                return StringStatus.class;
            }
            case 12: {
                return Boolean.class;
            }
            case 10: 
            case 23: {
                return Color.class;
            }
            default: {
                return String.class;
            }
            case 9: 
            case 22: {
                return Lithology.class;
            }
            case 25: 
        }
        return Integer.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.data != null) {
            return false;
        }
        switch (column) {
            case 13: {
                return this.scheme.getLink() != null;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.data != null) {
            return;
        }
        switch (col) {
            case 13: {
                try {
                    IGDUnitBase selected = this.list.get(row);
                    IGDUnitBase unit = (IGDUnitBase)obj;
                    selected.setLink(unit, this.scheme.getUnitBases());
                    this.scheme.updateStatus();
                    this.scheme.notifyObservers();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    void setUpTable(JTable table, int igdType, JComboBox combo) {
        TableUtils.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        columnModel.getColumn(12).setMaxWidth(colWidths[12]);
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Color.class, new ColourRenderer(true));
        table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        table.setDefaultRenderer(Lithology.class, new LithologyCellRenderer());
        table.getTableHeader().setReorderingAllowed(false);
        if (combo != null) {
            columnModel.getColumn(13).setCellEditor(new DefaultCellEditor(combo));
            columnModel.getColumn(13).setCellRenderer(new ComboCellRenderer());
        }
        block13: for (int i = 0; i < colTitles.length; ++i) {
            switch (i) {
                case 10: 
                case 23: {
                    columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
                    columnModel.getColumn(i).setHeaderValue(igdType == 26 ? "Polarity" : colTitles[i]);
                    break;
                }
                case 9: 
                case 22: {
                    if (igdType != 2) {
                        columnModel.getColumn(i).setMinWidth(0);
                        columnModel.getColumn(i).setPreferredWidth(0);
                        columnModel.getColumn(i).setMaxWidth(0);
                        break;
                    }
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 25: {
                    if (igdType == 26) {
                        columnModel.getColumn(i).setMinWidth(0);
                        columnModel.getColumn(i).setPreferredWidth(0);
                        columnModel.getColumn(i).setMaxWidth(0);
                        break;
                    }
                }
                default: {
                    columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
                    columnModel.getColumn(i).setHeaderValue(colTitles[i]);
                }
            }
            if (igdType != 2) continue;
            switch (i) {
                case 4: 
                case 17: {
                    columnModel.getColumn(i).setHeaderValue("Youngest Boundary");
                    continue block13;
                }
                case 7: 
                case 20: {
                    columnModel.getColumn(i).setHeaderValue("Oldest Boundary");
                    continue block13;
                }
                case 2: 
                case 15: {
                    columnModel.getColumn(i).setHeaderValue("Youngest W");
                    continue block13;
                }
                case 5: 
                case 18: {
                    columnModel.getColumn(i).setHeaderValue("Oldest W");
                    continue block13;
                }
                case 3: 
                case 16: {
                    columnModel.getColumn(i).setHeaderValue("Youngest E");
                    continue block13;
                }
                case 6: 
                case 19: {
                    columnModel.getColumn(i).setHeaderValue("Oldest E");
                }
            }
        }
    }

    void initData(List<IGDUnitBase> ws, List<IGDUnitBase> db) throws SBException, SQLException {
        if (this.list != null) {
            throw new IllegalStateException("Misuse of table model");
        }
        this.data = new MatchData();
        this.data.init(ws, db);
    }

    IGDUnitBase getData(int row, boolean ws) {
        return (IGDUnitBase)(ws ? this.data.get(row).getWs() : this.data.get(row).getDb());
    }

    List<IGDUnitBase> getList() {
        return this.list;
    }

    void setUnits(JDialog parent, IGDScheme scheme, SBdb ws) throws SBException, SQLException {
        if (this.data != null) {
            throw new IllegalStateException("Misuse of table model");
        }
        if (this.list == null) {
            this.list = new LinkedList<IGDUnitBase>();
        }
        this.list.clear();
        int igdType = scheme.getIGDType();
        if (igdType == 0) {
            throw new IllegalStateException("IGD type 0 in units table setup");
        }
        if (scheme == null) {
            throw new IllegalStateException("No workspace scheme available for this data type: " + igdType);
        }
        this.scheme = scheme;
        for (IGDUnitBase unit : scheme.getUnitBases()) {
            unit.setNoccs(0);
        }
        Iterator<Well> it = ws.getWellIterator();
        boolean warnUnits = false;
        while (it.hasNext()) {
            Well well = it.next();
            Iterator<WellInterp> iit = well.getInterpIterator();
            while (iit.hasNext()) {
                WellInterp interp = iit.next();
                for (IGDIntervalZone zone : interp.getIGDList(igdType, scheme.getID())) {
                    int lowUnit;
                    int uppUnit = zone.getUppZone();
                    if (uppUnit > 0) {
                        IGDUnitBase unit = scheme.findUnitBase(uppUnit);
                        if (unit != null) {
                            unit.setNoccs(unit.getNoccs(false) + 1);
                            if (!this.list.contains(unit)) {
                                this.list.add(unit);
                            }
                        } else {
                            System.out.println("Unit null for unit ID: " + uppUnit + " zone: " + String.valueOf(zone));
                            zone.setUppZone(0);
                            warnUnits = true;
                        }
                    }
                    if ((lowUnit = zone.getLowZone()) <= 0 || lowUnit == uppUnit) continue;
                    IGDUnitBase unit = scheme.findUnitBase(lowUnit);
                    if (unit != null) {
                        unit.setNoccs(unit.getNoccs(false) + 1);
                        if (this.list.contains(unit)) continue;
                        this.list.add(unit);
                        continue;
                    }
                    System.out.println("Unit null for unit ID: " + lowUnit + " zone: " + String.valueOf(zone));
                    zone.setLowZone(0);
                    warnUnits = true;
                }
            }
        }
        scheme.updateStatus();
        if (warnUnits) {
            JOptionPane.showMessageDialog(parent, "Warning: units found in some well intervals which are not found in scheme assigned to them.\nUnit/Scheme linkage ignored in these cases.", parent.getTitle(), 2);
        }
    }
}

