/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.table.AbstractTableModel;
import model3.Sample;
import util.DepthUtils;
import util.MatchData;
import util.status.DoubleStatus;
import util.status.StringStatus;

class TableModelMatchSamples
extends AbstractTableModel {
    static final int COL_DONOR_TOP = 0;
    static final int COL_DONOR_BASE = 1;
    static final int COL_DONOR_TYPE = 2;
    static final int COL_DONOR_LABEL = 3;
    static final int COL_ARROW = 4;
    static final int COL_HOST_TOP = 5;
    static final int COL_HOST_BASE = 6;
    static final int COL_HOST_TYPE = 7;
    static final int COL_HOST_LABEL = 8;
    static final String[] colTitles = new String[]{"Top", "Base", "Type", "Label", "", "Top", "Base", "Type", "Label"};
    static final int[] colWidths = new int[]{30, 30, 30, 40, 20, 30, 30, 30, 40};
    char units = (char)77;
    char wellType = (char)87;
    MatchData data = new MatchData();
    static final Boolean linked = true;
    static final Boolean unlinked = false;

    TableModelMatchSamples() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        Sample ws = (Sample)pair.getWs();
        Sample db = (Sample)pair.getDb();
        try {
            switch (columnIndex) {
                case 0: {
                    if (ws == null || ws.getTopDepth() == null) {
                        return null;
                    }
                    return new DoubleStatus(Double.valueOf(DepthUtils.convFromM((double)ws.getTopDepth(), (char)this.units, (char)this.wellType)), ws.getStatus());
                }
                case 1: {
                    if (ws == null || ws.getBaseDepth() == null) {
                        return null;
                    }
                    return new DoubleStatus(Double.valueOf(DepthUtils.convFromM((double)ws.getBaseDepth(), (char)this.units, (char)this.wellType)), ws.getStatus());
                }
                case 2: {
                    return ws == null ? null : new StringStatus(ws.getType().getAbr(), ws.getStatus());
                }
                case 3: {
                    return ws == null ? null : new StringStatus(ws.getLabel(), ws.getStatus());
                }
                case 4: {
                    return ws != null && db != null && ws.getStatus() == Sample.STORED ? linked : unlinked;
                }
                case 5: {
                    return db != null && db.hasTopDepth() ? Double.valueOf(db.getTopDepth(this.units)) : null;
                }
                case 6: {
                    return db != null && db.hasBaseDepth() ? Double.valueOf(db.getBaseDepth(this.units)) : null;
                }
                case 7: {
                    return db == null ? null : db.getType().getAbr();
                }
                case 8: {
                    return db == null ? null : db.getLabel();
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return DoubleStatus.class;
            }
            case 2: 
            case 3: {
                return StringStatus.class;
            }
            case 4: {
                return Boolean.class;
            }
            case 5: 
            case 6: {
                return Double.class;
            }
        }
        return String.class;
    }
}

