/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.ComboCellRenderer;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.Lastval;
import model3.ODMReader;
import model3.SBdb;
import util.SB;
import util.SBException;

class TableModelODMMap
extends AbstractTableModel {
    ODMReader odmReader = null;
    SBdb db;
    String[] colTitles = new String[]{"IC Type", "Column name", "StrataBugs type & level"};
    final int[] colWidths = new int[]{30, 30, 80};
    final int COL_ODMTYPE = 0;
    final int COL_ODMNAME = 1;
    final int COL_SBUGSTYPE = 2;
    JComboBox dataTypeComboBox = null;
    final String NONE_STRING = "<None>";
    List<ComboEntry> comboEntries = new LinkedList<ComboEntry>();

    TableModelODMMap() {
    }

    @Override
    public int getRowCount() {
        if (this.odmReader == null) {
            return 0;
        }
        if (this.odmReader.metadata == null) {
            return 0;
        }
        return this.odmReader.metadata.size();
    }

    @Override
    public int getColumnCount() {
        return this.colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.odmReader == null) {
            return null;
        }
        ODMReader.ODMMetadataEntry entry = this.odmReader.metadata.get(rowIndex);
        if (entry == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return entry.getODMTableDescrip();
            }
            case 1: {
                return entry.getODMColumnDescrip();
            }
            case 2: {
                return entry.getSbugsName();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.odmReader == null) {
            return;
        }
        ODMReader.ODMMetadataEntry entry = this.odmReader.metadata.get(row);
        if (entry == null) {
            return;
        }
        switch (col) {
            case 2: {
                try {
                    if (obj instanceof String) {
                        String dataType = (String)obj;
                        if (!dataType.equals("<None>")) break;
                        entry.setSbugsName("");
                        break;
                    }
                    this.setSbugsColumnData(entry, (ComboEntry)obj);
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            default: 
        }
        return String.class;
    }

    void setupTable(JTable jTable) throws SBException {
        SB.setTableHeaderBold((JTable)jTable);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(this.colTitles[i]);
            jTable.getColumnModel().getColumn(i).setPreferredWidth(this.colWidths[i]);
        }
        TableColumnModel model = jTable.getColumnModel();
        this.setupCombo();
        model.getColumn(2).setCellEditor(new DefaultCellEditor(this.dataTypeComboBox));
        model.getColumn(2).setCellRenderer(new ComboCellRenderer());
        this.dataTypeComboBox = new JComboBox();
    }

    void setupCombo() throws SBException {
        for (String igdTypeString : IGDInterval.igdTypes) {
            int igdType = IGDInterval.getIGDType(igdTypeString);
            if (igdType > 0 && igdType != 10) {
                int nHier = IGDIntervalZone.getNHier(igdType, true);
                for (int i = 1; i <= nHier; ++i) {
                    Object entry = igdTypeString;
                    entry = (String)entry + " - " + IGDIntervalZone.getHierName(igdType, i);
                    this.comboEntries.add(new ComboEntry(this, (String)entry, IGDInterval.igdType2dType(igdType), igdType, i));
                }
                continue;
            }
            if (igdTypeString.equals("Biostratigraphic Comments")) {
                block8: for (Discipline disc : Discipline.values()) {
                    Object entry = igdTypeString;
                    entry = (String)entry + " - " + disc.getNoun();
                    switch (disc.getChar()) {
                        case 'M': {
                            this.comboEntries.add(new ComboEntry(this, (String)entry, 3, igdType, 0));
                            continue block8;
                        }
                        case 'N': {
                            this.comboEntries.add(new ComboEntry(this, (String)entry, 5, igdType, 1));
                            continue block8;
                        }
                        case 'P': {
                            this.comboEntries.add(new ComboEntry(this, (String)entry, 7, igdType, 2));
                            continue block8;
                        }
                        case 'A': {
                            this.comboEntries.add(new ComboEntry(this, (String)entry, 9, igdType, 3));
                        }
                    }
                }
                continue;
            }
            if (igdTypeString.equals("Interpreted Lithology")) {
                this.comboEntries.add(new ComboEntry(this, igdTypeString, 21, 12, 0));
                continue;
            }
            if (igdTypeString.equals("Events")) {
                this.comboEntries.add(new ComboEntry(this, igdTypeString, 16, 20, 0));
                continue;
            }
            if (igdType == 10) continue;
            System.out.println("No IGDtype for: " + igdTypeString);
            this.comboEntries.add(new ComboEntry(this, igdTypeString, 0, 0, 0));
        }
        this.dataTypeComboBox = new JComboBox();
        this.dataTypeComboBox.addItem("<None>");
        for (ComboEntry entry : this.comboEntries) {
            this.dataTypeComboBox.addItem(entry);
        }
        this.dataTypeComboBox.setMaximumRowCount(30);
    }

    private void setSbugsColumnData(ODMReader.ODMMetadataEntry entry, ComboEntry comboEntry) throws SBException {
        entry.setSbugsName(comboEntry.sbugsName);
        entry.setDtype(comboEntry.dType);
        entry.setIgdType(comboEntry.igdType);
        entry.setHier(comboEntry.hier);
    }

    void setOdmReader(ODMReader odmReader) throws SQLException {
        this.odmReader = odmReader;
        int nEntries = Lastval.getInt(this.db, "ODM2SBNN");
        for (int n = 1; n <= nEntries; ++n) {
            String[] entries;
            String entryString = Lastval.getString(this.db, "ODM2SB" + n);
            if (entryString == null || entryString.isEmpty() || (entries = entryString.split("[|]")).length != 5) continue;
            int odmDataType = Integer.parseInt(entries[0]);
            int odmTableID = Integer.parseInt(entries[1]);
            block1: for (ODMReader.ODMMetadataEntry e : odmReader.metadata) {
                ODMReader.ODMMetadataEntry entry = e;
                if (entry.getODMDataType() != odmDataType || entry.getODMTableID() != odmTableID) continue;
                entry.setDtype(Integer.parseInt(entries[2]));
                entry.setIgdType(Integer.parseInt(entries[3]));
                entry.setHier(Integer.parseInt(entries[4]));
                for (ComboEntry comboEntry : this.comboEntries) {
                    if (comboEntry.dType != entry.getDtype() || comboEntry.hier != entry.getHier() || comboEntry.igdType != entry.getIgdType()) continue;
                    entry.setSbugsName(comboEntry.sbugsName);
                    continue block1;
                }
            }
        }
    }

    class ComboEntry {
        String sbugsName;
        int dType;
        int igdType;
        int hier;

        ComboEntry(TableModelODMMap this$0, String s, int d, int i, int h) {
            Objects.requireNonNull(this$0);
            this.sbugsName = s;
            this.dType = d;
            this.igdType = i;
            this.hier = h;
        }

        public String toString() {
            return this.sbugsName;
        }
    }
}

