/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.analysis.Situation;
import java.awt.Color;
import java.awt.Component;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.TableModelSB;
import jsbugs.table.CountRenderer;
import jsbugs.table.ImageIconRenderer;
import jsbugs.table.MarkerRenderer;
import jsbugs.table.cell.renderer.PercentageFillCellRenderer;
import jsbugs.uiutil.ImageCacheTooltip;
import jsbugs.uiutil.icon.IconFactory;
import model3.SBdb;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.Well;

public class TableModelOccurrences
extends TableModelSB {
    private static final Logger LOGGER = Logger.getLogger(TableModelOccurrences.class.getName());
    static final String[] columnTitles = new String[]{"Mkr?", "Cat.", "Image", "Name", "Code", "Situation", "?", "Abund.", "Coarse", "Medium", "Fine", "Total", "Type", "Preserv.", "Colour", "Comments", "Ratio"};
    private static final int[] defaultColumnWidths = new int[]{10, 20, 20, 120, 30, 10, 10, 20, 20, 20, 20, 20, 40, 50, 20, 70, 20};
    static final int COL_MARKER = 0;
    static final int COL_CAT = 1;
    static final int COL_IMAGE = 2;
    static final int COL_NAME = 3;
    static final int COL_ALPHACODE = 4;
    static final int COL_SITU = 5;
    static final int COL_QUESTION = 6;
    static final int COL_ABUND = 7;
    static final int COL_COARSE = 8;
    static final int COL_MEDIUM = 9;
    static final int COL_FINE = 10;
    static final int COL_AGG = 11;
    static final int COL_SPECTYPE = 12;
    static final int COL_PRESERV = 13;
    static final int COL_COLOUR = 14;
    static final int COL_COMMENTS = 15;
    static final int COL_PERCENTAGE = 16;
    private ImageCacheTooltip imageTooltip;
    Smpdtl smpdtl = null;
    Well well = null;
    boolean splits = false;
    private boolean logging = false;
    final UndoableEditSupport undoSupport = new UndoableEditSupport();
    LinkedList<TaxonOcc.Builder> unsaved = null;

    @Override
    public String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    String[] getColumnTitles(JTable table) {
        Object titles = "";
        for (int i = 0; i < columnTitles.length; ++i) {
            titles = (String)titles + String.valueOf(table.getColumnModel().getColumn(table.convertColumnIndexToModel(i)).getHeaderValue()) + ",";
        }
        return ((String)titles).split(",");
    }

    @Override
    public final String getPrefString() {
        return "TMOCCURREN";
    }

    @Override
    public final String getPrefOrderString() {
        return "TOOCCURREN";
    }

    @Override
    public final String getAutoResizeString() {
        return "TAROCCUR";
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    public void addUnsaved(TaxonOcc.Builder occ) {
        if (this.unsaved == null) {
            this.unsaved = new LinkedList();
        }
        this.unsaved.add(occ);
    }

    public void setLogging(boolean logging, JTable table) {
        if (logging != this.logging) {
            this.logging = logging;
            this.setSplits(table, this.splits);
        }
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.smpdtl == null) {
            return 0;
        }
        return this.smpdtl.getNOccs() + (this.unsaved != null ? this.unsaved.size() : 0);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object fss;
        if (this.smpdtl == null) {
            return null;
        }
        boolean saved = true;
        if (row < this.smpdtl.getNOccs()) {
            fss = this.smpdtl.getOccur(row);
        } else {
            fss = this.unsaved.get(row - this.smpdtl.getNOccs());
            saved = false;
        }
        if (fss == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return saved ? ((TaxonOcc)fss).isMarker() : ((TaxonOcc.Builder)fss).isMarker();
            }
            case 1: {
                return saved ? ((TaxonOcc)fss).getTaxon().getCatMnem() : ((TaxonOcc.Builder)fss).getTaxon().getCatMnem();
            }
            case 3: {
                return saved ? ((TaxonOcc)fss).getTaxon() : ((TaxonOcc.Builder)fss).getTaxon();
            }
            case 4: {
                return (saved ? ((TaxonOcc)fss).getTaxon() : ((TaxonOcc.Builder)fss).getTaxon()).getAlphaCode();
            }
            case 5: {
                return saved ? ((TaxonOcc)fss).getSituation().getAbr() : ((TaxonOcc.Builder)fss).getSituation().getAbr();
            }
            case 6: {
                if (saved ? ((TaxonOcc)fss).getIdentType() == '?' : ((TaxonOcc.Builder)fss).isQuestionable()) {
                    return "?";
                }
                return "";
            }
            case 7: {
                if (saved && ((TaxonOcc)fss).isOutsideCount()) {
                    return "+";
                }
                return saved ? ((TaxonOcc)fss).getSubAbund() : ((TaxonOcc.Builder)fss).getSubAbund();
            }
            case 8: {
                return saved ? ((TaxonOcc)fss).getCoarse() : ((TaxonOcc.Builder)fss).getCoarse();
            }
            case 9: {
                return saved ? ((TaxonOcc)fss).getMedium() : ((TaxonOcc.Builder)fss).getMedium();
            }
            case 10: {
                return saved ? ((TaxonOcc)fss).getFine() : ((TaxonOcc.Builder)fss).getFine();
            }
            case 11: {
                try {
                    return saved ? "" + this.getOccDerivedCount((TaxonOcc)fss) : "";
                }
                catch (SQLException sqle) {
                    return sqle.toString();
                }
            }
            case 12: {
                try {
                    return saved ? ((TaxonOcc)fss).getSpecTypeString() : ((TaxonOcc.Builder)fss).getSpecTypeString();
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            case 13: {
                return saved ? ((TaxonOcc)fss).getPreservation() : ((TaxonOcc.Builder)fss).getPreservation();
            }
            case 14: {
                return saved ? ((TaxonOcc)fss).getColour() : ((TaxonOcc.Builder)fss).getColour();
            }
            case 15: {
                return saved ? ((TaxonOcc)fss).getComment() : ((TaxonOcc.Builder)fss).getComment();
            }
            case 2: {
                if (saved) {
                    return ((TaxonOcc)fss).getImageSetID();
                }
                return null;
            }
            case 16: {
                if (fss instanceof TaxonOcc) {
                    try {
                        TaxonOcc occ = (TaxonOcc)fss;
                        int occTotal = this.getOccDerivedCount(occ);
                        int totalCount = this.getTotalDerivedCount();
                        if (totalCount == 0) {
                            return null;
                        }
                        return Float.valueOf((float)occTotal / (float)totalCount);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, null, e);
                    }
                }
                return null;
            }
        }
        return "Error col: " + col;
    }

    private int getOccDerivedCount(TaxonOcc occ) throws SQLException {
        if (occ.isCountingArtifact()) {
            return 0;
        }
        return (int)occ.getDerivedCount(this.smpdtl.getDatabase().getAbundanceSchemeService().findAbundanceScheme(this.smpdtl.getHeader().getAbnSchID()).orElse(null), this.smpdtl.getCoarse(), this.smpdtl.getMedium(), this.smpdtl.getFine());
    }

    private int getTotalDerivedCount() throws SQLException {
        int total = 0;
        for (int row = 0; row < this.getRowCount(); ++row) {
            TaxonOcc occ;
            if (row >= this.smpdtl.getNOccs() || (occ = this.smpdtl.getOccur(row)).isCountingArtifact()) continue;
            total += this.getOccDerivedCount(occ);
        }
        return total;
    }

    public Object getOcc(int row) {
        Object fss = null;
        if (this.smpdtl != null) {
            fss = row < this.smpdtl.getNOccs() ? this.smpdtl.getOccur(row) : this.unsaved.get(row - this.smpdtl.getNOccs());
        } else {
            System.out.println("Warning: smpdtl null in TableModelOcc.getOcc");
        }
        return fss;
    }

    public boolean getSaved(int row) {
        return row < this.smpdtl.getNOccs();
    }

    public boolean hasUnsaved(Taxon taxon, boolean isQuestionable, Situation situation, int specType) {
        if (this.unsaved != null) {
            for (TaxonOcc.Builder occ : this.unsaved) {
                if (occ.getTaxon() != taxon || occ.isQuestionable() != isQuestionable || occ.getSituation() != situation || occ.getSpecType() != specType) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            if (this.smpdtl == null) {
                return;
            }
            if (this.well == null) {
                System.out.println("Warning: well null in TableModelOcc.setValueAt");
                return;
            }
            boolean saved = true;
            TaxonOcc fss = null;
            TaxonOcc.Builder builder = null;
            if (row < this.smpdtl.getNOccs()) {
                fss = this.smpdtl.getOccur(row);
            } else {
                builder = this.unsaved.get(row - this.smpdtl.getNOccs());
                saved = false;
            }
            switch (col) {
                default: {
                    return;
                }
                case 8: {
                    int coarse;
                    int n = coarse = obj != null ? Integer.parseInt(obj.toString()) : 0;
                    if (saved && coarse != fss.getCoarse() || !saved && coarse != 0) {
                        if (saved) {
                            this.undoSupport.postEdit(this.smpdtl.incrementOcc(this.well.getWellID(), this.smpdtl.getSample().getSampID(), fss, 1, coarse - fss.getCoarse(), true));
                        } else {
                            this.unsaved.remove(builder);
                            builder.coarse(coarse);
                            this.undoSupport.postEdit((UndoableEdit)((Object)this.smpdtl.insertOccurrence(builder, this.well.getWellID())));
                        }
                        this.well.getDataModel().commit();
                        this.smpdtl.notifyObservers();
                        this.fireTableDataChanged();
                    }
                    break;
                }
                case 9: {
                    int medium;
                    int n = medium = obj != null ? Integer.parseInt(obj.toString()) : 0;
                    if (saved && medium != fss.getMedium() || !saved && medium > 0) {
                        if (saved) {
                            this.undoSupport.postEdit(this.smpdtl.incrementOcc(this.well.getWellID(), this.smpdtl.getSample().getSampID(), fss, 2, medium - fss.getMedium(), true));
                        } else {
                            this.unsaved.remove(builder);
                            builder.count(medium);
                            this.undoSupport.postEdit((UndoableEdit)((Object)this.smpdtl.insertOccurrence(builder, this.well.getWellID())));
                        }
                        this.smpdtl.notifyObservers();
                        this.well.getDataModel().commit();
                        this.fireTableDataChanged();
                    }
                    break;
                }
                case 10: {
                    int fine;
                    int n = fine = obj != null ? Integer.parseInt(obj.toString()) : 0;
                    if (saved && fine != fss.getFine() || !saved && fine != 0) {
                        if (saved) {
                            this.undoSupport.postEdit(this.smpdtl.incrementOcc(this.well.getWellID(), this.smpdtl.getSample().getSampID(), fss, 3, fine - fss.getFine(), true));
                        } else {
                            this.unsaved.remove(builder);
                            builder.fine(fine);
                            this.undoSupport.postEdit((UndoableEdit)((Object)this.smpdtl.insertOccurrence(builder, this.well.getWellID())));
                        }
                        this.well.getDataModel().commit();
                        this.smpdtl.notifyObservers();
                        this.fireTableDataChanged();
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.well.getDataModel().doRollback();
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        try {
            switch (col) {
                default: {
                    return false;
                }
                case 8: 
                case 10: {
                    return this.splits && this.logging && this.well.canWrite(this.well.getDataModel(), null);
                }
                case 9: 
            }
            return this.logging && this.well.canWrite(this.well.getDataModel(), null);
        }
        catch (SQLException sql) {
            sql.printStackTrace();
            return false;
        }
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 16: {
                return Float.class;
            }
            case 0: {
                return Boolean.class;
            }
            case 3: {
                return Taxon.class;
            }
            default: {
                return String.class;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
        }
        return Integer.class;
    }

    void setupTable(JTable jTableOccurrences, boolean splits, boolean logging, SBdb sbdb) {
        this.init(jTableOccurrences, sbdb);
        jTableOccurrences.setBackground(Color.WHITE);
        jTableOccurrences.getColumnModel().getColumn(0).setCellRenderer(new MarkerRenderer());
        jTableOccurrences.getColumnModel().getColumn(16).setCellRenderer(new PercentageFillCellRenderer());
        JTextField f = new JTextField();
        f.setHorizontalAlignment(2);
        f.setBorder(null);
        DefaultCellEditor dce = new DefaultCellEditor(f);
        jTableOccurrences.getColumnModel().getColumn(8).setCellEditor(dce);
        jTableOccurrences.getColumnModel().getColumn(9).setCellEditor(dce);
        jTableOccurrences.getColumnModel().getColumn(10).setCellEditor(dce);
        this.logging = logging;
        this.setSplits(jTableOccurrences, splits);
        jTableOccurrences.getColumnModel().getColumn(3).setCellRenderer(new DefaultTableCellRenderer(this){
            private final Color unsavedSelected;
            private final Color unsavedUnselected;
            final /* synthetic */ TableModelOccurrences this$0;
            {
                TableModelOccurrences tableModelOccurrences = this$0;
                Objects.requireNonNull(tableModelOccurrences);
                this.this$0 = tableModelOccurrences;
                this.unsavedSelected = new Color(51, 102, 204);
                this.unsavedUnselected = new Color(255, 255, 204);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int srow, int column) {
                Object rendererValue = value instanceof Taxon ? ((Taxon)value).toString(false, Taxon.includeAlphaInString, false) : value;
                if (table.getModel() instanceof TableModelOccurrences) {
                    boolean saved;
                    int row = table.convertRowIndexToModel(srow);
                    boolean bl = saved = row < this.this$0.smpdtl.getNOccs();
                    this.setBackground(saved ? (isSelected ? table.getSelectionBackground() : table.getBackground()) : (isSelected ? this.unsavedSelected : this.unsavedUnselected));
                    this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                    this.setValue(saved ? rendererValue : String.valueOf(rendererValue) + " UNSAVED");
                    return this;
                }
                return super.getTableCellRendererComponent(table, rendererValue, true, true, srow, column);
            }
        });
        Icon cameraOutlineIcon = IconFactory.getIcon("camera_bw.svg", 14);
        Icon cameraOutlineIconSelected = IconFactory.getIcon("camera_w.svg", 14);
        jTableOccurrences.getColumnModel().getColumn(2).setCellRenderer(new ImageIconRenderer(cameraOutlineIcon, cameraOutlineIconSelected));
        this.imageTooltip = new ImageCacheTooltip(jTableOccurrences, 2, sbdb.getImageRecordService(), sbdb.getImageLoader());
        jTableOccurrences.addMouseMotionListener(this.imageTooltip);
        jTableOccurrences.addMouseListener(this.imageTooltip);
        this.restoreColumnOrder(jTableOccurrences);
    }

    void setSplits(JTable jTableOccurrences, boolean splits) {
        this.splits = splits;
        TableColumnModel columns = jTableOccurrences.getColumnModel();
        TableColumn coarseCol = columns.getColumn(jTableOccurrences.convertColumnIndexToView(8));
        TableColumn mediumCol = columns.getColumn(jTableOccurrences.convertColumnIndexToView(9));
        TableColumn fineCol = columns.getColumn(jTableOccurrences.convertColumnIndexToView(10));
        coarseCol.setCellRenderer(new CountRenderer(this.logging && splits));
        mediumCol.setCellRenderer(new CountRenderer(this.logging));
        fineCol.setCellRenderer(new CountRenderer(this.logging && splits));
        mediumCol.setHeaderValue(splits ? columnTitles[9] : "Counts");
    }

    public void clearCachedImage(int imageSetID) {
        this.imageTooltip.clearImageSet(imageSetID);
    }

    public void clearCachedImagesForCurrentSmpdtl() {
        for (TaxonOcc occ : this.smpdtl.getOccurUnsorted()) {
            this.imageTooltip.clearImageSet(occ.getImageSetID());
        }
    }

    @Override
    void setDefaultColumnWidths() {
        System.arraycopy(this.getDefaultColumnWidths(), 0, this.getColumnWidths(), 0, this.getDefaultColumnWidths().length);
        if (!this.splits) {
            this.getColumnWidths()[8] = 0;
            this.getColumnWidths()[10] = 0;
            this.getColumnWidths()[11] = 0;
        }
    }

    @Override
    public void setupTable(JTable table, SBdb sbdb) {
        assert (false);
    }

    public boolean pruneUnsaved() {
        if (this.unsaved == null) {
            return false;
        }
        boolean wasPruned = false;
        ListIterator it = this.unsaved.listIterator();
        block0: while (it.hasNext()) {
            TaxonOcc.Builder unsavedOcc = (TaxonOcc.Builder)it.next();
            for (TaxonOcc occ : this.smpdtl.getOccurUnsorted()) {
                if (occ.getTaxon().getSpecID() != unsavedOcc.getTaxon().getSpecID() || occ.getSituation() != unsavedOcc.getSituation() || occ.getQuestionable() != unsavedOcc.isQuestionable() || occ.getSpecType() != unsavedOcc.getSpecType()) continue;
                it.remove();
                wasPruned = true;
                continue block0;
            }
        }
        return wasPruned;
    }
}

