/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import model3.InterpHdr;
import model3.SBdb;
import model3.WsWell;
import util.SB;
import util.SBException;
import util.status.DTMonitor;
import util.status.DTMonitorRenderer;
import util.status.SbugsStatus;
import util.status.SbugsStatusRenderer;

public class TableModelOrganiser
extends AbstractTableModel {
    private static final int ROW_HEIGHT = 20;
    List<WsWell> wsWells = null;
    char units = (char)68;
    private InterpHdr interpHdr = null;
    private Set<Integer> dataTypes = null;

    @Override
    public int getColumnCount() {
        if (this.dataTypes == null) {
            return 1;
        }
        return this.dataTypes.size() + 1;
    }

    @Override
    public int getRowCount() {
        if (this.wsWells == null) {
            return 0;
        }
        return this.wsWells.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.wsWells == null) {
            return "";
        }
        try {
            switch (col) {
                case 0: {
                    return this.wsWells.get(row);
                }
            }
            return this.wsWells.get(row).getDataMonitor(this.getColumnType(col), this.units, this.interpHdr != null ? this.interpHdr.getInterpID() : 0);
        }
        catch (SQLException | SBException e) {
            System.out.println(e.getMessage());
            return e.getMessage();
        }
    }

    int getColumnType(int column) throws SBException {
        int columnType = 0;
        int nColumn = 0;
        for (Integer dataType : this.dataTypes) {
            if (this.interpHdr == null && !SBdb.isInterpDataType(dataType)) {
                if (column != ++nColumn) continue;
                columnType = dataType;
                break;
            }
            if (this.interpHdr == null || !SBdb.isInterpDataType(dataType) || column != ++nColumn) continue;
            columnType = dataType;
            break;
        }
        return columnType;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return SbugsStatus.class;
        }
        return DTMonitor.class;
    }

    void setupTable(JTable jTableOrg) {
        SB.setTableHeaderBold((JTable)jTableOrg);
        jTableOrg.setDefaultRenderer(DTMonitor.class, (TableCellRenderer)new DTMonitorRenderer());
        jTableOrg.setDefaultRenderer(SbugsStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        jTableOrg.setRowHeight(20);
        jTableOrg.getTableHeader().setReorderingAllowed(false);
    }

    void setInterp(InterpHdr hdr) {
        this.interpHdr = hdr;
    }

    void setDataTypes(JTable jTableOrg, Set<Integer> dataTypes) {
        this.dataTypes = dataTypes;
        jTableOrg.getColumnModel().getColumn(0).setHeaderValue("Well/Outcrop");
        while (jTableOrg.getColumnCount() > 1) {
            TableColumn column = jTableOrg.getColumnModel().getColumn(1);
            jTableOrg.removeColumn(column);
        }
        if (dataTypes == null) {
            return;
        }
        int nColumns = 1;
        for (int dataType : dataTypes) {
            try {
                if (dataType <= 27) {
                    if ((this.interpHdr != null || SBdb.isInterpDataType(dataType)) && (this.interpHdr == null || !SBdb.isInterpDataType(dataType))) continue;
                    TableColumn column = new TableColumn(nColumns++);
                    column.setHeaderValue(SBdb.dTypeNames[dataType]);
                    column.setPreferredWidth(90);
                    jTableOrg.addColumn(column);
                    continue;
                }
                System.out.println("Can't add data type in OrganiserTableModel: " + String.valueOf(dataTypes));
            }
            catch (SBException ex) {
                ex.printStackTrace();
                System.out.println("Can't add data type in OrganiserTableModel: " + String.valueOf(dataTypes));
            }
        }
    }
}

