/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.FrameJsbugs;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.Surface;
import util.SB;
import util.SBException;

class TableModelSurfaces
extends AbstractTableModel {
    IGDScheme scheme = null;
    static String[] colTitles = new String[]{"Surface Name", "Type", "Magnitude", "Age", "Occs", "Unit"};
    static int[] colWidths = new int[]{90, 20, 20, 30, 20, 30};
    static final int COL_NAME = 0;
    static final int COL_TYPE = 1;
    static final int COL_MAG = 2;
    static final int COL_AGE = 3;
    static final int COL_OCCS = 4;
    static final int COL_UNIT = 5;

    public TableModelSurfaces(IGDScheme scheme) {
        this.scheme = scheme;
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.scheme == null) {
            return 0;
        }
        try {
            return this.scheme.getSurfaces().size();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error getting surfaces", sql, this.scheme.getDatabase());
            return 0;
        }
    }

    IGDScheme getScheme() {
        return this.scheme;
    }

    void setScheme(IGDScheme scheme) throws SQLException, SBException {
        scheme.loadUnits();
        scheme.getSurfaces();
        this.scheme = scheme;
    }

    int getIndexOf(Surface surface) throws SQLException {
        if (this.scheme == null) {
            return -1;
        }
        return this.scheme.getSurfaces().indexOf(surface);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.scheme == null) {
            return "";
        }
        try {
            Surface surface = this.scheme.getSurfaces().get(row);
            switch (col) {
                case 0: {
                    return surface.getName();
                }
                case 1: {
                    return surface.getTypeString();
                }
                case 3: {
                    return surface.getAge();
                }
                case 2: {
                    return surface.getType() == Surface.SurfaceType.MFS ? Surface.Magnitude.getMagnitude(surface.getMagnitude()) : null;
                }
                case 4: {
                    return surface.getNoccs(false);
                }
                case 5: {
                    try {
                        IGDUnit unit = this.scheme.findUnit(surface.getAge());
                        if (unit == null) {
                            unit = this.scheme.findUnit(surface.getName());
                        }
                        if (unit == null) {
                            return "";
                        }
                        return unit;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return "Error";
                    }
                }
            }
            return "";
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error getting surfaces", sql, this.scheme.getDatabase());
            return "";
        }
    }

    void setupTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        table.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < colTitles.length; ++i) {
            table.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
            table.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
        }
    }
}

