/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.TableModelSB;
import jsbugs.table.ColourRenderer;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.IGetValue;
import jsbugs.table.SampleRenderer;
import jsbugs.table.SimpleTableColumn;
import model3.IGDIntervalZone;
import model3.SBdb;
import model3.Sample;
import model3.Well;

public class ZonesTableModel
extends TableModelSB {
    private char units = (char)77;
    private List<IGDIntervalZone> zones = null;
    private final String prefString;
    private final String prefOrderString;
    private final String prefAutoResizeString;
    private SimpleTableColumn<IGDIntervalZone> topSampleColumn = new SimpleTableColumn<IGDIntervalZone>("Top Sample", 55, Sample.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            return zone.getTopSample();
        }
    });
    private SimpleTableColumn<IGDIntervalZone> topBoundaryColumn = new SimpleTableColumn<IGDIntervalZone>("Top Boundary", 25, String.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            return zone.getTopBnd();
        }
    });
    private SimpleTableColumn<IGDIntervalZone> baseSampleColumn = new SimpleTableColumn<IGDIntervalZone>("Base Sample", 55, Sample.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            return zone.getBaseSample();
        }
    });
    private SimpleTableColumn<IGDIntervalZone> baseBoundaryColumn = new SimpleTableColumn<IGDIntervalZone>("Base Boundary", 25, String.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            return zone.getBaseBnd();
        }
    });
    private SimpleTableColumn<IGDIntervalZone> levelColumn = new SimpleTableColumn<IGDIntervalZone>("Level", 40, String.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            return IGDIntervalZone.getHierName(zone.getIGDType(), zone.getHier());
        }
    });
    private SimpleTableColumn<IGDIntervalZone> zoneColumn = new SimpleTableColumn<IGDIntervalZone>("Unit", 50, String.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            return zone.toString();
        }
    });
    private SimpleTableColumn<IGDIntervalZone> upperColourColumn = new SimpleTableColumn<IGDIntervalZone>("Colour - Upper", 10, Color.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            try {
                return zone.getUnitColour(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    });
    private SimpleTableColumn<IGDIntervalZone> lowerColourColumn = new SimpleTableColumn<IGDIntervalZone>("Colour - Lower", 10, Color.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            try {
                return zone.getUnitColour(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    });
    private SimpleTableColumn<IGDIntervalZone> linkedColumn = new SimpleTableColumn<IGDIntervalZone>("Linked?", 30, String.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            return zone.getLinkString();
        }
    });
    private SimpleTableColumn<IGDIntervalZone> schemeColumn = new SimpleTableColumn<IGDIntervalZone>("Scheme", 60, String.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            try {
                return zone.getSchemeName();
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
    });
    private SimpleTableColumn<IGDIntervalZone> modifiedByColumn = new SimpleTableColumn<IGDIntervalZone>("Mod. By", 30, String.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            return zone.getModifierAbr();
        }
    });
    private SimpleTableColumn<IGDIntervalZone> modifiedOnColumn = new SimpleTableColumn<IGDIntervalZone>("Modified", 30, Date.class, new IGetValue<IGDIntervalZone>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            return zone.getModified();
        }
    });
    List<SimpleTableColumn<IGDIntervalZone>> columns = new ArrayList<SimpleTableColumn>(Arrays.asList(this.topSampleColumn, this.topBoundaryColumn, this.baseSampleColumn, this.baseBoundaryColumn, this.levelColumn, this.zoneColumn, this.upperColourColumn, this.lowerColourColumn, this.linkedColumn, this.schemeColumn, this.modifiedByColumn, this.modifiedOnColumn));
    private SampleRenderer sampleRenderer = new SampleRenderer(this.units);

    public ZonesTableModel() {
        this("TMZONES", "TOZONES", "TARZONES");
    }

    public ZonesTableModel(String prefString, String prefOrderString, String prefAutoResizeString) {
        this.prefString = prefString;
        this.prefOrderString = prefOrderString;
        this.prefAutoResizeString = prefAutoResizeString;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    public void setZones(List<IGDIntervalZone> zones, Well well) {
        this.zones = zones;
    }

    public List<IGDIntervalZone> getZones() {
        return this.zones;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.zones == null || row > this.zones.size() - 1) {
            return null;
        }
        IGDIntervalZone zone = this.zones.get(row);
        SimpleTableColumn<IGDIntervalZone> columnValue = this.columns.get(col);
        return columnValue.getValueFromRow(zone);
    }

    public Class getColumnClass(int col) {
        SimpleTableColumn<IGDIntervalZone> columnValue = this.columns.get(col);
        return columnValue.getValueClass();
    }

    @Override
    public int getRowCount() {
        if (this.zones == null) {
            return 0;
        }
        return this.zones.size();
    }

    @Override
    public void setupTable(JTable jTable, SBdb sbdb) {
        this.init(jTable, sbdb);
        jTable.setDefaultRenderer(Sample.class, this.sampleRenderer);
        jTable.getColumnModel().getColumn(this.columns.indexOf(this.levelColumn)).setCellRenderer(new ColouredRenderer(true, ColouredRenderer.GREY));
        jTable.setDefaultRenderer(Color.class, new ColourRenderer(true));
        jTable.setRowHeight(20);
        this.restoreColumnOrder(jTable);
    }

    @Override
    public String[] getColumnTitles() {
        String[] titles = new String[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            titles[i] = this.columns.get(i).getTitle();
        }
        return titles;
    }

    @Override
    public int[] getDefaultColumnWidths() {
        int[] widths = new int[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            widths[i] = this.columns.get(i).getDefaultWidth();
        }
        return widths;
    }

    @Override
    public String getPrefString() {
        return this.prefString;
    }

    @Override
    void setUnits(char units) {
        if (units != this.units) {
            this.units = units;
            this.sampleRenderer.setUnits(units);
        }
    }

    @Override
    public String getPrefOrderString() {
        return this.prefOrderString;
    }

    @Override
    public String getAutoResizeString() {
        return this.prefAutoResizeString;
    }

    public TableModel getTableModel() {
        return this;
    }
}

