/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.abnsch;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeInformationService;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.table.ComboRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.AnalystHeader;
import model3.SBdb;
import model3.Well;
import net.miginfocom.swing.MigLayout;
import util.SBException;

public class DialogEditAbundance
extends JDialog {
    private final EditAbnTableModel model = new EditAbnTableModel();
    private TableRowSorter<EditAbnTableModel> rowSorter;
    private final JComboBox<AbundanceScheme.AbundanceSchemeEntry> tableCellCombo = new JComboBox();
    private final SBdb db;
    private final Well well;
    private final AbundanceSchemeInformationService.Usage schemeUsage;
    private boolean inStartup = true;
    private AnalystHeader hdr = null;
    private JPanel panel1;
    private JLabel jLabel1;
    private JTextField jTextFieldWellName;
    private JLabel jLabel2;
    private JTextField jTextFieldDiscipline;
    private JLabel jLabel4;
    private JTextField jTextFieldAnalyst;
    private JLabel jLabel3;
    private JComboBox<AbundanceScheme> jComboBoxTargetScheme;
    private JScrollPane jScrollPane1;
    private JTable jTableAb;
    private JLabel jLabel5;
    private JTextField jTextFieldExistingAbn;
    private JPanel buttonBar;
    private JButton jButtonOK;
    private JButton jButtonHelp;
    private JButton jButtonCancel;

    public DialogEditAbundance(JDialog parent, boolean modal, SBdb db, Well well, AbundanceSchemeInformationService.Usage schemeUsage) throws SBException, SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.well = well;
        this.schemeUsage = schemeUsage;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.hdr = this.well.getAnalystHeader(this.schemeUsage.analyst().getAbr(), this.schemeUsage.discipline().getChar(), this.schemeUsage.analyNo(), true);
        AbundanceScheme orig = (AbundanceScheme)this.db.getAbundanceSchemeService().findAbundanceScheme(this.hdr.getAbnSchID()).orElseThrow(IllegalStateException::new);
        this.setTitle("Well Abundance : Edit : " + String.valueOf(orig));
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldWellName.setText(this.well.getWellName());
        this.jTextFieldDiscipline.setText(this.schemeUsage.discipline().getAbr(false));
        this.jTextFieldExistingAbn.setText(orig.toString());
        this.model.setupTable(this.jTableAb, this.tableCellCombo);
        this.rowSorter = new TableRowSorter<EditAbnTableModel>(this.model);
        this.jTableAb.setRowSorter(this.rowSorter);
        new ColumnSortResetHandler(this.jTableAb).attach();
        this.jComboBoxTargetScheme.removeAllItems();
        AbundanceScheme toSelect = null;
        for (AbundanceScheme abundanceScheme : this.db.getAbundanceSchemeService().getAllAbundanceSchemes()) {
            this.jComboBoxTargetScheme.addItem(abundanceScheme);
            if (abundanceScheme.getAbnSchID() != orig.getAbnSchID()) continue;
            toSelect = abundanceScheme;
        }
        this.jComboBoxTargetScheme.setSelectedItem(toSelect);
        this.well.loadAnalyses();
        this.jTextFieldAnalyst.setText(this.schemeUsage.analyst().getAbr() + "/" + this.schemeUsage.analyNo());
        this.inStartup = false;
        for (AbundanceSchemeInformationService.Usage.AbrUsage donorAbr : this.schemeUsage.usages()) {
            EditAbnTableModel.AbnRow abnRow = new EditAbnTableModel.AbnRow();
            abnRow.donorAbr = donorAbr.abr();
            abnRow.donorMin = orig.findEntryBySubjAbund(donorAbr.abr()).map(AbundanceScheme.AbundanceSchemeEntry::lowBound).orElse(0);
            abnRow.nOccs = donorAbr.nOccs();
            this.model.rows.add(abnRow);
        }
        if (this.model.rows.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No subjective occurrence entries found.\nYou can assign a different scheme to the suite, if required, without reassigning abundance for occurrences.", this.getTitle(), 1);
        }
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        this.rowSorter.setSortKeys(sortKeys);
        this.model.fireTableDataChanged();
        this.jComboBoxAbnSchemeActionPerformed(null);
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        AbundanceScheme targetScheme = this.jComboBoxTargetScheme.getItemAt(this.jComboBoxTargetScheme.getSelectedIndex());
        for (EditAbnTableModel.AbnRow row : this.model.rows) {
            if (row.target != null) continue;
            JOptionPane.showMessageDialog(this, "Not all entries are in selected scheme, select target entries for all abbreviations shown.", this.getTitle(), 2);
            return;
        }
        for (EditAbnTableModel.AbnRow row : this.model.rows) {
            String targetAbr = row.target.abr();
            if (targetAbr.equals(row.donorAbr)) continue;
            for (EditAbnTableModel.AbnRow row2 : this.model.rows) {
                if (row2 == row) continue;
                String targetAbr2 = row2.target.abr();
                if (!targetAbr.equals(row2.donorAbr) || row2.donorAbr.equals(targetAbr2)) continue;
                JOptionPane.showMessageDialog(this, "You can't edit '" + row.donorAbr + "' to '" + (String)targetAbr + "' because '" + (String)targetAbr + "' is being changed to '" + targetAbr2 + "'.", this.getTitle(), 2);
                return;
            }
        }
        if (this.hdr == null) {
            JOptionPane.showMessageDialog(this, "Cannot find analyst header. Abundance scheme not updated", this.getTitle(), 1);
            return;
        }
        boolean reassign = targetScheme.getAbnSchID() != this.hdr.getAbnSchID();
        try {
            if (reassign) {
                this.hdr.setAbnScheme(this.well.getWellID(), targetScheme.getAbnSchID());
            }
            int nUpdated = 0;
            for (EditAbnTableModel.AbnRow row : this.model.rows) {
                if (row.target.abr().equalsIgnoreCase(row.donorAbr)) continue;
                nUpdated += this.well.updateSubjAbund(row.donorAbr, row.target.abr(), this.hdr.getAnalyID());
            }
            this.db.commit();
            Object msg = "";
            if (reassign) {
                msg = (String)msg + "Scheme in suite reassigned.";
            }
            if (nUpdated > 0) {
                if (((String)msg).length() > 0) {
                    msg = (String)msg + "\n";
                }
                msg = (String)msg + "Number of occurrence entries updated: " + nUpdated;
            }
            if (((String)msg).length() > 0) {
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
            }
            this.dispose();
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxAbnSchemeActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        AbundanceScheme targetScheme = this.jComboBoxTargetScheme.getItemAt(this.jComboBoxTargetScheme.getSelectedIndex());
        this.tableCellCombo.removeAllItems();
        for (AbundanceScheme.AbundanceSchemeEntry entry : targetScheme.getEntries()) {
            this.tableCellCombo.addItem(entry);
        }
        for (EditAbnTableModel.AbnRow row : this.model.rows) {
            row.target = targetScheme.findEntryBySubjAbund(row.donorAbr).orElse(null);
        }
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        this.rowSorter.setSortKeys(sortKeys);
        this.model.fireTableDataChanged();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogeditabundance.html");
    }

    private void initComponents() {
        this.panel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldWellName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldDiscipline = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldAnalyst = new JTextField();
        this.jLabel3 = new JLabel();
        this.jComboBoxTargetScheme = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTableAb = new JTable();
        this.jLabel5 = new JLabel();
        this.jTextFieldExistingAbn = new JTextField();
        this.buttonBar = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 400));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.panel1.setLayout((LayoutManager)new MigLayout("hidemode 3", "[right][fill][grow,fill]", "[][][][][][177,grow]"));
        this.jLabel1.setText("Well:");
        this.panel1.add((Component)this.jLabel1, "cell 0 0");
        this.jTextFieldWellName.setEditable(false);
        this.panel1.add((Component)this.jTextFieldWellName, "cell 1 0 2 1");
        this.jLabel2.setText("Discipline:");
        this.panel1.add((Component)this.jLabel2, "cell 0 2");
        this.jTextFieldDiscipline.setEditable(false);
        this.panel1.add((Component)this.jTextFieldDiscipline, "cell 1 2 2 1");
        this.jLabel4.setText("Analysis suite:");
        this.panel1.add((Component)this.jLabel4, "cell 0 1");
        this.jTextFieldAnalyst.setEditable(false);
        this.panel1.add((Component)this.jTextFieldAnalyst, "cell 1 1 2 1");
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("New Abundance Scheme for suite:");
        this.panel1.add((Component)this.jLabel3, "cell 0 4 2 1");
        this.jComboBoxTargetScheme.addActionListener(e -> this.jComboBoxAbnSchemeActionPerformed(e));
        this.panel1.add(this.jComboBoxTargetScheme, "cell 2 4");
        this.jTableAb.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableAb);
        this.panel1.add((Component)this.jScrollPane1, "cell 0 5 3 1,growx");
        this.jLabel5.setHorizontalAlignment(11);
        this.jLabel5.setText("Abundance Scheme assigned to suite:");
        this.panel1.add((Component)this.jLabel5, "cell 0 3 2 1");
        this.jTextFieldExistingAbn.setEditable(false);
        this.panel1.add((Component)this.jTextFieldExistingAbn, "cell 2 3");
        contentPane.add((Component)this.panel1, "Center");
        this.buttonBar.setLayout((LayoutManager)new MigLayout("hidemode 3,alignx right", "[fill][fill][fill][fill]", "[]"));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(e -> this.jButtonOKActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonOK, "cell 0 0 2 1");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(e -> this.jButtonHelpActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonHelp, "cell 2 0");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(e -> this.jButtonCancelActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonCancel, "cell 3 0");
        contentPane.add((Component)this.buttonBar, "South");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private static class EditAbnTableModel
    extends AbstractTableModel {
        private final List<AbnRow> rows = new ArrayList<AbnRow>();

        private EditAbnTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            AbnRow abnRow = this.rows.get(row);
            return switch (col) {
                case 0 -> abnRow.donorMin;
                case 1 -> abnRow.donorAbr;
                case 2 -> {
                    if (abnRow.nOccs > 0) {
                        yield abnRow.nOccs;
                    }
                    yield "n/a";
                }
                case 3 -> {
                    if (abnRow.target != null) {
                        yield abnRow.target.entryName();
                    }
                    yield "";
                }
                default -> null;
            };
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            if (col == 3 && obj instanceof AbundanceScheme.AbundanceSchemeEntry) {
                AbundanceScheme.AbundanceSchemeEntry target;
                this.rows.get((int)row).target = target = (AbundanceScheme.AbundanceSchemeEntry)obj;
            }
        }

        public Class getColumnClass(int c) {
            return switch (c) {
                case 1, 3 -> String.class;
                case 0, 2 -> Integer.class;
                default -> Object.class;
            };
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 3;
        }

        void setupTable(JTable jTableAb, JComboBox comboBox) {
            int col = 0;
            TableColumnModel columnModel = jTableAb.getColumnModel();
            columnModel.getColumn(col).setHeaderValue("Min.");
            columnModel.getColumn(col++).setPreferredWidth(20);
            columnModel.getColumn(col).setHeaderValue("Abbreviation");
            columnModel.getColumn(col++).setPreferredWidth(20);
            columnModel.getColumn(col).setHeaderValue("Occs.");
            columnModel.getColumn(col++).setPreferredWidth(10);
            columnModel.getColumn(col).setHeaderValue("Change to");
            columnModel.getColumn(col).setCellEditor(new DefaultCellEditor(comboBox));
            columnModel.getColumn(col).setCellRenderer(new ComboRenderer());
            columnModel.getColumn(col++).setPreferredWidth(160);
            jTableAb.getTableHeader().setReorderingAllowed(false);
            TableUtils.setTableHeaderBold((JTable)jTableAb);
        }

        private static class AbnRow {
            int donorMin;
            String donorAbr;
            int nOccs;
            AbundanceScheme.AbundanceSchemeEntry target;

            private AbnRow() {
            }
        }
    }
}

