/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.abnsch;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBRestrictable;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;

public class DialogMergeAbn
extends SBDialog {
    private final SBdb db;
    private final AbundanceScheme target;
    private final List<AbundanceScheme> schemes;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jListAbnSchemes;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldName;

    public DialogMergeAbn(JDialog parent, boolean modal, SBdb db, AbundanceScheme target, List<AbundanceScheme> schemes) {
        super((Window)parent, modal);
        this.db = db;
        this.target = target;
        this.schemes = schemes;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jTextFieldName.setText(this.target.getName());
        this.jListAbnSchemes.setListData(new Vector<AbundanceScheme>(this.schemes));
        this.jListAbnSchemes.repaint();
        this.setTitle("Abundance Schemes : Merge");
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListAbnSchemes = new JList();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Abundance Scheme: ");
        this.jTextFieldName.setEditable(false);
        this.jButtonOK.setText("Merge");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMergeAbn this$0;
            {
                DialogMergeAbn dialogMergeAbn = this$0;
                Objects.requireNonNull(dialogMergeAbn);
                this.this$0 = dialogMergeAbn;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMergeAbn this$0;
            {
                DialogMergeAbn dialogMergeAbn = this$0;
                Objects.requireNonNull(dialogMergeAbn);
                this.this$0 = dialogMergeAbn;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jListAbnSchemes.setModel(new AbstractListModel(this){
            String[] strings;
            final /* synthetic */ DialogMergeAbn this$0;
            {
                DialogMergeAbn dialogMergeAbn = this$0;
                Objects.requireNonNull(dialogMergeAbn);
                this.this$0 = dialogMergeAbn;
                this.strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};
            }

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jListAbnSchemes);
        this.jLabel2.setText("Select scheme(s) to be merged:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jLabel2).add(1, (Component)this.jScrollPane1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldName, -2, 285, -2))).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(264, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldName, -2, -1, -2).add((Component)this.jLabel1)).add(18, 18, 18).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 139, Short.MAX_VALUE).add(14, 14, 14).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jListAbnSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select at least one scheme to merge.", this.getTitle(), 1);
            return;
        }
        try {
            List donors = this.jListAbnSchemes.getSelectedValuesList();
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int i = 0; i < donors.size(); ++i) {
                AbundanceScheme donor = (AbundanceScheme)donors.get(i);
                this.db.mergeAbnScheme(this.target, donor);
            }
            this.setOK();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

