/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import com.stratadata.util.ui.SBDialog;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.SchemeBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelKey;
import jsbchart.core.PanelWellHeader;
import jsbugs.DialogChartBlockImport;
import jsbugs.DialogChartTemplates;
import jsbugs.DialogList;
import jsbugs.DialogSelectIGDType;
import jsbugs.FrameChart;
import jsbugs.FrameJsbugs;
import jsbugs.list.RestrictableListRenderer;
import jsbugs.uiutil.ComboboxItem;
import jsbugs.uiutil.EnumCombo;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.InterpHdr;
import model3.SBdb;
import model3.Well;
import model3.project.WellList;
import org.apache.commons.lang3.StringUtils;
import util.AgeFormat;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsInputVerifier;
import util.exception.StackError;

public class DialogChartFont
extends SBDialog {
    private static final float CHART_MAX_HEIGHT = 1000000.0f;
    private final ChartProperties cp;
    private final ChartBlock block;
    private final SBdb sbdb;
    private IGDScheme scheme;
    private final DefaultComboBoxModel hierModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel interpModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel fontSizeModel = new DefaultComboBoxModel<ChartProperties.FontSize>(ChartProperties.FontSize.values());
    private char units;
    private BlockProperties.ScaleType scaleType;
    private SbugsInputVerifier ageVerifier;
    private SbugsInputVerifier depthVerifier;
    private Object wellObj;
    private final boolean allowSchemeSetWell;
    private final boolean alwaysEncode;
    private static final int DEPTHLEN = 8;
    private ActionListener applyListener = null;
    private static int tab = 0;
    private ButtonGroup AgeFormat;
    private ButtonGroup buttonGroupCapAlign;
    private ButtonGroup buttonGroupCapPos;
    private ButtonGroup buttonGroupHdrLocation;
    private ButtonGroup buttonGroupHdrPlacement;
    private ButtonGroup buttonGroupHeader;
    private ButtonGroup buttonGroupKeyPlacement;
    private ButtonGroup buttonGroupScaleType;
    private ButtonGroup buttonGroupTitlePos;
    private ButtonGroup buttonGroupUnits;
    private EnumCombo enumComboChartDatum;
    private Box.Filler filler1;
    private JButton jButtonApply;
    private JButton jButtonBackground;
    private JButton jButtonCancel;
    private JButton jButtonClearScheme;
    private JButton jButtonCopy;
    private JButton jButtonDefaultFont;
    private JButton jButtonForeground;
    private JButton jButtonGapHatchColour;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectScheme;
    private JButton jButtonWellObj;
    private JButton jButtonWellObjClear;
    private JCheckBox jCheckBoxAltAgeLTR;
    private JCheckBox jCheckBoxBgPinchouts;
    private JCheckBox jCheckBoxBlankRelative;
    private JCheckBox jCheckBoxBorder;
    private JCheckBox jCheckBoxCaptions;
    private JCheckBox jCheckBoxChartBorder;
    private JCheckBox jCheckBoxClientName;
    private JCheckBox jCheckBoxComments;
    private JCheckBox jCheckBoxCorrTick;
    private JCheckBox jCheckBoxCorrectCuttings;
    private JCheckBox jCheckBoxCorrectDepth;
    private JCheckBox jCheckBoxDepthInterval;
    private JCheckBox jCheckBoxDrawDisconfDuration;
    private JCheckBox jCheckBoxDrawDisconfs;
    private JCheckBox jCheckBoxDrawEmptyPanels;
    private JCheckBox jCheckBoxGreyscale;
    private JCheckBox jCheckBoxHdrTemplDate;
    private JCheckBox jCheckBoxHdrTemplDescr;
    private JCheckBox jCheckBoxHdrTemplName;
    private JCheckBox jCheckBoxHdrWellList;
    private JCheckBox jCheckBoxKey;
    private JCheckBox jCheckBoxKeyAbn;
    private JCheckBox jCheckBoxKeyBnd;
    private JCheckBox jCheckBoxKeyBorder;
    private JCheckBox jCheckBoxKeyCats;
    private JCheckBox jCheckBoxKeyCorr;
    private JCheckBox jCheckBoxKeyEnvSchs;
    private JCheckBox jCheckBoxKeyLithBase;
    private JCheckBox jCheckBoxKeyLithQual;
    private JCheckBox jCheckBoxKeySamp;
    private JCheckBox jCheckBoxKeyText;
    private JCheckBox jCheckBoxKeyTxGroup;
    private JCheckBox jCheckBoxLocation;
    private JCheckBox jCheckBoxLogo;
    private JCheckBox jCheckBoxMapAlign;
    private JCheckBox jCheckBoxOperator;
    private JCheckBox jCheckBoxScale;
    private JCheckBox jCheckBoxSpud;
    private JCheckBox jCheckBoxTD;
    private JCheckBox jCheckBoxWellCode;
    private JCheckBox jCheckBoxbgBlocks;
    private JComboBox jComboBoxAltScale;
    private JComboBox<ComboboxItem<PanelWellHeader.WellNameDisplay>> jComboBoxBCWellNames;
    private JComboBox jComboBoxBlockCapFontSize;
    private JComboBox jComboBoxFont;
    private JComboBox jComboBoxHier;
    private JComboBox jComboBoxVersion;
    private JComboBox jComboBoxVerticalScale;
    private JComboBox<ComboboxItem<PanelWellHeader.WellNameDisplay>> jComboBoxWellName;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelBaseDepth;
    private JLabel jLabelHdrAuthor;
    private JLabel jLabelHdrEnclosure;
    private JLabel jLabelHdrHeight;
    private JLabel jLabelHdrTitlePos;
    private JLabel jLabelKeyOrientation;
    private JLabel jLabelKeySize;
    private JLabel jLabelLOCMaxAge;
    private JLabel jLabelLOCMinAge;
    private JLabel jLabelMaxAge;
    private JLabel jLabelMinAge;
    private JLabel jLabelScale;
    private JLabel jLabelTopDepth;
    private JLabel jLabelWellName;
    private JLabel jLabelWellName1;
    private JLabel jLabelWellObj;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanelBlockAltScale;
    private JPanel jPanelBlockProperties;
    private JPanel jPanelBlockScaleType;
    private JPanel jPanelBlockUnits;
    private JPanel jPanelColours;
    private JPanel jPanelData;
    private JPanel jPanelDimensions;
    private JPanel jPanelFonts;
    private JPanel jPanelHdrCards;
    private JPanel jPanelHdrFree;
    private JPanel jPanelHdrNone;
    private JPanel jPanelHdrWell;
    private JPanel jPanelHeader;
    private JPanel jPanelKey;
    private JPanel jPanelKeyOptions;
    private JPanel jPanelWellObj;
    private JRadioButton jRadioButtonAFKA;
    private JRadioButton jRadioButtonAFMA;
    private JRadioButton jRadioButtonAGE;
    private JRadioButton jRadioButtonCapAlignBlocks;
    private JRadioButton jRadioButtonCapAlignChart;
    private JRadioButton jRadioButtonCapBase;
    private JRadioButton jRadioButtonCapTop;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonHdrBottom;
    private JRadioButton jRadioButtonHdrFree;
    private JRadioButton jRadioButtonHdrNone;
    private JRadioButton jRadioButtonHdrTop;
    private JRadioButton jRadioButtonHdrWell;
    private JRadioButton jRadioButtonKeyBottom;
    private JRadioButton jRadioButtonKeyLeft;
    private JRadioButton jRadioButtonKeyRight;
    private JRadioButton jRadioButtonKeyTop;
    private JRadioButton jRadioButtonLocDMS;
    private JRadioButton jRadioButtonLocDec;
    private JRadioButton jRadioButtonMD;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonTVD;
    private JRadioButton jRadioButtonWellNameCentre;
    private JRadioButton jRadioButtonWellNameLeft;
    private JScrollPane jScrollPane1;
    private JSlider jSliderbgDensity;
    private JSpinner jSpinnerBlankSpace;
    private JSpinner jSpinnerCapHeight;
    private JSpinner jSpinnerCaption;
    private JSpinner jSpinnerExtCaption;
    private JSpinner jSpinnerFontSize;
    private JSpinner jSpinnerMargin;
    private JSpinner jSpinnerSubHeader;
    private JSpinner jSpinnerVfreeze;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextAreaHdrTitle;
    private JTextField jTextFieldAltMax;
    private JTextField jTextFieldAltMin;
    private JTextField jTextFieldBackground;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldForeground;
    private JTextField jTextFieldGapHatchColour;
    private JTextField jTextFieldHdrAuthor;
    private JTextField jTextFieldHdrEnclosure;
    private JTextField jTextFieldHdrHeight;
    private JTextField jTextFieldKeyHeight;
    private JTextField jTextFieldMaxAge;
    private JTextField jTextFieldMinAge;
    private JTextField jTextFieldTopDepth;
    private JTextField jTextFieldTotalHeaderHeight;
    private JTextField jTextFieldWellObj;
    private JTextField jTextFieldbgScheme;

    public DialogChartFont(JDialog parent, boolean modal, ChartProperties cp, SBdb sbdb) {
        super((Window)parent, modal);
        this.cp = cp;
        this.sbdb = sbdb;
        this.block = null;
        this.allowSchemeSetWell = false;
        this.alwaysEncode = false;
        this.initComponents();
        this.init(cp, true, true);
    }

    public DialogChartFont(JFrame parent, boolean modal, ChartProperties cp, SBdb sbdb, ChartBlock block, boolean allowSchemeSetWell, boolean allowEdit, boolean canWrite, boolean alwaysEncode) {
        super((Frame)parent, modal);
        this.cp = cp;
        this.sbdb = sbdb;
        this.block = block;
        this.allowSchemeSetWell = allowSchemeSetWell;
        this.alwaysEncode = alwaysEncode;
        this.initComponents();
        this.init(cp, allowEdit, canWrite);
    }

    public DialogChartFont(JDialog parent, boolean modal, ChartProperties cp, SBdb sbdb, ChartBlock block, boolean allowSchemeSetWell, boolean allowEdit) {
        super((Window)parent, modal);
        this.cp = cp;
        this.sbdb = sbdb;
        this.block = block;
        this.allowSchemeSetWell = allowSchemeSetWell;
        this.alwaysEncode = false;
        this.initComponents();
        this.init(cp, allowEdit, true);
    }

    private void init(ChartProperties cp, boolean allowEdit, boolean canWrite) {
        DefaultComboBoxModel[] models;
        for (DefaultComboBoxModel model : models = new DefaultComboBoxModel[]{new DefaultComboBoxModel(), new DefaultComboBoxModel()}) {
            model.addElement(new ComboboxItem<PanelWellHeader.WellNameDisplay>(PanelWellHeader.WellNameDisplay.NORMAL, "Use primary well name"));
            model.addElement(new ComboboxItem<PanelWellHeader.WellNameDisplay>(PanelWellHeader.WellNameDisplay.ALTERNATIVE, "Use alternate well name"));
            model.addElement(new ComboboxItem<PanelWellHeader.WellNameDisplay>(PanelWellHeader.WellNameDisplay.BOTH, "Use primary, show both"));
            model.addElement(new ComboboxItem<PanelWellHeader.WellNameDisplay>(PanelWellHeader.WellNameDisplay.CONCAT, "Use primary + alternate"));
        }
        this.jComboBoxWellName.setModel(models[0]);
        this.jComboBoxBCWellNames.setModel(models[1]);
        this.jButtonApply.setVisible(this.applyListener != null);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = env.getAvailableFontFamilyNames();
        this.jComboBoxFont.setModel(new DefaultComboBoxModel<String>(fontFamilies));
        this.jComboBoxFont.setSelectedItem(cp.font);
        this.jSpinnerFontSize.setValue(Float.valueOf((float)SB.round((double)(cp.getFontSize() / 0.3527f), (int)1)));
        this.jCheckBoxCorrectCuttings.setSelected(cp.correctCuttings);
        this.jCheckBoxCorrectDepth.setSelected(cp.correctDepths);
        this.jCheckBoxDrawEmptyPanels.setSelected(cp.drawEmptyPanels);
        this.jCheckBoxDrawDisconfs.setSelected(cp.drawDisconformities);
        this.jCheckBoxDrawDisconfDuration.setSelected(cp.drawDisconfDuration);
        this.jCheckBoxCorrTick.setSelected(cp.isDrawCorrelationTicks());
        switch (cp.ageFormat) {
            case MA: {
                this.jRadioButtonAFMA.setSelected(true);
                break;
            }
            case KA: {
                this.jRadioButtonAFKA.setSelected(true);
            }
        }
        this.jSpinnerCaption.setValue((int)cp.panelCaptionHeight);
        this.jSpinnerExtCaption.setValue((int)cp.panelExtCaptionHeight);
        this.jSpinnerSubHeader.setValue((int)cp.panelSubHeaderHeight);
        this.setTotalHeaderHeight();
        this.jSpinnerMargin.setValue((int)cp.margin);
        this.jSpinnerBlankSpace.setValue((int)cp.blankPanel);
        this.jCheckBoxBlankRelative.setSelected(cp.blankPanelRelative);
        this.jSpinnerVfreeze.setValue(cp.getnVfreeze());
        this.jCheckBoxChartBorder.setSelected(cp.border);
        this.jCheckBoxMapAlign.setSelected(cp.alignMaps);
        this.jTextFieldForeground.setBackground(cp.foreground);
        this.jTextFieldBackground.setBackground(cp.background);
        this.jTextFieldGapHatchColour.setBackground(cp.gapHatchColour);
        this.jCheckBoxGreyscale.setSelected(cp.greyscale);
        if (cp.bgSchID > 0) {
            try {
                this.scheme = this.sbdb.getIGDScheme(cp.bgSchID);
                if (this.scheme != null) {
                    this.jTextFieldbgScheme.setText(this.scheme.toString());
                    this.fillHierCombo();
                    this.jComboBoxHier.setSelectedIndex(cp.bgHier - 1);
                } else {
                    cp.bgSchID = 0;
                }
            }
            catch (SQLException sql) {
                cp.bgSchID = 0;
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
        this.jCheckBoxbgBlocks.setSelected(cp.bgBlocks);
        this.jSliderbgDensity.setValue((int)(cp.bgDensity * 100.0f));
        this.jCheckBoxBgPinchouts.setSelected(cp.bgPinchouts);
        this.enableBG();
        this.jCheckBoxCaptions.setSelected(cp.plotBlockCaptions);
        if (cp.blockCapTop) {
            this.jRadioButtonCapTop.setSelected(true);
        } else {
            this.jRadioButtonCapBase.setSelected(true);
        }
        this.jSpinnerCapHeight.setValue((int)cp.blockCapHeight);
        if (cp.blockCapAlignChart) {
            this.jRadioButtonCapAlignChart.setSelected(true);
        } else {
            this.jRadioButtonCapAlignBlocks.setSelected(true);
        }
        this.jComboBoxBlockCapFontSize.setSelectedItem((Object)cp.blockcapFontSize);
        ComboboxItem.setComboBoxItemByValue(this.jComboBoxBCWellNames, cp.blockCapWellNameDisplay);
        this.jPanelWellObj.setVisible(false);
        if (this.block != null) {
            this.ageVerifier = new SbugsInputVerifier((float)((double)0.1f / cp.ageFormat.getMultiplyer()), (float)(1000.0 / cp.ageFormat.getMultiplyer()), this.block.getProp().getSingleScale());
            this.depthVerifier = new SbugsInputVerifier(1.0f, 100000.0f, (float)((int)this.block.getProp().getSingleScale()));
            if (this.block instanceof WellBlock) {
                WellBlock wBlock = (WellBlock)this.block;
                double blockMin = DepthUtils.convFromM((float)wBlock.getProp().getMin(), (char)this.block.getProp().getUnits(), (char)this.block.getWell().getType());
                double blockMax = DepthUtils.convFromM((float)wBlock.getProp().getMax(), (char)this.block.getProp().getUnits(), (char)this.block.getWell().getType());
                switch (this.block.getProp().getScaleType()) {
                    case AGE: {
                        blockMin = this.block.getInterp().getLOC().getDepth(blockMin, null, null, true);
                        blockMax = this.block.getInterp().getLOC().getDepth(blockMax, null, null, false);
                    }
                }
                this.jTextFieldTopDepth.setText(SB.floatString((double)blockMin, (int)2));
                this.jTextFieldBaseDepth.setText(SB.floatString((double)blockMax, (int)2));
            } else if (this.block instanceof SchemeBlock) {
                this.jLabelTopDepth.setText("Min age:");
                this.jLabelBaseDepth.setText("Max age:");
                this.jTextFieldTopDepth.setText((String)((double)this.block.getProp().getMin() > 999.99 ? SB.floatString((float)this.block.getProp().getMin(), (int)0) : "" + this.block.getProp().getMin()));
                this.jTextFieldBaseDepth.setText((String)((double)this.block.getProp().getMax() > 999.99 ? SB.floatString((float)this.block.getProp().getMax(), (int)0) : "" + this.block.getProp().getMax()));
                this.jPanelBlockScaleType.setVisible(false);
                this.jPanelBlockUnits.setVisible(false);
            }
            if (this.block.getProp().getUnits() == 'F') {
                this.jRadioButtonFeet.setSelected(true);
            } else {
                this.jRadioButtonMetres.setSelected(true);
            }
            this.units = this.block.getProp().getUnits();
            this.scaleType = this.block.getProp().getScaleType();
            switch (this.block.getProp().getScaleType()) {
                case MD: {
                    this.jRadioButtonMD.setSelected(true);
                    break;
                }
                case TVD: {
                    this.jRadioButtonTVD.setSelected(true);
                    break;
                }
                case AGE: {
                    this.jRadioButtonAGE.setSelected(true);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.block.getWell() != null && !(this.block instanceof SchemeBlock)) {
                this.updateDepthLabels();
            }
            ((JTextField)this.jComboBoxVerticalScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)(this.scaleType == BlockProperties.ScaleType.AGE ? this.ageVerifier : this.depthVerifier));
            this.setAgeVisible();
            this.updateAges();
            this.setScaleCombo(false);
            if (this.block.getWell() != null && this.block.getInterp().getLOC() != null) {
                this.jLabelLOCMinAge.setText("(min: " + SB.round((double)this.block.getInterp().getLOC().getMinAge(), (int)2) + ")");
                this.jLabelLOCMaxAge.setText("(max: " + SB.round((double)this.block.getInterp().getLOC().getMaxAge(), (int)2) + ")");
            } else {
                this.jRadioButtonAGE.setSelected(false);
                this.jRadioButtonAGE.setEnabled(false);
            }
            if (this.block instanceof SchemeBlock && this.allowSchemeSetWell) {
                this.wellObj = this.block.getWellList() != null ? this.block.getWellList() : this.block.getWell();
                this.jTextFieldWellObj.setText(this.wellObj != null ? this.wellObj.toString() : "");
                try {
                    for (InterpHdr interp : this.sbdb.getInterps()) {
                        this.interpModel.addElement(interp);
                    }
                    this.jComboBoxVersion.setSelectedItem(this.sbdb.getInterp(this.block.getInterpID()));
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                }
                this.jPanelWellObj.setVisible(true);
            }
        } else {
            this.jTabbedPane1.remove(this.jPanelBlockProperties);
        }
        PanelWellHeader hdr = cp.header != null ? cp.header : new PanelWellHeader();
        this.jTextFieldHdrHeight.setText("" + Float.valueOf(hdr.height).intValue());
        if (hdr.centreName) {
            this.jRadioButtonWellNameCentre.setSelected(true);
        } else {
            this.jRadioButtonWellNameLeft.setSelected(true);
        }
        this.jCheckBoxWellCode.setSelected(hdr.wellCode);
        this.jCheckBoxLocation.setSelected(hdr.location);
        if (hdr.decimalLocation) {
            this.jRadioButtonLocDec.setSelected(true);
        } else {
            this.jRadioButtonLocDMS.setSelected(true);
        }
        this.jCheckBoxLocationActionPerformed(null);
        this.jCheckBoxOperator.setSelected(hdr.operator);
        this.jCheckBoxSpud.setSelected(hdr.spud);
        this.jCheckBoxLogo.setSelected(hdr.logo);
        this.jCheckBoxBorder.setSelected(hdr.border);
        this.jCheckBoxScale.setSelected(hdr.scale);
        this.jCheckBoxComments.setSelected(hdr.comments);
        this.jCheckBoxDepthInterval.setSelected(hdr.depthInterval);
        this.jCheckBoxTD.setSelected(hdr.td);
        if (cp.header != null) {
            if (cp.header.style == PanelWellHeader.HeaderStyle.WELL) {
                this.jRadioButtonHdrWell.setSelected(true);
                this.jRadioButtonHdrWellActionPerformed(null);
            } else {
                this.jRadioButtonHdrFree.setSelected(true);
                this.jRadioButtonHdrFreeActionPerformed(null);
            }
        } else {
            this.jRadioButtonHdrNone.setSelected(true);
            this.jRadioButtonHdrNoneActionPerformed(null);
        }
        this.jTextAreaHdrTitle.setText(hdr.title);
        switch (hdr.orientation) {
            case TOP: {
                this.jRadioButtonHdrTop.setSelected(true);
                break;
            }
            case BOTTOM: {
                this.jRadioButtonHdrBottom.setSelected(true);
            }
        }
        this.jTextFieldHdrAuthor.setText(hdr.author);
        this.jTextFieldHdrEnclosure.setText(hdr.enclosure);
        this.jCheckBoxHdrTemplName.setSelected(hdr.templName);
        this.jCheckBoxHdrTemplDescr.setSelected(hdr.templDescr);
        this.jCheckBoxHdrTemplDate.setSelected(hdr.templDate);
        this.jCheckBoxClientName.setSelected(hdr.clientName);
        this.jCheckBoxHdrWellList.setSelected(hdr.wellListName);
        ComboboxItem.setComboBoxItemByValue(this.jComboBoxWellName, hdr.wellNameDisplay);
        this.enableHeaderFields(cp.header != null);
        PanelKey key = cp.key != null ? cp.key : new PanelKey();
        this.jCheckBoxKey.setSelected(cp.key != null);
        this.jCheckBoxKeyText.setSelected(key.text);
        this.jCheckBoxKeyBnd.setSelected(key.bndKey);
        this.jTextFieldKeyHeight.setText("" + (int)key.height);
        this.jCheckBoxKeyBorder.setSelected(key.border);
        switch (key.orientation) {
            case TOP: {
                this.jRadioButtonKeyTop.setSelected(true);
                break;
            }
            case BOTTOM: {
                this.jRadioButtonKeyBottom.setSelected(true);
                break;
            }
            case RIGHT: {
                this.jRadioButtonKeyRight.setSelected(true);
                break;
            }
            case LEFT: {
                this.jRadioButtonKeyLeft.setSelected(true);
            }
        }
        this.jCheckBoxKeyLithBase.setSelected(key.lithBase);
        this.jCheckBoxKeyLithQual.setSelected(key.lithQual);
        this.jCheckBoxKeySamp.setSelected(key.sampling);
        this.jCheckBoxKeyAbn.setSelected(key.abnSchemes);
        this.jCheckBoxKeyCorr.setSelected(key.correlationLines);
        this.jCheckBoxKeyTxGroup.setSelected(key.txGroups);
        this.jCheckBoxKeyEnvSchs.setSelected(key.envSchemes);
        this.jCheckBoxKeyCats.setSelected(key.categories);
        this.enableKeyFields(cp.key != null);
        if (!allowEdit) {
            this.jTabbedPane1.remove(this.jPanelData);
            this.jTabbedPane1.remove(this.jPanelColours);
            this.jTabbedPane1.remove(this.jPanelFonts);
            this.jTabbedPane1.remove(this.jPanelDimensions);
            this.jTabbedPane1.remove(this.jPanelHeader);
            this.jTabbedPane1.remove(this.jPanelKey);
            this.jButtonCopy.setEnabled(false);
        }
        this.setTitle("Block Layout Properties");
        if (canWrite) {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        } else {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText("Template is read-only");
        }
        if (this.jTabbedPane1.getTabCount() > tab) {
            this.jTabbedPane1.setSelectedIndex(tab);
        }
        this.enumComboChartDatum.init(ChartProperties.ChartDatum.class);
        this.enumComboChartDatum.setSelectedItem((Object)cp.getChartDatum());
    }

    private void setTotalHeaderHeight() {
        int capHeight = Integer.parseInt(this.jSpinnerCaption.getValue().toString());
        int subHeaderHeight = Integer.parseInt(this.jSpinnerSubHeader.getValue().toString());
        this.jTextFieldTotalHeaderHeight.setText("" + (capHeight + subHeaderHeight));
    }

    public void setApplyActionListener(ActionListener listener) {
        this.applyListener = listener;
        this.jButtonApply.setVisible(listener != null);
    }

    private void enableBG() {
        this.jSliderbgDensity.setEnabled(this.scheme != null);
        this.jCheckBoxbgBlocks.setEnabled(this.scheme != null);
        this.jComboBoxHier.setEnabled(this.scheme != null);
        this.jCheckBoxBgPinchouts.setEnabled(this.scheme != null);
    }

    private void fillHierCombo() {
        this.hierModel.removeAllElements();
        if (this.scheme == null) {
            return;
        }
        int nHier = IGDIntervalZone.getNHier(this.scheme.getIGDType(), true);
        for (int i = 1; i <= nHier; ++i) {
            this.hierModel.addElement(IGDIntervalZone.getHierName(this.scheme.getIGDType(), i));
        }
        this.jComboBoxHier.setSelectedIndex(nHier - 1);
    }

    private void setAgeVisible() {
        boolean b = this.block != null && this.block instanceof WellBlock && this.block.getInterp().getLOC() != null && this.jRadioButtonAGE.isSelected();
        this.jTextFieldMinAge.setVisible(b);
        this.jTextFieldMaxAge.setVisible(b);
        this.jLabelScale.setVisible(b);
        this.jLabelMinAge.setVisible(b);
        this.jLabelMaxAge.setVisible(b);
        this.jLabelLOCMaxAge.setVisible(b);
        this.jLabelLOCMinAge.setVisible(b);
    }

    private void setScaleCombo(boolean change) {
        float scale = 0.0f;
        if (this.jRadioButtonAGE.isSelected()) {
            SchemeBlock.fillScaleCombo(this.scaleModel);
            float minAge = Float.parseFloat(this.jTextFieldTopDepth.getText());
            float maxAge = Float.parseFloat(this.jTextFieldBaseDepth.getText());
            if (change) {
                scale = SchemeBlock.calcIdealScale(minAge, maxAge);
            }
            ((JTextField)this.jComboBoxVerticalScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)this.ageVerifier);
        } else {
            try {
                this.sbdb.getChartScales(this.scaleModel);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            float topDepth = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
            float baseDepth = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
            if (change) {
                scale = (float)WellBlock.getDefaultScale(topDepth, baseDepth, this.units);
            }
            ((JTextField)this.jComboBoxVerticalScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)this.depthVerifier);
        }
        if (!change) {
            scale = this.block.getProp().getSingleScale();
        }
        if (this.scaleModel.getIndexOf(Float.valueOf(scale)) < 0) {
            this.scaleModel.addElement(Float.valueOf(scale).intValue());
        }
        this.scaleModel.setSelectedItem(Float.valueOf(scale));
    }

    private void updateAges() {
        if (this.block == null || this.block.getWell() == null || this.block.getInterp().getLOC() == null || !this.jRadioButtonAGE.isSelected()) {
            return;
        }
        double topDepth = Double.parseDouble(this.jTextFieldTopDepth.getText());
        double baseDepth = Double.parseDouble(this.jTextFieldBaseDepth.getText());
        Point2D ageRange = this.block.getInterp().getLOC().getAgeRange(topDepth, baseDepth);
        this.jTextFieldMinAge.setText("" + SB.round((double)ageRange.getX(), (int)2));
        this.jTextFieldMaxAge.setText("" + SB.round((double)ageRange.getY(), (int)2));
    }

    private void enableHeaderFields(boolean b) {
        this.jLabelHdrHeight.setEnabled(b);
        this.jTextFieldHdrHeight.setEnabled(b);
        this.jRadioButtonHdrBottom.setEnabled(b);
        this.jRadioButtonHdrTop.setEnabled(b);
        this.jCheckBoxLogo.setEnabled(b);
        this.jCheckBoxScale.setEnabled(b);
        this.jCheckBoxBorder.setEnabled(b);
        this.jCheckBoxHdrTemplName.setEnabled(b);
        this.jCheckBoxHdrTemplDescr.setEnabled(b);
        this.jCheckBoxHdrTemplDate.setEnabled(b);
        this.jTextFieldHdrAuthor.setEnabled(b);
        this.jTextFieldHdrEnclosure.setEnabled(b);
        this.jLabelHdrTitlePos.setEnabled(b);
        this.jRadioButtonWellNameLeft.setEnabled(b);
        this.jRadioButtonWellNameCentre.setEnabled(b);
        this.jLabelHdrAuthor.setEnabled(b);
        this.jLabelHdrEnclosure.setEnabled(b);
        this.jLabelWellName.setEnabled(b);
        this.jComboBoxWellName.setEnabled(b);
        this.jCheckBoxHdrWellList.setEnabled(b);
    }

    private void enableKeyFields(boolean b) {
        this.jCheckBoxKeyText.setEnabled(b);
        this.jCheckBoxKeyBnd.setEnabled(b);
        this.jRadioButtonKeyTop.setEnabled(b);
        this.jRadioButtonKeyBottom.setEnabled(b);
        this.jRadioButtonKeyLeft.setEnabled(b);
        this.jRadioButtonKeyRight.setEnabled(b);
        this.jLabelKeyOrientation.setEnabled(b);
        this.jLabelKeySize.setEnabled(b);
        this.jTextFieldKeyHeight.setEnabled(b);
        this.jCheckBoxKeyBorder.setEnabled(b);
        this.jCheckBoxKeyLithBase.setEnabled(b);
        this.jCheckBoxKeyLithQual.setEnabled(b);
        this.jCheckBoxKeySamp.setEnabled(b);
        this.jCheckBoxKeyAbn.setEnabled(b);
        this.jCheckBoxKeyCorr.setEnabled(b);
        this.jCheckBoxKeyCats.setEnabled(b);
        this.jCheckBoxKeyTxGroup.setEnabled(b);
        this.jCheckBoxKeyEnvSchs.setEnabled(b);
    }

    private void updateDepthLabels() {
        if (this.jRadioButtonTVD.isSelected()) {
            this.jLabelTopDepth.setText("Top TVD:");
            this.jLabelBaseDepth.setText("Base TVD:");
        } else if (this.jRadioButtonMD.isSelected() || this.jRadioButtonAGE.isSelected()) {
            this.jLabelTopDepth.setText("Top Depth:");
            this.jLabelBaseDepth.setText("Base Depth:");
        } else assert (false);
    }

    private void initComponents() {
        this.AgeFormat = new ButtonGroup();
        this.buttonGroupCapAlign = new ButtonGroup();
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupScaleType = new ButtonGroup();
        this.buttonGroupHdrPlacement = new ButtonGroup();
        this.buttonGroupKeyPlacement = new ButtonGroup();
        this.buttonGroupHeader = new ButtonGroup();
        this.buttonGroupTitlePos = new ButtonGroup();
        this.jPanelBlockAltScale = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jComboBoxAltScale = new JComboBox();
        this.jTextFieldAltMin = new JTextField();
        this.jTextFieldAltMax = new JTextField();
        this.jCheckBoxAltAgeLTR = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.buttonGroupCapPos = new ButtonGroup();
        this.buttonGroupHdrLocation = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelBlockProperties = new JPanel();
        this.jPanelWellObj = new JPanel();
        this.jLabelWellObj = new JLabel();
        this.jTextFieldWellObj = new JTextField();
        this.jButtonWellObj = new JButton();
        this.jLabel23 = new JLabel();
        this.jComboBoxVersion = new JComboBox();
        this.jButtonWellObjClear = new JButton();
        this.jLabel22 = new JLabel();
        this.jLabelTopDepth = new JLabel();
        this.jLabelBaseDepth = new JLabel();
        this.jComboBoxVerticalScale = new JComboBox();
        this.jTextFieldTopDepth = new JTextField();
        this.jTextFieldBaseDepth = new JTextField();
        this.jPanelBlockUnits = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jTextFieldMaxAge = new JTextField();
        this.jTextFieldMinAge = new JTextField();
        this.jLabelMinAge = new JLabel();
        this.jLabelLOCMinAge = new JLabel();
        this.jLabelMaxAge = new JLabel();
        this.jLabelLOCMaxAge = new JLabel();
        this.jPanelBlockScaleType = new JPanel();
        this.jRadioButtonMD = new JRadioButton();
        this.jRadioButtonTVD = new JRadioButton();
        this.jRadioButtonAGE = new JRadioButton();
        this.jLabelScale = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 3), new Dimension(0, 3), new Dimension(Short.MAX_VALUE, 3));
        this.jPanelFonts = new JPanel();
        this.jLabel8 = new JLabel();
        this.jComboBoxFont = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jSpinnerFontSize = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jButtonDefaultFont = new JButton();
        this.jPanelColours = new JPanel();
        this.jLabel13 = new JLabel();
        this.jTextFieldForeground = new JTextField();
        this.jButtonForeground = new JButton();
        this.jTextFieldBackground = new JTextField();
        this.jLabel14 = new JLabel();
        this.jButtonBackground = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel16 = new JLabel();
        this.jTextFieldbgScheme = new JTextField();
        this.jButtonSelectScheme = new JButton();
        this.jButtonClearScheme = new JButton();
        this.jLabel17 = new JLabel();
        this.jComboBoxHier = new JComboBox();
        this.jCheckBoxbgBlocks = new JCheckBox();
        this.jSliderbgDensity = new JSlider();
        this.jLabel18 = new JLabel();
        this.jCheckBoxBgPinchouts = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.jTextFieldGapHatchColour = new JTextField();
        this.jButtonGapHatchColour = new JButton();
        this.jCheckBoxGreyscale = new JCheckBox();
        this.jPanelDimensions = new JPanel();
        this.jPanel2 = new JPanel();
        this.jRadioButtonCapTop = new JRadioButton();
        this.jRadioButtonCapBase = new JRadioButton();
        this.jSpinnerCapHeight = new JSpinner();
        this.jLabel20 = new JLabel();
        this.jCheckBoxCaptions = new JCheckBox();
        this.jRadioButtonCapAlignChart = new JRadioButton();
        this.jRadioButtonCapAlignBlocks = new JRadioButton();
        this.jLabel21 = new JLabel();
        this.jComboBoxBlockCapFontSize = new JComboBox();
        this.jComboBoxBCWellNames = new JComboBox();
        this.jLabelWellName1 = new JLabel();
        this.jSpinnerVfreeze = new JSpinner();
        this.jLabel7 = new JLabel();
        this.jCheckBoxChartBorder = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jLabel15 = new JLabel();
        this.jSpinnerBlankSpace = new JSpinner();
        this.jCheckBoxBlankRelative = new JCheckBox();
        this.jCheckBoxMapAlign = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jLabel19 = new JLabel();
        this.jSpinnerCaption = new JSpinner();
        this.jSpinnerExtCaption = new JSpinner();
        this.jLabel10 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jSpinnerSubHeader = new JSpinner();
        this.jTextFieldTotalHeaderHeight = new JTextField();
        this.jLabel26 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jSpinnerMargin = new JSpinner();
        this.jPanelHeader = new JPanel();
        this.jCheckBoxBorder = new JCheckBox();
        this.jCheckBoxLogo = new JCheckBox();
        this.jTextFieldHdrHeight = new JTextField();
        this.jLabelHdrHeight = new JLabel();
        this.jCheckBoxScale = new JCheckBox();
        this.jRadioButtonHdrBottom = new JRadioButton();
        this.jRadioButtonHdrTop = new JRadioButton();
        this.jRadioButtonHdrWell = new JRadioButton();
        this.jRadioButtonHdrFree = new JRadioButton();
        this.jRadioButtonHdrNone = new JRadioButton();
        this.jPanelHdrCards = new JPanel();
        this.jPanelHdrWell = new JPanel();
        this.jCheckBoxSpud = new JCheckBox();
        this.jCheckBoxWellCode = new JCheckBox();
        this.jCheckBoxLocation = new JCheckBox();
        this.jCheckBoxOperator = new JCheckBox();
        this.jRadioButtonLocDec = new JRadioButton();
        this.jRadioButtonLocDMS = new JRadioButton();
        this.jCheckBoxComments = new JCheckBox();
        this.jCheckBoxDepthInterval = new JCheckBox();
        this.jCheckBoxClientName = new JCheckBox();
        this.jCheckBoxTD = new JCheckBox();
        this.jPanelHdrFree = new JPanel();
        this.jLabel24 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaHdrTitle = TextFieldUtils.buildLimitedLengthTextArea(400);
        this.jPanelHdrNone = new JPanel();
        this.jRadioButtonWellNameCentre = new JRadioButton();
        this.jRadioButtonWellNameLeft = new JRadioButton();
        this.jLabelHdrTitlePos = new JLabel();
        this.jLabelHdrAuthor = new JLabel();
        this.jTextFieldHdrAuthor = TextFieldUtils.buildLimitedLengthTextField(40);
        this.jCheckBoxHdrTemplName = new JCheckBox();
        this.jCheckBoxHdrTemplDescr = new JCheckBox();
        this.jCheckBoxHdrTemplDate = new JCheckBox();
        this.jLabelHdrEnclosure = new JLabel();
        this.jTextFieldHdrEnclosure = TextFieldUtils.buildLimitedLengthTextField(40);
        this.jComboBoxWellName = new JComboBox();
        this.jLabelWellName = new JLabel();
        this.jCheckBoxHdrWellList = new JCheckBox();
        this.jPanelKey = new JPanel();
        this.jRadioButtonKeyTop = new JRadioButton();
        this.jRadioButtonKeyBottom = new JRadioButton();
        this.jRadioButtonKeyLeft = new JRadioButton();
        this.jRadioButtonKeyRight = new JRadioButton();
        this.jCheckBoxKey = new JCheckBox();
        this.jLabelKeyOrientation = new JLabel();
        this.jLabelKeySize = new JLabel();
        this.jTextFieldKeyHeight = new JTextField();
        this.jPanelKeyOptions = new JPanel();
        this.jCheckBoxKeyText = new JCheckBox();
        this.jCheckBoxKeyBnd = new JCheckBox();
        this.jCheckBoxKeyLithBase = new JCheckBox();
        this.jCheckBoxKeyLithQual = new JCheckBox();
        this.jCheckBoxKeySamp = new JCheckBox();
        this.jCheckBoxKeyAbn = new JCheckBox();
        this.jCheckBoxKeyCorr = new JCheckBox();
        this.jCheckBoxKeyTxGroup = new JCheckBox();
        this.jCheckBoxKeyEnvSchs = new JCheckBox();
        this.jCheckBoxKeyCats = new JCheckBox();
        this.jCheckBoxKeyBorder = new JCheckBox();
        this.jPanelData = new JPanel();
        this.jCheckBoxCorrectDepth = new JCheckBox();
        this.jCheckBoxCorrectCuttings = new JCheckBox();
        this.jLabel11 = new JLabel();
        this.jRadioButtonAFMA = new JRadioButton();
        this.jRadioButtonAFKA = new JRadioButton();
        this.jCheckBoxDrawEmptyPanels = new JCheckBox();
        this.jCheckBoxDrawDisconfs = new JCheckBox();
        this.jCheckBoxDrawDisconfDuration = new JCheckBox();
        this.jCheckBoxCorrTick = new JCheckBox();
        this.enumComboChartDatum = new EnumCombo();
        this.jLabel27 = new JLabel();
        this.jButtonApply = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonCopy = new JButton();
        this.jLabel2.setText("Min:");
        this.jLabel3.setText("Max:");
        this.jLabel4.setText("Scale:");
        this.jComboBoxAltScale.setEditable(true);
        this.jCheckBoxAltAgeLTR.setText("Left to Right");
        GroupLayout jPanelBlockAltScaleLayout = new GroupLayout(this.jPanelBlockAltScale);
        this.jPanelBlockAltScale.setLayout(jPanelBlockAltScaleLayout);
        jPanelBlockAltScaleLayout.setHorizontalGroup(jPanelBlockAltScaleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockAltScaleLayout.createSequentialGroup().addContainerGap().addGroup(jPanelBlockAltScaleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockAltScaleLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxAltScale, -2, -1, -2)).addGroup(jPanelBlockAltScaleLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanelBlockAltScaleLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelBlockAltScaleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldAltMax).addComponent(this.jTextFieldAltMin)).addContainerGap()).addComponent(this.jCheckBoxAltAgeLTR, -2, 177, -2))));
        jPanelBlockAltScaleLayout.setVerticalGroup(jPanelBlockAltScaleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockAltScaleLayout.createSequentialGroup().addContainerGap().addGroup(jPanelBlockAltScaleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldAltMin, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelBlockAltScaleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldAltMax, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelBlockAltScaleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jComboBoxAltScale, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxAltAgeLTR).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel6.setText("jLabel6");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabelWellObj.setText("Well/Project:");
        this.jTextFieldWellObj.setEditable(false);
        this.jTextFieldWellObj.setBackground(new Color(255, 255, 204));
        this.jButtonWellObj.setText("...");
        this.jButtonWellObj.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWellObjActionPerformed(evt);
            }
        });
        this.jLabel23.setText("Version:");
        this.jComboBoxVersion.setMaximumRowCount(30);
        this.jComboBoxVersion.setModel(this.interpModel);
        this.jComboBoxVersion.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jButtonWellObjClear.setText("Clear");
        this.jButtonWellObjClear.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWellObjClearActionPerformed(evt);
            }
        });
        GroupLayout jPanelWellObjLayout = new GroupLayout(this.jPanelWellObj);
        this.jPanelWellObj.setLayout(jPanelWellObjLayout);
        jPanelWellObjLayout.setHorizontalGroup(jPanelWellObjLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelWellObjLayout.createSequentialGroup().addContainerGap().addGroup(jPanelWellObjLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel23).addComponent(this.jLabelWellObj)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelWellObjLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldWellObj).addComponent(this.jComboBoxVersion, 0, 172, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonWellObj, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonWellObjClear).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelWellObjLayout.setVerticalGroup(jPanelWellObjLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelWellObjLayout.createSequentialGroup().addContainerGap().addGroup(jPanelWellObjLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelWellObj).addComponent(this.jTextFieldWellObj, -2, -1, -2).addComponent(this.jButtonWellObj).addComponent(this.jButtonWellObjClear)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelWellObjLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel23).addComponent(this.jComboBoxVersion, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel22.setHorizontalAlignment(11);
        this.jLabel22.setText("Scale:");
        this.jLabelTopDepth.setHorizontalAlignment(11);
        this.jLabelTopDepth.setText("Top depth:");
        this.jLabelBaseDepth.setHorizontalAlignment(11);
        this.jLabelBaseDepth.setText("Base depth:");
        this.jComboBoxVerticalScale.setEditable(true);
        this.jComboBoxVerticalScale.setModel(this.scaleModel);
        this.jComboBoxVerticalScale.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jTextFieldTopDepth.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.jTextFieldTopDepthFocusLost(evt);
            }
        });
        this.jTextFieldTopDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldTopDepthKeyTyped(evt);
            }
        });
        this.jTextFieldBaseDepth.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.jTextFieldBaseDepthFocusLost(evt);
            }
        });
        this.jTextFieldBaseDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldBaseDepthKeyTyped(evt);
            }
        });
        this.jPanelBlockUnits.setBorder(BorderFactory.createTitledBorder(null, "Depth Units", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setSelected(true);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanelBlockUnitsLayout = new GroupLayout(this.jPanelBlockUnits);
        this.jPanelBlockUnits.setLayout(jPanelBlockUnitsLayout);
        jPanelBlockUnitsLayout.setHorizontalGroup(jPanelBlockUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockUnitsLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonMetres).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFeet).addContainerGap(22, Short.MAX_VALUE)));
        jPanelBlockUnitsLayout.setVerticalGroup(jPanelBlockUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockUnitsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonMetres).addComponent(this.jRadioButtonFeet)));
        this.jTextFieldMaxAge.setEditable(false);
        this.jTextFieldMaxAge.setBackground(new Color(255, 255, 204));
        this.jTextFieldMaxAge.setToolTipText("Age at base depth");
        this.jTextFieldMinAge.setEditable(false);
        this.jTextFieldMinAge.setBackground(new Color(255, 255, 204));
        this.jTextFieldMinAge.setToolTipText("Age at top depth");
        this.jLabelMinAge.setText("Ma");
        this.jLabelLOCMinAge.setForeground(new Color(153, 153, 153));
        this.jLabelLOCMinAge.setText("(min: )");
        this.jLabelMaxAge.setText("Ma");
        this.jLabelLOCMaxAge.setForeground(new Color(153, 153, 153));
        this.jLabelLOCMaxAge.setText("(max: )");
        this.jPanelBlockScaleType.setBorder(BorderFactory.createTitledBorder(null, "Scale Type", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupScaleType.add(this.jRadioButtonMD);
        this.jRadioButtonMD.setText("Measured Depth");
        this.jRadioButtonMD.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMDActionPerformed(evt);
            }
        });
        this.buttonGroupScaleType.add(this.jRadioButtonTVD);
        this.jRadioButtonTVD.setText("True Vertical Depth");
        this.jRadioButtonTVD.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonTVDActionPerformed(evt);
            }
        });
        this.buttonGroupScaleType.add(this.jRadioButtonAGE);
        this.jRadioButtonAGE.setText("Age");
        this.jRadioButtonAGE.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonAGEActionPerformed(evt);
            }
        });
        GroupLayout jPanelBlockScaleTypeLayout = new GroupLayout(this.jPanelBlockScaleType);
        this.jPanelBlockScaleType.setLayout(jPanelBlockScaleTypeLayout);
        jPanelBlockScaleTypeLayout.setHorizontalGroup(jPanelBlockScaleTypeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockScaleTypeLayout.createSequentialGroup().addContainerGap().addGroup(jPanelBlockScaleTypeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonMD).addComponent(this.jRadioButtonTVD).addComponent(this.jRadioButtonAGE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelBlockScaleTypeLayout.setVerticalGroup(jPanelBlockScaleTypeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockScaleTypeLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonMD).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonTVD).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAGE).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabelScale.setText("m/ma");
        GroupLayout jPanelBlockPropertiesLayout = new GroupLayout(this.jPanelBlockProperties);
        this.jPanelBlockProperties.setLayout(jPanelBlockPropertiesLayout);
        jPanelBlockPropertiesLayout.setHorizontalGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockPropertiesLayout.createSequentialGroup().addContainerGap().addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filler1, -2, 354, -2).addGroup(jPanelBlockPropertiesLayout.createSequentialGroup().addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTopDepth, GroupLayout.Alignment.TRAILING).addComponent(this.jLabelBaseDepth, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel22, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldTopDepth, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldBaseDepth, GroupLayout.Alignment.LEADING, -2, 106, -2)).addComponent(this.jComboBoxVerticalScale, GroupLayout.Alignment.TRAILING, -2, 106, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockPropertiesLayout.createSequentialGroup().addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldMinAge, -2, 82, -2).addComponent(this.jTextFieldMaxAge, -2, 82, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockPropertiesLayout.createSequentialGroup().addComponent(this.jLabelMaxAge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelLOCMaxAge)).addGroup(jPanelBlockPropertiesLayout.createSequentialGroup().addComponent(this.jLabelMinAge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelLOCMinAge)))).addComponent(this.jLabelScale))).addGroup(jPanelBlockPropertiesLayout.createSequentialGroup().addComponent(this.jPanelBlockScaleType, -2, -1, -2).addGap(12, 12, 12).addComponent(this.jPanelBlockUnits, -2, -1, -2)).addComponent(this.jPanelWellObj, -2, -1, -2)).addContainerGap(86, Short.MAX_VALUE)));
        jPanelBlockPropertiesLayout.setVerticalGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBlockPropertiesLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelBlockPropertiesLayout.createSequentialGroup().addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTopDepth).addComponent(this.jTextFieldTopDepth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelBaseDepth).addComponent(this.jTextFieldBaseDepth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel22).addComponent(this.jComboBoxVerticalScale, -2, -1, -2).addComponent(this.jLabelScale))).addGroup(jPanelBlockPropertiesLayout.createSequentialGroup().addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMinAge, -2, -1, -2).addComponent(this.jLabelMinAge).addComponent(this.jLabelLOCMinAge)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMaxAge).addComponent(this.jTextFieldMaxAge, -2, -1, -2).addComponent(this.jLabelLOCMaxAge)).addGap(25, 25, 25))).addComponent(this.filler1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelBlockPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelBlockUnits, -2, -1, -2).addComponent(this.jPanelBlockScaleType, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanelWellObj, -2, -1, -2).addContainerGap(56, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Block", this.jPanelBlockProperties);
        this.jLabel8.setText("pt");
        this.jComboBoxFont.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxFont.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel1.setText("Font face name:");
        this.jSpinnerFontSize.setModel(new SpinnerNumberModel(Float.valueOf(8.5f), Float.valueOf(2.0f), Float.valueOf(42.0f), Float.valueOf(0.5f)));
        this.jLabel5.setText("Base font size:");
        this.jButtonDefaultFont.setText("Restore default");
        this.jButtonDefaultFont.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDefaultFontActionPerformed(evt);
            }
        });
        GroupLayout jPanelFontsLayout = new GroupLayout(this.jPanelFonts);
        this.jPanelFonts.setLayout(jPanelFontsLayout);
        jPanelFontsLayout.setHorizontalGroup(jPanelFontsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFontsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFontsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelFontsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelFontsLayout.createSequentialGroup().addComponent(this.jSpinnerFontSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonDefaultFont)).addComponent(this.jComboBoxFont, -2, 218, -2)).addContainerGap(151, Short.MAX_VALUE)));
        jPanelFontsLayout.setVerticalGroup(jPanelFontsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFontsLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(jPanelFontsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxFont, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanelFontsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerFontSize, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jLabel5).addComponent(this.jButtonDefaultFont)).addContainerGap(302, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Fonts", this.jPanelFonts);
        this.jLabel13.setText("Foreground:");
        this.jTextFieldForeground.setEditable(false);
        this.jButtonForeground.setText("...");
        this.jButtonForeground.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonForeground.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonForegroundActionPerformed(evt);
            }
        });
        this.jTextFieldBackground.setEditable(false);
        this.jLabel14.setText("Background:");
        this.jButtonBackground.setText("...");
        this.jButtonBackground.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonBackground.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonBackgroundActionPerformed(evt);
            }
        });
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Background Shading", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel16.setText("From scheme:");
        this.jTextFieldbgScheme.setBackground(new Color(255, 255, 204));
        this.jButtonSelectScheme.setText("...");
        this.jButtonSelectScheme.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSelectScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectSchemeActionPerformed(evt);
            }
        });
        this.jButtonClearScheme.setText("Clear");
        this.jButtonClearScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearSchemeActionPerformed(evt);
            }
        });
        this.jLabel17.setText("From level:");
        this.jComboBoxHier.setModel(this.hierModel);
        this.jComboBoxHier.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jCheckBoxbgBlocks.setText("Plot within blocks");
        this.jSliderbgDensity.setValue(30);
        this.jLabel18.setText("Density:");
        this.jCheckBoxBgPinchouts.setText("Pinchouts");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel16, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel18, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jCheckBoxbgBlocks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxBgPinchouts).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxHier, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jSliderbgDensity, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldbgScheme)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectScheme, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClearScheme))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.jTextFieldbgScheme, -2, -1, -2).addComponent(this.jButtonSelectScheme).addComponent(this.jButtonClearScheme)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.jComboBoxHier, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderbgDensity, -2, -1, -2).addComponent(this.jLabel18)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxbgBlocks).addComponent(this.jCheckBoxBgPinchouts)).addContainerGap()));
        this.jLabel9.setText("Interval sample gap:");
        this.jButtonGapHatchColour.setText("...");
        this.jButtonGapHatchColour.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonGapHatchColour.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGapHatchColourActionPerformed(evt);
            }
        });
        this.jCheckBoxGreyscale.setText("Greyscale");
        this.jCheckBoxGreyscale.setToolTipText("All colours will be converted to shades of grey.");
        GroupLayout jPanelColoursLayout = new GroupLayout(this.jPanelColours);
        this.jPanelColours.setLayout(jPanelColoursLayout);
        jPanelColoursLayout.setHorizontalGroup(jPanelColoursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelColoursLayout.createSequentialGroup().addContainerGap().addGroup(jPanelColoursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelColoursLayout.createSequentialGroup().addGroup(jPanelColoursLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel14).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelColoursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldForeground, -2, 26, -2).addComponent(this.jTextFieldBackground, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelColoursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelColoursLayout.createSequentialGroup().addComponent(this.jButtonBackground, -2, 30, -2).addGap(310, 310, 310)).addGroup(jPanelColoursLayout.createSequentialGroup().addComponent(this.jButtonForeground, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxGreyscale).addContainerGap()))).addGroup(jPanelColoursLayout.createSequentialGroup().addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(jPanelColoursLayout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldGapHatchColour, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGapHatchColour, -2, 30, -2).addGap(0, 0, Short.MAX_VALUE)))));
        jPanelColoursLayout.setVerticalGroup(jPanelColoursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelColoursLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(jPanelColoursLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jTextFieldForeground, -2, -1, -2).addComponent(this.jButtonForeground).addComponent(this.jCheckBoxGreyscale)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelColoursLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.jTextFieldBackground, -2, -1, -2).addComponent(this.jButtonBackground)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelColoursLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jTextFieldGapHatchColour, -2, -1, -2).addComponent(this.jButtonGapHatchColour)).addContainerGap(133, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Colours", this.jPanelColours);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Block Captions", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupCapPos.add(this.jRadioButtonCapTop);
        this.jRadioButtonCapTop.setText("Top");
        this.buttonGroupCapPos.add(this.jRadioButtonCapBase);
        this.jRadioButtonCapBase.setText("Bottom");
        this.jSpinnerCapHeight.setModel(new SpinnerNumberModel(10, 5, 100, 1));
        this.jLabel20.setText("Height:");
        this.jCheckBoxCaptions.setText("Plot captions");
        this.buttonGroupCapAlign.add(this.jRadioButtonCapAlignChart);
        this.jRadioButtonCapAlignChart.setText("Align with chart");
        this.buttonGroupCapAlign.add(this.jRadioButtonCapAlignBlocks);
        this.jRadioButtonCapAlignBlocks.setText("Align with blocks");
        this.jLabel21.setText("Font size:");
        this.jComboBoxBlockCapFontSize.setModel(this.fontSizeModel);
        this.jComboBoxBlockCapFontSize.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabelWellName1.setText("Well Names:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxBCWellNames, 0, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelWellName1).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonCapTop).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonCapBase)).addComponent(this.jCheckBoxCaptions).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerCapHeight, -2, 61, -2))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jRadioButtonCapAlignChart).addComponent(this.jRadioButtonCapAlignBlocks)))).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxBlockCapFontSize, 0, 133, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxCaptions).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonCapTop).addComponent(this.jRadioButtonCapBase)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerCapHeight, -2, -1, -2).addComponent(this.jLabel20)).addGap(18, 18, 18).addComponent(this.jRadioButtonCapAlignChart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonCapAlignBlocks).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel21).addComponent(this.jComboBoxBlockCapFontSize, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabelWellName1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxBCWellNames, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jSpinnerVfreeze.setModel(new SpinnerNumberModel(1, 1, 8, 1));
        this.jSpinnerVfreeze.setToolTipText("Used with the freeze panels option  in Samples & Interpretations");
        this.jLabel7.setText("No. panels to freeze:");
        this.jCheckBoxChartBorder.setText("Chart border");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Block Spacing"));
        this.jLabel15.setText("Between blocks:");
        this.jSpinnerBlankSpace.setModel(new SpinnerNumberModel(100, 10, 1000, 10));
        this.jSpinnerBlankSpace.setToolTipText("The gap between adjacent vertical blocks");
        this.jCheckBoxBlankRelative.setText("Relative spacing");
        this.jCheckBoxBlankRelative.setToolTipText("Vary the space between blocks using the well header coordinates.");
        this.jCheckBoxMapAlign.setText("Align map blocks");
        this.jCheckBoxMapAlign.setToolTipText("Attempt to position map blocks relative to their age bracket");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerBlankSpace)).addComponent(this.jCheckBoxBlankRelative).addComponent(this.jCheckBoxMapAlign)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerBlankSpace, -2, -1, -2).addComponent(this.jLabel15)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxBlankRelative).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxMapAlign).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Panel Headers"));
        this.jLabel19.setText("Panel caption height:");
        this.jSpinnerCaption.setModel(new SpinnerNumberModel(0, 0, 200, 1));
        this.jSpinnerCaption.addChangeListener(new ChangeListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jSpinnerCaptionStateChanged(evt);
            }
        });
        this.jSpinnerExtCaption.setModel(new SpinnerNumberModel(80, 0, 500, 5));
        this.jLabel10.setText("Extended caption height:");
        this.jLabel25.setText("Sub-header height:");
        this.jSpinnerSubHeader.setModel(new SpinnerNumberModel(80, 0, 500, 5));
        this.jSpinnerSubHeader.addChangeListener(new ChangeListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jSpinnerSubHeaderStateChanged(evt);
            }
        });
        this.jTextFieldTotalHeaderHeight.setEditable(false);
        this.jTextFieldTotalHeaderHeight.setHorizontalAlignment(11);
        this.jLabel26.setText("Total panel header height:");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel26).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldTotalHeaderHeight, -2, 67, -2)).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel19, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerExtCaption).addComponent(this.jSpinnerCaption))).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel25).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerSubHeader))).addGap(0, 11, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent(this.jSpinnerCaption, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerExtCaption, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel25).addComponent(this.jSpinnerSubHeader, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel26).addComponent(this.jTextFieldTotalHeaderHeight, -2, -1, -2)).addGap(0, 9, Short.MAX_VALUE)));
        this.jLabel12.setText("Chart margin:");
        this.jLabel12.setToolTipText("The margin/border around the whole chart");
        this.jSpinnerMargin.setModel(new SpinnerNumberModel(3, 0, 20, 1));
        GroupLayout jPanelDimensionsLayout = new GroupLayout(this.jPanelDimensions);
        this.jPanelDimensions.setLayout(jPanelDimensionsLayout);
        jPanelDimensionsLayout.setHorizontalGroup(jPanelDimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDimensionsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelDimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addGroup(jPanelDimensionsLayout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerMargin, -2, 56, -2)).addComponent(this.jCheckBoxChartBorder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanelDimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addGroup(jPanelDimensionsLayout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerVfreeze, -2, 41, -2))).addGap(55, 55, 55)));
        jPanelDimensionsLayout.setVerticalGroup(jPanelDimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDimensionsLayout.createSequentialGroup().addGap(33, 33, 33).addGroup(jPanelDimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDimensionsLayout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelDimensionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jSpinnerVfreeze, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanelDimensionsLayout.createSequentialGroup().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelDimensionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jSpinnerMargin, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxChartBorder).addGap(113, 113, 113)))));
        this.jTabbedPane1.addTab("Dimensions", this.jPanelDimensions);
        this.jCheckBoxBorder.setText("Border");
        this.jCheckBoxLogo.setText("Logo");
        this.jCheckBoxLogo.setToolTipText("Display \"logo.jpg\" from StrataBugs folder");
        this.jTextFieldHdrHeight.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldHdrHeightKeyTyped(evt);
            }
        });
        this.jLabelHdrHeight.setText("Height:");
        this.jCheckBoxScale.setText("Scale");
        this.buttonGroupHdrPlacement.add(this.jRadioButtonHdrBottom);
        this.jRadioButtonHdrBottom.setText("Bottom");
        this.buttonGroupHdrPlacement.add(this.jRadioButtonHdrTop);
        this.jRadioButtonHdrTop.setSelected(true);
        this.jRadioButtonHdrTop.setText("Top");
        this.buttonGroupHeader.add(this.jRadioButtonHdrWell);
        this.jRadioButtonHdrWell.setText("Well Header");
        this.jRadioButtonHdrWell.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonHdrWellActionPerformed(evt);
            }
        });
        this.buttonGroupHeader.add(this.jRadioButtonHdrFree);
        this.jRadioButtonHdrFree.setText("Free text");
        this.jRadioButtonHdrFree.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonHdrFreeActionPerformed(evt);
            }
        });
        this.buttonGroupHeader.add(this.jRadioButtonHdrNone);
        this.jRadioButtonHdrNone.setText("No header");
        this.jRadioButtonHdrNone.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonHdrNoneActionPerformed(evt);
            }
        });
        this.jPanelHdrCards.setLayout(new CardLayout());
        this.jPanelHdrWell.setBorder(BorderFactory.createTitledBorder(null, "Well Header", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jCheckBoxSpud.setText("Spud/Completion");
        this.jCheckBoxWellCode.setText("Well code");
        this.jCheckBoxLocation.setText("Location:");
        this.jCheckBoxLocation.setToolTipText("Latitude and Longitude");
        this.jCheckBoxLocation.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxLocationActionPerformed(evt);
            }
        });
        this.jCheckBoxOperator.setText("Operator");
        this.buttonGroupHdrLocation.add(this.jRadioButtonLocDec);
        this.jRadioButtonLocDec.setText("Decimal");
        this.buttonGroupHdrLocation.add(this.jRadioButtonLocDMS);
        this.jRadioButtonLocDMS.setText("DMS");
        this.jCheckBoxComments.setText("Comments");
        this.jCheckBoxComments.setToolTipText("These comments are in the well header details from editing the well in Wells & Outcrops");
        this.jCheckBoxDepthInterval.setText("Depth interval");
        this.jCheckBoxClientName.setText("Client Name");
        this.jCheckBoxTD.setText("Total Depth (TD)");
        GroupLayout jPanelHdrWellLayout = new GroupLayout(this.jPanelHdrWell);
        this.jPanelHdrWell.setLayout(jPanelHdrWellLayout);
        jPanelHdrWellLayout.setHorizontalGroup(jPanelHdrWellLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHdrWellLayout.createSequentialGroup().addContainerGap().addGroup(jPanelHdrWellLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelHdrWellLayout.createSequentialGroup().addComponent(this.jCheckBoxLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonLocDec).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonLocDMS, -1, 60, Short.MAX_VALUE).addGap(33, 33, 33)).addGroup(jPanelHdrWellLayout.createSequentialGroup().addComponent(this.jCheckBoxWellCode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxOperator, -2, 83, -2).addGap(41, 41, 41)).addGroup(jPanelHdrWellLayout.createSequentialGroup().addComponent(this.jCheckBoxSpud).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelHdrWellLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxDepthInterval).addComponent(this.jCheckBoxComments)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanelHdrWellLayout.createSequentialGroup().addGroup(jPanelHdrWellLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxClientName).addComponent(this.jCheckBoxTD, -2, 118, -2)).addGap(0, 0, Short.MAX_VALUE)))));
        jPanelHdrWellLayout.setVerticalGroup(jPanelHdrWellLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHdrWellLayout.createSequentialGroup().addContainerGap().addGroup(jPanelHdrWellLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxWellCode).addComponent(this.jCheckBoxOperator)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelHdrWellLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxLocation).addComponent(this.jRadioButtonLocDec).addComponent(this.jRadioButtonLocDMS)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelHdrWellLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxSpud).addComponent(this.jCheckBoxComments)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelHdrWellLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxClientName).addComponent(this.jCheckBoxDepthInterval)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addComponent(this.jCheckBoxTD)));
        this.jPanelHdrCards.add((Component)this.jPanelHdrWell, "cardWell");
        this.jPanelHdrFree.setBorder(BorderFactory.createTitledBorder(null, "Free text header", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel24.setText("Title:");
        this.jTextAreaHdrTitle.setColumns(20);
        this.jTextAreaHdrTitle.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaHdrTitle);
        GroupLayout jPanelHdrFreeLayout = new GroupLayout(this.jPanelHdrFree);
        this.jPanelHdrFree.setLayout(jPanelHdrFreeLayout);
        jPanelHdrFreeLayout.setHorizontalGroup(jPanelHdrFreeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHdrFreeLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel24).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 199, Short.MAX_VALUE).addContainerGap()));
        jPanelHdrFreeLayout.setVerticalGroup(jPanelHdrFreeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHdrFreeLayout.createSequentialGroup().addGroup(jPanelHdrFreeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHdrFreeLayout.createSequentialGroup().addComponent(this.jLabel24).addGap(0, 133, Short.MAX_VALUE)).addComponent(this.jScrollPane1)).addContainerGap()));
        this.jPanelHdrCards.add((Component)this.jPanelHdrFree, "cardFree");
        GroupLayout jPanelHdrNoneLayout = new GroupLayout(this.jPanelHdrNone);
        this.jPanelHdrNone.setLayout(jPanelHdrNoneLayout);
        jPanelHdrNoneLayout.setHorizontalGroup(jPanelHdrNoneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 259, Short.MAX_VALUE));
        jPanelHdrNoneLayout.setVerticalGroup(jPanelHdrNoneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 178, Short.MAX_VALUE));
        this.jPanelHdrCards.add((Component)this.jPanelHdrNone, "cardNone");
        this.buttonGroupTitlePos.add(this.jRadioButtonWellNameCentre);
        this.jRadioButtonWellNameCentre.setText("Centre");
        this.buttonGroupTitlePos.add(this.jRadioButtonWellNameLeft);
        this.jRadioButtonWellNameLeft.setText("Left");
        this.jLabelHdrTitlePos.setText("Title position:");
        this.jLabelHdrAuthor.setText("Author:");
        this.jCheckBoxHdrTemplName.setText("Chart name");
        this.jCheckBoxHdrTemplDescr.setText("Comments");
        this.jCheckBoxHdrTemplDescr.setToolTipText("Chart comments from Chart -> Edit Details.. menu");
        this.jCheckBoxHdrTemplDate.setText("Date");
        this.jLabelHdrEnclosure.setText("Enclosure text:");
        this.jLabelWellName.setText("Well Name:");
        this.jCheckBoxHdrWellList.setText("Project (Well list)");
        this.jCheckBoxHdrWellList.setToolTipText("<html>This option will show the chart <strong>default well list</strong> name (from Chart details)");
        GroupLayout jPanelHeaderLayout = new GroupLayout(this.jPanelHeader);
        this.jPanelHeader.setLayout(jPanelHeaderLayout);
        jPanelHeaderLayout.setHorizontalGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHeaderLayout.createSequentialGroup().addContainerGap().addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHeaderLayout.createSequentialGroup().addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelHdrCards, -2, 259, -2).addGroup(jPanelHeaderLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelHdrAuthor).addComponent(this.jLabelHdrTitlePos).addComponent(this.jLabelHdrEnclosure).addComponent(this.jLabelWellName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldHdrEnclosure).addGroup(jPanelHeaderLayout.createSequentialGroup().addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelHeaderLayout.createSequentialGroup().addComponent(this.jRadioButtonWellNameLeft).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonWellNameCentre)).addComponent(this.jTextFieldHdrAuthor, -1, 176, Short.MAX_VALUE).addComponent(this.jComboBoxWellName, 0, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE))))).addGap(18, 18, 18).addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxBorder).addComponent(this.jCheckBoxScale).addComponent(this.jCheckBoxLogo).addComponent(this.jCheckBoxHdrTemplDescr).addComponent(this.jCheckBoxHdrTemplName).addGroup(jPanelHeaderLayout.createSequentialGroup().addComponent(this.jLabelHdrHeight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldHdrHeight, -2, 31, -2)).addComponent(this.jCheckBoxHdrTemplDate).addComponent(this.jCheckBoxHdrWellList)).addGap(187, 187, 187)).addGroup(jPanelHeaderLayout.createSequentialGroup().addComponent(this.jRadioButtonHdrNone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonHdrWell).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonHdrFree).addGap(18, 18, 18).addComponent(this.jRadioButtonHdrTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonHdrBottom).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanelHeaderLayout.setVerticalGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHeaderLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonHdrWell).addComponent(this.jRadioButtonHdrFree).addComponent(this.jRadioButtonHdrNone).addComponent(this.jRadioButtonHdrTop).addComponent(this.jRadioButtonHdrBottom)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelHeaderLayout.createSequentialGroup().addComponent(this.jPanelHdrCards, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelHdrTitlePos).addComponent(this.jRadioButtonWellNameLeft).addComponent(this.jRadioButtonWellNameCentre))).addGroup(jPanelHeaderLayout.createSequentialGroup().addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelHdrHeight).addComponent(this.jTextFieldHdrHeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxHdrWellList).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxHdrTemplName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxHdrTemplDescr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxHdrTemplDate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxLogo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxBorder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxScale))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelHdrAuthor).addComponent(this.jTextFieldHdrAuthor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldHdrEnclosure, -2, -1, -2).addComponent(this.jLabelHdrEnclosure)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxWellName, -2, -1, -2).addComponent(this.jLabelWellName)).addContainerGap(43, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Header", this.jPanelHeader);
        this.buttonGroupKeyPlacement.add(this.jRadioButtonKeyTop);
        this.jRadioButtonKeyTop.setText("Top");
        this.buttonGroupKeyPlacement.add(this.jRadioButtonKeyBottom);
        this.jRadioButtonKeyBottom.setSelected(true);
        this.jRadioButtonKeyBottom.setText("Bottom");
        this.buttonGroupKeyPlacement.add(this.jRadioButtonKeyLeft);
        this.jRadioButtonKeyLeft.setText("Left");
        this.buttonGroupKeyPlacement.add(this.jRadioButtonKeyRight);
        this.jRadioButtonKeyRight.setText("Right");
        this.jCheckBoxKey.setText("Display key");
        this.jCheckBoxKey.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxKeyActionPerformed(evt);
            }
        });
        this.jLabelKeyOrientation.setText("Orientation:");
        this.jLabelKeySize.setText("Size:");
        this.jTextFieldKeyHeight.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldKeyHeightKeyTyped(evt);
            }
        });
        this.jPanelKeyOptions.setBorder(BorderFactory.createTitledBorder(null, "Keys", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jCheckBoxKeyText.setText("Unplaced text");
        this.jCheckBoxKeyBnd.setText("Boundary types");
        this.jCheckBoxKeyLithBase.setText("Base lithology");
        this.jCheckBoxKeyLithQual.setText("Lithology qualifiers");
        this.jCheckBoxKeySamp.setText("Sample types");
        this.jCheckBoxKeyAbn.setText("Abundance schemes");
        this.jCheckBoxKeyCorr.setText("Correlation lines");
        this.jCheckBoxKeyTxGroup.setText("Taxon groups");
        this.jCheckBoxKeyEnvSchs.setText("Palaeoenvironment schemes");
        this.jCheckBoxKeyCats.setText("Taxon categories");
        GroupLayout jPanelKeyOptionsLayout = new GroupLayout(this.jPanelKeyOptions);
        this.jPanelKeyOptions.setLayout(jPanelKeyOptionsLayout);
        jPanelKeyOptionsLayout.setHorizontalGroup(jPanelKeyOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelKeyOptionsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelKeyOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxKeyText).addComponent(this.jCheckBoxKeyBnd).addComponent(this.jCheckBoxKeyLithBase).addComponent(this.jCheckBoxKeyLithQual).addComponent(this.jCheckBoxKeySamp)).addGap(18, 18, 18).addGroup(jPanelKeyOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxKeyCats).addComponent(this.jCheckBoxKeyTxGroup).addComponent(this.jCheckBoxKeyCorr).addComponent(this.jCheckBoxKeyAbn).addComponent(this.jCheckBoxKeyEnvSchs)).addContainerGap(121, Short.MAX_VALUE)));
        jPanelKeyOptionsLayout.linkSize(0, this.jCheckBoxKeyBnd, this.jCheckBoxKeyLithBase, this.jCheckBoxKeyLithQual, this.jCheckBoxKeySamp, this.jCheckBoxKeyText);
        jPanelKeyOptionsLayout.linkSize(0, this.jCheckBoxKeyAbn, this.jCheckBoxKeyCats, this.jCheckBoxKeyCorr, this.jCheckBoxKeyEnvSchs, this.jCheckBoxKeyTxGroup);
        jPanelKeyOptionsLayout.setVerticalGroup(jPanelKeyOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelKeyOptionsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelKeyOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxKeyText).addComponent(this.jCheckBoxKeyAbn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelKeyOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelKeyOptionsLayout.createSequentialGroup().addComponent(this.jCheckBoxKeyCorr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxKeyTxGroup)).addGroup(jPanelKeyOptionsLayout.createSequentialGroup().addComponent(this.jCheckBoxKeyBnd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxKeyLithBase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelKeyOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxKeyLithQual).addComponent(this.jCheckBoxKeyCats)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelKeyOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxKeySamp).addComponent(this.jCheckBoxKeyEnvSchs)).addContainerGap(109, Short.MAX_VALUE)));
        jPanelKeyOptionsLayout.linkSize(1, this.jCheckBoxKeyBnd, this.jCheckBoxKeyLithBase, this.jCheckBoxKeyLithQual, this.jCheckBoxKeySamp, this.jCheckBoxKeyText);
        jPanelKeyOptionsLayout.linkSize(1, this.jCheckBoxKeyAbn, this.jCheckBoxKeyCats, this.jCheckBoxKeyCorr, this.jCheckBoxKeyEnvSchs, this.jCheckBoxKeyTxGroup);
        this.jCheckBoxKeyBorder.setText("Border");
        GroupLayout jPanelKeyLayout = new GroupLayout(this.jPanelKey);
        this.jPanelKey.setLayout(jPanelKeyLayout);
        jPanelKeyLayout.setHorizontalGroup(jPanelKeyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelKeyLayout.createSequentialGroup().addContainerGap().addGroup(jPanelKeyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelKeyOptions, -1, -1, Short.MAX_VALUE).addGroup(jPanelKeyLayout.createSequentialGroup().addGroup(jPanelKeyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxKey).addGroup(jPanelKeyLayout.createSequentialGroup().addGroup(jPanelKeyLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelKeySize).addComponent(this.jLabelKeyOrientation)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelKeyLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jRadioButtonKeyTop, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldKeyHeight, -2, 43, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelKeyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelKeyLayout.createSequentialGroup().addComponent(this.jRadioButtonKeyBottom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonKeyLeft).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonKeyRight)).addComponent(this.jCheckBoxKeyBorder)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelKeyLayout.setVerticalGroup(jPanelKeyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelKeyLayout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jCheckBoxKey).addGap(18, 18, 18).addGroup(jPanelKeyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonKeyTop).addComponent(this.jRadioButtonKeyBottom).addComponent(this.jRadioButtonKeyLeft).addComponent(this.jRadioButtonKeyRight).addComponent(this.jLabelKeyOrientation)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelKeyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldKeyHeight, -2, -1, -2).addComponent(this.jLabelKeySize).addComponent(this.jCheckBoxKeyBorder)).addGap(18, 18, 18).addComponent(this.jPanelKeyOptions, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Key", this.jPanelKey);
        this.jCheckBoxCorrectDepth.setText("Use corrected depths");
        this.jCheckBoxCorrectCuttings.setText("Correct cuttings");
        this.jLabel11.setText("Display ages in:");
        this.AgeFormat.add(this.jRadioButtonAFMA);
        this.jRadioButtonAFMA.setText("Ma");
        this.AgeFormat.add(this.jRadioButtonAFKA);
        this.jRadioButtonAFKA.setText("Ka");
        this.jCheckBoxDrawEmptyPanels.setText("Draw panels with no data");
        this.jCheckBoxDrawDisconfs.setText("Draw disconformities derived from Depth/Age curve");
        this.jCheckBoxDrawDisconfs.setToolTipText("Show disconformities as defined by well blocks' depth/age curves.");
        this.jCheckBoxDrawDisconfDuration.setText("Draw disconformity duration");
        this.jCheckBoxCorrTick.setText("Draw correlation ticks");
        this.jLabel27.setText("Default chart datum");
        GroupLayout jPanelDataLayout = new GroupLayout(this.jPanelData);
        this.jPanelData.setLayout(jPanelDataLayout);
        jPanelDataLayout.setHorizontalGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxCorrTick).addComponent(this.jCheckBoxDrawDisconfDuration).addComponent(this.jCheckBoxDrawEmptyPanels).addComponent(this.jCheckBoxCorrectCuttings).addComponent(this.jCheckBoxCorrectDepth).addGroup(jPanelDataLayout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAFMA).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAFKA)).addComponent(this.jCheckBoxDrawDisconfs, -2, 414, -2).addGroup(jPanelDataLayout.createSequentialGroup().addComponent(this.jLabel27).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enumComboChartDatum, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelDataLayout.setVerticalGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jCheckBoxCorrectDepth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxCorrectCuttings).addGap(18, 18, 18).addGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jRadioButtonAFMA).addComponent(this.jRadioButtonAFKA)).addGap(18, 18, 18).addComponent(this.jCheckBoxDrawEmptyPanels).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDrawDisconfs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDrawDisconfDuration).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCorrTick).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel27).addComponent(this.enumComboChartDatum, -2, -1, -2)).addContainerGap(123, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Data", this.jPanelData);
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonApplyActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonCopy.setText("Copy from...");
        this.jButtonCopy.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartFont this$0;
            {
                DialogChartFont dialogChartFont = this$0;
                Objects.requireNonNull(dialogChartFont);
                this.this$0 = dialogChartFont;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -2, 464, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonApply).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCopy, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -2, 417, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonHelp).addComponent(this.jButtonApply).addComponent(this.jButtonCopy)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        boolean valuesOK = this.checkBlockAgeValues();
        if (!valuesOK) {
            return;
        }
        boolean changed = true;
        try {
            changed = this.applyChanges();
        }
        catch (InvalidFieldException ex) {
            Logger.getLogger(DialogChartFont.class.getName()).log(Level.WARNING, null, ex);
            JOptionPane.showMessageDialog((Component)((Object)this), ex.getMessage(), this.getTitle(), 2);
            return;
        }
        if (changed) {
            this.setOK();
        }
        this.dispose();
    }

    private void jButtonForegroundActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog((Component)((Object)this), "Foreground Colour", this.jTextFieldForeground.getBackground());
        if (c != null) {
            this.jTextFieldForeground.setBackground(c);
        }
    }

    private void jButtonBackgroundActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog((Component)((Object)this), "Background Colour", this.jTextFieldBackground.getBackground());
        if (c != null) {
            this.jTextFieldBackground.setBackground(c);
        }
    }

    private void jButtonClearSchemeActionPerformed(ActionEvent evt) {
        this.scheme = null;
        this.jTextFieldbgScheme.setText("");
        this.fillHierCombo();
        this.enableBG();
    }

    private void jButtonSelectSchemeActionPerformed(ActionEvent evt) {
        List<IGDScheme> igdSchemes;
        DialogSelectIGDType typeDialog = new DialogSelectIGDType((JDialog)((Object)this), true, false, false, false, false);
        typeDialog.setLocationRelativeTo((Component)((Object)this));
        typeDialog.setVisible(true);
        if (!typeDialog.isOK()) {
            return;
        }
        try {
            igdSchemes = this.sbdb.getIGDSchemes(typeDialog.getIgdType());
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError("Error loading schemes", e, (Component)((Object)this));
            return;
        }
        Collections.sort(igdSchemes);
        DialogList<IGDScheme> dialog = new DialogList<IGDScheme>((JDialog)((Object)this), true, "Select Scheme", null, igdSchemes, true, false, (ListCellRenderer)new RestrictableListRenderer());
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getSelection() != null) {
            this.scheme = dialog.getSelection();
            this.jTextFieldbgScheme.setText(this.scheme.toString());
            this.fillHierCombo();
            this.enableBG();
        }
    }

    private void jTextFieldCaptionKeyTyped(KeyEvent evt) {
    }

    private void jTextFieldTopDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jRadioButtonMDActionPerformed(ActionEvent evt) {
        this.scaleTypeChange(BlockProperties.ScaleType.MD);
    }

    private void jRadioButtonTVDActionPerformed(ActionEvent evt) {
        this.scaleTypeChange(BlockProperties.ScaleType.TVD);
    }

    private void jRadioButtonAGEActionPerformed(ActionEvent evt) {
        this.scaleTypeChange(BlockProperties.ScaleType.AGE);
    }

    private void jTextFieldTopDepthFocusLost(FocusEvent evt) {
        this.updateAges();
    }

    private void jTextFieldBaseDepthFocusLost(FocusEvent evt) {
        this.updateAges();
    }

    private void jButtonWellObjActionPerformed(ActionEvent evt) {
        assert (this.block.getBlockType() == BlockType.SCHEME);
        DialogChartBlockImport dialog = new DialogChartBlockImport((JDialog)((Object)this), true, this.sbdb, this.block.getBlockType());
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.wellObj = dialog.getObject();
            this.jTextFieldWellObj.setText(this.wellObj != null ? this.wellObj.toString() : "");
        }
    }

    private void jButtonWellObjClearActionPerformed(ActionEvent evt) {
        this.wellObj = null;
        this.jTextFieldWellObj.setText("");
    }

    private void jCheckBoxLocationActionPerformed(ActionEvent evt) {
        this.jRadioButtonLocDMS.setEnabled(this.jCheckBoxLocation.isSelected());
        this.jRadioButtonLocDec.setEnabled(this.jCheckBoxLocation.isSelected());
    }

    private void jTextFieldHdrHeightKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldHdrHeight, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jRadioButtonHdrNoneActionPerformed(ActionEvent evt) {
        this.enableHeaderFields(!this.jRadioButtonHdrNone.isSelected());
        ((CardLayout)this.jPanelHdrCards.getLayout()).show(this.jPanelHdrCards, "cardNone");
    }

    private void jRadioButtonHdrWellActionPerformed(ActionEvent evt) {
        this.enableHeaderFields(!this.jRadioButtonHdrNone.isSelected());
        ((CardLayout)this.jPanelHdrCards.getLayout()).show(this.jPanelHdrCards, "cardWell");
    }

    private void jRadioButtonHdrFreeActionPerformed(ActionEvent evt) {
        this.enableHeaderFields(!this.jRadioButtonHdrNone.isSelected());
        ((CardLayout)this.jPanelHdrCards.getLayout()).show(this.jPanelHdrCards, "cardFree");
    }

    private void jTextFieldKeyHeightKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldKeyHeight, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jCheckBoxKeyActionPerformed(ActionEvent evt) {
        this.enableKeyFields(this.jCheckBoxKey.isSelected());
    }

    private void jButtonDefaultFontActionPerformed(ActionEvent evt) {
        this.jSpinnerFontSize.setValue(Float.valueOf(8.5f));
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogchartproperties.html");
    }

    private void jButtonGapHatchColourActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog((Component)((Object)this), "Interval Sample Gap Colour", this.jTextFieldForeground.getBackground());
        if (c != null) {
            this.jTextFieldGapHatchColour.setBackground(c);
        }
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        boolean valuesOK = this.checkBlockAgeValues();
        if (!valuesOK) {
            return;
        }
        boolean changed = true;
        try {
            changed = this.applyChanges();
        }
        catch (InvalidFieldException ex) {
            Logger.getLogger(DialogChartFont.class.getName()).log(Level.WARNING, null, ex);
            JOptionPane.showMessageDialog((Component)((Object)this), ex.getMessage(), this.getTitle(), 2);
            return;
        }
        if (this.applyListener != null && changed) {
            this.applyListener.actionPerformed(null);
        }
    }

    private void jSpinnerSubHeaderStateChanged(ChangeEvent evt) {
        this.setTotalHeaderHeight();
    }

    private void jSpinnerCaptionStateChanged(ChangeEvent evt) {
        this.setTotalHeaderHeight();
    }

    private void jButtonCopyActionPerformed(ActionEvent evt) {
        ChartManager cm = null;
        if (this.getParent() instanceof FrameChart) {
            cm = ((FrameChart)this.getParent()).getChartManager();
        }
        DialogChartTemplates dialog = new DialogChartTemplates((Dialog)((Object)this), true, this.sbdb, cm, null, (Boolean)true, null);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.selection != null && dialog.selection.size() > 0) {
            ChartTemplateBase b = dialog.selection.get(0);
            Component openTab = this.jTabbedPane1.getSelectedComponent();
            if (b instanceof ChartTemplateBase) {
                if (b.getType() == null) {
                    try {
                        ChartTemplate chart = cm.getChartTemplate(b.getID());
                        if (chart != null) {
                            String props = chart.getProperties();
                            ChartProperties newCp = new ChartProperties(props, this.scheme != null ? this.scheme.getID() : 0);
                            String header = chart.getHeaderProperties();
                            if (StringUtils.isNotBlank((CharSequence)header)) {
                                newCp.header = new PanelWellHeader(header);
                            }
                            this.init(newCp, true, this.jButtonOK.isEnabled());
                            this.jTabbedPane1.setSelectedComponent(openTab);
                        }
                    }
                    catch (SQLException e) {
                        StackError.showStackError((Exception)e);
                    }
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Select a CHART to copy from, not a block template", this.getTitle(), 1);
                }
            }
        }
    }

    private boolean applyChanges() throws InvalidFieldException {
        ChartProperties.ChartDatum selected;
        boolean hasChanged = false;
        hasChanged |= this.cp.setFont((String)this.jComboBoxFont.getSelectedItem());
        hasChanged |= this.cp.setFontSize(((Float)this.jSpinnerFontSize.getValue()).floatValue());
        if (this.cp.setMargin(((Integer)this.jSpinnerMargin.getValue()).floatValue())) {
            hasChanged = true;
        }
        if (this.cp.setPanelSubHeaderHeight(((Integer)this.jSpinnerSubHeader.getValue()).floatValue())) {
            hasChanged = true;
        }
        hasChanged |= this.cp.setPanelCaptionHeight(((Integer)this.jSpinnerCaption.getValue()).floatValue());
        hasChanged |= this.cp.setPanelExtCaptionHeight(((Integer)this.jSpinnerExtCaption.getValue()).floatValue());
        if (this.cp.setCorrections(this.jCheckBoxCorrectDepth.isSelected(), this.jCheckBoxCorrectCuttings.isSelected())) {
            hasChanged = true;
        }
        if (this.cp.setAgeFormat(this.jRadioButtonAFMA.isSelected() ? util.AgeFormat.MA : util.AgeFormat.KA)) {
            hasChanged = true;
        }
        if (this.cp.setForeground(this.jTextFieldForeground.getBackground())) {
            hasChanged = true;
        }
        if (this.cp.setBackground(this.jTextFieldBackground.getBackground())) {
            hasChanged = true;
        }
        if (this.cp.setGapHatchColour(this.jTextFieldGapHatchColour.getBackground())) {
            hasChanged = true;
        }
        if (this.cp.setGreyscale(this.jCheckBoxGreyscale.isSelected())) {
            hasChanged = true;
        }
        hasChanged |= this.cp.setBlankPanel(((Integer)this.jSpinnerBlankSpace.getValue()).floatValue(), this.jCheckBoxBlankRelative.isSelected());
        if (this.cp.setSchID(this.scheme == null ? 0 : this.scheme.getID())) {
            hasChanged = true;
        }
        if (this.cp.setHier(this.jComboBoxHier.getSelectedIndex() + 1)) {
            hasChanged = true;
        }
        if (this.cp.setbgDensity((float)this.jSliderbgDensity.getValue() / 100.0f)) {
            hasChanged = true;
        }
        if (this.cp.setbgBlocks(this.jCheckBoxbgBlocks.isSelected())) {
            hasChanged = true;
        }
        if (this.cp.setbgPinchouts(this.jCheckBoxBgPinchouts.isSelected())) {
            hasChanged = true;
        }
        if (this.cp.setDrawEmptyPanels(this.jCheckBoxDrawEmptyPanels.isSelected())) {
            hasChanged = true;
        }
        if (this.cp.setDrawDisconfs(this.jCheckBoxDrawDisconfs.isSelected())) {
            hasChanged = true;
        }
        if (this.cp.setDrawDisconfDuration(this.jCheckBoxDrawDisconfDuration.isSelected())) {
            hasChanged = true;
        }
        if (this.enumComboChartDatum.getSelectedItem() instanceof ChartProperties.ChartDatum && (selected = (ChartProperties.ChartDatum)((Object)this.enumComboChartDatum.getSelectedItem())) != this.cp.getChartDatum()) {
            this.cp.setChartDatum(selected);
            hasChanged = true;
        }
        hasChanged |= this.cp.setBorder(this.jCheckBoxChartBorder.isSelected());
        hasChanged |= this.cp.setDrawCorrelationTicks(this.jCheckBoxCorrTick.isSelected());
        hasChanged |= this.cp.setBlockCap(this.jCheckBoxCaptions.isSelected(), ((Integer)this.jSpinnerCapHeight.getValue()).floatValue(), this.jRadioButtonCapTop.isSelected(), this.jRadioButtonCapAlignChart.isSelected(), (ChartProperties.FontSize)((Object)this.jComboBoxBlockCapFontSize.getSelectedItem()));
        ComboboxItem display = (ComboboxItem)this.jComboBoxBCWellNames.getSelectedItem();
        hasChanged |= this.cp.setBlockCapWellNameDisplay((PanelWellHeader.WellNameDisplay)((Object)display.getValue()));
        if (this.cp.setNvFreeze((Integer)this.jSpinnerVfreeze.getValue())) {
            hasChanged = true;
        }
        hasChanged |= this.cp.setMapAlign(this.jCheckBoxMapAlign.isSelected());
        PanelWellHeader hdrPanel = null;
        if (!this.jRadioButtonHdrNone.isSelected()) {
            hdrPanel = new PanelWellHeader();
            float height = Float.parseFloat(this.jTextFieldHdrHeight.getText());
            if (height < 20.0f) {
                height = 20.0f;
            }
            hdrPanel.height = height;
            hdrPanel.centreName = this.jRadioButtonWellNameCentre.isSelected();
            hdrPanel.wellCode = this.jCheckBoxWellCode.isSelected();
            hdrPanel.location = this.jCheckBoxLocation.isSelected();
            hdrPanel.decimalLocation = this.jRadioButtonLocDec.isSelected();
            hdrPanel.operator = this.jCheckBoxOperator.isSelected();
            hdrPanel.spud = this.jCheckBoxSpud.isSelected();
            hdrPanel.logo = this.jCheckBoxLogo.isSelected();
            hdrPanel.border = this.jCheckBoxBorder.isSelected();
            hdrPanel.scale = this.jCheckBoxScale.isSelected();
            hdrPanel.comments = this.jCheckBoxComments.isSelected();
            hdrPanel.depthInterval = this.jCheckBoxDepthInterval.isSelected();
            hdrPanel.td = this.jCheckBoxTD.isSelected();
            hdrPanel.orientation = this.jRadioButtonHdrTop.isSelected() ? PanelWellHeader.Orientation.TOP : PanelWellHeader.Orientation.BOTTOM;
            hdrPanel.style = this.jRadioButtonHdrWell.isSelected() ? PanelWellHeader.HeaderStyle.WELL : PanelWellHeader.HeaderStyle.FREE;
            hdrPanel.title = this.jTextAreaHdrTitle.getText().trim();
            hdrPanel.author = this.jTextFieldHdrAuthor.getText().trim();
            hdrPanel.enclosure = this.jTextFieldHdrEnclosure.getText().trim();
            hdrPanel.templName = this.jCheckBoxHdrTemplName.isSelected();
            hdrPanel.templDescr = this.jCheckBoxHdrTemplDescr.isSelected();
            hdrPanel.templDate = this.jCheckBoxHdrTemplDate.isSelected();
            hdrPanel.clientName = this.jCheckBoxClientName.isSelected();
            hdrPanel.wellListName = this.jCheckBoxHdrWellList.isSelected();
            ComboboxItem item = (ComboboxItem)this.jComboBoxWellName.getSelectedItem();
            hdrPanel.wellNameDisplay = (PanelWellHeader.WellNameDisplay)((Object)item.getValue());
        }
        if (!SB.equal((Object)this.cp.header, (Object)hdrPanel)) {
            hasChanged = true;
        }
        this.cp.header = hdrPanel;
        PanelKey keyPanel = null;
        if (this.jCheckBoxKey.isSelected()) {
            keyPanel = new PanelKey();
            if (this.jRadioButtonKeyLeft.isSelected()) {
                keyPanel.orientation = PanelKey.Orientation.LEFT;
            } else if (this.jRadioButtonKeyRight.isSelected()) {
                keyPanel.orientation = PanelKey.Orientation.RIGHT;
            } else if (this.jRadioButtonKeyTop.isSelected()) {
                keyPanel.orientation = PanelKey.Orientation.TOP;
            } else if (this.jRadioButtonKeyBottom.isSelected()) {
                keyPanel.orientation = PanelKey.Orientation.BOTTOM;
            }
            keyPanel.text = this.jCheckBoxKeyText.isSelected();
            keyPanel.bndKey = this.jCheckBoxKeyBnd.isSelected();
            float height = Float.parseFloat(this.jTextFieldKeyHeight.getText());
            if (height < 20.0f) {
                height = 20.0f;
            }
            keyPanel.height = height;
            keyPanel.border = this.jCheckBoxKeyBorder.isSelected();
            keyPanel.lithBase = this.jCheckBoxKeyLithBase.isSelected();
            keyPanel.lithQual = this.jCheckBoxKeyLithQual.isSelected();
            keyPanel.sampling = this.jCheckBoxKeySamp.isSelected();
            keyPanel.abnSchemes = this.jCheckBoxKeyAbn.isSelected();
            keyPanel.correlationLines = this.jCheckBoxKeyCorr.isSelected();
            keyPanel.txGroups = this.jCheckBoxKeyTxGroup.isSelected();
            keyPanel.envSchemes = this.jCheckBoxKeyEnvSchs.isSelected();
            keyPanel.categories = this.jCheckBoxKeyCats.isSelected();
        }
        if (!SB.equal((Object)this.cp.key, (Object)keyPanel)) {
            hasChanged = true;
        }
        this.cp.key = keyPanel;
        boolean blockChange = false;
        if (this.block != null) {
            float max;
            float min;
            assert (this.units == (this.jRadioButtonFeet.isSelected() ? (char)'F' : 'M'));
            if (this.block.getProp().setUnits(this.units)) {
                blockChange = true;
            }
            if (this.scaleType == BlockProperties.ScaleType.AGE) {
                min = (float)SB.round((double)Double.parseDouble((this.block instanceof WellBlock ? this.jTextFieldMinAge : this.jTextFieldTopDepth).getText()), (int)3);
                max = (float)SB.round((double)Double.parseDouble((this.block instanceof WellBlock ? this.jTextFieldMaxAge : this.jTextFieldBaseDepth).getText()), (int)3);
            } else {
                min = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
                max = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
            }
            float scale = Float.parseFloat(String.valueOf(this.jComboBoxVerticalScale.getSelectedItem()));
            if (this.block.getProp().setLimits(min, max)) {
                blockChange = true;
            }
            if (scale == 0.0f) {
                scale = max - min;
            }
            if (this.block.getProp().setScale(scale)) {
                blockChange = true;
            }
            if (this.block.getProp().setScaleType(this.scaleType)) {
                blockChange = true;
            }
            this.block.setUnits(DepthUnits.getUnits((char)this.units));
            if (this.allowSchemeSetWell) {
                InterpHdr interp;
                Object blockObj;
                Object object = blockObj = this.block.getWellList() != null ? this.block.getWellList() : this.block.getWell();
                if (blockObj != this.wellObj) {
                    blockChange = true;
                    try {
                        Object object2 = this.wellObj;
                        if (object2 instanceof WellList) {
                            WellList wellList = (WellList)((Object)object2);
                            this.sbdb.getWellIterator(wellList.getID());
                            this.block.setWellList(wellList);
                        } else {
                            Well well;
                            List wells = (List)this.wellObj;
                            if (wells != null && !wells.isEmpty()) {
                                well = (Well)wells.get(0);
                                well.loadSamples();
                                well.loadInterps();
                            } else {
                                well = null;
                            }
                            this.block.setWell(well);
                        }
                    }
                    catch (SQLException | SBException sql) {
                        SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
                    }
                }
                if ((interp = (InterpHdr)this.jComboBoxVersion.getSelectedItem()).getInterpID() != this.block.getInterpID()) {
                    blockChange = true;
                    try {
                        this.block.setInterpID(interp.getInterpID());
                    }
                    catch (SQLException sql) {
                        FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                    }
                    catch (SBException sbe) {
                        StackError.showStackError((String)"Error", (Throwable)sbe);
                    }
                }
            }
        }
        tab = this.jTabbedPane1.getSelectedIndex();
        if (hasChanged || blockChange || this.alwaysEncode) {
            this.cp.encode(this.sbdb);
            return true;
        }
        return false;
    }

    private void scaleTypeChange(BlockProperties.ScaleType newType) {
        if (newType == this.scaleType) {
            return;
        }
        if (newType == BlockProperties.ScaleType.AGE) {
            this.updateAges();
            this.setScaleCombo(true);
        } else if (this.scaleType == BlockProperties.ScaleType.AGE) {
            this.setScaleCombo(true);
        }
        this.setAgeVisible();
        this.updateDepthLabels();
        this.scaleType = newType;
    }

    private void setUnits() {
        if (this.jRadioButtonFeet.isSelected() && this.units != 'F') {
            this.units = (char)70;
            try {
                this.jTextFieldTopDepth.setText("" + DepthUtils.convFromM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (NumberFormatException e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + DepthUtils.convFromM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (NumberFormatException e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        } else {
            this.units = (char)77;
            try {
                this.jTextFieldTopDepth.setText("" + DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (NumberFormatException e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (NumberFormatException e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        }
    }

    private boolean checkBlockAgeValues() {
        if (this.block != null) {
            float max;
            float min;
            assert (this.units == (this.jRadioButtonFeet.isSelected() ? (char)'F' : 'M'));
            if (this.scaleType == BlockProperties.ScaleType.AGE) {
                min = (float)SB.round((double)Double.parseDouble((this.block instanceof WellBlock ? this.jTextFieldMinAge : this.jTextFieldTopDepth).getText()), (int)3);
                max = (float)SB.round((double)Double.parseDouble((this.block instanceof WellBlock ? this.jTextFieldMaxAge : this.jTextFieldBaseDepth).getText()), (int)3);
            } else {
                min = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
                max = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
            }
            if (min > max) {
                if (this.block instanceof WellBlock) {
                    if (this.block.getWell().getType() == 'W') {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Top depth is greater than base depth", this.getTitle(), 2);
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Top depth is less than base depth", this.getTitle(), 2);
                    }
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Max age must be greater than min age", this.getTitle(), 2);
                }
                return false;
            }
        }
        return true;
    }
}

