/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbugs.uiutil.icon.IconFactory;

public class JPanelChartShortcuts
extends JPanel {
    private final NewBlockTemplateListener newBlockTemplateListener;
    private final ActionListener newChartListener;
    private final TemplateHandler templateSelectionHandler;
    private MouseListener boldFontMouseListener;
    private Box.Filler filler1;
    private JButton jButtonNewBlockMap;
    private JButton jButtonNewBlockProject;
    private JButton jButtonNewBlockScheme;
    private JButton jButtonNewBlockWell;
    private JButton jButtonNewChart;
    private JPanel jPanelStartNew;
    private JPanel jPanelStartRecent;

    public JPanelChartShortcuts(NewBlockTemplateListener newBlockTemplateListener, ActionListener newChartListener, TemplateHandler templateHandler) {
        this.newBlockTemplateListener = newBlockTemplateListener;
        this.newChartListener = newChartListener;
        this.templateSelectionHandler = templateHandler;
        this.initComponents();
        this.initBoldFontMouseListener();
        this.init();
    }

    private void init() {
        this.jButtonNewChart.addActionListener(this.newChartListener);
        for (JButton button : new JButton[]{this.jButtonNewBlockWell, this.jButtonNewBlockScheme, this.jButtonNewBlockProject, this.jButtonNewBlockMap, this.jButtonNewChart}) {
            this.initButton(button);
        }
    }

    public void initRecentButtons(ChartTemplateBase[] templates) {
        this.jPanelStartRecent.removeAll();
        for (ChartTemplateBase template : templates) {
            if (template == null) continue;
            TemplateButton button = new TemplateButton();
            this.initButton(button);
            button.setText(template.getName());
            if (template instanceof BlockTemplate) {
                BlockTemplate bt = (BlockTemplate)template;
                button.setIcon(bt.getType().getIcon());
            } else {
                button.setIcon(IconFactory.getIcon("chartTab"));
            }
            button.addActionListener(e -> {
                this.setCursor(null);
                this.templateSelectionHandler.templateSelected(template);
            });
            this.jPanelStartRecent.add(button);
        }
        this.jPanelStartRecent.add(this.filler1);
    }

    private void initButton(JButton button) {
        button.addMouseListener(this.boldFontMouseListener);
        button.setHorizontalAlignment(2);
        button.setMultiClickThreshhold(1000L);
    }

    private void initBoldFontMouseListener() {
        this.boldFontMouseListener = new MouseAdapter(this){
            private final Font normalFont;
            private final Font boldFont;
            final /* synthetic */ JPanelChartShortcuts this$0;
            {
                JPanelChartShortcuts jPanelChartShortcuts = this$0;
                Objects.requireNonNull(jPanelChartShortcuts);
                this.this$0 = jPanelChartShortcuts;
                this.normalFont = this.this$0.jButtonNewBlockWell.getFont();
                this.boldFont = this.normalFont.deriveFont(1);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JButton button = (JButton)e.getComponent();
                button.setFont(this.boldFont);
                this.this$0.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JButton button = (JButton)e.getComponent();
                button.setFont(this.normalFont);
                this.this$0.setCursor(null);
            }
        };
    }

    private void initComponents() {
        this.jPanelStartRecent = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 7), new Dimension(0, 7), new Dimension(Short.MAX_VALUE, 7));
        this.jPanelStartNew = new JPanel();
        this.jButtonNewBlockWell = new JButton();
        this.jButtonNewChart = new JButton();
        this.jButtonNewBlockScheme = new JButton();
        this.jButtonNewBlockProject = new JButton();
        this.jButtonNewBlockMap = new JButton();
        this.jPanelStartRecent.setBorder(BorderFactory.createTitledBorder(null, "Open Recent", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelStartRecent.setLayout(new BoxLayout(this.jPanelStartRecent, 3));
        this.jPanelStartRecent.add(this.filler1);
        this.jPanelStartNew.setBorder(BorderFactory.createTitledBorder(null, "New...", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jButtonNewBlockWell.setForeground(new Color(51, 102, 204));
        this.jButtonNewBlockWell.setIcon(BlockType.WELL.getIcon());
        this.jButtonNewBlockWell.setText("Well Block");
        this.jButtonNewBlockWell.setBorderPainted(false);
        this.jButtonNewBlockWell.setContentAreaFilled(false);
        this.jButtonNewBlockWell.setFocusPainted(false);
        this.jButtonNewBlockWell.setMargin(new Insets(2, 0, 2, 0));
        this.jButtonNewBlockWell.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelChartShortcuts this$0;
            {
                JPanelChartShortcuts jPanelChartShortcuts = this$0;
                Objects.requireNonNull(jPanelChartShortcuts);
                this.this$0 = jPanelChartShortcuts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonNewBlockWellActionPerformed(evt);
            }
        });
        this.jButtonNewChart.setForeground(new Color(51, 102, 204));
        this.jButtonNewChart.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/chartTab.png")));
        this.jButtonNewChart.setText("Named Chart");
        this.jButtonNewChart.setBorderPainted(false);
        this.jButtonNewChart.setContentAreaFilled(false);
        this.jButtonNewChart.setFocusPainted(false);
        this.jButtonNewChart.setMargin(new Insets(2, 0, 2, 0));
        this.jButtonNewBlockScheme.setForeground(new Color(51, 102, 204));
        this.jButtonNewBlockScheme.setIcon(BlockType.SCHEME.getIcon());
        this.jButtonNewBlockScheme.setText("Scheme Block");
        this.jButtonNewBlockScheme.setBorderPainted(false);
        this.jButtonNewBlockScheme.setContentAreaFilled(false);
        this.jButtonNewBlockScheme.setFocusPainted(false);
        this.jButtonNewBlockScheme.setMargin(new Insets(2, 0, 2, 0));
        this.jButtonNewBlockScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelChartShortcuts this$0;
            {
                JPanelChartShortcuts jPanelChartShortcuts = this$0;
                Objects.requireNonNull(jPanelChartShortcuts);
                this.this$0 = jPanelChartShortcuts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonNewBlockSchemeActionPerformed(evt);
            }
        });
        this.jButtonNewBlockProject.setForeground(new Color(51, 102, 204));
        this.jButtonNewBlockProject.setIcon(BlockType.PROJECT.getIcon());
        this.jButtonNewBlockProject.setText("Project Block");
        this.jButtonNewBlockProject.setBorderPainted(false);
        this.jButtonNewBlockProject.setContentAreaFilled(false);
        this.jButtonNewBlockProject.setFocusPainted(false);
        this.jButtonNewBlockProject.setMargin(new Insets(2, 0, 2, 0));
        this.jButtonNewBlockProject.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelChartShortcuts this$0;
            {
                JPanelChartShortcuts jPanelChartShortcuts = this$0;
                Objects.requireNonNull(jPanelChartShortcuts);
                this.this$0 = jPanelChartShortcuts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonNewBlockProjectActionPerformed(evt);
            }
        });
        this.jButtonNewBlockMap.setForeground(new Color(51, 102, 204));
        this.jButtonNewBlockMap.setIcon(BlockType.MAP.getIcon());
        this.jButtonNewBlockMap.setText("Map Block");
        this.jButtonNewBlockMap.setBorderPainted(false);
        this.jButtonNewBlockMap.setContentAreaFilled(false);
        this.jButtonNewBlockMap.setFocusPainted(false);
        this.jButtonNewBlockMap.setMargin(new Insets(2, 0, 2, 0));
        this.jButtonNewBlockMap.setMaximumSize(new Dimension(76, 22));
        this.jButtonNewBlockMap.setMinimumSize(new Dimension(76, 22));
        this.jButtonNewBlockMap.setPreferredSize(new Dimension(76, 22));
        this.jButtonNewBlockMap.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelChartShortcuts this$0;
            {
                JPanelChartShortcuts jPanelChartShortcuts = this$0;
                Objects.requireNonNull(jPanelChartShortcuts);
                this.this$0 = jPanelChartShortcuts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonNewBlockMapActionPerformed(evt);
            }
        });
        GroupLayout jPanelStartNewLayout = new GroupLayout(this.jPanelStartNew);
        this.jPanelStartNew.setLayout(jPanelStartNewLayout);
        jPanelStartNewLayout.setHorizontalGroup(jPanelStartNewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStartNewLayout.createSequentialGroup().addContainerGap().addGroup(jPanelStartNewLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonNewBlockMap, -1, -1, Short.MAX_VALUE).addGroup(jPanelStartNewLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonNewBlockWell, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonNewBlockScheme, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonNewBlockProject, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonNewChart, -1, -1, Short.MAX_VALUE))).addContainerGap(281, Short.MAX_VALUE)));
        jPanelStartNewLayout.setVerticalGroup(jPanelStartNewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelStartNewLayout.createSequentialGroup().addContainerGap().addComponent(this.jButtonNewBlockWell).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNewBlockProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNewBlockScheme, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNewBlockMap, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNewChart).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanelStartRecent, -1, -1, Short.MAX_VALUE).addGap(4, 4, 4)).addGroup(layout.createSequentialGroup().addComponent(this.jPanelStartNew, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelStartRecent, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelStartNew, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButtonNewBlockWellActionPerformed(ActionEvent evt) {
        this.newBlockTemplateListener.newBlockTemplate(BlockType.WELL);
    }

    private void jButtonNewBlockSchemeActionPerformed(ActionEvent evt) {
        this.newBlockTemplateListener.newBlockTemplate(BlockType.SCHEME);
    }

    private void jButtonNewBlockProjectActionPerformed(ActionEvent evt) {
        this.newBlockTemplateListener.newBlockTemplate(BlockType.PROJECT);
    }

    private void jButtonNewBlockMapActionPerformed(ActionEvent evt) {
        this.newBlockTemplateListener.newBlockTemplate(BlockType.MAP);
    }

    public JButton getNewWellBlockButton() {
        return this.jButtonNewBlockWell;
    }

    @FunctionalInterface
    public static interface NewBlockTemplateListener {
        public void newBlockTemplate(BlockType var1);
    }

    @FunctionalInterface
    public static interface TemplateHandler {
        public void templateSelected(ChartTemplateBase var1);
    }

    private static class TemplateButton
    extends JButton {
        private TemplateButton() {
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
        }
    }
}

