/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.mouse;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Optional;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbugs.ChartJPanel;
import jsbugs.chart.KeyboardStatusMonitor;
import jsbugs.chart.mouse.MouseBehaviourAdapter;

public class MapBlockMarqueeZoomBehaviour
extends MouseBehaviourAdapter {
    private final KeyboardStatusMonitor keyboardStatusMonitor;
    private boolean isCurrent = false;
    private Point2D.Float origin = null;

    public MapBlockMarqueeZoomBehaviour(ChartJPanel panel, KeyboardStatusMonitor keyboardStatusMonitor) {
        super(panel);
        this.keyboardStatusMonitor = keyboardStatusMonitor;
    }

    @Override
    public boolean isCurrent() {
        return this.isCurrent;
    }

    @Override
    public boolean isActiveForSelection(Object selection) {
        return selection != null && selection instanceof MapBlock;
    }

    @Override
    public Cursor getCursor(Point p) {
        return new Cursor(1);
    }

    @Override
    public boolean activeAt(Point p) {
        return this.getOverlappingSelectedMap(this.panel.getPoint(p)).isPresent() && this.keyboardStatusMonitor.isAltPressed() && !this.keyboardStatusMonitor.isShiftPressed() && !this.keyboardStatusMonitor.isCtrlPressed();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        Optional<MapBlock> map = this.getOverlappingSelectedMap(p);
        if (map.isPresent()) {
            this.isCurrent = true;
            this.origin = p;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        Optional<MapBlock> map = this.getOverlappingSelectedMap(p);
        if (map.isPresent()) {
            this.panel.clearMarquee();
            Rectangle2D.Float rect = new Rectangle2D.Float();
            rect.setFrameFromDiagonal(this.origin, p);
            map.get().zoomToRect(rect, this.panel.chart.getBlockBounds(map.get()));
            this.isCurrent = false;
            this.origin = null;
            this.notifyChartChange();
            this.panel.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        Optional<MapBlock> map = this.getOverlappingSelectedMap(p);
        if (this.origin != null && map.isPresent()) {
            this.panel.setMarquee(this.origin, p);
            this.panel.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.panel.clearMarquee();
        this.isCurrent = false;
        this.origin = null;
        this.panel.repaint();
    }

    private Optional<MapBlock> getOverlappingSelectedMap(Point2D.Float point) {
        return this.panel.chart.getSelectedBlock().filter(b -> b instanceof MapBlock).filter(b -> {
            Rectangle2D.Float blockBounds = this.panel.chart.getBlockBounds((ChartBlockBase)b);
            return blockBounds != null && blockBounds.contains(point);
        }).map(b -> (MapBlock)b);
    }
}

