/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.mouse;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import jsbugs.ChartJPanel;
import jsbugs.chart.KeyboardStatusMonitor;
import jsbugs.chart.mouse.MouseBehaviourAdapter;
import jsbugs.uiutil.CursorFactory;

public class MarqueeZoomBehaviour
extends MouseBehaviourAdapter {
    private static final Logger LOGGER = Logger.getLogger(MarqueeZoomBehaviour.class.getName());
    private final KeyboardStatusMonitor keyboardStatusMonitor;
    private boolean isCurrent = false;
    private Point2D.Float origin = null;
    private Cursor marqueeCursor = CursorFactory.getMarqueeZoomCursor();

    public MarqueeZoomBehaviour(ChartJPanel panel, KeyboardStatusMonitor keyboardStatusMonitor) {
        super(panel);
        this.keyboardStatusMonitor = keyboardStatusMonitor;
    }

    @Override
    public boolean isCurrent() {
        return this.isCurrent;
    }

    @Override
    public boolean isActiveForSelection(Object selection) {
        return true;
    }

    @Override
    public Cursor getCursor(Point p) {
        return this.marqueeCursor;
    }

    @Override
    public boolean activeAt(Point p) {
        return this.keyboardStatusMonitor.isAltPressed() && !this.keyboardStatusMonitor.isCtrlPressed() && !this.keyboardStatusMonitor.isShiftPressed();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.isCurrent = true;
            this.origin = this.panel.getPoint(e.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.panel.clearMarquee();
        if (this.origin != null) {
            Rectangle2D.Float rect = new Rectangle2D.Float();
            rect.setFrameFromDiagonal(this.origin, this.panel.getPoint(e.getPoint()));
            this.panel.getZoomManager().zoomToRect(rect);
            this.isCurrent = false;
            this.origin = null;
            this.panel.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.origin != null) {
            Point2D.Float p = this.panel.getPoint(e.getPoint());
            this.panel.setMarquee(this.origin, p);
            this.panel.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.panel.clearMarquee();
        this.isCurrent = false;
        this.origin = null;
        this.panel.repaint();
    }
}

