/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.mouse;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import jsbugs.ChartJPanel;
import jsbugs.chart.KeyboardStatusMonitor;
import jsbugs.chart.mouse.MouseBehaviourAdapter;

public class PanningAndZoomingMouseBehaviour
extends MouseBehaviourAdapter
implements MouseWheelListener {
    private boolean isCurrent = false;
    private Point origin;
    private final KeyboardStatusMonitor keyboardMonitor;

    public PanningAndZoomingMouseBehaviour(ChartJPanel panel, KeyboardStatusMonitor keyboardMonitor) {
        super(panel);
        this.keyboardMonitor = keyboardMonitor;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.origin = new Point(e.getPoint());
        this.isCurrent = true;
        this.panel.chart.clearSelectedTags();
        this.panel.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isCurrent = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.origin != null) {
            JViewport viewPort = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.panel);
            if (viewPort != null) {
                int deltaX = this.origin.x - e.getX();
                int deltaY = this.origin.y - e.getY();
                Rectangle view = viewPort.getViewRect();
                view.x += deltaX;
                view.y += deltaY;
                this.panel.scrollRectToVisible(view);
            }
            this.panel.repaint();
        }
    }

    @Override
    public boolean isCurrent() {
        return this.isCurrent;
    }

    @Override
    public Cursor getCursor(Point p) {
        return new Cursor(12);
    }

    @Override
    public boolean activeAt(Point p) {
        return this.keyboardMonitor.isCtrlPressed() && !this.keyboardMonitor.isShiftPressed() && !this.keyboardMonitor.isAltPressed();
    }

    @Override
    public boolean isActiveForSelection(Object selection) {
        return true;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() > 0) {
            this.panel.getZoomManager().zoomOutAt(e.getPoint().x, e.getPoint().y);
        } else if (e.getWheelRotation() < 0) {
            this.panel.getZoomManager().zoomInAt(e.getPoint().x, e.getPoint().y);
        }
        this.panel.repaint();
    }
}

