/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.MapBlock;
import jsbugs.chart.properties.BlockPropertyRowUnlinked;
import jsbugs.table.ListEditor;
import model3.IGDScheme;
import model3.LithostratUnit;
import model3.SBdb;

class BlockPropertyRowLithostratUnit
extends BlockPropertyRowUnlinked {
    private static final Logger LOGGER = Logger.getLogger(BlockPropertyRowLithostratUnit.class.getName());
    private final Unit unit;
    private final ListEditor valueEditor;

    static BlockPropertyRowLithostratUnit upperUnitRow(TableCellRenderer valueRenderer, ListEditor valueEditor) {
        return new BlockPropertyRowLithostratUnit(Unit.UPPER, valueRenderer, valueEditor);
    }

    static BlockPropertyRowLithostratUnit lowerUnitRow(TableCellRenderer valueRenderer, ListEditor valueEditor) {
        return new BlockPropertyRowLithostratUnit(Unit.LOWER, valueRenderer, valueEditor);
    }

    private BlockPropertyRowLithostratUnit(Unit unit, TableCellRenderer valueRenderer, ListEditor valueEditor) {
        super(valueRenderer, valueEditor);
        this.unit = unit;
        this.valueEditor = valueEditor;
    }

    @Override
    String getTitle() {
        return (switch (this.unit.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Upper";
            case 1 -> "Lower";
        }) + " Unit";
    }

    @Override
    TableCellEditor getCellEditor(int column) {
        if (column == 1) {
            IGDScheme lithostratScheme = ((MapBlock)this.block).getProp().getLithostratScheme();
            try {
                this.valueEditor.setList(lithostratScheme != null ? lithostratScheme.getLithostratUnits() : Collections.EMPTY_LIST);
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Exception setting lithostrat unit list for value editor", e);
            }
            return this.valueEditor;
        }
        return null;
    }

    @Override
    Object getValue() {
        return switch (this.unit.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ((MapBlock)this.block).getProp().getUpperLithostratUnit();
            case 1 -> ((MapBlock)this.block).getProp().getLowerLithostratUnit();
        };
    }

    @Override
    void setValue(Object value, SBdb sbdb) {
        switch (this.unit.ordinal()) {
            case 0: {
                ((MapBlock)this.block).setPropUpperLithostratUnit((LithostratUnit)value);
                break;
            }
            case 1: {
                ((MapBlock)this.block).setPropLowerLithostratUnit((LithostratUnit)value);
            }
        }
    }

    private static enum Unit {
        UPPER,
        LOWER;

    }
}

