/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockTypeHelper;
import jsbchart.block.ChartBlock;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.EnumEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;
import util.DepthUnits;
import util.InvalidFieldException;
import util.SBException;

class BlockPropertyRowUnits
extends LinkedBlockPropertyRow {
    public BlockPropertyRowUnits(LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer ComboRenderer2, EnumEditor valueEditor) {
        super(titleRenderer, linkEditor, ComboRenderer2, valueEditor);
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && BlockTypeHelper.canLinkUnits(this.block.getBlockType()) && this.blocksOfType().count() > 1L) {
            newLink = this.unitsEqual();
        }
        return newLink;
    }

    private boolean unitsEqual() {
        return this.blocksOfType().map(b -> (ChartBlock)b).allMatch(b -> b.getProp().getUnits() == ((ChartBlock)this.block).getProp().getUnits());
    }

    @Override
    void setValue(Object value, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        DepthUnits units = (DepthUnits)value;
        if (this.chart != null && this.isLinked()) {
            this.blocksOfType().map(b -> (ChartBlock)b).forEach(b -> b.setUnits(units));
            return;
        }
        ((ChartBlock)this.block).setUnits(units);
    }

    @Override
    String getTitle() {
        return "Units";
    }

    @Override
    Object getValue() {
        BlockProperties bp = ((ChartBlock)this.block).getProp();
        switch (bp.getScaleType()) {
            case AGE: {
                return "Ma";
            }
            case TWT: {
                return "msec";
            }
        }
        return DepthUnits.getUnits((char)bp.getUnits());
    }

    @Override
    boolean isValueEditable() {
        if (this.block instanceof ChartBlock && ((ChartBlock)this.block).getProp().getScaleType() == BlockProperties.ScaleType.AGE) {
            return false;
        }
        return super.isValueEditable();
    }
}

