/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.scheme.Confidence;
import java.awt.Color;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartTemplate;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbugs.FrameChart;
import jsbugs.chart.properties.PropertiesTableModel;
import jsbugs.table.ButtonRendererNoClear;
import jsbugs.table.ChartDatumEditor;
import jsbugs.table.CheckBoxEditor;
import jsbugs.table.CheckBoxRenderer;
import jsbugs.table.ColourButtonRenderer;
import jsbugs.table.ColourChooserEditor;
import jsbugs.table.ComboRenderer;
import jsbugs.table.EnumCollectionEditor;
import jsbugs.table.EnumEditor;
import jsbugs.table.InterpEditor;
import jsbugs.table.ListEditor;
import model3.DataType;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.SBdb;
import model3.Surface;

public class CorrelationPropertiesTableModel
extends PropertiesTableModel {
    private final FrameChart parent;
    private Correlation correlation;
    private static final int ROW_T1 = 0;
    private static final int ROW_VERSION = 1;
    private static final int ROW_USEBLOCKINTERP = 2;
    private static final int ROW_VISIBLE = 3;
    private static final int ROW_DATA = 4;
    private static final int ROW_SCHEME = 5;
    private static final int ROW_HIER = 6;
    private static final int ROW_CONF = 7;
    private static final int ROW_CORRANGE = 8;
    private static final int ROW_T2 = 9;
    private static final int ROW_COLOUR = 10;
    private static final int ROW_WEIGHT = 11;
    private static final int ROW_LINESTYLE = 12;
    private static final int ROW_LABEL = 13;
    private static final int ROW_LABEL_POS = 14;
    private static final int ROW_LABEL_ABR = 15;
    private static final int ROW_LABEL_SIZE = 16;
    private static final int ROW_LABEL_ALIGNMENT = 17;
    private static final int ROW_LABEL_TYPE = 18;
    private final ComboRenderer comboRenderer = new ComboRenderer();
    private final CheckBoxRenderer checkBoxRenderer = new CheckBoxRenderer();
    private final ColourButtonRenderer colourRenderer = new ColourButtonRenderer();
    private final ColourButtonRenderer colourRendererUnits = new ColourButtonRenderer(true);
    private final ComboRenderer bndRenderer = new ComboRenderer("Inherited");
    private final ComboRenderer labelPosRenderer = new ComboRenderer("Default");
    private final ButtonRendererNoClear datumRenderer = new ButtonRendererNoClear();
    private final ButtonRendererNoClear dataTypeRenderer = new ButtonRendererNoClear();
    private final ButtonRendererNoClear hierRenderer = new ButtonRendererNoClear();
    private final ButtonRendererNoClear schemeRenderer = new ButtonRendererNoClear();
    private final InterpEditor interpEditor = new InterpEditor(this.sbdb);
    private final CheckBoxEditor checkBoxEditor = new CheckBoxEditor();
    private final ColourChooserEditor colourEditor = new ColourChooserEditor();
    private final ColourChooserEditor colourEditorUnits = new ColourChooserEditor(true);
    private final EnumEditor bndEditor = new EnumEditor(new JComboBox(), Boundary.class, "Inherited");
    private final EnumEditor labelPosEditor = new EnumEditor(new JComboBox(), CorrLineStyle.LabelPosition.class, "Default");
    private final EnumEditor confEditor = new EnumEditor(new JComboBox(), Confidence.class, null);
    private final ChartDatumEditor datumEditor;
    private final EnumCollectionEditor eventTypeEditor;
    private final EnumCollectionEditor surfaceTypeEditor;
    private final EnumCollectionEditor bndTypeEditor;
    private final ListEditor hierEditor;
    private final ListEditor schemeEditor;
    private final EnumEditor fontSizeEditor = new EnumEditor(new JComboBox(), ChartProperties.FontSize.class, null);
    private final EnumEditor alignmentEditor = new EnumEditor(new JComboBox(), HorizontalAlignment.class, null);

    public CorrelationPropertiesTableModel(FrameChart parent, SBdb sbdb) {
        super(sbdb);
        this.interpEditor.allowNullValue(false);
        this.parent = parent;
        this.datumEditor = new ChartDatumEditor(this.parent);
        this.eventTypeEditor = new EnumCollectionEditor((JFrame)this.parent, EventType.class);
        this.surfaceTypeEditor = new EnumCollectionEditor((JFrame)this.parent, Surface.SurfaceType.class);
        this.bndTypeEditor = new EnumCollectionEditor((JFrame)this.parent, IGDIntervalZone.BoundaryType.class);
        this.hierEditor = new ListEditor(this.parent, "Select Hierarchy Level");
        this.schemeEditor = new ListEditor(this.parent, "Select Scheme");
    }

    public void setCorrelation(Correlation correlation) {
        this.correlation = correlation;
    }

    @Override
    protected boolean isTitleRow(int row) {
        return row == 0 || row == 9;
    }

    @Override
    protected boolean isTitleButtonRow(int row) {
        return false;
    }

    @Override
    protected boolean isTitleInnerRow(int row) {
        return false;
    }

    @Override
    protected boolean allowNull(int row) {
        return false;
    }

    @Override
    protected boolean showRow(int row) {
        switch (row) {
            case 5: 
            case 6: {
                return this.correlation.getTemplateID() == 0 && CorrelationType.isUnitType(this.correlation.getCorrType());
            }
            case 7: 
            case 15: {
                return this.correlation.getCorrType() != CorrelationType.SURFACE;
            }
            case 8: 
            case 18: {
                return this.correlation.getCorrType() != CorrelationType.SURFACE && this.correlation.getCorrType() != CorrelationType.EVENT;
            }
        }
        return true;
    }

    @Override
    public int getRowCount() {
        if (this.correlation == null) {
            return 0;
        }
        return 19;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 1: 
        }
        switch (row) {
            case 0: 
            case 9: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: {
                try {
                    ChartTemplate chartTemplate = this.parent.getSelectedChart().getTemplate();
                    if (chartTemplate != null && !chartTemplate.canWrite(this.sbdb, null)) {
                        return false;
                    }
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                    return false;
                }
                return true;
            }
        }
        if (this.correlation.getTemplateID() > 0) {
            try {
                return this.parent.getChartManager().getCorrTemplate(this.correlation.getTemplateID()).canWrite(this.sbdb, null);
            }
            catch (SQLException sql) {
                sql.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            switch (rowIndex) {
                case 0: {
                    if (columnIndex == 0) {
                        Object s = this.correlation.toString();
                        Chart chart = this.parent.getSelectedChart();
                        if (chart != null) {
                            s = (String)s + " in " + chart.getTemplate().getName();
                        }
                        return s;
                    }
                    return null;
                }
                case 1: {
                    if (columnIndex == 0) {
                        return "Version";
                    }
                    return this.sbdb.getInterp(this.correlation.getInterpID());
                }
                case 4: {
                    if (columnIndex == 0) {
                        return this.correlation.getTemplateID() > 0 ? "Datum" : "Data types";
                    }
                    if (this.correlation.getTemplateID() > 0) {
                        return this.correlation;
                    }
                    return this.correlation.getDataTypes();
                }
                case 3: {
                    if (columnIndex == 0) {
                        return "Visible only";
                    }
                    return this.correlation.getVisibleOnly();
                }
                case 2: {
                    if (columnIndex == 0) {
                        return "Use block version if absent";
                    }
                    return this.correlation.getUseBlockInterp();
                }
                case 7: {
                    if (columnIndex == 0) {
                        switch (this.correlation.getCorrType()) {
                            case EVENT: {
                                return "Minimum confidence";
                            }
                        }
                        return "Correlate questionable";
                    }
                    if (CorrelationType.isUnitType(this.correlation.getCorrType())) {
                        return this.correlation.getMaxUnconfidence() == 100;
                    }
                    return Confidence.getMaxUnconfidence((int)this.correlation.getMaxUnconfidence());
                }
                case 8: {
                    if (columnIndex == 0) {
                        return "Correlate ranged intervals";
                    }
                    return this.correlation.getCorrelateRangedIntervals();
                }
                case 5: {
                    if (columnIndex == 0) {
                        return "Scheme";
                    }
                    if (this.correlation.getSchID() > 0) {
                        return this.sbdb.getIGDScheme(this.correlation.getSchID());
                    }
                    return null;
                }
                case 6: {
                    if (columnIndex == 0) {
                        return "Hierarchy level";
                    }
                    if (this.correlation.getHier() > 0) {
                        return IGDIntervalZone.getHierName(DataType.getIGDType(this.correlation.getCorrType().getDataType()), this.correlation.getHier());
                    }
                    return null;
                }
                case 9: {
                    if (columnIndex == 0) {
                        return this.correlation.getTemplateID() > 0 ? "Default line style" : "Line style";
                    }
                    return this.correlation.getDefaultLineStyle().getBnd();
                }
                case 10: {
                    if (columnIndex == 0) {
                        return "Colour";
                    }
                    return this.correlation.getDefaultLineStyle().getColour();
                }
                case 11: {
                    if (columnIndex == 0) {
                        return "Weight";
                    }
                    return Float.valueOf(this.correlation.getDefaultLineWeight());
                }
                case 12: {
                    if (columnIndex == 0) {
                        return "Style";
                    }
                    return this.correlation.getDefaultLineStyle().getBnd();
                }
                case 13: {
                    if (columnIndex == 0) {
                        return "Label";
                    }
                    return this.correlation.getDefaultLineStyle().getLabel();
                }
                case 15: {
                    if (columnIndex == 0) {
                        return "Label abbreviation";
                    }
                    return this.correlation.getDefaultLineStyle().getLabelAbr();
                }
                case 14: {
                    if (columnIndex == 0) {
                        return "Label position";
                    }
                    return this.correlation.getDefaultLineStyle().getLabelPosition();
                }
                case 16: {
                    if (columnIndex == 0) {
                        return "Label font size";
                    }
                    return this.correlation.getDefaultLineStyle().getFontSize();
                }
                case 17: {
                    if (columnIndex == 0) {
                        return "Label alignment";
                    }
                    return this.correlation.getDefaultLineStyle().getAlignment();
                }
                case 18: {
                    if (columnIndex == 0) {
                        return "Show label top/base";
                    }
                    return this.correlation.getDefaultLineStyle().getShowLabelType();
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        assert (col == 1);
        if (this.correlation == null) {
            return;
        }
        switch (row) {
            case 1: {
                this.correlation.setInterpID((Integer)value);
                break;
            }
            case 4: {
                if (this.correlation.getTemplateID() > 0) {
                    int opt;
                    Chart chart = this.parent.getSelectedChart();
                    if (chart == null) break;
                    Correlation correlationWithDatum = chart.getCorrelationWithDatum();
                    if (correlationWithDatum != null && correlationWithDatum != this.correlation ? (opt = JOptionPane.showConfirmDialog(this.parent, "This will remove the datum from another correlation.\nDo you want to continue?", "Set Chart Datum", 0)) == 1 : value == null && (opt = JOptionPane.showConfirmDialog(this.parent, "Clear datum?", "Set Chart Datum", 0)) == 1) {
                        return;
                    }
                    chart.setDatum(this.correlation, (CorrelationLine[])value);
                    break;
                }
                this.correlation.setDataTypes((Collection)value);
                break;
            }
            case 3: {
                this.correlation.setVisibleOnly((Boolean)value);
                break;
            }
            case 2: {
                this.correlation.setUseBlockInterp((Boolean)value);
                break;
            }
            case 7: {
                if (value instanceof Confidence) {
                    this.correlation.setMaxUnconfidence((Confidence)value);
                    break;
                }
                if (!(value instanceof Boolean)) break;
                this.correlation.setMaxUnconfidence((Boolean)value);
                break;
            }
            case 8: {
                this.correlation.setCorrelateRangedIntervals((Boolean)value);
                break;
            }
            case 10: {
                this.correlation.setDefaultLineColour((Color)value);
                break;
            }
            case 11: {
                this.correlation.setDefaultLineWeight(Float.parseFloat(value.toString()));
                break;
            }
            case 12: {
                this.correlation.setDefaultLineStyle((Boundary)value);
                break;
            }
            case 13: {
                this.correlation.setDefaultLineLabel((Boolean)value);
                break;
            }
            case 15: {
                this.correlation.setDefaultLineLabelAbr((Boolean)value);
                break;
            }
            case 6: {
                this.correlation.setHier(IGDIntervalZone.getHierNumber(DataType.getIGDType(this.correlation.getCorrType().getDataType()), (String)value, true));
                break;
            }
            case 5: {
                this.correlation.setSchID((IGDScheme)value);
                break;
            }
            case 14: {
                this.correlation.setDefaultLineLabelPosition((CorrLineStyle.LabelPosition)((Object)value));
                break;
            }
            case 16: {
                this.correlation.setDefaultLineLabelFontSize((ChartProperties.FontSize)((Object)value));
                break;
            }
            case 17: {
                this.correlation.setDefaultLineLabelAlignment((HorizontalAlignment)((Object)value));
                break;
            }
            case 18: {
                this.correlation.setDefaultLineLabelShowLabelType((Boolean)value);
            }
        }
        this.correlation.notifyListeners();
        this.parent.fireChartMightHaveChanged();
    }

    @Override
    protected TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 1) {
            switch (row) {
                case 8: 
                case 18: {
                    return this.checkBoxRenderer;
                }
                case 7: {
                    if (CorrelationType.isUnitType(this.correlation.getCorrType())) {
                        return this.checkBoxRenderer;
                    }
                }
                case 1: 
                case 16: 
                case 17: {
                    this.comboRenderer.setEnabled(true);
                    return this.comboRenderer;
                }
                case 4: {
                    if (this.correlation.getTemplateID() > 0) {
                        return this.datumRenderer;
                    }
                    return this.dataTypeRenderer;
                }
                case 2: 
                case 3: 
                case 13: 
                case 15: {
                    return this.checkBoxRenderer;
                }
                case 10: {
                    if (CorrelationType.isUnitType(this.correlation.getCorrType())) {
                        return this.colourRendererUnits;
                    }
                    return this.colourRenderer;
                }
                case 11: {
                    return null;
                }
                case 12: {
                    this.bndRenderer.setEnabled(true);
                    return this.bndRenderer;
                }
                case 14: {
                    return this.labelPosRenderer;
                }
                case 6: {
                    return this.hierRenderer;
                }
                case 5: {
                    return this.schemeRenderer;
                }
            }
        }
        return null;
    }

    @Override
    protected TableCellEditor getCellEditor(int row, int column) {
        if (column == 1) {
            switch (row) {
                case 1: {
                    return this.interpEditor;
                }
                case 4: {
                    if (this.correlation.getTemplateID() > 0) {
                        return this.datumEditor;
                    }
                    switch (this.correlation.getCorrType()) {
                        case EVENT: {
                            return this.eventTypeEditor;
                        }
                        case SURFACE: {
                            return this.surfaceTypeEditor;
                        }
                        case CHRONO: 
                        case LITHO: 
                        case BIOZONE: {
                            return this.bndTypeEditor;
                        }
                    }
                    assert (false);
                    return null;
                }
                case 2: 
                case 3: 
                case 13: 
                case 15: {
                    return this.checkBoxEditor;
                }
                case 10: {
                    if (CorrelationType.isUnitType(this.correlation.getCorrType())) {
                        return this.colourEditorUnits;
                    }
                    return this.colourEditor;
                }
                case 11: {
                    return null;
                }
                case 12: {
                    return this.bndEditor;
                }
                case 6: {
                    this.hierEditor.setList(Arrays.asList(IGDIntervalZone.getHierNames(DataType.getIGDType(this.correlation.getCorrType().getDataType()))));
                    return this.hierEditor;
                }
                case 5: {
                    try {
                        this.schemeEditor.setList(new LinkedList<IGDScheme>(this.parent.getSelectedChart().getIGDSchemes(DataType.getIGDType(this.correlation.getCorrType().getDataType()), this.correlation.getInterpID(), this.correlation.getVisibleOnly(), this.sbdb)));
                    }
                    catch (Exception e) {
                        this.schemeEditor.setList(new LinkedList());
                        e.printStackTrace();
                    }
                    return this.schemeEditor;
                }
                case 14: {
                    return this.labelPosEditor;
                }
                case 7: {
                    if (CorrelationType.isUnitType(this.correlation.getCorrType())) {
                        return this.checkBoxEditor;
                    }
                    return this.confEditor;
                }
                case 8: 
                case 18: {
                    return this.checkBoxEditor;
                }
                case 16: {
                    return this.fontSizeEditor;
                }
                case 17: {
                    return this.alignmentEditor;
                }
            }
        }
        return null;
    }
}

