/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.io.File;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.SchemeBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelBiozones;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelWellDepthAge;
import jsbchart.panel.PanelZones;
import jsbchart.panel.PanelZonesProperties;
import jsbchart.panel.SBPanel;
import jsbchart.panel.spatial.MapLabelAttribute;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.util.LogInfo;
import jsbchart.util.colour.ColourScale;
import jsbchart.util.colour.ColourSpectrum;
import jsbugs.FrameChart;
import jsbugs.FrameOrganiser;
import jsbugs.FrameSamples;
import jsbugs.chart.properties.PanelPropertiesTableModelBase;
import jsbugs.table.AgeCurveEditor;
import jsbugs.table.AllowNullEditor;
import jsbugs.table.AnalystCollectionEditor;
import jsbugs.table.BlockTemplateEditor;
import jsbugs.table.ButtonRenderer;
import jsbugs.table.CaptionEditor;
import jsbugs.table.CheckBoxEditor;
import jsbugs.table.ColourChooserEditor;
import jsbugs.table.ColourScaleEditor;
import jsbugs.table.ColumnWidthRendererEditor;
import jsbugs.table.CompositeStandardEditor;
import jsbugs.table.DisciplineCollectionEditor;
import jsbugs.table.EnumCollectionEditor;
import jsbugs.table.EnumEditor;
import jsbugs.table.EnvSchEditor;
import jsbugs.table.FileChooserEditor;
import jsbugs.table.FillableEditor;
import jsbugs.table.FloatEditor;
import jsbugs.table.GrpSetEditor;
import jsbugs.table.HierarchyEditor;
import jsbugs.table.IntegerCollectionEditor;
import jsbugs.table.IntegerEditor;
import jsbugs.table.InterpEditor;
import jsbugs.table.ItemSelectorEditor;
import jsbugs.table.LabelAttributeEditor;
import jsbugs.table.ListEditor;
import jsbugs.table.LogDefCollectionEditor;
import jsbugs.table.LogDefEditor;
import jsbugs.table.LogDefSelectorEditor;
import jsbugs.table.PanelEventsCatFilterEditor;
import jsbugs.table.PanelTaxonOccFilterEditor;
import jsbugs.table.ScaleEditor;
import jsbugs.table.SchemeButtonEditor;
import jsbugs.table.SchemeEditor;
import jsbugs.table.ShapeStoreEditor;
import jsbugs.table.SpectrumEditor;
import jsbugs.table.SynonymSchemeEditor;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.AgeCurve;
import model3.CompositeStandard;
import model3.DataType;
import model3.EnvScheme;
import model3.IGDColMap;
import model3.IGDScheme;
import model3.InterpHdr;
import model3.Lastval;
import model3.LogDef;
import model3.SBEvent;
import model3.SBRestrictable;
import model3.SBdb;
import model3.SynonymScheme;
import model3.TxGroupSet;
import model3.Well;
import util.NegativeFloat;
import util.SBException;
import util.SBPermissionException;

public class PanelPropertiesTableModel
extends PanelPropertiesTableModelBase {
    private static final Logger LOGGER = Logger.getLogger(PanelPropertiesTableModel.class.getName());
    private PanelTemplate templ;
    private ChartPanel panel;
    private final HashMap<Class<?>, TableCellEditor> editors = new HashMap();
    private final ButtonRenderer buttonRenderer = new ButtonRenderer();
    private final ListEditor schemeListEditor;
    private final JFrame parent;
    private final ChartManager chartManager;
    private boolean editable = true;
    private static final int ROW_T1 = 0;
    private static final int ROW_CAPTION = 1;
    private static final int ROW_SUBCAPTION = 2;
    private static final int ROW_CAPORIENT = 3;
    private static final int ROW_OVERPLOT = 4;
    private static final int ROW_INTERP = 5;
    private static final int ROW_SCHEME = 6;
    private static final int ROW_T2 = 7;
    private static final int NPANELOCCROWS = 8;

    public PanelPropertiesTableModel(JFrame parent, SBdb sbdb) {
        super(sbdb, null);
        this.parent = parent;
        if (parent instanceof FrameChart) {
            this.chartManager = ((FrameChart)parent).getChartManager();
        } else if (parent instanceof FrameSamples) {
            this.chartManager = ((FrameSamples)parent).getParent().getChartManager();
        } else if (parent instanceof FrameOrganiser) {
            this.chartManager = ((FrameOrganiser)parent).getWsChartManager();
        } else {
            throw new IllegalArgumentException("Unexpected parent for PanelPropertiesTableModel: should be FrameChart or FrameSamples");
        }
        this.initEditors();
        this.schemeListEditor = new ListEditor(parent, "Select Biozone Scheme");
    }

    public PanelPropertiesTableModel(JFrame parent, ChartManager cm, SBdb sbdb) {
        super(sbdb, null);
        this.parent = parent;
        this.chartManager = cm;
        this.initEditors();
        this.schemeListEditor = new ListEditor(parent, "Select Biozone Scheme");
    }

    private void initEditors() {
        this.editors.put(InterpHdr.class, new InterpEditor(this.sbdb));
        this.editors.put(Discipline[].class, new DisciplineCollectionEditor(this.parent));
        this.editors.put(Userdef[].class, new AnalystCollectionEditor(this.parent, this.sbdb));
        this.editors.put(IGDScheme.class, new SchemeEditor());
        SchemeButtonEditor schemeButtonEditor = new SchemeButtonEditor(this.parent, this.sbdb);
        schemeButtonEditor.renderer.canClear(true);
        this.editors.put(IGDScheme[].class, schemeButtonEditor);
        this.editors.put(CompositeStandard.class, new CompositeStandardEditor(this.sbdb));
        this.editors.put(EnvScheme.class, new EnvSchEditor(this.sbdb));
        this.editors.put(BlockProperties.ScaleType.class, new ScaleEditor(new JComboBox()));
        this.editors.put(SampleType.class, new EnumCollectionEditor(this.parent, SampleType.class));
        this.editors.put(SynonymScheme.class, new SynonymSchemeEditor());
        this.editors.put(TxGroupSet.class, new GrpSetEditor());
        this.editors.put(AgeCurve.class, new AgeCurveEditor(new JComboBox(), this.sbdb));
        this.editors.put(PanelProperties.ColumnWidth.class, new ColumnWidthRendererEditor());
        this.editors.put(CaptionTemplate.class, new CaptionEditor(this.parent));
        this.editors.put(SchemeBlock.class, new BlockTemplateEditor(new JComboBox()));
        this.editors.put(IGDColMap.class, new HierarchyEditor(new JComboBox()));
        this.editors.put(LogDef[].class, new LogDefCollectionEditor(this.parent, this.sbdb));
        this.editors.put(LogDef.class, new LogDefEditor(this.parent, this.sbdb));
        this.editors.put(LogInfo.class, new LogDefSelectorEditor(this.parent, this.sbdb));
        this.editors.put(PanelTaxonOcc.Filter.class, new PanelTaxonOccFilterEditor(this.parent, "<not restricted>", false));
        this.editors.put(Category.class, new PanelEventsCatFilterEditor(this.parent, null));
        this.editors.put(SBShapeStore.class, new ShapeStoreEditor(this.parent, this.chartManager.getShapeStoreService()));
        this.editors.put(Taxon.class, ItemSelectorEditor.taxonSelectorEditor(this.parent, "<select>"));
        this.editors.put(SBEvent.class, ItemSelectorEditor.eventSelectorEditor(this.parent, "<select>"));
        this.editors.put(MapLabelAttribute.class, new LabelAttributeEditor(this.parent, () -> this.getProperties(0)));
        this.editors.put(File.class, new FileChooserEditor());
        this.editors.put(Color.class, new ColourChooserEditor());
        this.editors.put(ColourScale.class, new ColourScaleEditor(this.parent));
        this.editors.put(ColourSpectrum.class, new SpectrumEditor(this.parent));
        this.editors.put(Boolean.class, new CheckBoxEditor());
        this.editors.put(Float.class, new FloatEditor(false));
        this.editors.put(NegativeFloat.class, new FloatEditor(true));
        this.editors.put(Integer.class, new IntegerEditor(false));
        this.editors.put(Integer[].class, new IntegerCollectionEditor(this.parent));
    }

    public boolean setTemplate(PanelTemplate templ, ChartPanel panel) {
        if (this.templ != templ || this.panel != panel) {
            this.templ = templ;
            this.panel = panel;
            return true;
        }
        return false;
    }

    public void setEditable(boolean value) {
        this.editable = value;
    }

    @Override
    public PanelProperties getProperties(int n) {
        if (this.templ != null) {
            return this.templ.getEditableProp();
        }
        if (this.panel != null) {
            return this.panel.getProperties();
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (this.templ == null) {
            if (this.panel != null) {
                int titleRows = this.panel.getProperties().getTitleRows() != null ? this.panel.getProperties().getTitleRows().length : 0;
                return this.panel.getProperties().getnProps() + titleRows + 8;
            }
            return 0;
        }
        if (this.templ.getEditableProp() == null) {
            return 0;
        }
        int titleRows = 0;
        if (this.templ.getEditableProp().getTitleRows() != null) {
            titleRows = this.templ.getEditableProp().getTitleRows().length;
        }
        return this.templ.getEditableProp().getnProps() + titleRows + 8;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    protected boolean showRow(int row) {
        switch (row) {
            case 0: 
            case 1: 
            case 2: {
                return this.panel != null;
            }
            case 3: {
                return this.panel != null && this.panel.getPanelType().allowCaptionOrientationChange;
            }
            case 4: {
                return this.panel != null && this.panel.getPanelType().allowOverplot;
            }
            case 5: {
                return this.panel != null && this.panel.getPanelType().isInterpPanel();
            }
            case 6: {
                return this.panel != null && this.panel instanceof PanelBiozones;
            }
        }
        PanelProperties prop = this.getProperties(0);
        if (prop.getTitleRows() != null) {
            int titleRow = row - 8;
            for (int i : prop.getTitleRows()) {
                if (i != titleRow) continue;
                return true;
            }
        }
        return prop.showRow(this.convertRowIndexToPanelProperties(row));
    }

    @Override
    int convertRowIndexToPanelProperties(int row) {
        int propRow = row - 8;
        if (this.getProperties(0).getTitleRows() != null) {
            int nTitles = 0;
            for (int titleRow : this.getProperties(0).getTitleRows()) {
                if (titleRow > propRow) continue;
                ++nTitles;
            }
            return propRow - nTitles;
        }
        return propRow;
    }

    private int getnTitleRow(int row) {
        if (row < 8) {
            return -1;
        }
        int[] titleRows = this.getProperties(0).getTitleRows();
        if (titleRows == null) {
            return -1;
        }
        int titleRow = row - 8;
        for (int i = 0; i < titleRows.length; ++i) {
            if (titleRow != titleRows[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.getProperties(0) == null) {
            return null;
        }
        if (!this.showRow(row)) {
            return null;
        }
        switch (row) {
            case 0: {
                ChartBlockBase block = this.panel.getBlock();
                if (block != null && block.getTemplate() != null) {
                    String blockTemplateName = block.getTemplate().getName();
                    try {
                        String parentName = block.getTemplate().getParentName();
                        if (parentName != null) {
                            blockTemplateName = parentName;
                        }
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    return "Properties in block template [" + blockTemplateName + "]";
                }
                return "Properties in block (no template)";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                switch (col) {
                    case 0: {
                        return PanelOcc.getPropertyName(row - 1);
                    }
                    case 1: {
                        PanelOcc panelOcc = this.panel.getPanelOcc();
                        switch (row) {
                            case 1: {
                                return panelOcc.getCaption();
                            }
                            case 2: {
                                return panelOcc.getSubCaption();
                            }
                            case 3: {
                                return panelOcc.getCapOrient();
                            }
                            case 4: {
                                return panelOcc.getCapOrient() != BlockTemplate.CaptionOrientation.getDefault();
                            }
                            case 5: {
                                if (panelOcc.getInterpID() != null) {
                                    try {
                                        return this.sbdb.getInterp(panelOcc.getInterpID());
                                    }
                                    catch (SQLException sql) {
                                        sql.printStackTrace();
                                        return null;
                                    }
                                }
                                return "Inherited";
                            }
                            case 6: {
                                if (panelOcc.getSchID() > 0) {
                                    try {
                                        return this.sbdb.getIGDScheme(panelOcc.getSchID());
                                    }
                                    catch (SQLException e) {
                                        e.printStackTrace();
                                        return null;
                                    }
                                }
                                return ((PanelZonesProperties)this.getProperties(0)).getForEachString(true);
                            }
                        }
                    }
                }
                assert (false);
            }
            case 7: {
                if (this.templ == null) {
                    return "Local panel properties";
                }
                return this.templ;
            }
        }
        int nTitleRow = this.getnTitleRow(row);
        if (nTitleRow > -1) {
            if (col == 0) {
                return this.getProperties(0).getTitleName(nTitleRow);
            }
            return null;
        }
        row = this.convertRowIndexToPanelProperties(row);
        switch (col) {
            case 0: {
                return this.getProperties(0).getPropertyName(row);
            }
            case 1: {
                return this.getProperties(0).getProperty(row);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.editable || this.parent instanceof FrameOrganiser) {
            return false;
        }
        switch (col) {
            default: {
                return false;
            }
            case 1: 
        }
        if (this.isTitleRow(row) || this.getnTitleRow(row) > -1) {
            return false;
        }
        try {
            FrameChart cParent;
            SBRestrictable blockTemplate = null;
            if (this.templ != null && (cParent = (FrameChart)this.parent).getSelectedChart() != null && cParent.getSelectedChart().getBlockSingle() != null) {
                blockTemplate = cParent.getSelectedChart().getBlockSingle().getTemplate();
            }
            switch (row) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return blockTemplate == null || blockTemplate.canWrite(this.sbdb, null);
                }
            }
            if (blockTemplate != null && !blockTemplate.canWrite(this.sbdb, null)) {
                return false;
            }
            if (this.templ != null && !this.templ.canWrite(this.sbdb, null)) {
                return false;
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        if (col == 0) {
            return;
        }
        if (row < 8) {
            switch (row) {
                case 6: {
                    int schID = 0;
                    if (o != null && o instanceof IGDScheme) {
                        schID = ((IGDScheme)o).getID();
                    }
                    o = schID;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.panel.setPanelOccProperty(row - 1, o);
                    if (this.parent instanceof FrameChart) {
                        ((FrameChart)this.parent).fireChartMightHaveChanged();
                    }
                    if (this.templ == null) {
                        this.panel.update((Observable)((Object)this.panel.getPanelOcc()), null);
                    }
                    if (row != 1 && row != 3 || !this.getProperties((int)0).getPanelType().captionPreference) break;
                    try {
                        Lastval.putString(this.sbdb, "CAP_" + this.getProperties(0).getPanelType().ordinal(), CaptionTemplate.getDbString(this.panel.getPanelOcc().getCaption()));
                        Lastval.putString(this.sbdb, "CAPOR_" + this.getProperties(0).getPanelType().ordinal(), this.panel.getPanelOcc().getCapOrient().name());
                        this.sbdb.commit();
                        break;
                    }
                    catch (SQLException sql) {
                        sql.printStackTrace();
                    }
                }
            }
            return;
        }
        int propertyRow = this.convertRowIndexToPanelProperties(row);
        if (this.templ != null) {
            this.templ.updateProperty(o, propertyRow);
            this.fireTableCellUpdated(row, col);
            if (this.showRow(7)) {
                this.fireTableCellUpdated(7, 0);
            }
            if (this.showRow(6)) {
                this.fireTableCellUpdated(6, col);
            }
            if (this.parent instanceof FrameChart) {
                FrameChart cParent = (FrameChart)this.parent;
                if (this.templ.getProperties().hasShowRowDependencies(propertyRow)) {
                    cParent.firePropertiesTableDataChanged();
                }
                cParent.fireTreeNodeChanged(this.templ);
                cParent.firePanelTaxonSaveButtonChange(this.templ);
                if (!this.templ.isVisible()) {
                    cParent.fireChartMightHaveChanged();
                }
            }
        } else {
            this.panel.getProperties().setProperty(propertyRow, o);
            this.fireTableCellUpdated(row, col);
            if (this.panel.getProperties().hasShowRowDependencies(propertyRow)) {
                this.fireTableDataChanged();
            }
            this.panel.doPropertyChangeNotify();
        }
    }

    @Override
    protected void doTitleButtonRowAction() {
        if (this.templ.isVisible()) {
            this.saveTemplate();
        } else {
            this.restoreTemplate();
        }
    }

    void saveTemplate() {
        int opt;
        if (this.templ.hasBeenRefreshed() && (opt = JOptionPane.showConfirmDialog(this.parent, "This template has been changed by another user.\nSaving your changes will overwrite theirs.\nContinue?", "Save Template", 0)) != 0) {
            return;
        }
        try {
            if (this.parent instanceof FrameChart && !((FrameChart)this.parent).checkPanelSave(this.templ)) {
                return;
            }
            this.templ.update(this.sbdb);
            this.sbdb.commit();
            if (this.parent instanceof FrameChart) {
                ((FrameChart)this.parent).fireTreeNodeChanged(this.templ);
            }
        }
        catch (SQLException | SBPermissionException sql) {
            this.sbdb.doRollback();
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
    }

    void restoreTemplate() {
        this.templ.restoreSavedProperties();
        if (this.showRow(7)) {
            this.fireTableCellUpdated(7, 0);
        }
        if (this.parent instanceof FrameChart) {
            ((FrameChart)this.parent).fireTreeNodeChanged(this.templ);
        }
    }

    public PanelTemplate getPanelTemplate() {
        return this.templ;
    }

    public ChartPanel getPanel() {
        return this.panel;
    }

    @Override
    public Class<?> getCellClass(int row, int col) {
        switch (col) {
            default: {
                return this.getColumnClass(col);
            }
            case 1: 
        }
        if (this.isTitleRow(row) || this.getnTitleRow(row) > -1) {
            return String.class;
        }
        if (row < 8) {
            return PanelOcc.getPropertyClass(row - 1);
        }
        return this.getProperties(0).getPropertyClass(this.convertRowIndexToPanelProperties(row));
    }

    @Override
    public boolean isTitleRow(int row) {
        if (row == 0 || row == 7) {
            return true;
        }
        return this.getnTitleRow(row) > -1;
    }

    @Override
    protected boolean isTitleInnerRow(int row) {
        return this.getnTitleRow(row) > -1;
    }

    @Override
    public boolean isTitleButtonRow(int row) {
        return row == 7;
    }

    @Override
    public boolean allowNull(int row) {
        if (row < 8) {
            return true;
        }
        return this.getProperties(0).allowNull(this.convertRowIndexToPanelProperties(row));
    }

    @Override
    String getToolTipText(int row) {
        if (row < 8) {
            return null;
        }
        return this.getProperties(0).getToolTipText(this.convertRowIndexToPanelProperties(row));
    }

    DataType getDataType() {
        if (this.templ != null) {
            return this.templ.getEditableProp().getDataType();
        }
        throw new IllegalStateException("Template is null in PanelProperties table model");
    }

    private boolean allowNullScheme() {
        switch (this.getProperties(0).getPanelType()) {
            case SURFACE: 
            case SEQUENCE: 
            case CHRONOSCHEME: 
            case LITHOSCHEME: 
            case BIOSCHEME: 
            case VS: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected TableCellRenderer getCellRenderer(int row, int column) {
        switch (row) {
            case 6: {
                if (column != 1) break;
                return this.buttonRenderer;
            }
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    protected TableCellEditor getCellEditor(int row, int column) {
        switch (row) {
            case 6: {
                List<Object> list = null;
                if (this.panel != null && this.panel instanceof PanelZones) {
                    try {
                        list = ((PanelZones)this.panel).getSchemesInWell();
                    }
                    catch (SQLException | SBException e) {
                        e.printStackTrace();
                    }
                }
                if (list == null) {
                    list = new LinkedList<IGDScheme>();
                    try {
                        list.addAll(this.sbdb.getBiozoneSchemes(((PanelZonesProperties)this.templ.getProperties()).getDisc()));
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                Collections.sort(list);
                PanelTemplate template = this.templ != null ? this.templ : this.panel.getTemplate();
                list.add(0, ((PanelZonesProperties)template.getEditableProp()).getForEachString(false));
                this.schemeListEditor.setList(list);
                return this.schemeListEditor;
            }
        }
        TableCellEditor e = this.editors.get(this.getCellClass(row, column));
        if (e != null) {
            if (e instanceof FillableEditor) {
                ((FillableEditor)((Object)e)).fill(this.sbdb);
            }
            if (e instanceof InterpEditor) {
                try {
                    Collection<InterpHdr> versions = null;
                    if (this.templ == null && this.panel != null) {
                        versions = ((SBPanel)this.panel).getVersionsInWell();
                    } else if (this.panel != null) {
                        versions = this.sbdb.getVersionsInProject(this.panel.getBlock().getTemplate().getProjID());
                    }
                    ((InterpEditor)e).restrictCombo(versions);
                }
                catch (SQLException | SBException err) {
                    err.printStackTrace();
                    ((InterpEditor)e).restrictCombo(null);
                }
            }
            if (e instanceof AllowNullEditor) {
                ((AllowNullEditor)e).allowNullValue(this.allowNull(row));
            }
            if (e instanceof GrpSetEditor) {
                int projID = 0;
                if (this.templ != null) {
                    projID = this.templ.getProjID();
                } else {
                    Iterator<Integer> iterator;
                    Well well = this.panel.getBlock().getWell();
                    if (well != null && (iterator = well.getDataModel().getProjIDs(well).iterator()).hasNext()) {
                        int id;
                        projID = id = iterator.next().intValue();
                    }
                }
                ((GrpSetEditor)e).fill(this.sbdb, projID);
            } else if (e instanceof DisciplineCollectionEditor) {
                ((DisciplineCollectionEditor)e).allowNullValue(this.allowNull(row));
            } else if (e instanceof SchemeEditor) {
                ((SchemeEditor)e).fill(this.getDataType(), this.allowNullScheme(), this.sbdb);
            } else if (e instanceof BlockTemplateEditor) {
                ((BlockTemplateEditor)e).fill(this.chartManager, BlockType.SCHEME, this.templ.getProjID());
            } else if (e instanceof ScaleEditor) {
                float scale = ((Float)this.getValueAt(row, column)).floatValue();
                try {
                    ((ScaleEditor)e).setScale(scale, this.sbdb, this.panel instanceof PanelWellDepthAge ? BlockProperties.ScaleType.AGE : BlockProperties.ScaleType.TVD);
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            } else if (e instanceof HierarchyEditor && this.templ.getEditableProp().getDataType() != null) {
                ((HierarchyEditor)e).fill(DataType.getIGDType(this.templ.getEditableProp().getDataType()));
            } else if (e instanceof AnalystCollectionEditor) {
                try {
                    List<Userdef> analysts = null;
                    if (this.templ == null && this.panel != null) {
                        analysts = ((SBPanel)this.panel).getAnalystsInWell();
                    } else if (this.panel != null) {
                        analysts = this.sbdb.getAnalystsInProject(this.panel.getBlock().getTemplate().getProjID(), this.panel.getPanelType().getDiscipine());
                    } else if (this.templ != null) {
                        analysts = this.sbdb.getAnalystsInProject(this.templ.getProjID(), this.templ.getType().getDiscipine());
                    }
                    ((AnalystCollectionEditor)e).restrictList(analysts);
                }
                catch (SQLException | SBException ex) {
                    ex.printStackTrace();
                    ((AnalystCollectionEditor)e).restrictList(null);
                }
            } else if (e instanceof PanelTaxonOccFilterEditor) {
                Set<Integer> projIDs;
                int projID = 0;
                if (this.templ != null) {
                    projID = this.templ.getProjID();
                } else if (this.panel != null && this.panel.getBlock().getWell() != null && !(projIDs = this.panel.getBlock().getWell().getDataModel().getProjIDs(this.panel.getBlock().getWell())).isEmpty()) {
                    projID = projIDs.iterator().next();
                }
                ((PanelTaxonOccFilterEditor)e).setContext(null, this.templ != null ? this.templ.getType().getDiscipine() : this.panel.getPanelType().getDiscipine(), projID);
            }
            if (e instanceof ColourChooserEditor && this.allowNull(row)) {
                ((ColourChooserEditor)e).setRendererNullString(this.getProperties(0).getNullText(this.convertRowIndexToPanelProperties(row)));
            }
        }
        if (e == null && this.getCellClass(row, column).isEnum()) {
            Class<?> cellClass = this.getCellClass(row, column);
            EnumEditor enumEditor = new EnumEditor(new JComboBox(), cellClass, null);
            this.editors.put(cellClass, enumEditor);
            return enumEditor;
        }
        return e;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        super.addTableModelListener(l);
    }
}

