/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties.taxon;

import com.stratadata.model3.taxon.Category;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import jsbugs.chart.properties.taxon.DialogCategoryOrder;
import jsbugs.list.CategoryListCellRenderer;
import jsbugs.uiutil.UIColours;

public class DialogCategorySelect
extends SBDialog {
    private final Frame myParent;
    private boolean listChanging = false;
    private List<Category> selectedCategories = new ArrayList<Category>();
    private List<Category> primaryCategoryList = new ArrayList<Category>();
    private List<Category> secondaryCategoryList = null;
    private JButton jButton1;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JButton jButtonSort;
    private JCheckBox jCheckBoxShowAll;
    private JLabel jLabelSelected;
    private JList<Category> jListCategories;
    private JPanel jPanelShowAll;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextField jTextFieldSelectedCategories;

    public DialogCategorySelect(Frame parent, boolean modal, boolean allowMultiple) {
        super(parent, modal);
        this.myParent = parent;
        this.initComponents();
        this.init(allowMultiple);
    }

    private void init(boolean allowMultiple) {
        CategoryListCellRenderer categoryListCellRenderer = new CategoryListCellRenderer();
        categoryListCellRenderer.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jListCategories.setCellRenderer(categoryListCellRenderer);
        if (allowMultiple) {
            this.setTitle("Select Categories");
            this.jListCategories.setSelectionModel(new DefaultListSelectionModel(this){
                boolean gestureStarted;
                final /* synthetic */ DialogCategorySelect this$0;
                {
                    DialogCategorySelect dialogCategorySelect = this$0;
                    Objects.requireNonNull(dialogCategorySelect);
                    this.this$0 = dialogCategorySelect;
                    this.gestureStarted = false;
                }

                @Override
                public void setSelectionInterval(int index0, int index1) {
                    if (!this.gestureStarted) {
                        if (this.isSelectedIndex(index0)) {
                            super.removeSelectionInterval(index0, index1);
                        } else {
                            super.addSelectionInterval(index0, index1);
                        }
                    }
                    this.gestureStarted = true;
                }

                @Override
                public void setValueIsAdjusting(boolean isAdjusting) {
                    if (!isAdjusting) {
                        this.gestureStarted = false;
                    }
                }
            });
        } else {
            this.setTitle("Select Category");
            this.jListCategories.setSelectionMode(0);
        }
        this.jListCategories.addListSelectionListener(e -> this.listValueChanged(e));
        this.jCheckBoxShowAll.addItemListener(e -> this.changeListedCategories(e.getStateChange() == 1));
        this.jLabelSelected.setVisible(allowMultiple);
        this.jTextFieldSelectedCategories.setVisible(allowMultiple);
        this.jButtonSort.setVisible(allowMultiple);
        this.jTextFieldSelectedCategories.setBackground(UIColours.EDITABLE_CELL_BACKGROUND);
        this.pack();
    }

    public void setCategories(List<Category> categories) {
        this.jCheckBoxShowAll.setVisible(false);
        this.primaryCategoryList = categories;
        this.secondaryCategoryList = null;
        this.changeListedCategories(false);
    }

    public List<Category> getCategories() {
        return this.selectedCategories;
    }

    public void setSelectedCategories(List<Category> categories) {
        this.selectedCategories = categories;
        this.updateListSelectionToMatchSelectedCategories();
        this.updateSelectedCategoryDisplay();
    }

    public void setCategories(List<Category> shortList, List<Category> fullList) {
        this.jCheckBoxShowAll.setVisible(true);
        this.primaryCategoryList = shortList;
        this.secondaryCategoryList = fullList;
        this.changeListedCategories(false);
    }

    private void listValueChanged(ListSelectionEvent e) {
        if (!this.listChanging) {
            this.updateSelectedCategoryList(e.getFirstIndex(), e.getLastIndex());
            this.updateSelectedCategoryDisplay();
        }
    }

    private void updateSelectedCategoryList(int fromIndex, int toIndex) {
        for (int i = fromIndex; i <= toIndex; ++i) {
            Category c = this.jListCategories.getModel().getElementAt(i);
            if (this.jListCategories.isSelectedIndex(i) && !this.selectedCategories.contains(c)) {
                this.selectedCategories.add(c);
                continue;
            }
            if (this.jListCategories.isSelectedIndex(i) || !this.selectedCategories.contains(c)) continue;
            this.selectedCategories.remove(c);
        }
    }

    private void updateSelectedCategoryDisplay() {
        StringBuilder sb = new StringBuilder();
        if (!this.selectedCategories.isEmpty()) {
            sb.append(this.selectedCategories.get(0).getMnemonic());
            for (int i = 1; i < this.selectedCategories.size(); ++i) {
                sb.append(", ").append(this.selectedCategories.get(i).getMnemonic());
            }
        }
        this.jTextFieldSelectedCategories.setText(sb.toString());
    }

    private void changeListedCategories(boolean useSecondaryCategoriesList) {
        if (useSecondaryCategoriesList && this.secondaryCategoryList == null) {
            return;
        }
        this.listChanging = true;
        List<Category> listToUse = !useSecondaryCategoriesList ? this.primaryCategoryList : this.secondaryCategoryList;
        this.jListCategories.setListData((Category[])listToUse.toArray(new Category[listToUse.size()]));
        this.jListCategories.getSelectionModel().setAnchorSelectionIndex(-1);
        this.jListCategories.getSelectionModel().setLeadSelectionIndex(-1);
        this.jListCategories.clearSelection();
        this.updateListSelectionToMatchSelectedCategories();
        this.listChanging = false;
    }

    private void updateListSelectionToMatchSelectedCategories() {
        if (!this.selectedCategories.isEmpty()) {
            int[] toSelect = new int[this.jListCategories.getModel().getSize()];
            int nextSelectIndex = 0;
            for (int i = 0; i < this.jListCategories.getModel().getSize(); ++i) {
                if (!this.selectedCategories.contains(this.jListCategories.getModel().getElementAt(i))) continue;
                toSelect[nextSelectIndex] = i;
                ++nextSelectIndex;
            }
            this.jListCategories.setSelectedIndices(Arrays.copyOfRange(toSelect, 0, nextSelectIndex));
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListCategories = new JList();
        this.jLabelSelected = new JLabel();
        this.jTextFieldSelectedCategories = new JTextField();
        this.jButtonSort = new JButton();
        this.jPanelShowAll = new JPanel();
        this.jCheckBoxShowAll = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jButton1.setText("jButton1");
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategorySelect this$0;
            {
                DialogCategorySelect dialogCategorySelect = this$0;
                Objects.requireNonNull(dialogCategorySelect);
                this.this$0 = dialogCategorySelect;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategorySelect this$0;
            {
                DialogCategorySelect dialogCategorySelect = this$0;
                Objects.requireNonNull(dialogCategorySelect);
                this.this$0 = dialogCategorySelect;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOkActionPerformed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListCategories);
        this.jLabelSelected.setText("Selected:");
        this.jTextFieldSelectedCategories.setEditable(false);
        this.jTextFieldSelectedCategories.setBackground(new Color(255, 255, 255));
        this.jButtonSort.setText("Order");
        this.jButtonSort.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCategorySelect this$0;
            {
                DialogCategorySelect dialogCategorySelect = this$0;
                Objects.requireNonNull(dialogCategorySelect);
                this.this$0 = dialogCategorySelect;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSortActionPerformed(evt);
            }
        });
        this.jPanelShowAll.setLayout(new BoxLayout(this.jPanelShowAll, 2));
        this.jCheckBoxShowAll.setText("Show all ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 79, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSelectedCategories).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSort, -2, 60, -2)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addGap(0, 0, 0).addComponent(this.jPanelShowAll, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxShowAll).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxShowAll).addComponent(this.jPanelShowAll, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 185, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSort).addComponent(this.jTextFieldSelectedCategories, -2, -1, -2).addComponent(this.jLabelSelected, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOk)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.setOK();
    }

    private void jButtonSortActionPerformed(ActionEvent evt) {
        DialogCategoryOrder orderDialog = new DialogCategoryOrder(this.myParent, true);
        orderDialog.setCategories(this.selectedCategories);
        orderDialog.setLocationRelativeTo((Component)((Object)this));
        orderDialog.setVisible(true);
        if (orderDialog.isOK()) {
            this.selectedCategories = orderDialog.getCategories();
            this.updateSelectedCategoryDisplay();
        }
    }
}

