/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties.taxon;

import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbugs.chart.properties.taxon.PanelTaxonGroupDisplay;
import jsbugs.chart.properties.taxon.PanelTaxonGroupDisplaySelectionListener;
import jsbugs.chart.properties.taxon.PanelTaxonGroupPropertiesRenderer;
import jsbugs.chart.properties.taxon.PanelTaxonPropertiesPanel;

class JTreePTG
extends JTree
implements PanelTaxonGroupDisplay {
    private static final Logger LOGGER = Logger.getLogger(JTreePTG.class.getName());
    private final PanelTaxonPropertiesPanel parentComponent;
    private boolean isSettingList;

    JTreePTG(PanelTaxonPropertiesPanel parentComponent) {
        super(new DefaultMutableTreeNode("No tree nodes yet"));
        this.parentComponent = parentComponent;
        this.init();
    }

    private void init() {
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new PanelTaxonGroupPropertiesRenderer(this.parentComponent));
    }

    @Override
    public void clearData() {
        this.setModel(null);
    }

    @Override
    public void initData() {
        this.isSettingList = true;
        this.setModel(new DefaultTreeModel(JTreePTG.createNodes(this.parentComponent.getPanelProperties())));
        this.isSettingList = false;
    }

    private static TreeNode createNodes(PanelTaxonGroupProperties root) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(root, true);
        for (PanelTaxonOcc occ : root.getInnerPanels()) {
            rootNode.add(new DefaultMutableTreeNode(occ, false));
        }
        return rootNode;
    }

    @Override
    public boolean isInitialising() {
        return this.isSettingList;
    }

    @Override
    public void addSelectionListener(final PanelTaxonGroupDisplaySelectionListener listener) {
        this.addTreeSelectionListener(new TreeSelectionListener(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                listener.valueChanged();
            }
        });
    }

    @Override
    public void setSelectedAtLocationOfEvent(MouseEvent evt) {
        int row = this.getRowForLocation(evt.getX(), evt.getY());
        this.setSelectionRow(row);
    }

    @Override
    public PanelTaxonOcc getSelection() {
        Object obj;
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        Object node = selectionPath.getLastPathComponent();
        if (node instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)node).getUserObject()) instanceof PanelTaxonOcc) {
            return (PanelTaxonOcc)obj;
        }
        return null;
    }

    @Override
    public void setSelection(PanelTaxonOcc toSelect) {
        if (toSelect == null) {
            this.setSelectionPath(null);
            return;
        }
        Object root = this.getModel().getRoot();
        int nLeaves = this.getModel().getChildCount(root);
        for (int i = 0; i < nLeaves; ++i) {
            PanelTaxonOcc occ = (PanelTaxonOcc)((DefaultMutableTreeNode)this.getModel().getChild(root, i)).getUserObject();
            if (occ != toSelect && !occ.wasCopiedFrom(toSelect) && !toSelect.wasCopiedFrom(occ)) continue;
            this.setSelectionRow(i + 1);
            return;
        }
        this.setSelectionPath(null);
    }

    @Override
    public void setSelectedValue(Object anObject) {
        if (anObject instanceof PanelTaxonOcc) {
            this.setSelection((PanelTaxonOcc)anObject);
        }
    }
}

