/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.depthage;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import jsbugs.uiutil.DecimalCellEditor;
import jsbugs.uiutil.TextFieldUtils;
import util.AgeFormat;
import util.DepthUnits;
import util.DepthUtils;

public class DepthAgeTextFieldBuilder {
    public static final double NODE_AGE_MAX_MA = 4600.0;
    public static final long NODE_AGE_MAX_KA = 4600000L;
    public static final int NODE_AGE_PRECISION_MA = 3;
    public static final double NODE_DEPTH_MAX = 99999.0;
    public static final int NODE_DEPTH_M_PRECISION = 3;
    public static final int NODE_DEPTH_F_PRECISION = 2;

    public static JTextField BuildNodeAgeTextField(AgeFormat af) {
        if (af == AgeFormat.KA) {
            return TextFieldUtils.buildIntegerOnlyTextField(false, 4600000L);
        }
        return TextFieldUtils.buildDecimalOnlyTextField(false, 4600.0, 3);
    }

    public static void UpdateTextFieldToNodeAgeField(JTextField field, AgeFormat af) {
        if (af == AgeFormat.KA) {
            TextFieldUtils.updateTextFieldToIntegerOnly(field, false, 4600000L);
        } else {
            TextFieldUtils.updateTextFieldToDecimalOnly(field, false, 4600.0, 3);
        }
    }

    public static DefaultCellEditor BuildNodeAgeCellEditor(AgeFormat af) {
        JTextField tf = DepthAgeTextFieldBuilder.BuildNodeAgeTextField(af);
        tf.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        tf.setHorizontalAlignment(10);
        int precision = 0;
        if (af == AgeFormat.MA) {
            precision = 3;
        }
        return new DecimalCellEditor(tf, precision);
    }

    public static void UpdateTextFieldToNodeDepthField(JTextField field, char units) {
        TextFieldUtils.updateTextFieldToDecimalOnly(field, false, DepthUtils.convFromM((double)99999.0, (char)units), DepthAgeTextFieldBuilder.getDepthPrecision(units));
    }

    public static JTextField BuildNodeDepthTextField(char units) {
        return TextFieldUtils.buildDecimalOnlyTextField(false, DepthUtils.convFromM((double)99999.0, (char)units), DepthAgeTextFieldBuilder.getDepthPrecision(units));
    }

    public static DefaultCellEditor BuildNodeDepthCellEditor(char units) {
        JTextField tf = DepthAgeTextFieldBuilder.BuildNodeDepthTextField(units);
        tf.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        tf.setHorizontalAlignment(10);
        return new DecimalCellEditor(tf, DepthAgeTextFieldBuilder.getDepthPrecision(units));
    }

    private static int getDepthPrecision(char units) {
        int precision = 3;
        if (DepthUnits.getUnits((char)units) == DepthUnits.F) {
            precision = 2;
        }
        return precision;
    }
}

