/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.depthage;

import com.stratadata.model3.wellinterp.LOCNode;
import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import jsbugs.depthage.JPanelCompositeStandardSelect;
import jsbugs.depthage.JPanelSnapRange;
import jsbugs.depthage.LOCNodeShiftRequest;
import jsbugs.depthage.SnapNodeToEventHelper;
import jsbugs.depthage.SnapToEventTableRow;
import jsbugs.table.AlignedHeaderRenderer;
import jsbugs.table.PaddingCellRenderer;
import jsbugs.util.UserPrefsHelper;
import model3.CompositeStandard;
import model3.SBdb;
import model3.WellInterp;
import util.AgeFormat;
import util.DepthUnits;
import util.SB;

public class DialogSnapSingleNodeToEvent
extends SBDialog {
    private final AgeFormat ageFormat;
    private final char units;
    private final SBdb db;
    private final UserPrefsHelper prefs;
    private final WellInterp wellInterp;
    private final LOCNode node;
    private final SnapToSingleEventTableModel tableModel;
    private LOCNodeShiftRequest shiftRequest = null;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JCheckBox jCheckBoxHideExactMatches;
    private JLabel jLabelNodesTable;
    private JLabel jLabelSummary;
    private JLabel jLabelTop;
    private JPanel jPanel1;
    private JPanelCompositeStandardSelect jPanelCompositeStandardSelect1;
    private JPanelSnapRange jPanelSnapRange1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public DialogSnapSingleNodeToEvent(Frame parent, boolean modal, char units, AgeFormat ageFormat, SBdb sbdb, WellInterp wellInterp, LOCNode node) {
        super(parent, modal);
        this.initComponents();
        this.ageFormat = ageFormat;
        this.db = sbdb;
        this.prefs = new UserPrefsHelper(sbdb);
        this.wellInterp = wellInterp;
        this.node = node;
        this.units = units;
        this.tableModel = new SnapToSingleEventTableModel(this);
        this.jTable1.setModel(this.tableModel);
        SB.setTableHeaderBold((JTable)this.jTable1);
        this.jPanelSnapRange1.setupPanel(this.prefs, units, ageFormat);
        this.jPanelCompositeStandardSelect1.populateSelect(this.db);
        this.setSelectedCompositeStandardById(this.prefs.getLastCompositeStandardIDSelected());
        this.setTopLabelText();
        this.jTable1.setDefaultRenderer(String.class, new PaddingCellRenderer());
        this.jTable1.getTableHeader().setDefaultRenderer(new AlignedHeaderRenderer(0, this.jTable1.getTableHeader().getDefaultRenderer()));
        this.updateTable();
        this.jPanelCompositeStandardSelect1.addSelectActionListener(new ActionListener(this){
            final /* synthetic */ DialogSnapSingleNodeToEvent this$0;
            {
                DialogSnapSingleNodeToEvent dialogSnapSingleNodeToEvent = this$0;
                Objects.requireNonNull(dialogSnapSingleNodeToEvent);
                this.this$0 = dialogSnapSingleNodeToEvent;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.updateTable();
            }
        });
        this.jPanelSnapRange1.addPropertyChangeListener(new PropertyChangeListener(this){
            final /* synthetic */ DialogSnapSingleNodeToEvent this$0;
            {
                DialogSnapSingleNodeToEvent dialogSnapSingleNodeToEvent = this$0;
                Objects.requireNonNull(dialogSnapSingleNodeToEvent);
                this.this$0 = dialogSnapSingleNodeToEvent;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("age range")) {
                    this.this$0.updateTable();
                } else if (evt.getPropertyName().equals("depth range")) {
                    this.this$0.updateTable();
                }
            }
        });
    }

    public void setSelectedCompositeStandardById(Integer id) {
        this.jPanelCompositeStandardSelect1.selectCompositeStandardById(id);
    }

    private void setTopLabelText() {
        NumberFormat ageNumberFormat = NumberFormat.getInstance();
        ageNumberFormat.setMaximumFractionDigits(this.ageFormat.getPrecision());
        this.jLabelTop.setText(String.format("Snap the selected node at %s, %s %s to an event", this.getNodeDepthString(), ageNumberFormat.format(this.node.getAge()), this.ageFormat.getDescr()));
    }

    private String getNodeDepthString() {
        NumberFormat depthNumberFormat = NumberFormat.getInstance();
        depthNumberFormat.setMaximumFractionDigits(3);
        return depthNumberFormat.format(this.node.getDepth()) + " " + DepthUnits.getUnits((char)this.units).getAbr();
    }

    private void updateTable() {
        CompositeStandard cs = this.jPanelCompositeStandardSelect1.getSelectedCompositeStandard();
        ArrayList<LOCNode> nodes = new ArrayList<LOCNode>();
        nodes.add(this.node);
        this.tableModel.rows = SnapNodeToEventHelper.buldRowsList(this.units, this.ageFormat, cs, this.wellInterp, this.jPanelSnapRange1.getDepthRange(), this.jPanelSnapRange1.getAgeRange(), nodes, this.jCheckBoxHideExactMatches.isSelected());
        this.tableModel.fireTableDataChanged();
        this.jLabelSummary.setText(String.format("Current interpretation has %s matching events.", SnapNodeToEventHelper.findNumberOfMatchingEvents(cs, this.wellInterp)));
    }

    public LOCNodeShiftRequest getNodeShiftRequest() {
        return this.shiftRequest;
    }

    private void initComponents() {
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelTop = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabelNodesTable = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanelCompositeStandardSelect1 = new JPanelCompositeStandardSelect();
        this.jPanelSnapRange1 = new JPanelSnapRange();
        this.jLabelSummary = new JLabel();
        this.jCheckBoxHideExactMatches = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Snap to Event");
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSnapSingleNodeToEvent this$0;
            {
                DialogSnapSingleNodeToEvent dialogSnapSingleNodeToEvent = this$0;
                Objects.requireNonNull(dialogSnapSingleNodeToEvent);
                this.this$0 = dialogSnapSingleNodeToEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSnapSingleNodeToEvent this$0;
            {
                DialogSnapSingleNodeToEvent dialogSnapSingleNodeToEvent = this$0;
                Objects.requireNonNull(dialogSnapSingleNodeToEvent);
                this.this$0 = dialogSnapSingleNodeToEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabelTop.setText("Snap the selected node to the events of a Composite Standard.");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jTable1.setRowHeight(20);
        this.jTable1.setSelectionMode(0);
        this.jTable1.getTableHeader().setResizingAllowed(false);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabelNodesTable.setText("Select event to snap to:");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, -10, 0, 0));
        this.jPanel1.setLayout(new FlowLayout(0, 10, 0));
        this.jPanel1.add(this.jPanelCompositeStandardSelect1);
        this.jPanel1.add(this.jPanelSnapRange1);
        this.jLabelSummary.setText("Selected standard has 0 matching events");
        this.jCheckBoxHideExactMatches.setText("Hide exact matches");
        this.jCheckBoxHideExactMatches.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSnapSingleNodeToEvent this$0;
            {
                DialogSnapSingleNodeToEvent dialogSnapSingleNodeToEvent = this$0;
                Objects.requireNonNull(dialogSnapSingleNodeToEvent);
                this.this$0 = dialogSnapSingleNodeToEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxHideExactMatchesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jCheckBoxHideExactMatches).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addGap(7, 7, 7)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 658, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTop).addComponent(this.jLabelNodesTable).addComponent(this.jLabelSummary)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSummary).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelNodesTable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOk).addComponent(this.jCheckBoxHideExactMatches)).addContainerGap()));
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.prefs.setLastCompositeStandardIDSelected(this.jPanelCompositeStandardSelect1.getSelectedCompositeStandard().getID());
        this.prefs.setLastNodeSnapAgeRange(this.jPanelSnapRange1.getAgeRange());
        this.prefs.setLastNodeSnapDepthRange(this.jPanelSnapRange1.getDepthRange());
        if (this.jTable1.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No events selected from the table to snap to.", "No events selected", 2);
            return;
        }
        int selectedRow = this.jTable1.getSelectedRow();
        this.shiftRequest = this.tableModel.rows.get(this.jTable1.convertRowIndexToModel(selectedRow)).buildShiftRequest();
        this.setIsOK(true);
        this.setVisible(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jCheckBoxHideExactMatchesActionPerformed(ActionEvent evt) {
        this.updateTable();
    }

    private class SnapToSingleEventTableModel
    extends AbstractTableModel {
        String[] headers;
        public static final int COL_SNAP_EVENT = 0;
        public static final int COL_EVENT_DEPTH = 1;
        public static final int COL_EVENT_AGE = 2;
        List<SnapToEventTableRow> rows;
        final /* synthetic */ DialogSnapSingleNodeToEvent this$0;

        private SnapToSingleEventTableModel(DialogSnapSingleNodeToEvent dialogSnapSingleNodeToEvent) {
            DialogSnapSingleNodeToEvent dialogSnapSingleNodeToEvent2 = dialogSnapSingleNodeToEvent;
            Objects.requireNonNull(dialogSnapSingleNodeToEvent2);
            this.this$0 = dialogSnapSingleNodeToEvent2;
            this.headers = new String[]{"Event", "Event Depth", "Event Age"};
            this.rows = new ArrayList<SnapToEventTableRow>();
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return this.headers.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.rows.size() || columnIndex >= this.headers.length) {
                return null;
            }
            SnapToEventTableRow row = this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.getEventString();
                }
                case 1: {
                    return row.getEventDepthWithDiff();
                }
                case 2: {
                    return row.getEventAgeWithDiff();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            return this.headers[column];
        }
    }
}

