/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.depthage;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.depthage.JPanelCompositeStandardSelect;
import jsbugs.depthage.JPanelSnapRange;
import jsbugs.depthage.LOCNodeShiftRequest;
import jsbugs.depthage.SnapNodeToEventHelper;
import jsbugs.depthage.SnapToEventTableRow;
import jsbugs.table.AlignedHeaderRenderer;
import jsbugs.table.DecimalRenderer;
import jsbugs.table.PaddingCellRenderer;
import jsbugs.util.UserPrefsHelper;
import model3.CompositeStandard;
import model3.LOC;
import model3.SBdb;
import model3.WellInterp;
import util.AgeFormat;
import util.SB;

public class DialogSnapToEvent
extends SBDialog {
    private final AgeFormat ageFormat;
    private final char units;
    private final SBdb db;
    private final UserPrefsHelper prefs;
    private final WellInterp wellInterp;
    private final LOC loc;
    private final SnapToEventTableModel tableModel;
    private List<LOCNodeShiftRequest> shiftRequests = null;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JCheckBox jCheckBoxHideExactMatches;
    private JLabel jLabel6;
    private JLabel jLabelNodesTable;
    private JLabel jLabelSummary;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JPanelCompositeStandardSelect jPanelCompositeStandardSelect1;
    private JPanelSnapRange jPanelSnapRange1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public DialogSnapToEvent(Frame parent, boolean modal, char units, AgeFormat ageFormat, SBdb sbdb, WellInterp wellInterp, LOC loc) {
        super(parent, modal);
        this.initComponents();
        this.ageFormat = ageFormat;
        this.db = sbdb;
        this.prefs = new UserPrefsHelper(sbdb);
        this.wellInterp = wellInterp;
        this.loc = loc;
        this.units = units;
        this.tableModel = new SnapToEventTableModel(this);
        this.jTable1.setModel(this.tableModel);
        this.jPanelSnapRange1.setupPanel(this.prefs, units, ageFormat);
        SB.setTableHeaderBold((JTable)this.jTable1);
        TableColumnModel columns = this.jTable1.getColumnModel();
        DecimalRenderer depthRenderer = new DecimalRenderer(false, "0.00");
        depthRenderer.setHorizontalAlignment(4);
        columns.getColumn(0).setCellRenderer(depthRenderer);
        DecimalRenderer ageRenderer = ageFormat == AgeFormat.MA ? new DecimalRenderer(false, "0.000") : new DecimalRenderer(false, "0");
        ageRenderer.setHorizontalAlignment(4);
        columns.getColumn(1).setCellRenderer(ageRenderer);
        this.jTable1.setDefaultRenderer(String.class, new PaddingCellRenderer());
        this.jTable1.getTableHeader().setDefaultRenderer(new AlignedHeaderRenderer(0, this.jTable1.getTableHeader().getDefaultRenderer()));
        this.jPanelCompositeStandardSelect1.populateSelect(this.db);
        this.jPanelCompositeStandardSelect1.selectCompositeStandardById(this.prefs.getLastCompositeStandardIDSelected());
        this.updateTable();
        this.jPanelCompositeStandardSelect1.addSelectActionListener(new ActionListener(this){
            final /* synthetic */ DialogSnapToEvent this$0;
            {
                DialogSnapToEvent dialogSnapToEvent = this$0;
                Objects.requireNonNull(dialogSnapToEvent);
                this.this$0 = dialogSnapToEvent;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.updateTable();
            }
        });
        this.jPanelSnapRange1.addPropertyChangeListener(new PropertyChangeListener(this){
            final /* synthetic */ DialogSnapToEvent this$0;
            {
                DialogSnapToEvent dialogSnapToEvent = this$0;
                Objects.requireNonNull(dialogSnapToEvent);
                this.this$0 = dialogSnapToEvent;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("age range")) {
                    this.this$0.updateTable();
                } else if (evt.getPropertyName().equals("depth range")) {
                    this.this$0.updateTable();
                }
            }
        });
    }

    private void updateTable() {
        CompositeStandard cs = this.jPanelCompositeStandardSelect1.getSelectedCompositeStandard();
        this.tableModel.rows = SnapNodeToEventHelper.buldRowsList(this.units, this.ageFormat, cs, this.wellInterp, this.jPanelSnapRange1.getDepthRange(), this.jPanelSnapRange1.getAgeRange(), this.loc.getNodes(), this.jCheckBoxHideExactMatches.isSelected());
        this.tableModel.fireTableDataChanged();
        this.jLabelSummary.setText(String.format("Current interpretation has %s matching events.", SnapNodeToEventHelper.findNumberOfMatchingEvents(cs, this.wellInterp)));
    }

    public List<LOCNodeShiftRequest> getNodeShiftRequests() {
        return this.shiftRequests;
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel6 = new JLabel();
        this.jLabelSummary = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabelNodesTable = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanelCompositeStandardSelect1 = new JPanelCompositeStandardSelect();
        this.jPanelSnapRange1 = new JPanelSnapRange();
        this.jCheckBoxHideExactMatches = new JCheckBox();
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setDefaultCloseOperation(2);
        this.setTitle("Snap to Event");
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSnapToEvent this$0;
            {
                DialogSnapToEvent dialogSnapToEvent = this$0;
                Objects.requireNonNull(dialogSnapToEvent);
                this.this$0 = dialogSnapToEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSnapToEvent this$0;
            {
                DialogSnapToEvent dialogSnapToEvent = this$0;
                Objects.requireNonNull(dialogSnapToEvent);
                this.this$0 = dialogSnapToEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Snap the selected nodes to the events of a Composite Standard.");
        this.jLabelSummary.setText("Selected standard has 0 matching events");
        this.jLabelSummary.setVerticalAlignment(1);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jTable1.setRowHeight(20);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabelNodesTable.setText("Select nodes to snap:");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, -10, 0, 0));
        this.jPanel1.setLayout(new FlowLayout(0, 10, 0));
        this.jPanelCompositeStandardSelect1.setMinimumSize(new Dimension(100, 20));
        this.jPanel1.add(this.jPanelCompositeStandardSelect1);
        this.jPanel1.add(this.jPanelSnapRange1);
        this.jCheckBoxHideExactMatches.setSelected(true);
        this.jCheckBoxHideExactMatches.setText("Hide exact matches");
        this.jCheckBoxHideExactMatches.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSnapToEvent this$0;
            {
                DialogSnapToEvent dialogSnapToEvent = this$0;
                Objects.requireNonNull(dialogSnapToEvent);
                this.this$0 = dialogSnapToEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxHideExactMatchesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSummary).addComponent(this.jLabelNodesTable)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxHideExactMatches).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, 657, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSummary).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelNodesTable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 122, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOk).addComponent(this.jCheckBoxHideExactMatches)).addContainerGap()));
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.prefs.setLastCompositeStandardIDSelected(this.jPanelCompositeStandardSelect1.getSelectedCompositeStandard().getID());
        this.prefs.setLastNodeSnapAgeRange(this.jPanelSnapRange1.getAgeRange());
        this.prefs.setLastNodeSnapDepthRange(this.jPanelSnapRange1.getDepthRange());
        this.shiftRequests = new ArrayList<LOCNodeShiftRequest>();
        if (this.jTable1.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No nodes selected from the table to snap.", "No nodes selected", 2);
            return;
        }
        for (int selectedRow : this.jTable1.getSelectedRows()) {
            SnapToEventTableRow row = this.tableModel.rows.get(this.jTable1.convertRowIndexToModel(selectedRow));
            this.shiftRequests.add(row.buildShiftRequest());
        }
        this.setIsOK(true);
        this.setVisible(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jCheckBoxHideExactMatchesActionPerformed(ActionEvent evt) {
        this.updateTable();
    }

    private class SnapToEventTableModel
    extends AbstractTableModel {
        String[] headers;
        public static final int COL_DEPTH = 0;
        public static final int COL_AGE = 1;
        public static final int COL_BOUNDARY = 2;
        public static final int COL_SNAP_EVENT = 3;
        public static final int COL_EVENT_DEPTH = 4;
        public static final int COL_NEW_AGE = 5;
        List<SnapToEventTableRow> rows;
        final /* synthetic */ DialogSnapToEvent this$0;

        private SnapToEventTableModel(DialogSnapToEvent dialogSnapToEvent) {
            DialogSnapToEvent dialogSnapToEvent2 = dialogSnapToEvent;
            Objects.requireNonNull(dialogSnapToEvent2);
            this.this$0 = dialogSnapToEvent2;
            this.headers = new String[]{"Depth", "Age", "Style", "Snapping Event", "Event Depth", "Event Age"};
            this.rows = new ArrayList<SnapToEventTableRow>();
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return this.headers.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.rows.size() || columnIndex >= this.headers.length) {
                return null;
            }
            SnapToEventTableRow row = this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.getNodeDepth();
                }
                case 1: {
                    return row.getNodeAge();
                }
                case 2: {
                    return row.getBoundaryString();
                }
                case 3: {
                    return row.getEventString();
                }
                case 4: {
                    return row.getEventDepthWithDiff();
                }
                case 5: {
                    return row.getEventAgeWithDiff();
                }
            }
            return null;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: 
                case 1: {
                    return Double.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return this.headers[column];
        }
    }
}

