/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.depthage;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jsbugs.depthage.DepthAgeEventDetails;
import jsbugs.depthage.LOCNodeShiftRequest;
import model3.IGDIntervalZone;
import util.AgeFormat;
import util.DepthUnits;
import util.DepthUtils;

public class SnapToEventTableRow {
    public static final int NODE_AGE_PRECISION_MA = 3;
    public static final int NODE_AGE_PRECISION_KA = 0;
    private final char units;
    private final AgeFormat ageFormat;
    private final double depth;
    private final double age;
    private final int boundary;
    private final DepthAgeEventDetails event;

    public SnapToEventTableRow(char units, AgeFormat ageFormat, double depth, double age, int boundary, DepthAgeEventDetails event) {
        this.units = units;
        this.ageFormat = ageFormat;
        this.depth = depth;
        this.age = age;
        this.boundary = boundary;
        this.event = event;
    }

    public String getBoundaryString() {
        return IGDIntervalZone.getBoundary(this.boundary);
    }

    public String getNodeDepth() {
        double nodeDepth = DepthUtils.convFromM((double)this.depth, (char)this.units, (char)'W');
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(2);
        return nf.format(nodeDepth);
    }

    public String getNodeAge() {
        double nodeAge = this.age * this.ageFormat.getMultiplyer();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(this.getNodeAgePrecision());
        return nf.format(nodeAge);
    }

    public String getEventString() {
        return this.event.getNameAndTypeString();
    }

    public String getEventAgeWithDiff() {
        DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance();
        nf.setMaximumFractionDigits(this.getNodeAgePrecision());
        Object result = nf.format(this.event.getAge() * this.ageFormat.getMultiplyer());
        nf.setPositivePrefix("+");
        nf.setNegativePrefix("-");
        Object diff = "";
        double min = Math.pow(0.1, this.getNodeAgePrecision());
        diff = Math.abs(this.age - this.event.getAge()) >= min ? " (" + nf.format((this.event.getAge() - this.age) * this.ageFormat.getMultiplyer()) + ")" : " (+0)";
        result = (String)result + (String)diff;
        result = (String)result + " " + this.ageFormat.getDescr();
        return result;
    }

    public String getEventDepthWithDiff() {
        DepthUnits du = DepthUnits.getUnits((char)this.units);
        DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance();
        nf.setMaximumFractionDigits(3);
        Object result = nf.format(DepthUtils.convFromM((double)this.event.getDepth(), (char)this.units));
        nf.setPositivePrefix("+");
        nf.setNegativePrefix("-");
        Object diff = "";
        diff = Math.abs(this.depth - this.event.getDepth()) >= Math.pow(0.1, 3.0) ? " (" + nf.format(DepthUtils.convFromM((double)(this.event.getDepth() - this.depth), (char)this.units)) + ")" : " (+0)";
        result = (String)result + (String)diff;
        result = (String)result + " " + du.getAbr();
        return result;
    }

    public LOCNodeShiftRequest buildShiftRequest() {
        return new LOCNodeShiftRequest(this.depth, this.age, this.boundary, this.event.getAge(), this.event.getDepth());
    }

    private int getNodeAgePrecision() {
        if (this.ageFormat == AgeFormat.MA) {
            return 3;
        }
        return 0;
    }
}

