/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.image;

import com.stratadata.model3.image.EditableImageSet;
import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageSet;
import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Lastval;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.layout.GroupLayout;

public class DialogImageSet
extends SBDialog
implements ClipboardOwner {
    private static final Logger LOGGER = Logger.getLogger(DialogImageSet.class.getName());
    static final int CAPTION_LEN = 255;
    private final SBdb sbdb;
    private final EditableImageSet imageSet;
    private final ImageRecordService imageRecordService;
    private int currentImageNumber = -1;
    private final boolean allowEdit;
    boolean imagesDeleted = false;
    private int imageSetID;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonCancel;
    private JButton jButtonDeleteImage;
    private JButton jButtonNext;
    private JButton jButtonOK;
    private JButton jButtonPasteImage;
    private JButton jButtonPath;
    private JButton jButtonPrevious;
    private JButton jButtonSelectImage;
    private JLabel jLabelImage;
    private JLabel jLabelImageID;
    private JLabel jLabelNimages;
    private JMenuItem jMenuItemCopyImage;
    private JMenuItem jMenuItemPasteImage;
    private JMenuItem jMenuItemSelectImage;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenuImageContext;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaCaption;
    private JTextField jTextFieldPicPath;

    public DialogImageSet(JDialog parent, boolean modal, SBdb sbdb, ImageSet imageSet, boolean allowEdit, int imageIndex) {
        super((Window)parent, modal);
        this.sbdb = sbdb;
        this.imageRecordService = sbdb.getImageRecordService();
        this.imageSet = imageSet != null ? new EditableImageSet(imageSet, this.imageRecordService, sbdb.getImageLoader()) : new EditableImageSet(sbdb.getImageLoader());
        this.allowEdit = allowEdit && sbdb.isConnected();
        this.initComponents();
        this.init(imageIndex);
    }

    public DialogImageSet(Window parent, boolean modal, SBdb sbdb, ImageSet imageSet, boolean allowEdit) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.imageRecordService = sbdb.getImageRecordService();
        this.imageSet = imageSet != null ? new EditableImageSet(imageSet, this.imageRecordService, sbdb.getImageLoader()) : new EditableImageSet(sbdb.getImageLoader());
        this.allowEdit = allowEdit && sbdb.isConnected();
        this.initComponents();
        this.init(0);
    }

    private void init(int imageIndex) {
        this.initPreferences();
        this.initClipboardShortcuts();
        if (this.imageSet.getSize() > 0) {
            this.setCurrentImageIndex(imageIndex);
        } else {
            this.refreshImageDisplay();
            this.refreshComponentDisplay();
        }
        if (!this.allowEdit) {
            this.setTitle("Image Set : View");
        } else if (this.imageSet.getImageSetID() == 0) {
            this.setTitle("Image Set : Add");
        } else {
            this.setTitle("Image Set : Edit");
        }
        if (!this.allowEdit) {
            this.jButtonSelectImage.setEnabled(false);
            this.jButtonPasteImage.setEnabled(false);
            this.jButtonDeleteImage.setEnabled(false);
            this.jTextAreaCaption.setEnabled(false);
            this.jMenuItemSelectImage.setEnabled(false);
            this.jButtonOK.setEnabled(false);
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
        this.jLabelImage.grabFocus();
    }

    private void initPreferences() {
        if (this.sbdb.isConnected()) {
            try {
                int dialogWidth = Lastval.getInt(this.sbdb, "DIS-W");
                int dialogHeight = Lastval.getInt(this.sbdb, "DIS-H");
                if (dialogWidth > this.getMinimumSize().width || dialogHeight > this.getMinimumSize().height) {
                    this.setSize(dialogWidth, dialogHeight);
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error getting preferences", e);
            }
        }
    }

    private void initClipboardShortcuts() {
        this.jButtonPasteImage.setEnabled(this.imagesAreStoredInDB());
        this.jMenuItemPasteImage.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.jLabelImage.getInputMap(2).put(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "paste image");
        this.jLabelImage.getActionMap().put("paste image", new AbstractAction(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.insertImageFromClipboard();
            }
        });
        this.jMenuItemCopyImage.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.jLabelImage.getInputMap(2).put(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "copy image");
        this.jLabelImage.getActionMap().put("copy image", new AbstractAction(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.copyImage();
            }
        });
    }

    private void setCurrentImageIndex(int index) {
        if (this.allowEdit && this.getCurrentImageNumber() > -1) {
            this.imageSet.setCaption(this.getCurrentImageNumber(), this.jTextAreaCaption.getText().trim());
        }
        this.currentImageNumber = index;
        this.refreshImageDisplay();
        this.refreshComponentDisplay();
    }

    private void refreshComponentDisplay() {
        int currentImageNumber = this.getCurrentImageNumber();
        this.jButtonPrevious.setEnabled(currentImageNumber > 0);
        this.jButtonNext.setEnabled(currentImageNumber > -1 && currentImageNumber < this.imageSet.getSize() - 1);
        this.jButtonDeleteImage.setEnabled(currentImageNumber > -1);
        this.setLabelImagesText();
    }

    private void setLabelImagesText() {
        if (this.imageSet.getSize() == 0) {
            this.jLabelNimages.setText("no images");
            return;
        }
        this.jLabelNimages.setText(this.currentImageNumber + 1 + " of " + this.imageSet.getSize());
    }

    private int getCurrentImageNumber() {
        return this.currentImageNumber;
    }

    private File findLastImageDirectory() {
        File setDir;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "WINIMG", "UNXIMG"));
            setDir = setDir.getParent() == null || !setDir.getParentFile().exists() ? new File(".") : new File(setDir.getParent());
        }
        catch (SQLException ex) {
            LOGGER.log(Level.WARNING, "Error getting last image file name", ex);
            setDir = new File(".");
        }
        return setDir;
    }

    public void setVisibleAfterFileSelection() {
        this.insertImageFromFile();
        this.setVisible(true);
    }

    private void insertImageFromFile() {
        File[] files;
        int currentIndex = this.getCurrentImageNumber();
        if (currentIndex == -1) {
            currentIndex = 0;
        }
        if ((files = FileChooserUtils.chooseReadableFiles((Component)((Object)this), (FileNameExtensionFilter)FileChooserUtils.IMAGE_FILTER, (File)this.findLastImageDirectory(), (boolean)true)) != null) {
            String fileName = "";
            for (int nImage = 0; nImage < files.length; ++nImage) {
                fileName = files[nImage].getPath();
                try {
                    File testFile;
                    if (this.sbdb.getImageFolder() != null && (testFile = new File(this.sbdb.getImageFolder() + File.separator + files[nImage].getName())).exists() && testFile.lastModified() == files[nImage].lastModified() && testFile.length() == files[nImage].length()) {
                        fileName = testFile.getPath();
                    }
                }
                catch (SQLException ex) {
                    LOGGER.log(Level.WARNING, "Error getting image folder", ex);
                }
                try {
                    this.imageSet.addImageFromFile(currentIndex++, new File(fileName));
                    continue;
                }
                catch (IOException | RuntimeException ex) {
                    SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
                }
            }
            Lastval.tryPutString(this.sbdb, "WINIMG", "UNXIMG", fileName);
            this.setCurrentImageIndex(currentIndex - 1);
        }
    }

    private void insertImageFromClipboard() {
        if (!this.clipboardHasImage()) {
            return;
        }
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = c.getContents(this);
        if (t != null) {
            try {
                Image i = (Image)t.getTransferData(DataFlavor.imageFlavor);
                int imageIndex = this.getCurrentImageNumber();
                if (imageIndex < 0) {
                    imageIndex = 0;
                }
                this.imageSet.addNewImage(imageIndex, i);
                this.setCurrentImageIndex(imageIndex);
            }
            catch (UnsupportedFlavorException | IOException | RuntimeException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), this.getTitle(), 2);
                LOGGER.log(Level.WARNING, "Error pasting image", e);
            }
        }
    }

    private boolean clipboardHasImage() {
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = c.getContents(this);
        if (t == null) {
            return false;
        }
        return Arrays.asList(t.getTransferDataFlavors()).contains(DataFlavor.imageFlavor);
    }

    private boolean imagesAreStoredInDB() {
        boolean imagesStored = false;
        if (this.sbdb != null && this.sbdb.isConnected()) {
            imagesStored = this.sbdb.storeImage();
        }
        return imagesStored;
    }

    private void toggleImageContext(MouseEvent evt) {
        this.jLabelImage.grabFocus();
        if (evt.isPopupTrigger()) {
            this.jMenuItemPasteImage.setEnabled(this.clipboardHasImage() && this.imagesAreStoredInDB());
            this.jPopupMenuImageContext.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPopupMenuImageContext = new JPopupMenu();
        this.jMenuItemSelectImage = new JMenuItem();
        this.jMenuItemPasteImage = new JMenuItem();
        this.jMenuItemCopyImage = new JMenuItem();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelImage = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaCaption = TextFieldUtils.buildLimitedLengthTextArea(255);
        this.jTextFieldPicPath = new JTextField();
        this.jButtonPath = new JButton();
        this.jPanel1 = new JPanel();
        this.jButtonNext = new JButton();
        this.jButtonPrevious = new JButton();
        this.jLabelNimages = new JLabel();
        this.jButtonDeleteImage = new JButton();
        this.jLabelImageID = new JLabel();
        this.jButtonSelectImage = new JButton();
        this.jButtonPasteImage = new JButton();
        this.jButton1.setText("jButton1");
        this.jButton2.setText("jButton2");
        this.jMenuItemSelectImage.setText("Select Image ...");
        this.jMenuItemSelectImage.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSelectImageActionPerformed(evt);
            }
        });
        this.jPopupMenuImageContext.add(this.jMenuItemSelectImage);
        this.jMenuItemPasteImage.setText("Paste Image ...");
        this.jMenuItemPasteImage.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPasteImageActionPerformed(evt);
            }
        });
        this.jPopupMenuImageContext.add(this.jMenuItemPasteImage);
        this.jMenuItemCopyImage.setText("Copy image");
        this.jMenuItemCopyImage.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCopyImageActionPerformed(evt);
            }
        });
        this.jPopupMenuImageContext.add(this.jMenuItemCopyImage);
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(420, 480));
        this.setModal(true);
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                this.this$0.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabelImage.setBackground(new Color(255, 255, 255));
        this.jLabelImage.setText("jLabel9");
        this.jLabelImage.setBorder(new MatteBorder(null));
        this.jLabelImage.setPreferredSize(new Dimension(360, 160));
        this.jLabelImage.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jLabelImageMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jLabelImageMouseReleased(evt);
            }
        });
        this.jTextAreaCaption.setColumns(20);
        this.jTextAreaCaption.setFont(new Font("Tahoma", 0, 13));
        this.jTextAreaCaption.setLineWrap(true);
        this.jTextAreaCaption.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.jTextAreaCaption);
        this.jTextFieldPicPath.setEditable(false);
        this.jButtonPath.setText("Open location");
        this.jButtonPath.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPathActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonNext.setFont(new Font("Segoe UI", 1, 12));
        this.jButtonNext.setForeground(new Color(51, 102, 204));
        this.jButtonNext.setText("Next >");
        this.jButtonNext.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonNextActionPerformed(evt);
            }
        });
        this.jButtonPrevious.setFont(new Font("Segoe UI", 1, 12));
        this.jButtonPrevious.setForeground(new Color(51, 102, 204));
        this.jButtonPrevious.setText("< Previous");
        this.jButtonPrevious.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jLabelNimages.setFont(new Font("Tahoma", 1, 11));
        this.jLabelNimages.setHorizontalAlignment(0);
        this.jLabelNimages.setText("i of n");
        this.jButtonDeleteImage.setText("Remove");
        this.jButtonDeleteImage.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteImageActionPerformed(evt);
            }
        });
        this.jLabelImageID.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jButtonPrevious).addPreferredGap(0).add((Component)this.jLabelNimages).addPreferredGap(0).add((Component)this.jButtonNext).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabelImageID, -2, 113, -2).addPreferredGap(1).add((Component)this.jButtonDeleteImage).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.jButtonNext, this.jButtonPrevious}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jButtonPrevious).add((Component)this.jButtonNext).add((Component)this.jLabelNimages).add((Component)this.jButtonDeleteImage).add((Component)this.jLabelImageID)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonSelectImage.setText("Select new...");
        this.jButtonSelectImage.setToolTipText("Select an image from file");
        this.jButtonSelectImage.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectImageActionPerformed(evt);
            }
        });
        this.jButtonPasteImage.setText("Paste new...");
        this.jButtonPasteImage.setToolTipText("Paste an image from clipboard");
        this.jButtonPasteImage.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogImageSet this$0;
            {
                DialogImageSet dialogImageSet = this$0;
                Objects.requireNonNull(dialogImageSet);
                this.this$0 = dialogImageSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPasteImageActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldPicPath).addPreferredGap(0).add((Component)this.jButtonPath, -2, 105, -2)).add(2, (Component)this.jScrollPane1).add((Component)this.jLabelImage, -1, 580, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonSelectImage).addPreferredGap(0).add((Component)this.jButtonPasteImage).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -2, 65, -2).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelImage, -1, 362, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 56, -2).add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonPath).add((Component)this.jTextFieldPicPath, -2, -1, -2)).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonSelectImage).add((Component)this.jButtonPasteImage).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonSelectImageActionPerformed(ActionEvent evt) {
        this.insertImageFromFile();
    }

    private void jButtonDeleteImageActionPerformed(ActionEvent evt) {
        int newImageIndex;
        int currentImageNumber = this.getCurrentImageNumber();
        if (currentImageNumber < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No image to delete", this.getTitle(), 2);
            return;
        }
        this.imageSet.removeImage(currentImageNumber);
        this.currentImageNumber = newImageIndex = currentImageNumber < this.imageSet.getSize() ? currentImageNumber : this.imageSet.getSize() - 1;
        this.refreshImageDisplay();
        this.refreshComponentDisplay();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.jLabelImage.getWidth() > this.getWidth()) {
            int width = this.getWidth() - 30;
            int height = this.getHeight() - 200;
            this.jLabelImage.setIcon(null);
            this.jLabelImage.setSize(width, height);
        }
        try {
            this.refreshImageDisplay();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), this.getTitle(), 2);
            e.printStackTrace();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (!this.allowEdit) {
            this.dispose();
        }
        if (this.imageSet.getSize() == 0) {
            if (this.imageSet.getImageSetID() == 0) {
                this.dispose();
            }
            if (JOptionPane.showConfirmDialog((Component)((Object)this), "Delete this image set?", "Delete Image Set", 0) != 0) {
                return;
            }
            this.imageRecordService.deleteImageRecords(this.imageSet.getImageSetID());
            this.imageSetID = 0;
            this.setOK();
            return;
        }
        this.imageSet.setCaption(this.getCurrentImageNumber(), this.jTextAreaCaption.getText().trim());
        try {
            this.imageSetID = this.imageRecordService.storeImageSet(this.imageSet.getImageSetID(), this.imageSet.getImageRecords(), (ImageLoader)this.imageSet);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
            return;
        }
        this.storeDisplayPreferences();
        this.setOK();
    }

    public int getImageSetID() {
        return this.imageSetID;
    }

    private void storeDisplayPreferences() {
        try {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width > this.getMinimumSize().width || height > this.getMinimumSize().height) {
                Lastval.putInt(this.sbdb, "DIS-W", width);
                Lastval.putInt(this.sbdb, "DIS-H", height);
            }
            this.sbdb.commit();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not commit display preferences", e);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCancelActionPerformed(null);
    }

    private void jLabelImageMousePressed(MouseEvent evt) {
        this.toggleImageContext(evt);
    }

    private void jLabelImageMouseReleased(MouseEvent evt) {
        this.toggleImageContext(evt);
    }

    private void jMenuItemSelectImageActionPerformed(ActionEvent evt) {
        this.insertImageFromFile();
    }

    private void jMenuItemPasteImageActionPerformed(ActionEvent evt) {
        this.insertImageFromClipboard();
    }

    private void jButtonPasteImageActionPerformed(ActionEvent evt) {
        if (!this.clipboardHasImage()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No image found on the clipboard.\n", this.getTitle(), 1);
        }
        if (!this.imagesAreStoredInDB()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Can't proceed with paste as the database isn't set to store images. .\n", this.getTitle(), 1);
        }
        this.insertImageFromClipboard();
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        this.setCurrentImageIndex(this.getCurrentImageNumber() + 1);
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        this.setCurrentImageIndex(this.getCurrentImageNumber() - 1);
    }

    private void jMenuItemCopyImageActionPerformed(ActionEvent evt) {
        this.copyImage();
    }

    private void jButtonPathActionPerformed(ActionEvent evt) {
        String picPath = this.jTextFieldPicPath.getText();
        if (!StringUtils.isBlank((CharSequence)picPath)) {
            File file = new File(picPath);
            try {
                if (file.getParentFile() == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "The file specification does not have a folder specified.", this.getTitle(), 1);
                } else if (file.getParentFile().exists()) {
                    Desktop.getDesktop().open(file.getParentFile());
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "This folder does not exist: " + String.valueOf(file.getParentFile()), this.getTitle(), 1);
                }
            }
            catch (IOException | RuntimeException ex) {
                JOptionPane.showMessageDialog((Component)((Object)this), ex.getMessage(), this.getTitle(), 2);
            }
        }
    }

    private void copyImage() {
        ImageRecord currentImageRecord;
        Image icon;
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        int currentImageNumber = this.getCurrentImageNumber();
        if (currentImageNumber > -1 && (icon = this.imageSet.getImage(currentImageRecord = this.imageSet.getImageRecords().get(currentImageNumber))) != null) {
            try {
                TransferableImage trans = new TransferableImage(icon);
                c.setContents(trans, this);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), this.getTitle(), 2);
                LOGGER.log(Level.WARNING, "Error copying to clipboard", e);
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard clip, Transferable trans) {
        System.out.println("Lost Clipboard Ownership");
    }

    private void refreshImageDisplay() {
        int currentImageNumber = this.getCurrentImageNumber();
        if (currentImageNumber > -1) {
            this.jLabelImage.setText(null);
            Rectangle bounds = this.jLabelImage.getBounds();
            ImageRecord currentImageRecord = this.imageSet.getImageRecords().get(currentImageNumber);
            Image image = this.imageSet.getImage(currentImageRecord.imageID(), new Dimension(bounds.width, bounds.height));
            ImageIcon icon = image != null ? new ImageIcon(image) : null;
            this.jLabelImage.setIcon(icon);
            this.jTextAreaCaption.setText(currentImageRecord.caption());
            this.jTextFieldPicPath.setText(currentImageRecord.picPath());
            if (currentImageRecord.imageID() > 0) {
                this.jLabelImageID.setText("(ID: " + currentImageRecord.imageID() + ")");
            } else {
                this.jLabelImageID.setText("");
            }
        } else {
            this.jLabelImage.setIcon(null);
            this.jLabelImage.setText("Select or paste to add an image here");
            this.jLabelImage.setHorizontalAlignment(0);
            this.jLabelImage.setVerticalAlignment(0);
            this.jTextAreaCaption.setText(null);
            this.jTextFieldPicPath.setText(null);
        }
    }

    private static class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }
    }
}

