/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.image;

import com.stratadata.model3.image.ImageSet;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import jsbugs.image.DialogImageSet;
import jsbugs.image.TableModelImageSet;
import model3.SBRestrictable;
import model3.SBdb;

public class DialogImageSetOverview
extends JDialog {
    private TableModelImageSet model;
    private final SBdb sbdb;
    private final boolean allowEdit;
    private JScrollPane jScrollPane1;
    private JTable jTableImageSet;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JButton jButtonAdd;

    public DialogImageSetOverview(Dialog parent, boolean modal, ImageSet imageSet, SBdb sbdb, boolean allowEdit) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.allowEdit = allowEdit && SBRestrictable.canWrite(sbdb);
        this.initComponents();
        this.init(imageSet);
    }

    private void init(ImageSet imageSet) {
        this.setTitle("Image Set : Overview");
        this.model = new TableModelImageSet(this.sbdb.getImageRecordService(), this.sbdb.getImageLoader());
        this.model.setImageSet(imageSet);
        this.jTableImageSet.setModel(this.model);
        this.model.setupTable(this.jTableImageSet);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        if (!this.allowEdit) {
            this.jButtonAdd.setText("View...");
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableImageSet = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonAdd = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 450));
        Container contentPane = this.getContentPane();
        this.jTableImageSet.setModel(new DefaultTableModel());
        this.jTableImageSet.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogImageSetOverview this$0;
            {
                DialogImageSetOverview dialogImageSetOverview = this$0;
                Objects.requireNonNull(dialogImageSetOverview);
                this.this$0 = dialogImageSetOverview;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.this$0.jTableImageSetMouseClicked(e);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableImageSet);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(e -> this.jButtonCloseActionPerformed(e));
        this.jButtonHelp.setText("Help");
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(e -> this.jButtonAddActionPerformed(e));
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup().addComponent(this.jScrollPane1, -1, 441, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        contentPaneLayout.linkSize(0, this.jButtonAdd, this.jButtonClose, this.jButtonHelp);
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE).addGap(14, 14, 14).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonHelp).addComponent(this.jButtonAdd)).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        if (this.jTableImageSet.getCellEditor() != null) {
            this.jTableImageSet.getCellEditor().stopCellEditing();
        }
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogImageSet dialog = new DialogImageSet(this, true, this.sbdb, this.model.getImageSet(), this.allowEdit, this.model.getRowCount() - 1);
        dialog.setLocationRelativeTo(this);
        if (this.allowEdit && this.sbdb.isConnected()) {
            dialog.setVisibleAfterFileSelection();
        } else {
            dialog.setVisible(true);
        }
        if (dialog.isOK()) {
            this.model.fireTableDataChanged();
        }
    }

    private void selectImage(int index) {
        DialogImageSet dialog = new DialogImageSet(this, true, this.sbdb, this.model.getImageSet(), this.allowEdit, index);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.model.fireTableDataChanged();
        }
    }

    private void jTableImageSetMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            int index = this.jTableImageSet.getSelectedRow();
            this.selectImage(index);
        }
    }
}

