/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.image;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageSet;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import util.table.TextAreaRenderer;

public class TableModelImageSet
extends AbstractTableModel {
    private static final Logger LOGGER = Logger.getLogger(TableModelImageSet.class.getName());
    private static final int IMAGE_SIZE = 175;
    private static final String[] COL_TITLES = new String[]{"Number", "Image", "Caption"};
    private static final int[] COL_WIDTHS = new int[]{20, 100, 175};
    private static final int COL_NO = 0;
    private static final int COL_IMAGE = 1;
    private static final int COL_CAPTION = 2;
    private final ImageRecordService imageRecordService;
    private final ImageLoader imageLoader;
    private ImageSet imageSet = null;

    public TableModelImageSet(ImageRecordService imageRecordService, ImageLoader imageLoader) {
        this.imageRecordService = imageRecordService;
        this.imageLoader = imageLoader;
    }

    @Override
    public int getColumnCount() {
        return COL_TITLES.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.imageSet == null) {
            return null;
        }
        try {
            return switch (col) {
                case 0 -> row + 1;
                case 2 -> this.imageSet.getImageRecord(row, this.imageRecordService).caption();
                case 1 -> {
                    ImageRecord imageRecord = this.imageSet.getImageRecord(row, this.imageRecordService);
                    yield new ImageIcon(this.imageSet.getImage(this.imageRecordService, this.imageLoader, imageRecord.imageID(), new Dimension(175, 175)));
                }
                default -> "";
            };
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public Class getColumnClass(int col) {
        return switch (col) {
            case 0 -> Integer.class;
            case 1 -> ImageIcon.class;
            default -> String.class;
        };
    }

    @Override
    public int getRowCount() {
        if (this.imageSet == null) {
            return 0;
        }
        try {
            return this.imageSet.getSize(this.imageRecordService);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't get image set size", ex);
            return 0;
        }
    }

    @Override
    public boolean isCellEditable(int r, int col) {
        return col == 2;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            if (col == 2) {
                ImageRecord imageRecord = this.imageSet.getImageRecord(row, this.imageRecordService);
                String newCaption = obj.toString();
                this.updateCaption(this.imageSet.getImageSetID(), imageRecord.imageID(), newCaption);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error updating caption", e);
        }
    }

    private void updateCaption(int imageSetID, int imageID, String newCaption) {
        if (newCaption.length() > 255) {
            newCaption = newCaption.substring(0, 255);
        }
        this.imageRecordService.updateCaption(imageSetID, imageID, newCaption);
    }

    public void setupTable(JTable table) {
        TableUtils.setTableHeaderBold((JTable)table);
        for (int i = 0; i < COL_TITLES.length; ++i) {
            table.getColumnModel().getColumn(i).setHeaderValue(COL_TITLES[i]);
            table.getColumnModel().getColumn(i).setPreferredWidth(COL_WIDTHS[i]);
        }
        table.setRowHeight(175);
        table.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new TextAreaRenderer(false));
        table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new TextAreaRenderer(false));
        table.getTableHeader().setReorderingAllowed(false);
    }

    public void setImageSet(ImageSet imageSet) {
        this.imageSet = imageSet;
    }

    public ImageSet getImageSet() {
        return this.imageSet;
    }
}

