/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.imagegallery;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.imagegallery.ImageGalleryPrintProperties;
import model3.SBdb;

public class DialogPrintImageGallery
extends SBDialog {
    private final SBdb db;
    private final ImageGalleryPrintProperties p;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAuthor;
    private JCheckBox jCheckBoxCat;
    private JCheckBox jCheckBoxExcludeWells;
    private JCheckBox jCheckBoxFullPicPath;
    private JCheckBox jCheckBoxImageCaption;
    private JCheckBox jCheckBoxNotes;
    private JCheckBox jCheckBoxOccComments;
    private JCheckBox jCheckBoxPicPath;
    private JCheckBox jCheckBoxReferences;
    private JCheckBox jCheckBoxSuite;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonSetAll;
    private JRadioButton jRadioButtonSetFirst;
    private JRadioButton jRadioButtonSizeL;
    private JRadioButton jRadioButtonSizeM;
    private JRadioButton jRadioButtonSizeS;

    public DialogPrintImageGallery(Dialog parent, boolean modal, ImageGalleryPrintProperties properties, SBdb db) {
        super((Window)parent, modal);
        this.p = properties;
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogPrintImageGallery(JFrame parent, boolean modal, ImageGalleryPrintProperties properties, SBdb db) {
        super((Frame)parent, modal);
        this.p = properties;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Image Gallery Print Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        switch (this.p.imageSize()) {
            case S: {
                this.jRadioButtonSizeS.setSelected(true);
                break;
            }
            case M: {
                this.jRadioButtonSizeM.setSelected(true);
                break;
            }
            case L: {
                this.jRadioButtonSizeL.setSelected(true);
            }
        }
        if (this.p.showAllImagesInSet()) {
            this.jRadioButtonSetAll.setSelected(true);
        } else {
            this.jRadioButtonSetFirst.setSelected(true);
        }
        this.jCheckBoxOccComments.setSelected(this.p.showOccComments());
        this.jCheckBoxCat.setSelected(this.p.excludeCats());
        this.jCheckBoxSuite.setSelected(this.p.showSuite());
        this.jCheckBoxPicPath.setSelected(this.p.showFileName());
        this.jCheckBoxFullPicPath.setSelected(this.p.showFullFilePath());
        this.jCheckBoxAuthor.setSelected(this.p.showAuthor());
        this.jCheckBoxImageCaption.setSelected(this.p.showImageCaption());
        this.jCheckBoxReferences.setSelected(this.p.showReferences());
        this.jCheckBoxNotes.setSelected(this.p.showNotes());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSizeL = new JRadioButton();
        this.jRadioButtonSizeM = new JRadioButton();
        this.jRadioButtonSizeS = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanel2 = new JPanel();
        this.jRadioButtonSetFirst = new JRadioButton();
        this.jRadioButtonSetAll = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jCheckBoxExcludeWells = new JCheckBox();
        this.jCheckBoxSuite = new JCheckBox();
        this.jCheckBoxOccComments = new JCheckBox();
        this.jCheckBoxCat = new JCheckBox();
        this.jCheckBoxAuthor = new JCheckBox();
        this.jCheckBoxImageCaption = new JCheckBox();
        this.jCheckBoxFullPicPath = new JCheckBox();
        this.jCheckBoxPicPath = new JCheckBox();
        this.jCheckBoxReferences = new JCheckBox();
        this.jCheckBoxNotes = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Image size", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroup1.add(this.jRadioButtonSizeL);
        this.jRadioButtonSizeL.setText("Large");
        this.buttonGroup1.add(this.jRadioButtonSizeM);
        this.jRadioButtonSizeM.setText("Medium");
        this.buttonGroup1.add(this.jRadioButtonSizeS);
        this.jRadioButtonSizeS.setText("Small");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonSizeL).addComponent(this.jRadioButtonSizeM).addComponent(this.jRadioButtonSizeS)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonSizeS).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSizeM).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSizeL).addContainerGap(8, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPrintImageGallery this$0;
            {
                DialogPrintImageGallery dialogPrintImageGallery = this$0;
                Objects.requireNonNull(dialogPrintImageGallery);
                this.this$0 = dialogPrintImageGallery;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPrintImageGallery this$0;
            {
                DialogPrintImageGallery dialogPrintImageGallery = this$0;
                Objects.requireNonNull(dialogPrintImageGallery);
                this.this$0 = dialogPrintImageGallery;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPrintImageGallery this$0;
            {
                DialogPrintImageGallery dialogPrintImageGallery = this$0;
                Objects.requireNonNull(dialogPrintImageGallery);
                this.this$0 = dialogPrintImageGallery;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Images"));
        this.buttonGroup2.add(this.jRadioButtonSetFirst);
        this.jRadioButtonSetFirst.setText("First image in set");
        this.buttonGroup2.add(this.jRadioButtonSetAll);
        this.jRadioButtonSetAll.setText("All images in set");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonSetAll).addComponent(this.jRadioButtonSetFirst)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonSetFirst).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSetAll).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Captions"));
        this.jCheckBoxExcludeWells.setText("Exclude well and sample info");
        this.jCheckBoxExcludeWells.setToolTipText("*Only when printing from TaxaDB");
        this.jCheckBoxSuite.setText("Show analysis suite");
        this.jCheckBoxOccComments.setText("Show occurrence comments");
        this.jCheckBoxCat.setText("Exclude taxon categories");
        this.jCheckBoxAuthor.setText("Show author name");
        this.jCheckBoxImageCaption.setText("Show image caption");
        this.jCheckBoxFullPicPath.setText("Show image file path");
        this.jCheckBoxPicPath.setText("Show image file name");
        this.jCheckBoxReferences.setText("Show reference");
        this.jCheckBoxNotes.setText("Show notes");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCheckBoxExcludeWells, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxSuite, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxOccComments, -1, 217, Short.MAX_VALUE).addComponent(this.jCheckBoxAuthor, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxCat).addComponent(this.jCheckBoxPicPath, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxFullPicPath, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxImageCaption, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxNotes, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxReferences, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        jPanel3Layout.linkSize(0, this.jCheckBoxAuthor, this.jCheckBoxCat, this.jCheckBoxFullPicPath, this.jCheckBoxImageCaption, this.jCheckBoxOccComments, this.jCheckBoxPicPath, this.jCheckBoxSuite);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxExcludeWells).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSuite).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxOccComments).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxAuthor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxPicPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxFullPicPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxImageCaption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxReferences).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxNotes).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)).addComponent(this.jPanel3, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jRadioButtonSizeL.isSelected()) {
            this.p.setImageSize(ImageGalleryPrintProperties.ImageSize.L);
        } else if (this.jRadioButtonSizeM.isSelected()) {
            this.p.setImageSize(ImageGalleryPrintProperties.ImageSize.M);
        } else {
            this.p.setImageSize(ImageGalleryPrintProperties.ImageSize.S);
        }
        this.p.setShowAllImagesInSet(this.jRadioButtonSetAll.isSelected());
        this.p.setShowOccComments(this.jCheckBoxOccComments.isSelected());
        this.p.setShowSuite(this.jCheckBoxSuite.isSelected());
        this.p.setShowImageCaption(this.jCheckBoxImageCaption.isSelected());
        this.p.setShowFileName(this.jCheckBoxPicPath.isSelected());
        this.p.setShowFullFilePath(this.jCheckBoxFullPicPath.isSelected());
        this.p.setShowAuthor(this.jCheckBoxAuthor.isSelected());
        this.p.setExcludeCats(this.jCheckBoxCat.isSelected());
        this.p.setExcludeWellInfo(this.jCheckBoxExcludeWells.isSelected());
        this.p.setShowReferences(this.jCheckBoxReferences.isSelected());
        this.p.setShowNotes(this.jCheckBoxNotes.isSelected());
        ImageGalleryPrintProperties.encode(this.p, this.db);
        this.setOK();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtoprintimagegalleries.html");
    }
}

