/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.imagegallery;

import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageSet;
import com.stratadata.model3.image.OccurrenceImage;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogSelectTaxa;
import jsbugs.FrameJsbugs;
import jsbugs.image.DialogImageSet;
import jsbugs.image.DialogImageSetOverview;
import jsbugs.imagegallery.ImageGalleryPrintProperties;
import jsbugs.imagegallery.TaxonImageGallery;
import jsbugs.imagegallery.TaxonImageGalleryPrint;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.TaxonOcc;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.table.TableEventUtils;
import util.table.TextAreaRenderer;

public class DialogTaxonImages
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(DialogTaxonImages.class.getName());
    private static final int IMAGE_SIZE = 80;
    private final SBdb db;
    private final TableModelTaxonImage model;
    private final model3.Taxon taxon;
    private final String title;
    private ImageRecord selectedImage = null;
    int formWidth = 0;
    int formHeight = 0;
    boolean toSetSelectedImage = false;
    private SelectedAnalysis selectedItem;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonExport;
    private JButton jButtonGoToAnalysis;
    private JButton jButtonHelp;
    private JButton jButtonMarkAsType;
    private JButton jButtonPrint;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelTypeImage;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemEdit;
    private JMenuItem jMenuItemReassignImage;
    private JPopupMenu jPopupMenuImages;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTable jTableTaxonImage;
    private JTextField jTextFieldTaxonName;
    private JTextField jTextFieldTotalImageSets;
    private JTextField jTextFieldTotalImages;

    public static DialogTaxonImages imageGalleryDialogForTaxon(Window parent, model3.Taxon taxon, SBdb sbdb) {
        TaxonImageGallery imageGallery = TaxonImageGallery.ImageGalleryForTaxa(List.of(taxon), sbdb.getTaxonImageService(), sbdb.getImageRecordService(), sbdb.getImageLoader());
        String title = taxon.toString(false, true);
        DialogTaxonImages dialog = new DialogTaxonImages(parent, sbdb, taxon, imageGallery, title);
        TableColumn taxonCol = dialog.jTableTaxonImage.getColumnModel().getColumn(dialog.jTableTaxonImage.convertColumnIndexToView(6));
        taxonCol.setMinWidth(0);
        taxonCol.setMaxWidth(0);
        taxonCol.setResizable(false);
        return dialog;
    }

    public static DialogTaxonImages imageGalleryDialogForTaxa(Window parent, List<model3.Taxon> taxa, SBdb sbdb) {
        TaxonImageGallery imageGallery = TaxonImageGallery.ImageGalleryForTaxa(taxa, sbdb.getTaxonImageService(), sbdb.getImageRecordService(), sbdb.getImageLoader());
        String title = "Taxa";
        return new DialogTaxonImages(parent, sbdb, null, imageGallery, title);
    }

    public static DialogTaxonImages imageGalleryDialogForAnalyses(Window parent, List<Smpdtl> smpdtls, SBdb sbdb) {
        TaxonImageGallery imageGallery = TaxonImageGallery.ImageGalleryForAnalyses(smpdtls, sbdb.getTaxonImageService(), sbdb.getImageRecordService(), sbdb.getImageLoader());
        Object title = "Analyses";
        if (!smpdtls.isEmpty()) {
            try {
                Well well = sbdb.getWell(smpdtls.get(0).getSample().getWellID());
                title = (String)title + " in " + well.getWellName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new DialogTaxonImages(parent, sbdb, null, imageGallery, (String)title);
    }

    private DialogTaxonImages(Window parent, SBdb db, model3.Taxon taxon, TaxonImageGallery gallery, String title) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.taxon = taxon;
        this.db = db;
        this.model = new TableModelTaxonImage(db.getTaxonService(), gallery);
        this.title = title;
        this.init();
    }

    private void init() {
        this.setTitle("Images : " + this.title);
        this.jTableTaxonImage.setModel(this.model);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.jTableTaxonImage.getColumnModel().getColumn(i).setHeaderValue(TableModelTaxonImage.colTitles[i]);
            this.jTableTaxonImage.getColumnModel().getColumn(i).setPreferredWidth(TableModelTaxonImage.colWidth[i]);
        }
        this.jTableTaxonImage.setDefaultRenderer(String.class, (TableCellRenderer)new TextAreaRenderer(false));
        this.jTableTaxonImage.setDefaultRenderer(Well.class, (TableCellRenderer)new TextAreaRenderer(false));
        this.jTableTaxonImage.setDefaultRenderer(Float.class, (TableCellRenderer)new TextAreaRenderer(false));
        this.jTableTaxonImage.setDefaultRenderer(Integer.class, (TableCellRenderer)new TextAreaRenderer(false));
        TableUtils.setTableHeaderBold((JTable)this.jTableTaxonImage);
        this.jTableTaxonImage.add(this.jPopupMenuImages);
        this.jTableTaxonImage.setRowSorter(new TableRowSorter<TableModelTaxonImage>(this.model));
        new ColumnSortResetHandler(this.jTableTaxonImage).attach();
        this.jTableTaxonImage.setSelectionMode(0);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jTableTaxonImage.setRowHeight(80);
        this.setTotals();
        this.model.fireTableDataChanged();
        if (this.taxon == null) {
            this.jTextFieldTaxonName.setVisible(false);
            this.jLabel1.setVisible(false);
            this.jButtonAdd.setVisible(false);
            this.jButtonMarkAsType.setVisible(false);
        } else {
            this.jTextFieldTaxonName.setText(this.taxon.toString(true, true));
            int row = 0;
            for (TaxonImageSet images : this.model.gallery.getData()) {
                if (images.isType()) {
                    this.selectedImage = (ImageRecord)images.getImageRecords(this.model.gallery.imageRecordService).get(0);
                    this.jTableTaxonImage.getSelectionModel().setSelectionInterval(row, row);
                    break;
                }
                ++row;
            }
            this.displaySelectedImage();
        }
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonDelete.setEnabled(false);
            this.jButtonMarkAsType.setEnabled(false);
            this.jButtonAdd.setEnabled(false);
        } else if (!this.db.isConnected()) {
            this.jButtonAdd.setEnabled(false);
            this.jButtonDelete.setText("Exclude");
        }
        this.jButtonGoToAnalysis.setVisible(false);
        this.jTableTaxonImage.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (this.this$0.jTableTaxonImage.getSelectedRow() >= 0) {
                    this.this$0.selectedImage = (ImageRecord)this.this$0.model.gallery.getImageSet(this.this$0.jTableTaxonImage.getRowSorter().convertRowIndexToModel(this.this$0.jTableTaxonImage.getSelectedRow())).getImageRecords(this.this$0.model.gallery.imageRecordService).get(0);
                    this.this$0.displaySelectedImage();
                }
            }
        });
        if (SbugsSession.getSession().useHiResIcons()) {
            this.jButtonPrint.setIcon(IconFactory.getIcon("/resources/icon/", "print.svg", 16));
            this.jButtonExport.setIcon(IconFactory.getIcon("/resources/icon/", "exportVector.svg", 16));
        }
    }

    public void enableAnalysisSelection() {
        this.jButtonGoToAnalysis.setVisible(true);
    }

    private void setTotals() {
        this.jTextFieldTotalImageSets.setText("" + this.model.gallery.getTotalImageCount(false));
        this.jTextFieldTotalImages.setText("" + this.model.gallery.getTotalImageCount(true));
    }

    private TaxonImageSet getSelectedImageSet() {
        if (this.jTableTaxonImage.getSelectedRow() > -1) {
            return this.model.gallery.getImageSet(this.jTableTaxonImage.convertRowIndexToModel(this.jTableTaxonImage.getSelectedRow()));
        }
        return null;
    }

    private void displaySelectedImage() {
        if (this.model.gallery.isEmpty()) {
            this.jLabelTypeImage.setVisible(false);
            return;
        }
        if (this.selectedImage == null) {
            this.jLabelTypeImage.setVisible(false);
        } else {
            this.jLabelTypeImage.setVisible(true);
            this.jLabelTypeImage.setText(null);
            Rectangle bounds = this.jLabelTypeImage.getBounds();
            if (bounds.width > 10 && bounds.height > 10) {
                TaxonImageSet imageSet = this.model.gallery.getData().stream().filter(taxonImageSet -> taxonImageSet.getImageRecords(this.model.gallery.imageRecordService).contains(this.selectedImage)).findFirst().orElseThrow();
                ImageIcon icon = null;
                Image image = imageSet.getImage(this.model.gallery.imageRecordService, this.model.gallery.imageLoader, this.selectedImage.imageID(), new Dimension(bounds.width, bounds.height));
                if (image != null) {
                    icon = new ImageIcon(image);
                }
                this.jLabelTypeImage.setIcon(icon);
                this.jLabelTypeImage.setHorizontalAlignment(0);
                this.jLabelTypeImage.setVerticalAlignment(0);
            }
        }
    }

    private void initComponents() {
        this.jPopupMenuImages = new JPopupMenu();
        this.jMenuItemEdit = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jMenuItemReassignImage = new JMenuItem();
        this.jLabel1 = new JLabel();
        this.jTextFieldTaxonName = new JTextField();
        this.jButtonClose = new JButton();
        this.jButtonMarkAsType = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonHelp = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jLabelTypeImage = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableTaxonImage = new JTable();
        this.jLabel2 = new JLabel();
        this.jTextFieldTotalImageSets = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldTotalImages = new JTextField();
        this.jButtonGoToAnalysis = new JButton();
        this.jButtonPrint = new JButton();
        this.jButtonExport = new JButton();
        this.jMenuItemEdit.setText("Edit...");
        this.jMenuItemEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEditActionPerformed(evt);
            }
        });
        this.jPopupMenuImages.add(this.jMenuItemEdit);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuImages.add(this.jMenuItemDelete);
        this.jMenuItemReassignImage.setText("Reassign image to a different taxon...");
        this.jMenuItemReassignImage.setToolTipText("Moves the selected image set to a different occurrence in the selected analysis only.");
        this.jMenuItemReassignImage.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemReassignImageActionPerformed(evt);
            }
        });
        this.jPopupMenuImages.add(this.jMenuItemReassignImage);
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 300));
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                this.this$0.formMouseMoved(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                this.this$0.formComponentResized(evt);
            }
        });
        this.jLabel1.setText("Taxon:");
        this.jTextFieldTaxonName.setEditable(false);
        this.jTextFieldTaxonName.setBackground(new Color(255, 255, 204));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonMarkAsType.setText("Mark as \"Type\"");
        this.jButtonMarkAsType.setToolTipText("Mark selected image set as notable \"type\" specimen");
        this.jButtonMarkAsType.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMarkAsTypeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected image set");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.setToolTipText("Edit selected image set");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.setToolTipText("Add new images to link to taxon");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerSize(10);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.3);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jLabelTypeImage.setToolTipText("");
        this.jLabelTypeImage.setPreferredSize(new Dimension(37, 500));
        this.jLabelTypeImage.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                this.this$0.jLabelTypeImageComponentResized(evt);
            }
        });
        this.jSplitPane1.setLeftComponent(this.jLabelTypeImage);
        this.jTableTaxonImage.setToolTipText("");
        this.jTableTaxonImage.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableTaxonImageMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jTableTaxonImageMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jTableTaxonImageMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableTaxonImage);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jLabel2.setText("Total number of image sets: ");
        this.jTextFieldTotalImageSets.setEditable(false);
        this.jTextFieldTotalImageSets.setText("0");
        this.jLabel3.setText("Total number of images:");
        this.jTextFieldTotalImages.setEditable(false);
        this.jTextFieldTotalImages.setText("0");
        this.jButtonGoToAnalysis.setText("Go to analysis...");
        this.jButtonGoToAnalysis.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGoToAnalysisActionPerformed(evt);
            }
        });
        this.jButtonPrint.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/print16.png")));
        this.jButtonPrint.setToolTipText("Send image gallery to printer");
        this.jButtonPrint.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPrintActionPerformed(evt);
            }
        });
        this.jButtonExport.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/export16.png")));
        this.jButtonExport.setToolTipText("Export image gallery to PDF");
        this.jButtonExport.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonImages this$0;
            {
                DialogTaxonImages dialogTaxonImages = this$0;
                Objects.requireNonNull(dialogTaxonImages);
                this.this$0 = dialogTaxonImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExportActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonGoToAnalysis).addPreferredGap(0).add((Component)this.jButtonPrint, -2, 30, -2).addPreferredGap(0).add((Component)this.jButtonExport, -2, 30, -2).addPreferredGap(0, 105, Short.MAX_VALUE).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonMarkAsType).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add((Component)this.jSplitPane1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jTextFieldTotalImageSets, -2, 40, -2).addPreferredGap(1).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jTextFieldTotalImages, -2, 35, -2).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldTaxonName))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonClose, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp}, 1);
        layout.linkSize(new Component[]{this.jTextFieldTotalImageSets, this.jTextFieldTotalImages}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldTaxonName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldTotalImageSets, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.jTextFieldTotalImages, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSplitPane1, -1, 762, Short.MAX_VALUE).add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonClose).add((Component)this.jButtonMarkAsType).add((Component)this.jButtonDelete).add((Component)this.jButtonEdit).add((Component)this.jButtonAdd).add((Component)this.jButtonHelp).add((Component)this.jButtonGoToAnalysis).add((Component)this.jButtonPrint).add((Component)this.jButtonExport)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableTaxonImage.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one item", this.getTitle(), 1);
            return;
        }
        TaxonImageSet taxonImageSet = this.getSelectedImageSet();
        if (taxonImageSet.getImageSetID() == 0) {
            JOptionPane.showMessageDialog(this, "To delete this image set, you must delete the image files from the external image folder.", this.getTitle(), 1);
            return;
        }
        List imageRecords = taxonImageSet.getImageRecords(this.model.gallery.imageRecordService);
        try {
            String msg = "Really delete this set of " + imageRecords.size() + " image" + (imageRecords.size() > 1 ? "s" : "");
            msg = taxonImageSet.getAnalysisID().isPresent() ? msg + ", which is linked to an analysis?" : msg + "?";
            if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) {
                return;
            }
            this.db.deleteTaxonImageSet(this.taxon.getSpecID(), taxonImageSet);
            this.model.gallery.removeImageSet(taxonImageSet);
            this.model.fireTableDataChanged();
            this.setTotals();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error deleting images", e, this);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogImageSet dialog = new DialogImageSet(this, true, this.db, null, true, 0);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                this.db.getTaxonImageService().addTaxonImageSet(this.taxon.getSpecID(), new TaxonImageSet(dialog.getImageSetID(), this.taxon.getSpecID(), false));
                this.db.commit();
                this.model.gallery.setData(this.db.getTaxonImages(this.taxon.getSpecID()));
                this.setTotals();
            }
            catch (Exception e) {
                SbugsExceptionHandler.showStackError(e);
            }
            this.model.fireTableDataChanged();
            this.jTableTaxonImage.clearSelection();
            this.jTableTaxonImage.setRowSelectionInterval(0, 0);
        }
    }

    private void jButtonMarkAsTypeActionPerformed(ActionEvent evt) {
        if (this.jTableTaxonImage.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one item", this.getTitle(), 1);
            return;
        }
        TaxonImageSet item = this.getSelectedImageSet();
        try {
            this.db.getTaxonImageService().setTaxonImageSetType(this.taxon.getSpecID(), item, !item.isType());
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        boolean allowEdit;
        if (this.jTableTaxonImage.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one item", this.getTitle(), 1);
            return;
        }
        TaxonImageSet item = this.getSelectedImageSet();
        try {
            allowEdit = SBRestrictable.canWrite(this.db) && item.getImageSetID() > 0 && (item.getAnalysisID().isEmpty() || ((OccurrenceImage)item).getWell().canWrite(this.db, null));
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
            return;
        }
        DialogImageSetOverview dialog = new DialogImageSetOverview(this, true, (ImageSet)item, this.db, allowEdit);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this.db.getTaxonImageService().notifyListeners(item.getSpecID());
    }

    private void jTableTaxonImageMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.taxon != null && this.jTableTaxonImage.getSelectedColumn() == 10) {
                this.jButtonMarkAsTypeActionPerformed(null);
            } else {
                this.jButtonEditActionPerformed(null);
            }
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogtaxonimages.html");
    }

    private void formComponentResized(ComponentEvent evt) {
        try {
            if (this.getWidth() == this.formWidth && this.getHeight() == this.formHeight) {
                this.displaySelectedImage();
                this.toSetSelectedImage = false;
            } else {
                this.jLabelTypeImage.setIcon(null);
                this.jLabelTypeImage.setText("Resizing");
                this.toSetSelectedImage = true;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            e.printStackTrace();
        }
        this.formWidth = this.getWidth();
        this.formHeight = this.getHeight();
    }

    private void formMouseMoved(MouseEvent evt) {
        try {
            if (this.toSetSelectedImage) {
                this.toSetSelectedImage = false;
                this.displaySelectedImage();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            e.printStackTrace();
        }
    }

    private void jLabelTypeImageComponentResized(ComponentEvent evt) {
        if (FrameJsbugs.isMacPlatform()) {
            try {
                if (this.toSetSelectedImage) {
                    this.displaySelectedImage();
                    this.toSetSelectedImage = false;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
                e.printStackTrace();
            }
        }
    }

    public SelectedAnalysis getSelectedAnalysis() {
        return this.selectedItem;
    }

    private void jButtonGoToAnalysisActionPerformed(ActionEvent evt) {
        OccurrenceImage occImage;
        if (this.jTableTaxonImage.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one item", this.getTitle(), 1);
            return;
        }
        TaxonImageSet selectedImageSet = this.getSelectedImageSet();
        if (selectedImageSet instanceof OccurrenceImage && (occImage = (OccurrenceImage)selectedImageSet).getSmpdtl() != null) {
            this.selectedItem = new SelectedAnalysis(occImage.getWell(), occImage.getSmpdtl());
            this.dispose();
        }
    }

    private void jButtonPrintActionPerformed(ActionEvent evt) {
        this.createGalleryPrint().print(this, this.db);
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        this.createGalleryPrint().exportPdfPDFBox(this, this.db);
    }

    private void jMenuItemReassignImageActionPerformed(ActionEvent evt) {
        int row = this.jTableTaxonImage.convertRowIndexToModel(this.jTableTaxonImage.getSelectedRow());
        TaxonImageGallery gallery = this.model.gallery;
        TaxonImageSet item = gallery.getImageSet(row);
        Well itemWell = gallery.getImageSetWell(item);
        Sample itemSample = gallery.getImageSetSample(item);
        Smpdtl itemSmpdtl = gallery.getImageSetAnalysis(item);
        String messageTitle = "Reassign Taxon Image Set";
        if (itemSmpdtl == null) {
            JOptionPane.showMessageDialog(this, "Can't reassign an image which is not linked to an occurrence", "Reassign Taxon Image Set", 0);
            return;
        }
        DialogSelectTaxa dialog = new DialogSelectTaxa(this, true, this.db, 0, true, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        Taxon targetTaxon = (Taxon)dialog.getSelectedItem();
        TaxonOcc sourceOcc = itemSmpdtl.getOccurUnsorted().stream().filter(occ -> occ.getImageSetID() == item.getImageSetID()).findAny().orElse(null);
        if (sourceOcc == null) {
            JOptionPane.showMessageDialog(this, "Can't find original occurrence", "Reassign Taxon Image Set", 0);
            return;
        }
        if (sourceOcc.getSpecID() == targetTaxon.getSpecID()) {
            JOptionPane.showMessageDialog(this, "Selected taxon is the same as the original", "Reassign Taxon Image Set", 0);
            return;
        }
        List<TaxonOcc> occsWithTargetSpecID = itemSmpdtl.getOccurUnsorted().stream().filter(occ -> occ.getImageSetID() != item.getImageSetID() && occ.getSpecID() == targetTaxon.getSpecID()).toList();
        TaxonOcc targetOcc = occsWithTargetSpecID.stream().filter(occ -> occ.getSituation() == Situation.INSITU).findFirst().orElse(occsWithTargetSpecID.stream().findFirst().orElse(null));
        if (targetOcc != null && targetOcc.getImageSetID() > 0) {
            JOptionPane.showMessageDialog(this, "Selected taxon already has images assigned", "Reassign Taxon Image Set", 0);
            return;
        }
        try {
            if (targetOcc == null) {
                TaxonOcc.Builder builder = new TaxonOcc.Builder(this.db, this.db.getTaxon(targetTaxon.getSpecID()), sourceOcc.getSituation(), sourceOcc.getQuestionable(), sourceOcc.getSpecType()).count(sourceOcc.getCoarse(), sourceOcc.getMedium(), sourceOcc.getFine()).marker(sourceOcc.isMarker()).imageSet(item.getImageSetID());
                itemSmpdtl.insertOccurrence(builder, itemWell.getWellID(), true);
            } else {
                targetOcc.updateImageSet(itemWell.getWellID(), itemSmpdtl.getAnalyID(), itemSample.getSampID(), item.getImageSetID());
            }
            sourceOcc.updateImageSet(itemWell.getWellID(), itemSmpdtl.getAnalyID(), itemSample.getSampID(), 0);
            gallery.removeImageSet(item);
            this.model.fireTableDataChanged();
            itemWell.notifyObservers((Object)itemSmpdtl);
            JOptionPane.showMessageDialog(this, "Image set reassigned to " + (targetOcc == null ? "new" : "existing") + " occurrence of '" + String.valueOf(targetTaxon) + "'.", "Reassign Taxon Image Set", 1);
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jTableTaxonImageMousePressed(MouseEvent evt) {
        TableEventUtils.setRowSelectionPopup((JTable)this.jTableTaxonImage, (MouseEvent)evt, (JPopupMenu)this.jPopupMenuImages);
    }

    private void jTableTaxonImageMouseReleased(MouseEvent evt) {
        TableEventUtils.setRowSelectionPopup((JTable)this.jTableTaxonImage, (MouseEvent)evt, (JPopupMenu)this.jPopupMenuImages);
    }

    private void jMenuItemEditActionPerformed(ActionEvent evt) {
        this.jButtonEditActionPerformed(evt);
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        this.jButtonDeleteActionPerformed(evt);
    }

    private TaxonImageGalleryPrint createGalleryPrint() {
        ImageGalleryPrintProperties printProperties = ImageGalleryPrintProperties.getDecodedProperties(this.db);
        if (this.jTableTaxonImage.getRowSorter().getSortKeys().stream().findFirst().filter(sortKey -> sortKey.getColumn() == 6).isPresent()) {
            printProperties.setSortOrder(ImageGalleryPrintProperties.Sort.TAXON);
        } else if (this.jTableTaxonImage.getRowSorter().getSortKeys().stream().findFirst().filter(sortKey -> sortKey.getColumn() == 7).isPresent()) {
            printProperties.setSortOrder(ImageGalleryPrintProperties.Sort.CAPTION);
        }
        return new TaxonImageGalleryPrint(this.model.gallery, printProperties, this.db.getTaxonService(), this.title);
    }

    private static class TableModelTaxonImage
    extends AbstractTableModel {
        final TaxonService taxonService;
        final TaxonImageGallery gallery;
        static String[] colTitles = new String[]{"Well", "Depth", "Sample Type", "Disc", "Analyst", "Analy.No.", "Name", "Caption to 1st image", "No. in Set", "Image", "Type?"};
        static int[] colWidth = new int[]{50, 30, 20, 15, 20, 10, 50, 100, 10, 80, 10};
        static final int COL_WELL = 0;
        static final int COL_DEPTH = 1;
        static final int COL_TYPE = 2;
        static final int COL_DISC = 3;
        static final int COL_ANALYST = 4;
        static final int COL_ANALYNO = 5;
        static final int COL_TAXON = 6;
        static final int COL_CAPTION = 7;
        static final int COL_NIMAGES = 8;
        static final int COL_IMAGE = 9;
        static final int COL_TXTYPE = 10;

        public TableModelTaxonImage(TaxonService taxonService, TaxonImageGallery gallery) {
            this.taxonService = taxonService;
            this.gallery = gallery;
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            TaxonImageSet item = this.gallery.getImageSet(row);
            Well itemWell = this.gallery.getImageSetWell(item);
            Sample itemSample = this.gallery.getImageSetSample(item);
            Smpdtl itemSmpdtl = this.gallery.getImageSetAnalysis(item);
            try {
                switch (col) {
                    case 0: {
                        return itemWell;
                    }
                    case 1: {
                        return itemSample == null ? null : DepthUtils.depthString((double)itemSample.getDepth(), (DepthUnits)itemWell.getHeader().getDepthUnits(), (int)2, (SectionType)itemWell.getSectionType());
                    }
                    case 2: {
                        return itemSample != null ? itemSample.getType().getAbr() : null;
                    }
                    case 3: {
                        return itemSmpdtl != null ? SBdb.getDiscAbr(itemSmpdtl.getDiscID()) : null;
                    }
                    case 4: {
                        return itemSmpdtl != null ? itemSmpdtl.getAnalystAbr() : null;
                    }
                    case 5: {
                        return itemSmpdtl != null ? Integer.valueOf(itemSmpdtl.getAnalyNo()) : null;
                    }
                    case 6: {
                        return this.taxonService.findTaxon(item.getSpecID()).map(t -> t.toString(false)).orElse("");
                    }
                    case 8: {
                        return item.getImageRecords(this.gallery.imageRecordService).size();
                    }
                    case 7: {
                        return ((ImageRecord)item.getImageRecords(this.gallery.imageRecordService).get(0)).caption();
                    }
                    case 9: {
                        return new ImageIcon(item.getFirstImage(this.gallery.imageRecordService, this.gallery.imageLoader, new Dimension(80, 80)));
                    }
                    case 10: {
                        return item.isType() ? "Y" : "";
                    }
                }
                return "";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }

        public Class getColumnClass(int col) {
            return switch (col) {
                case 0 -> Well.class;
                case 1 -> Float.class;
                case 2, 3, 4, 7, 10 -> String.class;
                default -> String.class;
                case 5, 8 -> Integer.class;
                case 9 -> ImageIcon.class;
            };
        }

        @Override
        public int getRowCount() {
            return this.gallery.getTotalImageCount(false);
        }
    }

    public record SelectedAnalysis(Well well, Smpdtl smpdtl) {
    }
}

