/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.imagegallery;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.OccurrenceImage;
import com.stratadata.model3.image.TaxonImageService;
import com.stratadata.model3.image.TaxonImageSet;
import java.util.ArrayList;
import java.util.List;
import model3.Sample;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.Well;

public class TaxonImageGallery {
    final ImageRecordService imageRecordService;
    final ImageLoader imageLoader;
    private final List<TaxonImageSet> data;

    private TaxonImageGallery(ImageRecordService imageRecordService, ImageLoader imageLoader) {
        this.imageRecordService = imageRecordService;
        this.imageLoader = imageLoader;
        this.data = new ArrayList<TaxonImageSet>();
    }

    public static TaxonImageGallery ImageGalleryForTaxa(List<Taxon> taxa, TaxonImageService taxonImageService, ImageRecordService imageRecordService, ImageLoader imageLoader) {
        TaxonImageGallery gallery = new TaxonImageGallery(imageRecordService, imageLoader);
        for (Taxon taxon : taxa) {
            gallery.data.addAll(taxonImageService.getImages(taxon.getSpecID()));
        }
        return gallery;
    }

    public static TaxonImageGallery ImageGalleryForAnalyses(List<Smpdtl> smpdtls, TaxonImageService taxonImageService, ImageRecordService imageRecordService, ImageLoader imageLoader) {
        TaxonImageGallery gallery = new TaxonImageGallery(imageRecordService, imageLoader);
        for (Smpdtl dtl : smpdtls) {
            for (TaxonOcc occ : dtl.getOccurSorted()) {
                if (occ.getImageSetID() <= 0) continue;
                gallery.data.add(taxonImageService.getTaxonImageSet(occ.getImageSetID()));
            }
        }
        return gallery;
    }

    public void setData(List<TaxonImageSet> newData) {
        this.data.clear();
        this.data.addAll(newData);
    }

    public TaxonImageSet getImageSet(int n) {
        return this.data.get(n);
    }

    public List<TaxonImageSet> getData() {
        return new ArrayList<TaxonImageSet>(this.data);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void removeImageSet(TaxonImageSet toRemove) {
        this.data.remove(toRemove);
    }

    public int getTotalImageCount(boolean allImagesInSet) {
        if (allImagesInSet) {
            return this.data.stream().mapToInt(imageSet -> imageSet.getSize(this.imageRecordService)).sum();
        }
        return this.data.size();
    }

    public List<GalleryImage> getGalleryImages(boolean allImagesInSet) {
        ArrayList<GalleryImage> galleryImages = new ArrayList<GalleryImage>();
        for (TaxonImageSet imageSet : this.data) {
            TaxonOcc imageOcc = null;
            if (imageSet.getAnalysisID().isPresent()) {
                OccurrenceImage occImage = (OccurrenceImage)imageSet;
                imageOcc = occImage.getSmpdtl().getOccurUnsorted().stream().filter(occ -> occ.getImageSetID() == imageSet.getImageSetID()).findFirst().orElse(null);
            }
            if (allImagesInSet) {
                int imageNo = 0;
                for (ImageRecord imageRecord : imageSet.getImageRecords(this.imageRecordService)) {
                    galleryImages.add(new GalleryImage(imageRecord, imageSet, imageNo++, imageOcc));
                }
                continue;
            }
            galleryImages.add(new GalleryImage(imageSet.getImageRecord(0, this.imageRecordService), imageSet, 0, imageOcc));
        }
        return galleryImages;
    }

    public Well getImageSetWell(TaxonImageSet imageSet) {
        if (imageSet instanceof OccurrenceImage) {
            OccurrenceImage occImage = (OccurrenceImage)imageSet;
            return occImage.getWell();
        }
        return null;
    }

    public Sample getImageSetSample(TaxonImageSet imageSet) {
        if (imageSet instanceof OccurrenceImage) {
            OccurrenceImage occImage = (OccurrenceImage)imageSet;
            return occImage.getSample();
        }
        return null;
    }

    public Smpdtl getImageSetAnalysis(TaxonImageSet imageSet) {
        if (imageSet instanceof OccurrenceImage) {
            OccurrenceImage occImage = (OccurrenceImage)imageSet;
            return occImage.getSmpdtl();
        }
        return null;
    }

    public record GalleryImage(ImageRecord imageRecord, TaxonImageSet imageSet, int imageNo, TaxonOcc occ) {
    }
}

