/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.imagestorage;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.imagestorage.ImageExportOptions;

public class DialogStoreImagePaths
extends JDialog {
    private int result = 2;
    private ImageExportOptions options = null;
    private ButtonGroup buttonGroupImportOptions;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JButton jButtonSetExportFolderPath;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonExportAndUpdate;
    private JRadioButton jRadioButtonExportNoUpdate;
    private JRadioButton jRadioButtonNoExport;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldExportFolderPath;

    public DialogStoreImagePaths(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }

    public ImageExportOptions getOptions() {
        return this.options;
    }

    private void init() {
        this.setTitle("Change Image Storage and Export Options");
        this.pack();
    }

    private void disableExportFolderControls() {
        this.jTextFieldExportFolderPath.setEnabled(false);
        this.jButtonSetExportFolderPath.setEnabled(false);
    }

    private void enableExportFolderControls() {
        this.jTextFieldExportFolderPath.setEnabled(true);
        this.jButtonSetExportFolderPath.setEnabled(true);
    }

    private void initComponents() {
        this.buttonGroupImportOptions = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonExportNoUpdate = new JRadioButton();
        this.jRadioButtonExportAndUpdate = new JRadioButton();
        this.jRadioButtonNoExport = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldExportFolderPath = new JTextField();
        this.jButtonSetExportFolderPath = new JButton();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setMinimumSize(new Dimension(445, 360));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Export Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupImportOptions.add(this.jRadioButtonExportNoUpdate);
        this.jRadioButtonExportNoUpdate.setSelected(true);
        this.jRadioButtonExportNoUpdate.setText("Export all images, but do not update the paths stored (do not delete existing image data)");
        this.jRadioButtonExportNoUpdate.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImagePaths this$0;
            {
                DialogStoreImagePaths dialogStoreImagePaths = this$0;
                Objects.requireNonNull(dialogStoreImagePaths);
                this.this$0 = dialogStoreImagePaths;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonExportNoUpdateActionPerformed(evt);
            }
        });
        this.buttonGroupImportOptions.add(this.jRadioButtonExportAndUpdate);
        this.jRadioButtonExportAndUpdate.setText("Export all images and update the paths stored, then delete all image data from the database");
        this.jRadioButtonExportAndUpdate.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImagePaths this$0;
            {
                DialogStoreImagePaths dialogStoreImagePaths = this$0;
                Objects.requireNonNull(dialogStoreImagePaths);
                this.this$0 = dialogStoreImagePaths;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonExportAndUpdateActionPerformed(evt);
            }
        });
        this.buttonGroupImportOptions.add(this.jRadioButtonNoExport);
        this.jRadioButtonNoExport.setText("Don't attempt to export anything (do not delete existing image data)");
        this.jRadioButtonNoExport.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImagePaths this$0;
            {
                DialogStoreImagePaths dialogStoreImagePaths = this$0;
                Objects.requireNonNull(dialogStoreImagePaths);
                this.this$0 = dialogStoreImagePaths;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonNoExportActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Export to folder:");
        this.jButtonSetExportFolderPath.setText("Browse");
        this.jButtonSetExportFolderPath.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImagePaths this$0;
            {
                DialogStoreImagePaths dialogStoreImagePaths = this$0;
                Objects.requireNonNull(dialogStoreImagePaths);
                this.this$0 = dialogStoreImagePaths;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSetExportFolderPathActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Change the image storage option, AND:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonExportAndUpdate).addComponent(this.jRadioButtonExportNoUpdate).addComponent(this.jRadioButtonNoExport).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldExportFolderPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSetExportFolderPath))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonExportAndUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonExportNoUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonNoExport, -2, 23, -2).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldExportFolderPath).addComponent(this.jButtonSetExportFolderPath)).addContainerGap()));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImagePaths this$0;
            {
                DialogStoreImagePaths dialogStoreImagePaths = this$0;
                Objects.requireNonNull(dialogStoreImagePaths);
                this.this$0 = dialogStoreImagePaths;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOk.setText("Set database to store only image paths");
        this.jButtonOk.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImagePaths this$0;
            {
                DialogStoreImagePaths dialogStoreImagePaths = this$0;
                Objects.requireNonNull(dialogStoreImagePaths);
                this.this$0 = dialogStoreImagePaths;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOkActionPerformed(evt);
            }
        });
        this.jScrollPane1.setBorder(null);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Tahoma", 0, 11));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(3);
        this.jTextArea1.setText("You are about the modify the current database to store only image paths rather than images themselves. Any images currently stored in the database will be removed and will attempt to be read from the filesystem when needed using the stored path. \n\nThis will affect ALL users of the currently connected database.\n\nStratabugs can attempt to export the images currently stored in the database.");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setOpaque(false);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jScrollPane1, -1, 103, Short.MAX_VALUE).addGap(30, 30, 30).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCancel).addComponent(this.jButtonOk)).addContainerGap()));
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        if (this.jRadioButtonNoExport.isSelected()) {
            this.options = new ImageExportOptions(false, false, null);
        } else {
            String path = this.jTextFieldExportFolderPath.getText();
            if (path.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No export path specified.", "Error locating folder", 2);
                return;
            }
            File folder = new File(path);
            if (!folder.exists()) {
                int opt = JOptionPane.showConfirmDialog(this, "Folder to export to doesn't exist. Create it?", this.getTitle(), 0, 3);
                if (opt != 0) {
                    return;
                }
                if (!folder.mkdir()) {
                    JOptionPane.showMessageDialog(this, "Could not create the specified export folder. ", this.getTitle(), 2);
                    return;
                }
            }
            boolean updatePaths = this.jRadioButtonExportAndUpdate.isSelected();
            this.options = new ImageExportOptions(true, updatePaths, folder);
        }
        this.result = 0;
        this.setVisible(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.result = 2;
        this.options = null;
        this.setVisible(false);
    }

    private void jRadioButtonExportNoUpdateActionPerformed(ActionEvent evt) {
        this.enableExportFolderControls();
    }

    private void jRadioButtonExportAndUpdateActionPerformed(ActionEvent evt) {
        this.enableExportFolderControls();
    }

    private void jRadioButtonNoExportActionPerformed(ActionEvent evt) {
        this.disableExportFolderControls();
    }

    private void jButtonSetExportFolderPathActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this) == 0) {
            File folder = fileChooser.getSelectedFile();
            this.jTextFieldExportFolderPath.setText(folder.getAbsolutePath());
        }
    }
}

