/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import jsbugs.io.JPanelCSVOptions;
import jsbugs.uiutil.ComboboxItem;
import jsbugs.uiutil.JPanelWarnings;
import jsbugs.util.UserPrefsHelper;
import model3.InterpHdr;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import org.apache.commons.lang3.StringUtils;
import util.DepthUnits;
import util.FilePathUtils;
import util.SBException;
import util.gridwriter.CSVExportOptions;

public class DialogSampleDetailsExport
extends SBDialog {
    private static String TITLE = "Sample Details Export";
    private static String DEFAULT_FILE_NAME = "samples";
    private static int DIALOG_MIN_HEIGHT = 404;
    private static int WARNIGN_PANEL_HEIGHT = 132;
    private static FileNameExtensionFilter[] supportedFileTypes = new FileNameExtensionFilter[]{FileChooserUtils.EXCEL_FILTER, FileChooserUtils.CSV_FILTER, FileChooserUtils.LEGACY_EXCEL_FILTER};
    private final UserPrefsHelper prefs;
    private List<Well> wells;
    private static Logger log = Logger.getLogger(DialogSampleDetailsExport.class.getName());
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonCancel;
    private JButton jButtonFileBrowse;
    private JButton jButtonOk;
    private JCheckBox jCheckBoxIgnoreLogSamples;
    private JCheckBox jCheckBoxIncludeAnalysis;
    private JComboBox<ComboboxItem<InterpHdr>> jComboBoxInterpVersions;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanelCSVOptions jPanelCSVOptions;
    private JPanelWarnings jPanelWarnings;
    private JPanel jPanelWarningsContainer;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMeters;
    private JTextField jTextFieldFilePath;

    public DialogSampleDetailsExport(Frame parent, boolean modal, SBdb sbdb, char units, List<Well> wells, InterpHdr selectedInterp, Set<InterpHdr> interpVersions) {
        super(parent, modal);
        this.prefs = new UserPrefsHelper(sbdb);
        this.setTitle(TITLE);
        this.wells = wells;
        this.initComponents();
        this.setInitialUnits(units);
        this.setupDefaultPath();
        this.updateCSVExportOptionsEnabled();
        this.setpuInterpComboBox(selectedInterp, interpVersions);
        this.updateAnalysisCheckbox(interpVersions);
        this.updateWarnings();
    }

    private void updateAnalysisCheckbox(Set<InterpHdr> interpVersions) {
        if (interpVersions.isEmpty()) {
            this.jCheckBoxIncludeAnalysis.setEnabled(false);
            this.jComboBoxInterpVersions.setEnabled(false);
            this.jCheckBoxIncludeAnalysis.setSelected(false);
        } else {
            this.jCheckBoxIncludeAnalysis.setEnabled(true);
            this.jComboBoxInterpVersions.setEnabled(true);
            this.jCheckBoxIncludeAnalysis.setSelected(true);
        }
    }

    private void updateWarnings() {
        this.jPanelWarnings.clearWarnings();
        if (this.wells != null) {
            try {
                for (Well w : this.wells) {
                    if (!w.getSamples().isEmpty()) continue;
                    this.jPanelWarnings.addWarning("The well %s has no samples loaded.", w.getWellName());
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error reading well data", e);
                this.jPanelWarnings.addWarning("Error reading well data. " + e.getMessage());
            }
        }
        if (this.getSelectedInterpId() == null) {
            this.jPanelWarnings.addWarning("No interpretation version loaded, additional analysis output will be unavailable.");
        } else if (this.getIncludeAnalysisData()) {
            for (Well w : this.wells) {
                try {
                    if (this.checkStratigraphyDataPresent(w, this.getSelectedInterpId())) continue;
                    this.jPanelWarnings.addWarning("No stratigraphy data found for well %s", w.getWellName());
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Exception occurred while checking stratigraphy data for well " + w.getWellName() + "(" + w.getWellID() + ")", ex);
                }
            }
        }
        if (this.jPanelWarnings.hasWarnings()) {
            this.setMinimumSize(new Dimension(412, DIALOG_MIN_HEIGHT));
            this.jPanelWarningsContainer.setVisible(true);
        } else {
            this.setMinimumSize(new Dimension(412, DIALOG_MIN_HEIGHT - WARNIGN_PANEL_HEIGHT));
            if (this.jPanelWarningsContainer.isVisible()) {
                this.jPanelWarningsContainer.setVisible(false);
                this.setSize(this.getWidth(), this.getHeight() - WARNIGN_PANEL_HEIGHT);
                this.pack();
            }
        }
    }

    private void setupDefaultPath() {
        File f = this.prefs.getLastSampleDetailsFile();
        if (f != null && f.getParent() != null) {
            Object defaultName = f.getParent() + File.separator + this.getSuggestedFileName();
            defaultName = FilePathUtils.appendExtensionIfNeccesary((String)defaultName, (String)FilePathUtils.getFileExtension((String)f.getName()));
            this.jTextFieldFilePath.setText((String)defaultName);
        }
    }

    private String getSuggestedFileName() {
        if (this.wells.size() == 1) {
            return this.wells.get(0).getWellCode() + "_samples";
        }
        return DEFAULT_FILE_NAME;
    }

    public void setInitialUnits(char units) {
        if (units == DepthUnits.F.getChar()) {
            this.jRadioButtonFeet.setSelected(true);
        } else {
            this.jRadioButtonMeters.setSelected(true);
        }
    }

    public char getSelectedUnits() {
        if (this.jRadioButtonMeters.isSelected()) {
            return DepthUnits.M.getChar();
        }
        return DepthUnits.F.getChar();
    }

    public File getOutputFile() {
        String text = this.jTextFieldFilePath.getText();
        File f = null;
        if (!StringUtils.isEmpty((CharSequence)text)) {
            f = new File(text);
        }
        return f;
    }

    public CSVExportOptions getCSVSettings() {
        return this.jPanelCSVOptions.getSelectedOptions();
    }

    public boolean getIncludeAnalysisData() {
        return this.jCheckBoxIncludeAnalysis.isSelected();
    }

    public boolean getIgnoreLogSamples() {
        return this.jCheckBoxIgnoreLogSamples.isSelected();
    }

    private void updateCSVExportOptionsEnabled() {
        File f = this.getOutputFile();
        if (f == null) {
            return;
        }
        if (FilePathUtils.isFileExtension((String)f.getPath(), (String[])new String[]{"xls", "xlsx"})) {
            this.jPanelCSVOptions.setEnabled(false);
        } else {
            this.jPanelCSVOptions.setEnabled(true);
        }
    }

    private void setpuInterpComboBox(InterpHdr selectedInterp, Set<InterpHdr> interpVersions) {
        ArrayList<ComboboxItem<InterpHdr>> options = new ArrayList<ComboboxItem<InterpHdr>>();
        if (interpVersions.isEmpty()) {
            options.add(new ComboboxItem<InterpHdr>(null, "No Version Loaded"));
        } else {
            for (InterpHdr hdr : interpVersions) {
                options.add(new ComboboxItem<InterpHdr>(hdr, hdr.toString()));
            }
        }
        this.jComboBoxInterpVersions.setModel(new DefaultComboBoxModel<Object>(options.toArray()));
        if (selectedInterp != null) {
            for (int i = 0; i < this.jComboBoxInterpVersions.getItemCount(); ++i) {
                InterpHdr hdr;
                ComboboxItem<InterpHdr> item = this.jComboBoxInterpVersions.getItemAt(i);
                if (item == null || (hdr = item.getValue()) == null || hdr.getInterpID() != selectedInterp.getInterpID()) continue;
                this.jComboBoxInterpVersions.setSelectedIndex(i);
            }
        }
    }

    public Integer getSelectedInterpId() {
        ComboboxItem item = (ComboboxItem)this.jComboBoxInterpVersions.getSelectedItem();
        if (item.getValue() != null) {
            return ((InterpHdr)item.getValue()).getInterpID();
        }
        return null;
    }

    private boolean checkStratigraphyDataPresent(Well w, Integer selectedInterpId) throws SBException, SQLException {
        if (selectedInterpId == null) {
            return false;
        }
        WellInterp interp = w.getInterp(selectedInterpId);
        if (interp != null) {
            for (Sample s : w.getSamples()) {
                String stratigraphy;
                if (s.getType() == SampleType.LOG && this.getIgnoreLogSamples() || StringUtils.isEmpty((CharSequence)(stratigraphy = s.getStratigraphy(interp, false)))) continue;
                return true;
            }
        }
        return false;
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.jPanel7 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldFilePath = new JTextField();
        this.jPanel8 = new JPanel();
        this.jButtonFileBrowse = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jCheckBoxIncludeAnalysis = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jComboBoxInterpVersions = new JComboBox();
        this.jCheckBoxIgnoreLogSamples = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jRadioButtonMeters = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jPanelCSVOptions = new JPanelCSVOptions();
        this.jPanelWarningsContainer = new JPanel();
        this.jPanelWarnings = new JPanelWarnings();
        this.jPanel5 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setMinimumSize(new Dimension(412, 404));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.jPanel7.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel7.setLayout(new BoxLayout(this.jPanel7, 3));
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.jPanel6.setLayout(new BoxLayout(this.jPanel6, 2));
        this.jLabel1.setText("File :");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.jPanel6.add(this.jLabel1);
        this.jTextFieldFilePath.setEditable(false);
        this.jTextFieldFilePath.setBackground(new Color(255, 255, 204));
        this.jTextFieldFilePath.setMaximumSize(new Dimension(Integer.MAX_VALUE, 23));
        this.jTextFieldFilePath.setMinimumSize(new Dimension(6, 23));
        this.jPanel6.add(this.jTextFieldFilePath);
        this.jPanel8.setMaximumSize(new Dimension(4, 10));
        this.jPanel8.setMinimumSize(new Dimension(4, 10));
        this.jPanel8.setPreferredSize(new Dimension(4, 10));
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 4, Short.MAX_VALUE));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel6.add(this.jPanel8);
        this.jButtonFileBrowse.setText("...");
        this.jButtonFileBrowse.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleDetailsExport this$0;
            {
                DialogSampleDetailsExport dialogSampleDetailsExport = this$0;
                Objects.requireNonNull(dialogSampleDetailsExport);
                this.this$0 = dialogSampleDetailsExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFileBrowseActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButtonFileBrowse);
        this.jPanel7.add(this.jPanel6);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 3));
        this.jPanel4.setAlignmentX(0.0f);
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 2));
        this.jCheckBoxIncludeAnalysis.setText("Include sample analysis information");
        this.jCheckBoxIncludeAnalysis.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleDetailsExport this$0;
            {
                DialogSampleDetailsExport dialogSampleDetailsExport = this$0;
                Objects.requireNonNull(dialogSampleDetailsExport);
                this.this$0 = dialogSampleDetailsExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxIncludeAnalysisActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jCheckBoxIncludeAnalysis);
        this.jLabel3.setText("Version : ");
        this.jLabel3.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.jPanel4.add(this.jLabel3);
        this.jPanel4.add(this.jComboBoxInterpVersions);
        this.jPanel1.add(this.jPanel4);
        this.jCheckBoxIgnoreLogSamples.setText("Ignore LOG samples");
        this.jCheckBoxIgnoreLogSamples.setAlignmentX(-0.5f);
        this.jPanel1.add(this.jCheckBoxIgnoreLogSamples);
        this.jPanel7.add(this.jPanel1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Units", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, 46));
        this.jPanel2.setLayout(new FlowLayout(0, 5, 0));
        this.buttonGroupUnits.add(this.jRadioButtonMeters);
        this.jRadioButtonMeters.setText("Meters");
        this.jPanel2.add(this.jRadioButtonMeters);
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jPanel2.add(this.jRadioButtonFeet);
        this.jPanel7.add(this.jPanel2);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "CSV Export Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        this.jPanel3.setMinimumSize(new Dimension(212, 50));
        this.jPanel3.setName("");
        this.jPanel3.setPreferredSize(new Dimension(212, 50));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.jPanelCSVOptions, "Center");
        this.jPanel7.add(this.jPanel3);
        this.jPanelWarningsContainer.setBorder(BorderFactory.createTitledBorder(null, "Warnings", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelWarningsContainer.setLayout(new BorderLayout());
        this.jPanelWarningsContainer.add((Component)this.jPanelWarnings, "Center");
        this.jPanel7.add(this.jPanelWarningsContainer);
        this.jButtonOk.setText("Ok");
        this.jButtonOk.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleDetailsExport this$0;
            {
                DialogSampleDetailsExport dialogSampleDetailsExport = this$0;
                Objects.requireNonNull(dialogSampleDetailsExport);
                this.this$0 = dialogSampleDetailsExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleDetailsExport this$0;
            {
                DialogSampleDetailsExport dialogSampleDetailsExport = this$0;
                Objects.requireNonNull(dialogSampleDetailsExport);
                this.this$0 = dialogSampleDetailsExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGap(0, 333, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOk))));
        this.jPanel7.add(this.jPanel5);
        this.getContentPane().add(this.jPanel7);
        this.pack();
    }

    private void jButtonFileBrowseActionPerformed(ActionEvent evt) {
        String suggestedName;
        File lastFile = this.getOutputFile();
        if (lastFile == null) {
            if (this.prefs.getLastSampleDetailsFile() != null) {
                lastFile = this.prefs.getLastSampleDetailsFile();
            }
            suggestedName = this.getSuggestedFileName();
        } else {
            suggestedName = FilePathUtils.extractFileNameWithoutExtension((String)lastFile.getName());
        }
        File f = FileChooserUtils.saveAsDialogWithFilters((Component)((Object)this), (String)(lastFile != null ? lastFile.getPath() : null), (String)suggestedName, (FileNameExtensionFilter[])supportedFileTypes);
        if (f != null) {
            this.jTextFieldFilePath.setText(f.getPath());
            this.updateCSVExportOptionsEnabled();
        }
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.prefs.setLastSampleDetailsFile(new File(this.jTextFieldFilePath.getText()));
        this.setIsOK(true);
        this.setVisible(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setIsOK(false);
        this.setVisible(false);
    }

    private void jCheckBoxIncludeAnalysisActionPerformed(ActionEvent evt) {
        this.updateWarnings();
    }
}

