/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import com.stratadata.model3.user.Userdef;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model3.IGDIntervalZone;
import model3.Sample;
import model3.Well;
import util.gridwriter.CellFormat;
import util.gridwriter.GridSheet;

public class GridBuilderIGDZones {
    private boolean useCoreSampleCorrections = false;
    private boolean useCuttingSampleCorrections = false;
    String[] prefix = new String[]{"early", "middle", "late", "mid", "upper", "lower"};

    public Object[][] exportZonesToStandardGrid(Well well, List<IGDIntervalZone> zones, char units) {
        GridSheet builder = new GridSheet();
        for (IGDIntervalZone zone : zones) {
            builder.addRow();
            builder.append(new Object[]{zone.toString()});
            builder.append(new Object[]{this.getSampleDepth(well, zone.getTopSample(), units)});
            builder.append(new Object[]{zone.getTopSample().getType().getAbr()});
            builder.append(new Object[]{zone.getTopBnd()});
            builder.append(new Object[]{this.getSampleDepth(well, zone.getBaseSample(), units)});
            builder.append(new Object[]{zone.getBaseSample().getType().getAbr()});
            builder.append(new Object[]{zone.getBaseBnd()});
        }
        return builder.getObjectArray();
    }

    public Object[][] exportZonesToOpenWorksStyleGrid(Well well, List<IGDIntervalZone> zones, char units) {
        GridSheet builder = new GridSheet();
        for (IGDIntervalZone zone : zones) {
            Object zoneName = zone.toString();
            for (String prefix1 : this.prefix) {
                if (!((String)zoneName).toLowerCase().startsWith(prefix1 + " ") || ((String)zoneName).toLowerCase().startsWith(prefix1 + " -")) continue;
                String suffix = ((String)zoneName).substring(0, prefix1.length());
                zoneName = ((String)zoneName).substring(suffix.length() + 1) + " " + suffix;
                break;
            }
            builder.addRow(new Object[]{(String)zoneName + " Top"});
            builder.append(new Object[]{this.getSampleDepth(well, zone.getTopSample(), units)});
            builder.append(new Object[]{"BIOSTRAT"});
            builder.addRow(new Object[]{(String)zoneName + " Base"});
            builder.append(new Object[]{this.getSampleDepth(well, zone.getBaseSample(), units)});
            builder.append(new Object[]{"BIOSTRAT"});
        }
        return builder.getObjectArray();
    }

    public Object[][] exportZonesToExtendedOpenWorksStyleGrid(Well well, List<IGDIntervalZone> zones, char units) {
        GridSheet builder = new GridSheet();
        builder.addRow(new Object[]{new CellFormat().setBold(true), "Well name", "Pick", "Interp", "Obs", "Depth (" + Character.toLowerCase(units) + " MD)", "Confidence", "Qualifier", "Remarks", "Interval Remarks", "Source"});
        HashMap<String, Integer> obs = new HashMap<String, Integer>();
        for (IGDIntervalZone zone : zones) {
            String wellName = well.getWellName();
            Object zoneName = zone.toString();
            for (String prefix1 : this.prefix) {
                if (!((String)zoneName).toLowerCase().startsWith(prefix1 + " ") || ((String)zoneName).toLowerCase().startsWith(prefix1 + " -")) continue;
                String suffix = ((String)zoneName).substring(0, prefix1.length());
                zoneName = ((String)zoneName).substring(suffix.length() + 1) + " " + suffix;
                break;
            }
            Userdef modifier = null;
            try {
                modifier = well.getDataModel().getUser(zone.getModifier());
            }
            catch (SQLException ex) {
                Logger.getLogger(GridBuilderIGDZones.class.getName()).log(Level.SEVERE, "Error getting modifier for well " + wellName + " and zone " + (String)zoneName, ex);
            }
            String modifierAbr = modifier != null ? modifier.getAbr() : "BIOS";
            int obsNumber = 0;
            if (obs.get(zoneName) != null) {
                obsNumber = (Integer)obs.get(zoneName);
            }
            obs.put((String)zoneName, ++obsNumber);
            builder.addRow(new Object[]{wellName});
            builder.append(new Object[]{(String)zoneName + " Top"});
            builder.append(new Object[]{"BIOS"});
            builder.append(new Object[]{obsNumber});
            builder.append(new Object[]{this.getSampleDepth(well, zone.getTopSample(), units)});
            builder.append(new Object[]{this.getOWConfidenceString(zone.getTopBndInt())});
            builder.append(new Object[]{this.getOWQualifierString(zone.getTopBndInt())});
            builder.append(new Object[]{modifierAbr});
            builder.append(new Object[]{zone.toString()});
            builder.append(new Object[]{"SBUGS"});
            builder.addRow(new Object[]{wellName});
            builder.append(new Object[]{(String)zoneName + " Base"});
            builder.append(new Object[]{"BIOS"});
            builder.append(new Object[]{obsNumber});
            builder.append(new Object[]{this.getSampleDepth(well, zone.getBaseSample(), units)});
            builder.append(new Object[]{this.getOWConfidenceString(zone.getBaseBndInt())});
            builder.append(new Object[]{this.getOWQualifierString(zone.getBaseBndInt())});
            builder.append(new Object[]{modifierAbr});
            builder.append(new Object[]{zone.toString()});
            builder.append(new Object[]{"SBUGS"});
        }
        return builder.getObjectArray();
    }

    private String getOWConfidenceString(int bnd) {
        switch (bnd) {
            default: {
                return "";
            }
            case 3: {
                return "G";
            }
            case 2: {
                return "F";
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
        return "P";
    }

    private String getOWQualifierString(int bnd) {
        switch (bnd) {
            default: {
                return "";
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
        return "ER";
    }

    private Double getSampleDepth(Well well, Sample sample, char units) {
        if (!sample.hasDepth()) {
            return null;
        }
        Double depth = sample.getDepth(units);
        return this.correctSampleDepth(depth, sample, well);
    }

    private Double correctSampleDepth(Double depth, Sample sample, Well well) {
        if (depth == null) {
            return null;
        }
        if (sample.getType().correctDepth(this.useCoreSampleCorrections, this.useCuttingSampleCorrections)) {
            try {
                return well.getCorrectedDepth(depth);
            }
            catch (SQLException ex) {
                Logger.getLogger(GridBuilderIGDZones.class.getName()).log(Level.SEVERE, "Failed to get corrected depth for well " + well.getWellName(), ex);
                return null;
            }
        }
        return depth;
    }

    public boolean getUseCoreSampleCorrections() {
        return this.useCoreSampleCorrections;
    }

    public void setUseCoreSampleCorrections(boolean value) {
        this.useCoreSampleCorrections = value;
    }

    public boolean getUseCuttingSampleCorrections() {
        return this.useCuttingSampleCorrections;
    }

    public void setUseCuttingSampleCorrections(boolean value) {
        this.useCuttingSampleCorrections = value;
    }
}

