/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import util.SbugsFileFilter;

public enum ImageFileType {
    PDF("pdf", true),
    SVG("svg", true),
    PNG("png", false),
    GIF("gif", false),
    JPG("jpg", false),
    TIF("tif", false);

    private final boolean vector;
    private final String extension;
    private final SbugsFileFilter filter;

    private ImageFileType(String extension, boolean vector) {
        this.vector = vector;
        this.extension = extension;
        this.filter = new SbugsFileFilter(extension.toLowerCase(), extension.toUpperCase());
    }

    public String getExtension() {
        return this.extension;
    }

    public SbugsFileFilter getFilter() {
        return this.filter;
    }

    public boolean isVector() {
        return this.vector;
    }

    public static ImageFileType getType(String ex) {
        for (ImageFileType type : ImageFileType.values()) {
            if (!ex.equalsIgnoreCase(type.getExtension())) continue;
            return type;
        }
        return null;
    }

    public static SbugsFileFilter getDefaultFilter(boolean vector) {
        if (vector) {
            return PDF.getFilter();
        }
        return JPG.getFilter();
    }
}

