/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import com.stratadata.util.depth.DepthUnits;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import model3.IGDIntervalEnv;
import model3.IGDIntervalZone;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import util.SBException;

public class JsonExport {
    String title = "StrataBugs interpretation";
    Date date = Calendar.getInstance().getTime();
    List<JsonWell> wells = new LinkedList<JsonWell>();

    public JsonExport(List<Well> wells, int interpID, Set<Integer> dataTypes) throws SBException {
        for (Well well : wells) {
            JsonWell jsWell = new JsonWell(this);
            this.wells.add(jsWell);
            jsWell.wellName = well.getWellName();
            jsWell.wellCode = well.getWellCode();
            jsWell.td = well.getTD();
            char units = well.getHeader().getWellUnits();
            jsWell.depthUnits = DepthUnits.getUnits((char)units).getFullName();
            block7: for (Integer dataType : dataTypes) {
                switch (dataType) {
                    case 10: {
                        jsWell.chronostratigraphy = new LinkedList<JsonChrono>();
                        WellInterp wellInterp = well.getInterp(interpID);
                        List<IGDIntervalZone> chrono = wellInterp.getIGDList(3);
                        for (IGDIntervalZone iGDIntervalZone : chrono) {
                            JsonChrono jsChrono = new JsonChrono(this);
                            jsChrono.topDepth = iGDIntervalZone.getTopSample().getDepth(units);
                            jsChrono.topSampleType = iGDIntervalZone.getTopSample().getTypeString();
                            jsChrono.topBoundaryType = iGDIntervalZone.getTopBnd();
                            jsChrono.baseDepth = iGDIntervalZone.getBaseSample().getDepth(units);
                            jsChrono.baseSampleType = iGDIntervalZone.getBaseSample().getTypeString();
                            jsChrono.baseBoundaryType = iGDIntervalZone.getBaseBnd();
                            jsChrono.intervalName = iGDIntervalZone.getNameString();
                            jsWell.chronostratigraphy.add(jsChrono);
                        }
                        continue block7;
                    }
                    case 12: {
                        jsWell.lithostratigraphy = new LinkedList<JsonLithostrat>();
                        WellInterp wellInterp = well.getInterp(interpID);
                        List<IGDIntervalZone> lstrat = wellInterp.getIGDList(2);
                        for (IGDIntervalZone iGDIntervalZone : lstrat) {
                            JsonLithostrat jsLithostrat = new JsonLithostrat(this);
                            jsLithostrat.topDepth = iGDIntervalZone.getTopSample().getDepth(units);
                            jsLithostrat.topSampleType = iGDIntervalZone.getTopSample().getTypeString();
                            jsLithostrat.topBoundaryType = iGDIntervalZone.getTopBnd();
                            jsLithostrat.baseDepth = iGDIntervalZone.getBaseSample().getDepth(units);
                            jsLithostrat.baseSampleType = iGDIntervalZone.getBaseSample().getTypeString();
                            jsLithostrat.baseBoundaryType = iGDIntervalZone.getBaseBnd();
                            jsLithostrat.intervalName = iGDIntervalZone.getNameString();
                            jsWell.lithostratigraphy.add(jsLithostrat);
                        }
                        continue block7;
                    }
                    case 15: {
                        jsWell.palaeoenvironments = new LinkedList<JsonEnv>();
                        WellInterp wellInterp = well.getInterp(interpID);
                        List<IGDIntervalEnv> envs = wellInterp.getEnvs();
                        for (IGDIntervalEnv iGDIntervalEnv : envs) {
                            JsonEnv jsEnv = new JsonEnv(this);
                            jsEnv.topDepth = iGDIntervalEnv.getTopSample().getDepth(units);
                            jsEnv.topSampleType = iGDIntervalEnv.getTopSample().getTypeString();
                            jsEnv.baseDepth = iGDIntervalEnv.getBaseSample().getDepth(units);
                            jsEnv.baseSampleType = iGDIntervalEnv.getBaseSample().getTypeString();
                            jsEnv.environment = iGDIntervalEnv.toString();
                            jsWell.palaeoenvironments.add(jsEnv);
                        }
                        continue block7;
                    }
                    case 16: {
                        jsWell.events = new LinkedList<JsonEvent>();
                        WellInterp wellInterp = well.getInterp(interpID);
                        List<WellEvent> events = wellInterp.getEventsByDepth();
                        for (WellEvent wellEvent : events) {
                            JsonEvent jsEvent = new JsonEvent(this);
                            jsEvent.depth = wellEvent.getSample().getDepth(units);
                            jsEvent.sampleType = wellEvent.getSample().getTypeString();
                            jsEvent.eventType = wellEvent.getType();
                            jsEvent.bioevent = wellEvent.toString(false, false, false);
                            jsWell.events.add(jsEvent);
                        }
                        continue block7;
                    }
                    default: {
                        System.out.println("Data type: " + dataType + " not supported");
                    }
                }
            }
        }
    }

    class JsonWell {
        String wellName;
        String wellCode;
        double td;
        String depthUnits;
        List<JsonChrono> chronostratigraphy;
        List<JsonLithostrat> lithostratigraphy;
        List<JsonEnv> palaeoenvironments;
        List<JsonEvent> events;

        JsonWell(JsonExport this$0) {
            Objects.requireNonNull(this$0);
            this.chronostratigraphy = null;
            this.lithostratigraphy = null;
            this.palaeoenvironments = null;
            this.events = null;
        }
    }

    class JsonChrono {
        double topDepth;
        String topSampleType;
        String topBoundaryType;
        double baseDepth;
        String baseSampleType;
        String baseBoundaryType;
        String intervalName;

        JsonChrono(JsonExport this$0) {
            Objects.requireNonNull(this$0);
        }
    }

    class JsonLithostrat {
        double topDepth;
        String topSampleType;
        String topBoundaryType;
        double baseDepth;
        String baseSampleType;
        String baseBoundaryType;
        String intervalName;

        JsonLithostrat(JsonExport this$0) {
            Objects.requireNonNull(this$0);
        }
    }

    class JsonEnv {
        double topDepth;
        String topSampleType;
        double baseDepth;
        String baseSampleType;
        String environment;

        JsonEnv(JsonExport this$0) {
            Objects.requireNonNull(this$0);
        }
    }

    class JsonEvent {
        double depth;
        String sampleType;
        String eventType;
        String bioevent;

        JsonEvent(JsonExport this$0) {
            Objects.requireNonNull(this$0);
        }
    }
}

