/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.TaxonOcc;
import model3.Well;
import org.apache.commons.lang3.StringUtils;
import util.DepthUnits;
import util.ITextWriter;
import util.SBException;
import util.gridwriter.GridBuilder;

public class OrganiserReportWriter {
    private static Logger log = Logger.getLogger(OrganiserReportWriter.class.getName());
    private DateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
    private char units = (char)77;
    private final SBdb db;
    private boolean includeEmptySamples = false;

    public OrganiserReportWriter(SBdb db) {
        this.db = db;
    }

    public char getUnits() {
        return this.units;
    }

    public void setUnits(char units) {
        this.units = units;
    }

    public void setIncludeEmptySamples(boolean value) {
        this.includeEmptySamples = value;
    }

    public void writeReport(ITextWriter writer, List<Well> wells, String currentUser, Date reportDate) throws IOException, SBException, SQLException {
        this.writeReportHeader(writer, currentUser, reportDate);
        writer.writeHR();
        for (Well w : wells) {
            this.writeWellHeader(writer, w);
            writer.writeHR();
            this.writeSampleAnalysisSummary(w, writer);
            writer.writeHR();
            this.writeSampleAnalysisDetails(w, writer);
            writer.writeHR();
        }
    }

    void writeSampleAnalysisDetails(Well w, ITextWriter writer) throws SQLException, SBException, IOException {
        for (Discipline d : Arrays.asList(Discipline.MACRO, Discipline.MICRO, Discipline.NANNO, Discipline.PALY)) {
            for (Sample s : w.getSamples()) {
                for (Smpdtl a : s.getAnalysesCopy()) {
                    if (a.getDiscipline() != d) continue;
                    if (this.isSimpleAnalysis(a)) {
                        this.writeAnalysisDetails(writer, w, s, a, DisplayCountDetails.SingleCount, this.hasSemiQuantData(a));
                        continue;
                    }
                    this.writeAnalysisDetails(writer, w, s, a, DisplayCountDetails.SplitCounts, this.hasSemiQuantData(a));
                }
            }
        }
    }

    private boolean hasSemiQuantData(Smpdtl a) {
        if (a.getHeader().getAbnSchID() == 0) {
            return false;
        }
        return a.hasSemiQuantData();
    }

    private boolean isSimpleAnalysis(Smpdtl a) {
        if (a.getWeight() != 0.0f || a.getCoarse() != 0.0f || a.getMedium() != 0.0f || a.getFine() != 0.0f) {
            return false;
        }
        return !a.hasSplitCountData();
    }

    private void writeAnalysisDetails(ITextWriter writer, Well w, Sample s, Smpdtl a, DisplayCountDetails countDisplay, boolean includeSubjectAbundance) throws SBException, SQLException, IOException {
        String headingFormat = "Sample: %1$s %2$s %3$s";
        if (countDisplay == DisplayCountDetails.SplitCounts) {
            headingFormat = "Sample: %1$s %2$s %3$s Weight:%4$5.2f Coarse:%5$5.2f Medium:%6$5.2f Fine:%7$5.2f";
        }
        writer.writeLine((Object)String.format(headingFormat, this.getSampleDepthString(w, s), s.getTypeString(), s.getLabel(), Float.valueOf(a.getWeight()), Float.valueOf(a.getCoarse()), Float.valueOf(a.getMedium()), Float.valueOf(a.getFine())));
        writer.writeLine((Object)("Analysis " + a.getAnalyNo() + " " + a.getAnalystAbr()));
        writer.writeLine();
        GridBuilder gb = new GridBuilder();
        gb.addRow(new Object[]{"Cat.", "Species name", "Rw.", "?", "Cv."});
        if (includeSubjectAbundance || countDisplay == DisplayCountDetails.SubCount) {
            gb.append(new Object[]{"Ab."});
        }
        if (countDisplay == DisplayCountDetails.SplitCounts) {
            gb.append(new Object[]{"Cse.", "Med.", "Fin.", "Tot."});
        } else if (!includeSubjectAbundance) {
            gb.append(new Object[]{"Count."});
        }
        gb.append(new Object[]{"%"});
        gb.addRow();
        int totalCount = this.getAnalysisTotalCount(a);
        for (TaxonOcc occ : a.getOccurSorted()) {
            String taxonName = StringUtils.rightPad((String)(occ.getTaxon().toString(false, false, false) + " "), (int)50, (char)'_');
            gb.addRow(new Object[]{occ.getTaxon().getCatMnem(), taxonName, occ.getReworked() ? "Y" : "", occ.getQuestionable() ? "Y" : "", occ.getCaved() ? "Y" : ""});
            if (includeSubjectAbundance || countDisplay == DisplayCountDetails.SubCount) {
                gb.append(new Object[]{occ.getSubAbund()});
            }
            int occTotal = this.getOccurrenceDerivedCount(occ, a);
            if (countDisplay == DisplayCountDetails.SplitCounts) {
                gb.append(new Object[]{occ.getCoarse(), occ.getMedium(), occ.getFine(), occTotal});
            } else if (!includeSubjectAbundance) {
                gb.append(new Object[]{occTotal});
            }
            String percentage = String.format("%.1f", Float.valueOf((float)occTotal / (float)totalCount * 100.0f));
            gb.append(new Object[]{percentage});
        }
        writer.writeTable(gb.getDataArray());
        writer.writeLine((Object)(StringUtils.leftPad((String)"Taxa: ", (int)51, (char)' ') + String.format("%4d", a.getOccurUnsorted().size())));
        writer.writeLine((Object)(StringUtils.leftPad((String)"Total counts: ", (int)51, (char)' ') + String.format("%4d", totalCount)));
        if (countDisplay == DisplayCountDetails.SplitCounts) {
            writer.writeLine((Object)(StringUtils.leftPad((String)"Weighted counts: ", (int)51, (char)' ') + String.format("%7.2f", this.getAnalysisTotalWeighted(a))));
        }
        writer.writeLine();
    }

    int getAnalysisTotalCount(Smpdtl a) throws SQLException {
        int totalCount = 0;
        for (TaxonOcc occ : a.getOccurUnsorted()) {
            totalCount += this.getOccurrenceDerivedCount(occ, a);
        }
        return totalCount;
    }

    double getAnalysisTotalWeighted(Smpdtl a) throws SQLException {
        double total = 0.0;
        for (TaxonOcc occ : a.getOccurUnsorted()) {
            total += this.getWeightedDerivedCount(occ, a);
        }
        return total;
    }

    int getOccurrenceDerivedCount(TaxonOcc occ, Smpdtl a) {
        AbundanceScheme abundanceScheme = this.db.getAbundanceSchemeService().findAbundanceScheme(a.getHeader().getAbnSchID()).orElse(null);
        int occTotal = occ.getDerivedCount(abundanceScheme);
        return occTotal;
    }

    double getWeightedDerivedCount(TaxonOcc occ, Smpdtl a) {
        AbundanceScheme abundanceScheme = this.db.getAbundanceSchemeService().findAbundanceScheme(a.getHeader().getAbnSchID()).orElse(null);
        return occ.getDerivedCount(abundanceScheme, a.getCoarse(), a.getMedium(), a.getFine());
    }

    void writeWellHeader(ITextWriter writer, Well w) throws IOException {
        writer.writeLine((Object)("Well Name: " + w.getWellName()));
    }

    void writeReportHeader(ITextWriter writer, String currentUser, Date reportDate) throws IOException {
        writer.writeHeader((Object)"StrataBugs report");
        writer.writeLine((Object)("Produced by : " + currentUser));
        writer.writeLine((Object)("Date : " + this.df.format(reportDate)));
        writer.writeLine((Object)"Core depth values are not corrected to loggers depth");
    }

    void writeSampleAnalysisSummary(Well w, ITextWriter writer) throws IOException, SBException, SQLException {
        if (this.includeEmptySamples) {
            GridBuilder emptySamplesTable = new GridBuilder();
            emptySamplesTable.addRow(new Object[]{"Depth", "Type", "Label"});
            boolean samplesWithoutAnalysisFound = false;
            for (Sample s : w.getSamples()) {
                if (!s.getAnalysesCopy().isEmpty()) continue;
                samplesWithoutAnalysisFound = true;
                emptySamplesTable.addRow(new Object[]{this.getPaddedSampleDepthString(w, s), s.getTypeString(), s.getLabel()});
            }
            if (samplesWithoutAnalysisFound) {
                writer.writeLine((Object)"Samples without any analysis");
                writer.writeTable(emptySamplesTable.getDataArray());
                writer.writeLine();
            }
        }
        for (Discipline d : Arrays.asList(Discipline.MACRO, Discipline.MICRO, Discipline.NANNO, Discipline.PALY)) {
            boolean samplesFound = false;
            GridBuilder b = new GridBuilder();
            b.addRow(new Object[]{"Depth", "Type", "Label", "Anlst.", "Pickr.", "Src.", "Date modified", "Modifier", "?Barren"});
            for (Sample s : w.getSamples()) {
                for (Smpdtl a : s.getAnalysesCopy()) {
                    if (!a.getDiscipline().equals((Object)d)) continue;
                    samplesFound = true;
                    b.addRow(new Object[]{this.getPaddedSampleDepthString(w, s), s.getTypeString(), s.getLabel(), a.getAnalystAbr(), a.getPicker(), a.getSource(), this.df.format(a.getUpdated()), a.getModifierID(), a.getBarren() ? "Y" : "N"});
                }
            }
            if (!samplesFound) continue;
            writer.writeLine((Object)(d.getNoun() + " Samples"));
            writer.writeTable(b.getDataArray());
            writer.writeLine();
        }
    }

    private String getPaddedSampleDepthString(Well w, Sample s) throws SBException {
        String sampleDepth = "";
        char prefUnits = w.getPrefUnits(this.units);
        String unitAbr = DepthUnits.getUnits((char)prefUnits).getAbr();
        if (s.hasTopDepth() && s.hasBaseDepth()) {
            double top = s.getTopDepth(prefUnits);
            double base = s.getBaseDepth(prefUnits);
            sampleDepth = String.format("%7.2f - %7.2f%s", top, base, unitAbr);
        } else if (s.hasTopDepth()) {
            double top = s.getTopDepth(prefUnits);
            sampleDepth = String.format("%7.2f%s          ", top, unitAbr);
        } else if (s.hasBaseDepth()) {
            double base = s.getBaseDepth(prefUnits);
            sampleDepth = String.format("          %7.2f%s", base, unitAbr);
        }
        return sampleDepth;
    }

    private String getSampleDepthString(Well w, Sample s) throws SBException {
        String sampleDepth = "";
        char prefUnits = w.getPrefUnits(this.units);
        String unitAbr = DepthUnits.getUnits((char)prefUnits).getAbr();
        if (s.hasTopDepth() && s.hasBaseDepth()) {
            double top = s.getTopDepth(prefUnits);
            double base = s.getBaseDepth(prefUnits);
            sampleDepth = String.format("%.2f - %.2f%s", top, base, unitAbr);
        } else if (s.hasTopDepth()) {
            double top = s.getTopDepth(prefUnits);
            sampleDepth = String.format("%.2f%s", top, unitAbr);
        } else if (s.hasBaseDepth()) {
            double base = s.getBaseDepth(prefUnits);
            sampleDepth = String.format("%.2f%s", base, unitAbr);
        }
        return sampleDepth;
    }

    private static enum DisplayCountDetails {
        SplitCounts,
        SingleCount,
        SubCount;

    }
}

