/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.analysis;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jsbugs.io.analysis.AnalysisOccurrenceCategory;
import jsbugs.io.analysis.OccurrenceCollection;
import jsbugs.io.analysis.TaxonOccurrenceCategory;
import model3.TaxonOcc;
import org.apache.commons.lang3.StringUtils;
import util.SBException;
import util.gridwriter.CellDataFormat;
import util.gridwriter.CellFormat;
import util.gridwriter.GridCell;
import util.gridwriter.IGridBuilder;

public class GridBuilderAnalysis {
    private boolean showQualifiers = false;
    private boolean includeSampleType = false;
    private boolean includeSampleLabel = false;
    private boolean includeAnalyst = false;
    private boolean includeSampleSatatus = false;
    private boolean includeDepthRange = false;
    private boolean includeTaxaSpeciesCodes = false;
    private boolean includeTotalsWithPercentage = false;
    private boolean includeGroupInfo = false;
    private boolean includeCategory = true;
    private boolean includeZeroValuesInOutput = false;
    private boolean rotateHeaderText = false;
    private boolean addQualifiersAsComments = false;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private OutputData outputData = OutputData.AbsoluteAbundance;
    private static final char PRESENT_WITH_NO_ABN_SCHEME = '+';
    private static final CellFormat PERCENT_FORMAT = new CellFormat().setDataFormat(CellDataFormat.Percent3DP);
    private static final CellFormat DEPTH_FORMAT = new CellFormat().setDataFormat(CellDataFormat.Fixed2DP);
    private static final CellFormat ROTATED_COLUMNS_HEADER_FORMAT = new CellFormat().setTextRotation((short)90);
    private static final CellFormat COLUMNS_HEADER_FORMAT = new CellFormat().setTextRotation((short)0);

    public void buildGridWithTaxaColumns(IGridBuilder gb, OccurrenceCollection data) throws SQLException, SBException {
        List<String> analysisLabels = this.buildAnalysisLabels();
        gb.appendFormatted(this.getHeaderFormat(), analysisLabels.toArray());
        for (TaxonOccurrenceCategory taxonCat : data.getTaxonCategories()) {
            gb.appendFormatted(this.getHeaderFormat(), new Object[]{taxonCat.getTitle()});
        }
        gb.addRow();
        if (this.includeCategory) {
            gb.appendEmpty(analysisLabels.size());
            for (TaxonOccurrenceCategory taxonCat : data.getTaxonCategories()) {
                gb.append(new Object[]{taxonCat.getCategory()});
            }
            gb.addRow();
        }
        if (this.includeTaxaSpeciesCodes) {
            gb.appendEmpty(analysisLabels.size());
            for (TaxonOccurrenceCategory taxonCat : data.getTaxonCategories()) {
                gb.append(new Object[]{taxonCat.getCode()});
            }
            gb.addRow();
        }
        if (this.includeGroupInfo) {
            gb.appendEmpty(analysisLabels.size());
            for (TaxonOccurrenceCategory taxonCat : data.getTaxonCategories()) {
                gb.append(new Object[]{taxonCat.getSetName()});
            }
            gb.addRow();
            gb.appendEmpty(analysisLabels.size());
            for (TaxonOccurrenceCategory taxonCat : data.getTaxonCategories()) {
                gb.append(new Object[]{taxonCat.getGroupName()});
            }
            gb.addRow();
        }
        Map<AnalysisOccurrenceCategory, Integer> totalCount = this.buildTotalHashMap(data);
        for (AnalysisOccurrenceCategory analysisCat : data.getAnalysisCategories()) {
            if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.TOP)) {
                gb.appendFormatted(DEPTH_FORMAT, new Object[]{analysisCat.getTopDepth()});
            }
            if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.BASE)) {
                gb.appendFormatted(DEPTH_FORMAT, new Object[]{analysisCat.getBaseDepth()});
            }
            if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.DEPTH)) {
                gb.appendFormatted(DEPTH_FORMAT, new Object[]{analysisCat.getDepth()});
            }
            if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.TYPE)) {
                gb.append(new Object[]{analysisCat.getType()});
            }
            if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.ANALYST)) {
                gb.append(new Object[]{analysisCat.getAnalyst()});
            }
            if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.LABEL)) {
                gb.append(new Object[]{analysisCat.getLabel()});
            }
            if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.STATUS)) {
                gb.append(new Object[]{analysisCat.getStatus()});
            }
            if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.TOTAL)) {
                gb.append(new Object[]{totalCount.get(analysisCat)});
            }
            AbundanceScheme abnScheme = analysisCat.getAbundanceScheme();
            for (TaxonOccurrenceCategory taxonCat : data.getTaxonCategories()) {
                List<TaxonOcc> occs = data.getOccurrences(analysisCat, taxonCat);
                Object result = this.buildOccurrenceResult(occs, abnScheme, totalCount, analysisCat);
                this.appendResultToGrid(occs, gb, result);
            }
            gb.addRow();
        }
    }

    public void buildGridWithAnalysisColumns(IGridBuilder gb, OccurrenceCollection data) throws SQLException, SBException {
        List<String> analysisLabels = this.buildAnalysisLabels();
        int numToSkip = 1;
        boolean titleAdded = false;
        titleAdded = this.addAnalysisHeaderRow(AnalysisOccurrenceCategory.HEADERS.TOP, gb, analysisLabels, data, titleAdded, numToSkip, true);
        titleAdded = this.addAnalysisHeaderRow(AnalysisOccurrenceCategory.HEADERS.BASE, gb, analysisLabels, data, titleAdded, numToSkip, true);
        titleAdded = this.addAnalysisHeaderRow(AnalysisOccurrenceCategory.HEADERS.DEPTH, gb, analysisLabels, data, titleAdded, numToSkip, true);
        titleAdded = this.addAnalysisHeaderRow(AnalysisOccurrenceCategory.HEADERS.ANALYST, gb, analysisLabels, data, titleAdded, numToSkip, false);
        titleAdded = this.addAnalysisHeaderRow(AnalysisOccurrenceCategory.HEADERS.TYPE, gb, analysisLabels, data, titleAdded, numToSkip, false);
        titleAdded = this.addAnalysisHeaderRow(AnalysisOccurrenceCategory.HEADERS.LABEL, gb, analysisLabels, data, titleAdded, numToSkip, false);
        titleAdded = this.addAnalysisHeaderRow(AnalysisOccurrenceCategory.HEADERS.STATUS, gb, analysisLabels, data, titleAdded, numToSkip, false);
        Map<AnalysisOccurrenceCategory, Integer> totalCount = this.buildTotalHashMap(data);
        if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.TOTAL)) {
            this.addAnalysisHeadersTotalsRow(gb, data, totalCount, titleAdded, numToSkip);
        }
        for (TaxonOccurrenceCategory taxonCat : data.getTaxonCategories()) {
            gb.append(new Object[]{taxonCat.getTitle()});
            if (this.includeCategory) {
                gb.append(new Object[]{taxonCat.getCategory()});
            } else {
                gb.append();
            }
            for (AnalysisOccurrenceCategory analysisCat : data.getAnalysisCategories()) {
                List<TaxonOcc> occurrences = data.getOccurrences(analysisCat, taxonCat);
                Object result = this.buildOccurrenceResult(occurrences, analysisCat.getAbundanceScheme(), totalCount, analysisCat);
                this.appendResultToGrid(occurrences, gb, result);
            }
            gb.addRow();
        }
    }

    public void buildGridWithIndividualRows(IGridBuilder gb, OccurrenceCollection data) throws SQLException, SBException {
        List<String> analysisLabels = this.buildAnalysisLabels();
        Map<AnalysisOccurrenceCategory, Integer> totalCount = this.buildTotalHashMap(data);
        gb.appendFormatted(this.getHeaderFormat(), analysisLabels.toArray());
        gb.addRow();
        for (AnalysisOccurrenceCategory analysisCat : data.getAnalysisCategories()) {
            for (TaxonOccurrenceCategory taxonCat : data.getTaxonCategories()) {
                List<TaxonOcc> occurrences = data.getOccurrences(analysisCat, taxonCat);
                Object result = this.buildOccurrenceResult(occurrences, analysisCat.getAbundanceScheme(), totalCount, analysisCat);
                if (result == null) continue;
                if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.TOP)) {
                    gb.appendFormatted(DEPTH_FORMAT, new Object[]{analysisCat.getTopDepth()});
                }
                if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.BASE)) {
                    gb.appendFormatted(DEPTH_FORMAT, new Object[]{analysisCat.getBaseDepth()});
                }
                if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.DEPTH)) {
                    gb.appendFormatted(DEPTH_FORMAT, new Object[]{analysisCat.getDepth()});
                }
                if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.TYPE)) {
                    gb.append(new Object[]{analysisCat.getType()});
                }
                if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.ANALYST)) {
                    gb.append(new Object[]{analysisCat.getAnalyst()});
                }
                if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.LABEL)) {
                    gb.append(new Object[]{analysisCat.getLabel()});
                }
                if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.STATUS)) {
                    gb.append(new Object[]{analysisCat.getStatus()});
                }
                if (analysisLabels.contains(AnalysisOccurrenceCategory.HEADERS.TOTAL)) {
                    gb.append(new Object[]{totalCount.get(analysisCat)});
                }
                gb.append(new Object[]{taxonCat.getTitle()});
                if (this.includeCategory) {
                    gb.append(new Object[]{taxonCat.getCategory()});
                }
                if (this.includeTaxaSpeciesCodes) {
                    gb.append(new Object[]{taxonCat.getCode()});
                }
                if (this.includeGroupInfo) {
                    gb.append(new Object[]{taxonCat.getSetName()});
                    gb.append(new Object[]{taxonCat.getGroupName()});
                }
                this.appendResultToGrid(occurrences, gb, result);
                gb.addRow();
            }
        }
    }

    private boolean addAnalysisHeaderRow(String headerName, IGridBuilder gb, List<String> analysisLabels, OccurrenceCollection data, boolean titleAdded, int numToSkip, boolean isDepthValue) {
        boolean addedTitle = titleAdded;
        if (analysisLabels.contains(headerName)) {
            if (!addedTitle) {
                gb.append(new Object[]{"Samples"});
                gb.appendEmpty(numToSkip - 1);
                addedTitle = true;
            } else {
                gb.appendEmpty(numToSkip);
            }
            gb.append(new Object[]{headerName});
            for (AnalysisOccurrenceCategory analysisCat : data.getAnalysisCategories()) {
                if (isDepthValue) {
                    gb.appendFormatted(DEPTH_FORMAT, new Object[]{analysisCat.getValueForHeader(headerName)});
                    continue;
                }
                gb.append(new Object[]{analysisCat.getValueForHeader(headerName)});
            }
            gb.addRow();
        }
        return addedTitle;
    }

    private void addAnalysisHeadersTotalsRow(IGridBuilder gb, OccurrenceCollection data, Map<AnalysisOccurrenceCategory, Integer> totalMap, boolean titleAdded, int numToSkip) {
        if (!titleAdded) {
            gb.append(new Object[]{"Samples"});
            gb.appendEmpty(numToSkip - 1);
        } else {
            gb.appendEmpty(numToSkip);
        }
        gb.append(new Object[]{AnalysisOccurrenceCategory.HEADERS.TOTAL});
        for (AnalysisOccurrenceCategory analysisCat : data.getAnalysisCategories()) {
            if (totalMap.containsKey(analysisCat)) {
                gb.append(new Object[]{totalMap.get(analysisCat)});
                continue;
            }
            gb.append();
        }
        gb.addRow();
    }

    private Object buildOccurrenceResult(List<TaxonOcc> occs, AbundanceScheme abnScheme, Map<AnalysisOccurrenceCategory, Integer> totalCount, AnalysisOccurrenceCategory analysisCat) {
        if (occs == null || occs.isEmpty()) {
            return null;
        }
        Object result = null;
        if (this.outputData == OutputData.AbsoluteAbundance) {
            int occurrenceTotal = this.calcTotalDerivedCount(occs, abnScheme);
            result = occurrenceTotal > 0 || this.includeZeroValuesInOutput ? Integer.valueOf(occurrenceTotal) : "+";
        } else if (this.outputData == OutputData.Percentage) {
            int analysisTotal;
            int occurrenceTotal = this.calcTotalDerivedCount(occs, abnScheme);
            if (occurrenceTotal > 0) {
                int analysisTotal2 = totalCount.get(analysisCat);
                result = analysisTotal2 == 0 ? "Error" : Double.valueOf((double)occurrenceTotal / (double)analysisTotal2);
            } else if (this.includeZeroValuesInOutput && (analysisTotal = totalCount.get(analysisCat).intValue()) > 0) {
                result = 0.0;
            }
        } else if (this.outputData == OutputData.SemiQuantative) {
            int occurrenceTotal = this.calcTotalDerivedCount(occs, abnScheme);
            result = occurrenceTotal > 0 ? (abnScheme == null ? String.valueOf('+') : abnScheme.getSubjAbundByCount(occurrenceTotal)) : "+";
        } else if (this.outputData == OutputData.Richness) {
            int richnessTotal = this.calcTotalRichness(occs);
            if (richnessTotal > 0 || this.includeZeroValuesInOutput) {
                result = richnessTotal;
            }
        } else if (this.outputData == OutputData.PercentReworking) {
            int totalGroupCount;
            int reworkCount = this.calcTotalReworkCount(occs, abnScheme);
            if (reworkCount > 0) {
                int totalGroupCount2 = this.calcTotalDerivedCount(occs, abnScheme);
                result = totalGroupCount2 == 0 ? "Error" : Double.valueOf((double)reworkCount / (double)totalGroupCount2);
            } else if (reworkCount == 0 && this.includeZeroValuesInOutput && (totalGroupCount = this.calcTotalDerivedCount(occs, abnScheme)) > 0) {
                result = 0.0;
            }
        }
        return result;
    }

    private void appendResultToGrid(List<TaxonOcc> occs, IGridBuilder gb, Object result) {
        List<String> qualifierList = this.buildQualifierList(occs);
        if (this.showQualifiers && !qualifierList.isEmpty()) {
            if (this.addQualifiersAsComments) {
                gb.append(new Object[]{new GridCell(result, null, StringUtils.join(qualifierList, (String)" "))});
            } else {
                if (result instanceof Float || result instanceof Double) {
                    result = this.numberFormat.format(result);
                }
                if (result.toString().startsWith("+")) {
                    gb.append(new Object[]{StringUtils.join(qualifierList, (String)"") + String.valueOf(result)});
                } else {
                    gb.append(new Object[]{String.valueOf(result) + " " + StringUtils.join(qualifierList, (String)" ")});
                }
            }
        } else if (this.outputData == OutputData.Percentage || this.outputData == OutputData.PercentReworking) {
            gb.appendFormatted(PERCENT_FORMAT, new Object[]{result});
        } else {
            gb.append(new Object[]{result});
        }
    }

    private List<String> buildQualifierList(List<TaxonOcc> occs) {
        ArrayList<String> qualifierList = new ArrayList<String>();
        for (TaxonOcc o : occs) {
            this.addQualifiers(o, qualifierList);
        }
        return qualifierList;
    }

    private int calcTotalDerivedCount(List<TaxonOcc> occurrences, AbundanceScheme abn) {
        int occurrenceTotal = 0;
        for (TaxonOcc o : occurrences) {
            occurrenceTotal += o.getDerivedCount(abn);
        }
        return occurrenceTotal;
    }

    private int calcTotalReworkCount(List<TaxonOcc> occurrences, AbundanceScheme abn) {
        int reworkedTotal = 0;
        for (TaxonOcc o : occurrences) {
            if (!o.getReworked()) continue;
            reworkedTotal += o.getDerivedCount(abn);
        }
        return reworkedTotal;
    }

    private int calcTotalRichness(List<TaxonOcc> occurrences) {
        int totalRichness = occurrences.size();
        return totalRichness;
    }

    private Map<AnalysisOccurrenceCategory, Integer> buildTotalHashMap(OccurrenceCollection data) {
        HashMap<AnalysisOccurrenceCategory, Integer> totalCount = new HashMap<AnalysisOccurrenceCategory, Integer>();
        for (AnalysisOccurrenceCategory analysisCat : data.getAnalysisCategories()) {
            totalCount.put(analysisCat, 0);
            List<TaxonOcc> occurrences = data.getAnalysisTotalOccurrences(analysisCat);
            int count = this.calcTotalDerivedCount(occurrences, analysisCat.getAbundanceScheme());
            totalCount.put(analysisCat, count);
        }
        return totalCount;
    }

    private void addQualifiers(TaxonOcc o, List<String> qualifiers) {
        StringBuilder sb = new StringBuilder();
        if (o.getReworked()) {
            sb.append("Rw");
        }
        if (o.getCaved()) {
            sb.append("Cv");
        }
        if (o.getIdentType() != 'P') {
            sb.append("?");
        }
        if (sb.length() > 0) {
            qualifiers.add(sb.toString());
        }
    }

    private List<String> buildAnalysisLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        if (this.includeDepthRange) {
            labels.add(AnalysisOccurrenceCategory.HEADERS.TOP);
            labels.add(AnalysisOccurrenceCategory.HEADERS.BASE);
        } else {
            labels.add(AnalysisOccurrenceCategory.HEADERS.DEPTH);
        }
        if (this.includeSampleType) {
            labels.add(AnalysisOccurrenceCategory.HEADERS.TYPE);
        }
        if (this.includeAnalyst) {
            labels.add(AnalysisOccurrenceCategory.HEADERS.ANALYST);
        }
        if (this.includeSampleLabel) {
            labels.add(AnalysisOccurrenceCategory.HEADERS.LABEL);
        }
        if (this.includeSampleSatatus) {
            labels.add(AnalysisOccurrenceCategory.HEADERS.STATUS);
        }
        if (this.includeTotalsWithPercentage && this.outputData == OutputData.Percentage) {
            labels.add(AnalysisOccurrenceCategory.HEADERS.TOTAL);
        }
        return labels;
    }

    private CellFormat getHeaderFormat() {
        if (this.rotateHeaderText) {
            return ROTATED_COLUMNS_HEADER_FORMAT;
        }
        return COLUMNS_HEADER_FORMAT;
    }

    public void setShowQualifiers(boolean showQualifiers) {
        this.showQualifiers = showQualifiers;
    }

    public void setIncludeSampleType(boolean includeSampleType) {
        this.includeSampleType = includeSampleType;
    }

    public void setIncludeSampleLabel(boolean includeSampleLabel) {
        this.includeSampleLabel = includeSampleLabel;
    }

    public void setIncludeAnalyst(boolean includeAnalyst) {
        this.includeAnalyst = includeAnalyst;
    }

    public void setIncludeSampleSatatus(boolean includeSampleSatatus) {
        this.includeSampleSatatus = includeSampleSatatus;
    }

    public void setIncludeDepthRange(boolean includeDepthRange) {
        this.includeDepthRange = includeDepthRange;
    }

    public void setIncludeTaxaSpeciesCodes(boolean value) {
        this.includeTaxaSpeciesCodes = value;
    }

    public void setIncludeTotalsWithPercentage(boolean value) {
        this.includeTotalsWithPercentage = value;
    }

    public void setOutputData(OutputData value) {
        this.outputData = value;
    }

    public void setIncludeGroupInfo(boolean value) {
        this.includeGroupInfo = value;
    }

    public void setIncludeCategory(boolean value) {
        this.includeCategory = value;
    }

    public void setIncludeZeroValuesInOutput(boolean value) {
        this.includeZeroValuesInOutput = value;
    }

    public void setRotateHeaderText(boolean value) {
        this.rotateHeaderText = value;
    }

    public void setNumberFormat(NumberFormat value) {
        this.numberFormat = value;
    }

    public void setQualifiersAsComments(boolean value) {
        this.addQualifiersAsComments = value;
    }

    public static enum OutputData {
        AbsoluteAbundance,
        Percentage,
        SemiQuantative,
        Richness,
        PercentReworking;

    }
}

