/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.welldata;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jsbugs.io.welldata.SummaryPickType;
import jsbugs.io.welldata.WellDataSummaryRecord;
import model3.SBdb;
import org.apache.commons.lang3.ObjectUtils;
import util.CompareUtils;
import util.DepthUnits;
import util.SBException;
import util.gridwriter.GridSheet;

public class GridHelperOneColumnPerDataType {
    public Object[][] populateGridOneColumnPerType(GridSheet gb, List<WellDataSummaryRecord> records, boolean includeWellCode, boolean includeVersionName, boolean includeBase, char units) throws SBException, SQLException {
        HashMap rowData = new HashMap();
        HashSet<ColumnHeader> allHeaders = new HashSet<ColumnHeader>();
        for (WellDataSummaryRecord rec : records) {
            Map headerValues;
            RowHeader rowHeader = this.buildRowHeader(rec, includeBase, includeWellCode, includeVersionName);
            ColumnHeader header = new ColumnHeader(this, rec);
            if (!rowData.containsKey(rowHeader)) {
                rowData.put(rowHeader, new HashMap());
            }
            Object newValue = (headerValues = (Map)rowData.get(rowHeader)).containsKey(header) ? (String)headerValues.get(header) + ", " + rec.getValue() : rec.getValue();
            headerValues.put(header, newValue);
            allHeaders.add(header);
        }
        ArrayList rowHeaders = new ArrayList(rowData.keySet());
        Collections.sort(rowHeaders);
        ArrayList sortedHeaders = new ArrayList(allHeaders);
        Collections.sort(sortedHeaders);
        gb.addRow(new Object[]{"Well"});
        if (includeWellCode) {
            gb.append(new Object[]{"Code"});
        }
        if (includeVersionName) {
            gb.append(new Object[]{"Version"});
        }
        DepthUnits u = DepthUnits.getUnits((char)units);
        if (includeBase) {
            gb.append(new Object[]{"Top Depth (" + u.getAbr() + ")", "Top Sample Type", "Base Depth (" + u.getAbr() + ")", "Base Sample Type"});
        } else {
            gb.append(new Object[]{"Depth (" + u.getAbr() + ")", "Sample Type"});
        }
        for (ColumnHeader h : sortedHeaders) {
            gb.append(new Object[]{h.getText()});
        }
        for (RowHeader row : rowHeaders) {
            gb.addRow();
            gb.append(new Object[]{row.well});
            if (includeWellCode) {
                gb.append(new Object[]{row.wellCode});
            }
            if (includeVersionName) {
                gb.append(new Object[]{row.version});
            }
            gb.append(new Object[]{row.topDepth, row.topType});
            if (includeBase) {
                gb.append(new Object[]{row.baseDepth, row.baseType});
            }
            Map rowValues = (Map)rowData.get(row);
            for (ColumnHeader header : sortedHeaders) {
                if (rowValues.containsKey(header)) {
                    gb.append(new Object[]{rowValues.get(header)});
                    continue;
                }
                gb.append();
            }
        }
        return gb.getObjectArray();
    }

    private RowHeader buildRowHeader(WellDataSummaryRecord rec, boolean includeBase, boolean includeWellCode, boolean includeVersionName) {
        RowHeader rowHeader = new RowHeader(this);
        rowHeader.well = rec.getWellName();
        if (includeWellCode) {
            rowHeader.wellCode = rec.getWellCode();
        }
        if (includeVersionName) {
            rowHeader.version = rec.getVersionName();
        }
        if (rec.getTopSample() != null) {
            rowHeader.topDepth = rec.getTopSample().getDepth();
            rowHeader.topType = rec.getTopSample().getType();
        }
        if (rowHeader.topDepth == null && rowHeader.topType == null && !includeBase && rec.getBaseSample() != null) {
            rowHeader.topDepth = rec.getBaseSample().getDepth();
            rowHeader.topType = rec.getBaseSample().getType();
        }
        if (rec.getBaseSample() != null && includeBase) {
            rowHeader.baseDepth = rec.getBaseSample().getDepth();
            rowHeader.baseType = rec.getBaseSample().getType();
        }
        return rowHeader;
    }

    private class RowHeader
    implements Comparable<RowHeader> {
        String well;
        String wellCode;
        String version;
        Double topDepth;
        String topType;
        Double baseDepth;
        String baseType;

        private RowHeader(GridHelperOneColumnPerDataType gridHelperOneColumnPerDataType) {
            Objects.requireNonNull(gridHelperOneColumnPerDataType);
            this.well = null;
            this.wellCode = null;
            this.version = null;
            this.topDepth = null;
            this.topType = null;
            this.baseDepth = null;
            this.baseType = null;
        }

        @Override
        public int compareTo(RowHeader other) {
            int result = CompareUtils.compareToStringAsLower((String)this.well, (String)other.well);
            if (result == 0) {
                result = CompareUtils.compareToStringAsLower((String)this.wellCode, (String)other.wellCode);
            }
            if (result == 0) {
                result = CompareUtils.compareToStringAsLower((String)this.version, (String)other.version);
            }
            if (result == 0) {
                result = CompareUtils.compareNullableDoubles((Double)this.topDepth, (Double)other.topDepth);
            }
            if (result == 0) {
                result = CompareUtils.compareNullableDoubles((Double)this.baseDepth, (Double)other.baseDepth);
            }
            if (result == 0) {
                result = CompareUtils.compareToStringAsLower((String)this.topType, (String)other.topType);
            }
            if (result == 0) {
                result = CompareUtils.compareToStringAsLower((String)this.baseType, (String)other.baseType);
            }
            return result;
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + Objects.hashCode(this.well);
            hash = 19 * hash + Objects.hashCode(this.wellCode);
            hash = 19 * hash + Objects.hashCode(this.version);
            hash = 19 * hash + Objects.hashCode(this.topDepth);
            hash = 19 * hash + Objects.hashCode(this.topType);
            hash = 19 * hash + Objects.hashCode(this.baseDepth);
            hash = 19 * hash + Objects.hashCode(this.baseType);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RowHeader other = (RowHeader)obj;
            if (!Objects.equals(this.well, other.well)) {
                return false;
            }
            if (!Objects.equals(this.wellCode, other.wellCode)) {
                return false;
            }
            if (!Objects.equals(this.version, other.version)) {
                return false;
            }
            if (!Objects.equals(this.topType, other.topType)) {
                return false;
            }
            if (!Objects.equals(this.baseType, other.baseType)) {
                return false;
            }
            if (!Objects.equals(this.topDepth, other.topDepth)) {
                return false;
            }
            return Objects.equals(this.baseDepth, other.baseDepth);
        }
    }

    private class ColumnHeader
    implements Comparable<ColumnHeader> {
        int dataType;
        SummaryPickType pick;
        String scheme;

        public ColumnHeader(GridHelperOneColumnPerDataType gridHelperOneColumnPerDataType, WellDataSummaryRecord record) {
            Objects.requireNonNull(gridHelperOneColumnPerDataType);
            this.scheme = null;
            this.dataType = record.getDataType();
            if (record.getDataType() != 16 && record.getDataType() != 14) {
                this.pick = record.getPickType();
            }
            if (record.getDataType() == 11) {
                this.scheme = record.getScheme();
            }
        }

        public String getText() {
            Object headerText = SBdb.dTypeNames[this.dataType];
            if (this.pick != null) {
                headerText = (String)headerText + " - " + this.pick.getName();
            }
            if (this.scheme != null) {
                headerText = (String)headerText + " (" + this.scheme + ")";
            }
            return headerText;
        }

        @Override
        public int compareTo(ColumnHeader o) {
            int result = ObjectUtils.compare((Comparable)Integer.valueOf(this.dataType), (Comparable)Integer.valueOf(o.dataType));
            if (result == 0) {
                if (this.pick != null && o.pick != null) {
                    result = ObjectUtils.compare((Comparable)Integer.valueOf(this.pick.getSortOrder()), (Comparable)Integer.valueOf(o.pick.getSortOrder()));
                } else if (this.pick == null) {
                    result = 1;
                } else if (o.pick == null) {
                    result = -1;
                }
            }
            if (result == 0) {
                result = ObjectUtils.compare((Comparable)((Object)this.scheme), (Comparable)((Object)o.scheme));
            }
            return result;
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + this.dataType;
            hash = 59 * hash + Objects.hashCode(this.pick);
            hash = 59 * hash + Objects.hashCode(this.scheme);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ColumnHeader other = (ColumnHeader)obj;
            if (this.dataType != other.dataType) {
                return false;
            }
            if (!Objects.equals(this.scheme, other.scheme)) {
                return false;
            }
            return Objects.equals(this.pick, other.pick);
        }
    }
}

