/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.list;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.CategoryService;
import java.util.List;
import java.util.Optional;
import javax.swing.JComboBox;
import jsbugs.list.CategoryListCellRenderer;

public class CategoryComboBox
extends JComboBox<Category> {
    private CategoryService categoryService;

    public CategoryComboBox() {
        this.setRenderer(new CategoryListCellRenderer());
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public void fill() {
        this.fill(null);
    }

    public void fill(Discipline discipline) {
        List categories = this.categoryService.getCategoryList();
        Category selectedCategory = null;
        if (this.getItemCount() > 0) {
            selectedCategory = this.getSelectedCategory().orElse(null);
            this.removeAllItems();
        }
        categories.stream().filter(cat -> discipline == null || cat.getDiscipline() == discipline).forEach(item -> this.addItem(item));
        this.insertItemAt(null, 0);
        if (selectedCategory != null && (discipline == null || selectedCategory.getDiscipline() == discipline)) {
            this.setSelectedItem(selectedCategory);
        } else {
            this.setSelectedIndex(0);
        }
    }

    public static void fillDomainCategoryCombo(CategoryService categoryService, JComboBox<Category> combo, Discipline discID) {
    }

    public Optional<Category> getSelectedCategory() {
        return Optional.ofNullable((Category)this.getSelectedItem());
    }

    public String getSelectedMnemonic() {
        return this.getSelectedCategory().map(Category::getMnemonic).orElse("");
    }

    public void setSelectedCategory(String mnemonic) {
        this.setSelectedItem(this.categoryService.findCategory(mnemonic).orElse(null));
    }
}

