/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.event;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogSelectGroup;
import jsbugs.model2.event.DialogCmpStdEvent;
import jsbugs.model2.event.DialogCmpStdUnits;
import jsbugs.model2.event.JPanelCmpStdHeader;
import jsbugs.model2.event.JTableCmpStd;
import jsbugs.model2.event.TableModelCmpStd;
import jsbugs.uiutil.audit.JPanelAuditLine;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Audit;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.IGDScheme;
import model3.LOC;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Taxon;
import model3.TxGroup;
import model3.WellEvent;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.table.ColumnHeaderToolTips;

public class DialogCmpStd
extends SBDialog {
    private final SBdb db;
    private final TableModelCmpStd model = new TableModelCmpStd();
    private final CompositeStandard cmpStd;
    private final Date cmpStdUpdated;
    CompositeStandard cmpStdAdded = null;
    static final Logger LOGGER = Logger.getLogger(DialogCmpStd.class.getName());
    private ButtonGroup buttonGroup1;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonInsertGroup;
    private JButton jButtonModify;
    private JButton jButtonOK;
    private JButton jButtonPrune;
    private JButton jButtonSaveAsGroup;
    private JCheckBox jCheckBoxArchived;
    private JPanelAuditLine jPanelAudit;
    private JScrollPane jScrollPane1;
    private JTable jTableCmpStd;
    private JPanelCmpStdHeader panelHdr;

    public DialogCmpStd(Frame parent, boolean modal, SBdb db, CompositeStandard std) throws SQLException, SBException {
        super(parent, modal);
        if (std != null) {
            std.loadEvents();
            this.cmpStdUpdated = std.getAudit().getUpdated();
        } else {
            this.cmpStdUpdated = null;
        }
        this.cmpStd = std;
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogCmpStd(JDialog parent, boolean modal, SBdb db, CompositeStandard std) throws SQLException, SBException {
        super((Window)parent, modal);
        if (std != null) {
            std.loadEvents();
            this.cmpStdUpdated = std.getAudit().getUpdated();
        } else {
            this.cmpStdUpdated = null;
        }
        this.cmpStd = std;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        assert (this.db.isConnected());
        this.model.setupTable(this.jTableCmpStd);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTableCmpStd.setRowSorter(new TableRowSorter<TableModelCmpStd>(this.model));
        new ColumnSortResetHandler(this.jTableCmpStd).attach();
        this.jTableCmpStd.getTableHeader().addMouseMotionListener((MouseMotionListener)ColumnHeaderToolTips.createColumnHeaderToolTips((String[])TableModelCmpStd.tooltips, (JTable)this.jTableCmpStd));
        this.panelHdr.init((Component)((Object)this), this.model, this.db, this.cmpStd);
        this.panelHdr.setFields();
        if (this.cmpStd != null) {
            this.setTitle("Composite Standard : Edit");
            IGDScheme parentScheme = null;
            if (this.cmpStd.getParentSchID() > 0) {
                try {
                    parentScheme = this.db.getIGDScheme(this.cmpStd.getParentSchID());
                }
                catch (SQLException sql) {
                    SbugsExceptionHandler.showStackError(sql);
                }
            }
            this.model.updateFields(this.cmpStd.getName(), this.cmpStd.getMinAge(), this.cmpStd.getMaxAge(), this.cmpStd.getTopCSU(), this.cmpStd.getBaseCSU(), this.cmpStd.isAgeScale(), parentScheme, this.cmpStd.getParentCmpStd());
            this.panelHdr.setFields();
            this.initEvents();
            this.model.addPropertyChangeListener(evt -> {
                if ("parentComposite".equals(evt.getPropertyName())) {
                    this.initEvents();
                }
            });
            if (!this.cmpStd.canWrite(this.db, null)) {
                this.jButtonOK.setEnabled(false);
                this.jButtonOK.setToolTipText("This is a read-only Composite Standard");
            }
            Audit audit = this.cmpStd.getAudit();
            String creator = "";
            if (audit.getCreator() > 0 && this.cmpStd.getDatabase() != null) {
                creator = this.cmpStd.getDatabase().getUser(audit.getCreator()).getAbr();
            }
            String modifier = "";
            if (audit.getModifier() > 0 && this.cmpStd.getDatabase() != null) {
                modifier = this.cmpStd.getDatabase().getUser(audit.getModifier()).getAbr();
            }
            this.jPanelAudit.setAuditText(creator, audit.getCreated(), modifier, audit.getModified());
            this.jCheckBoxArchived.setSelected(this.cmpStd.isArchived());
        } else {
            this.setTitle("Composite Standard : Add");
        }
        this.model.fireTableDataChanged();
        if (this.cmpStd != null && !this.cmpStd.canWrite(this.db, null) || this.cmpStd == null && !SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.cmpStd != null ? this.cmpStd.getDeniedReason(this.db, "composite standard", false) : SBRestrictable.getDeniedReason(false));
        }
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonInsertGroup.setEnabled(false);
        }
    }

    private void initEvents() {
        try {
            this.cmpStd.loadEvents();
            LinkedList<CompositeStandardEvent.Builder> events = new LinkedList<CompositeStandardEvent.Builder>();
            for (CompositeStandardEvent event : this.cmpStd.getEvents(false)) {
                events.add(this.getEventCopy(event));
            }
            if (this.model.getParentCmpStd() != null) {
                List<CompositeStandardEvent.Builder> excludedEvents = this.cmpStd.getEventsNotInherited();
                LinkedList<CompositeStandardEvent.Builder> inheritedEvents = new LinkedList<CompositeStandardEvent.Builder>();
                for (CompositeStandardEvent parentEvent : this.model.getParentCmpStd().getEvents(true)) {
                    boolean hasMatch = events.stream().anyMatch(e -> e.matches(parentEvent));
                    boolean excludes = excludedEvents.stream().anyMatch(e -> e.matches(parentEvent));
                    if (!hasMatch && !excludes) {
                        CompositeStandardEvent.Builder eventCopy = this.getEventCopy(parentEvent);
                        eventCopy.inheritedFromParent = true;
                        inheritedEvents.add(eventCopy);
                        continue;
                    }
                    if (!hasMatch) continue;
                    CompositeStandardEvent.Builder parentEventCopy = this.getEventCopy(parentEvent);
                    parentEventCopy.inheritedFromParent = true;
                    events.stream().filter(e -> e.matches(parentEvent)).findFirst().ifPresent(overridingEvent -> {
                        overridingEvent.matchingParentEvent = parentEventCopy;
                    });
                }
                events.addAll(inheritedEvents);
                events.addAll(excludedEvents);
            }
            this.model.setEvents(events);
        }
        catch (SQLException | SBException e2) {
            throw new RuntimeException(e2);
        }
    }

    private CompositeStandardEvent.Builder getEventCopy(CompositeStandardEvent event) throws SQLException, SBException {
        CompositeStandardEvent.Builder copy = CompositeStandardEvent.Builder.copyOf(event);
        if (this.cmpStd.getDatabase().isConnected()) {
            copy.event(event.getEvent());
        } else {
            if (event.getEvent().getLink() == null) {
                throw new IllegalStateException("Unlinked event in workspace composite: " + String.valueOf(event.getEvent()));
            }
            copy.event(event.getEvent().getLink());
            copy.audit(new Audit(this.db, this.cmpStd.getDatabase(), event.getAudit()));
        }
        return copy;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCmpStd = new JTableCmpStd(this.model);
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonInsertGroup = new JButton();
        this.jButtonSaveAsGroup = new JButton();
        this.jPanelAudit = new JPanelAuditLine();
        this.jCheckBoxArchived = new JCheckBox();
        this.panelHdr = new JPanelCmpStdHeader();
        this.jButtonPrune = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(585, 400));
        this.jTableCmpStd.setModel(this.model);
        this.jTableCmpStd.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogCmpStd this$0;
            {
                DialogCmpStd dialogCmpStd = this$0;
                Objects.requireNonNull(dialogCmpStd);
                this.this$0 = dialogCmpStd;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableCmpStdMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableCmpStd);
        this.jButtonAdd.setText("Add event...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStd this$0;
            {
                DialogCmpStd dialogCmpStd = this$0;
                Objects.requireNonNull(dialogCmpStd);
                this.this$0 = dialogCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStd this$0;
            {
                DialogCmpStd dialogCmpStd = this$0;
                Objects.requireNonNull(dialogCmpStd);
                this.this$0 = dialogCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit event...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStd this$0;
            {
                DialogCmpStd dialogCmpStd = this$0;
                Objects.requireNonNull(dialogCmpStd);
                this.this$0 = dialogCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStd this$0;
            {
                DialogCmpStd dialogCmpStd = this$0;
                Objects.requireNonNull(dialogCmpStd);
                this.this$0 = dialogCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStd this$0;
            {
                DialogCmpStd dialogCmpStd = this$0;
                Objects.requireNonNull(dialogCmpStd);
                this.this$0 = dialogCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStd this$0;
            {
                DialogCmpStd dialogCmpStd = this$0;
                Objects.requireNonNull(dialogCmpStd);
                this.this$0 = dialogCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonModify.setText("Modify...");
        this.jButtonModify.setToolTipText("Adjust all CSU values");
        this.jButtonModify.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStd this$0;
            {
                DialogCmpStd dialogCmpStd = this$0;
                Objects.requireNonNull(dialogCmpStd);
                this.this$0 = dialogCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonModifyActionPerformed(evt);
            }
        });
        this.jButtonInsertGroup.setText("Insert group...");
        this.jButtonInsertGroup.setToolTipText("Insert a top/base event for all the taxa in a group");
        this.jButtonInsertGroup.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonInsertGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStd this$0;
            {
                DialogCmpStd dialogCmpStd = this$0;
                Objects.requireNonNull(dialogCmpStd);
                this.this$0 = dialogCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertGroupActionPerformed(evt);
            }
        });
        this.jButtonSaveAsGroup.setText("Save as group...");
        this.jButtonSaveAsGroup.setToolTipText("Create a group from selected event linked taxa");
        this.jButtonSaveAsGroup.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSaveAsGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStd this$0;
            {
                DialogCmpStd dialogCmpStd = this$0;
                Objects.requireNonNull(dialogCmpStd);
                this.this$0 = dialogCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsGroupActionPerformed(evt);
            }
        });
        this.jCheckBoxArchived.setText("Archived");
        this.jButtonPrune.setText("Prune");
        this.jButtonPrune.setToolTipText("Remove all the events that are duplicated in a parent Composite Standard");
        this.jButtonPrune.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStd this$0;
            {
                DialogCmpStd dialogCmpStd = this$0;
                Objects.requireNonNull(dialogCmpStd);
                this.this$0 = dialogCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPruneActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanelAudit, -2, -1, -2).addPreferredGap(0, 110, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp, -2, 80, -2).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonSaveAsGroup, -2, 120, -2).add((Component)this.jButtonAdd, -2, 120, -2).add((Component)this.jButtonEdit, -2, 120, -2).add((Component)this.jButtonDelete, -2, 120, -2).add((Component)this.jButtonPrune, -2, 120, -2).add((Component)this.jButtonModify, -2, 120, -2).add((Component)this.jButtonInsertGroup, -2, 120, -2).add((Component)this.jCheckBoxArchived)).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.panelHdr, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.panelHdr, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelAudit, -2, -1, -2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK))).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).add(9, 9, 9).add((Component)this.jButtonPrune).addPreferredGap(0).add((Component)this.jButtonModify).addPreferredGap(0).add((Component)this.jButtonInsertGroup).addPreferredGap(0).add((Component)this.jButtonSaveAsGroup).add(18, 18, 18).add((Component)this.jCheckBoxArchived).add(52, 136, Short.MAX_VALUE)))));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if ((this.cmpStd == null && this.model.hasEvents() || this.cmpStd != null && !this.cmpStd.equalsCompositeEvents(this.model.getEvents())) && JOptionPane.showConfirmDialog((Component)((Object)this), "Discard changes to event list?", this.getTitle(), 0) != 0) {
            return;
        }
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtousecmpstds.html#dialogcmpstd");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int opt;
        if (this.cmpStdUpdated != null && this.cmpStd.getAudit().getUpdated().after(this.cmpStdUpdated) && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Data refresh task has detected changes in the composite standard since you opened this dialog.\nIf you continue, you will overwrite these changes.\nAre you sure you want to continue?", this.getTitle(), 0)) != 0) {
            return;
        }
        try {
            this.panelHdr.validateFields(this.db, this.cmpStd);
            this.model.validateCSU();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), this.getTitle(), 2);
            return;
        }
        boolean isAgeScale = this.panelHdr.isAgeScale();
        try {
            if (this.cmpStd != null) {
                if (this.cmpStd.getDatabase() != this.db && !this.cmpStd.getDatabase().isConnected()) {
                    this.cmpStdAdded = this.db.addCompositeStandard(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, isAgeScale, this.model.getEvents(), new Audit(this.db, this.cmpStd.getDatabase(), this.cmpStd.getAudit()), this.model.getParentSchID(), this.model.getParentCmpStd());
                } else {
                    this.cmpStd.update(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, isAgeScale, this.model.getEvents(), this.model.getParentSchID(), this.model.getParentCmpStd());
                    if (this.jCheckBoxArchived.isSelected() != this.cmpStd.isArchived()) {
                        this.cmpStd.setArchived(this.jCheckBoxArchived.isSelected());
                    }
                }
            } else {
                this.cmpStdAdded = this.db.addCompositeStandard(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, isAgeScale, this.model.getEvents(), null, this.model.getParentSchID(), this.model.getParentCmpStd());
            }
            this.db.commit();
            if (this.cmpStd != null) {
                this.cmpStd.notifyObservers();
            }
            this.setOK();
        }
        catch (IllegalStateException | InvalidFieldException | SBPermissionException ife) {
            JOptionPane.showMessageDialog((Component)((Object)this), ife.getMessage(), this.getTitle(), 2);
            ife.printStackTrace();
        }
        catch (SQLException | SBException sql) {
            this.db.doRollback();
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogCmpStdEvent dialog = new DialogCmpStdEvent((JDialog)((Object)this), true, this.db, null, this.panelHdr.isAgeScale());
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.addEvent(dialog.builder);
                int index = this.jTableCmpStd.convertRowIndexToView(this.model.indexOf(dialog.builder));
                this.jTableCmpStd.getSelectionModel().setSelectionInterval(index, index);
            }
        }
        catch (RuntimeException re) {
            SbugsExceptionHandler.showStackError(re);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableCmpStd.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one row to edit", this.getTitle(), 2);
            return;
        }
        int selectedRow = this.jTableCmpStd.getSelectedRow();
        CompositeStandardEvent.Builder toEdit = this.model.getEvent(this.jTableCmpStd.convertRowIndexToModel(selectedRow));
        if (toEdit.inheritedFromParent) {
            // empty if block
        }
        try {
            int index;
            DialogCmpStdEvent dialog = new DialogCmpStdEvent((JDialog)((Object)this), true, this.db, toEdit, this.panelHdr.isAgeScale());
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.sort();
                this.model.fireTableDataChanged();
                index = this.jTableCmpStd.convertRowIndexToView(this.model.indexOf(dialog.builder));
            } else {
                index = selectedRow;
            }
            this.jTableCmpStd.getSelectionModel().setSelectionInterval(index, index);
        }
        catch (RuntimeException re) {
            SbugsExceptionHandler.showStackError(re);
        }
    }

    private void jTableCmpStdMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableCmpStd.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No row(s) selected", this.getTitle(), 2);
            return;
        }
        LinkedList<CompositeStandardEvent.Builder> toRemove = new LinkedList<CompositeStandardEvent.Builder>();
        for (int i = 0; i < selection.length; ++i) {
            toRemove.add(this.model.getEvent(this.jTableCmpStd.convertRowIndexToModel(selection[i])));
        }
        this.model.removeEvents(toRemove);
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        DialogCmpStdUnits dialog = new DialogCmpStdUnits((JDialog)((Object)this), true);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            String topString = this.panelHdr.getTopCSUString();
            String baseString = this.panelHdr.getBaseCSUString();
            if (!topString.isEmpty() && !baseString.isEmpty()) {
                double top = Double.parseDouble(topString);
                top = dialog.reFactor(top);
                double base = Double.parseDouble(baseString);
                base = dialog.reFactor(base);
                this.model.updateFields(this.model.stdName, this.model.minAge, this.model.maxAge, top, base, this.model.isAgeScale, this.model.getParentScheme(), this.model.getParentCmpStd());
                try {
                    this.panelHdr.setFields();
                }
                catch (SQLException sqle) {
                    SbugsExceptionHandler.showStackError(sqle);
                }
            }
            for (CompositeStandardEvent.Builder event : this.model.getEvents()) {
                if (event.inheritedFromParent) continue;
                event.csu(dialog.reFactor(event.getCSU()));
            }
            this.model.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonInsertGroupActionPerformed(ActionEvent evt) {
        try {
            DialogSelectGroup dialog = new DialogSelectGroup((JDialog)((Object)this), true, this.db, true);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                TxGroup group = dialog.getSelection();
                LinkedList<Taxon> taxa = new LinkedList<Taxon>(this.db.getTxGroupTaxa(group));
                int nAdded = this.model.importTaxa(taxa, this.db);
                this.model.fireTableDataChanged();
                if (nAdded > 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Number of events added: " + nAdded, this.getTitle(), 1);
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No new events added.", this.getTitle(), 1);
                }
            }
        }
        catch (RuntimeException | SQLException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveAsGroupActionPerformed(ActionEvent evt) {
        boolean restrict = false;
        int[] selection = this.jTableCmpStd.getSelectedRows();
        if (this.jTableCmpStd.getSelectedRowCount() > 0 && this.jTableCmpStd.getSelectedRowCount() < this.jTableCmpStd.getRowCount()) {
            int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Restrict to selected events only?", this.getTitle(), 1, 3);
            if (opt == 2 || opt == -1) {
                return;
            }
            if (opt == 0) {
                restrict = true;
            }
        }
        try {
            DialogSelectGroup dialog = new DialogSelectGroup((JDialog)((Object)this), true, this.db, true);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                TxGroup group = dialog.getSelection();
                LinkedList<Taxon> toAdd = new LinkedList<Taxon>();
                for (int i = 0; i < this.model.getRowCount(); ++i) {
                    Taxon taxon;
                    CompositeStandardEvent.Builder ev = this.model.getEvent(i);
                    if (restrict) {
                        boolean selected = false;
                        for (int ind = 0; ind < selection.length; ++ind) {
                            if (i != this.jTableCmpStd.convertRowIndexToModel(selection[ind])) continue;
                            selected = true;
                            break;
                        }
                        if (!selected) continue;
                    }
                    if ((taxon = ev.getEvent().getTaxon()) == null || toAdd.contains(taxon) || group.isMember(taxon.getSpecID(), 0)) continue;
                    toAdd.add(taxon);
                }
                if (toAdd.isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No new taxa added to group: " + group.toString(), this.getTitle(), 1);
                } else {
                    group.addTaxa(toAdd);
                    group.notifyObservers();
                    this.db.commit();
                    JOptionPane.showMessageDialog((Component)((Object)this), "Number of taxa added: " + toAdd.size(), this.getTitle(), 1);
                }
            }
        }
        catch (SQLException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonPruneActionPerformed(ActionEvent evt) {
        try {
            this.panelHdr.validateFields(this.db, this.cmpStd);
            this.model.validateCSU();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), this.getTitle(), 2);
            return;
        }
        if (this.model.getParentCmpStd() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No parent Composite Standard specified.", this.getTitle(), 1);
            return;
        }
        try {
            this.model.getParentCmpStd().loadEvents();
        }
        catch (SQLException sql) {
            LOGGER.log(Level.SEVERE, "Error loading events", sql);
            JOptionPane.showMessageDialog((Component)((Object)this), sql.getMessage(), this.getTitle(), 2);
            return;
        }
        LinkedList<CompositeStandardEvent.Builder> toDelete = new LinkedList<CompositeStandardEvent.Builder>();
        for (CompositeStandardEvent.Builder b : this.model.getEvents()) {
            CompositeStandardEvent parentEvent;
            if (b.inheritedFromParent || (parentEvent = this.model.getParentCmpStd().getEvent(b.getEvent().getEvID(), b.getType())) == null || !(Math.abs(parentEvent.getCSU() - b.getCSU()) < 0.001) || !this.isEqual(parentEvent.getErrMinus(), b.getErrMinus()) || !this.isEqual(parentEvent.getErrMinus(), b.getErrMinus())) continue;
            toDelete.add(b);
        }
        if (!toDelete.isEmpty()) {
            if (JOptionPane.showConfirmDialog((Component)((Object)this), "This will remove " + toDelete.size() + " events. Continue?", "Composite Standard", 0, 3) == 0) {
                this.model.removeEvents(toDelete);
                this.model.fireTableDataChanged();
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "No duplicate entries found.", this.getTitle(), 1);
        }
    }

    private boolean isEqual(Double d1, Double d2) {
        if (d1 == null) {
            if (d2 == null) {
                return true;
            }
            return d2 < 0.001;
        }
        if (d2 == null) {
            return d1 < 0.001;
        }
        return Math.abs(d1 - d2) < 0.001;
    }

    public CompositeStandard getCmpStdAdded() {
        return this.cmpStdAdded;
    }

    public void loadWellEvents(WellInterp interp) throws SQLException {
        this.panelHdr.setNameField(interp.getHeader().toString());
        LOC loc = interp.getLOC();
        Double minAge = null;
        Double maxAge = null;
        for (WellEvent event : interp.getEvents()) {
            double csu = 0.0;
            if (loc != null) {
                csu = loc.getAge(event.getSample().getDepth(), false);
                if (minAge == null || csu < minAge) {
                    minAge = csu;
                }
                if (maxAge == null || csu > maxAge) {
                    maxAge = csu;
                }
            }
            if (csu <= 0.0) {
                csu = event.getSample().getDepth();
            }
            CompositeStandardEvent.Builder csEvent = new CompositeStandardEvent.Builder().event(event.getEvent()).csu(csu).type(event.getTypeObj());
            this.model.addEvent(csEvent);
        }
        this.model.fireTableDataChanged();
        if (minAge != null) {
            this.model.minAge = SB.round((double)minAge, (int)2);
        }
        if (maxAge != null) {
            this.model.maxAge = SB.round((double)maxAge, (int)2);
        }
        this.panelHdr.setFields();
    }
}

