/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.event;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogList;
import jsbugs.model2.event.TableModelCmpStd;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.CompositeStandard;
import model3.IGDScheme;
import model3.SBdb;
import util.InvalidFieldException;
import util.SB;

public class JPanelCmpStdHeader
extends JPanel {
    private TableModelCmpStd model;
    private CompositeStandard std;
    private SBdb sbdb;
    private JDialog parentDialog;
    private final DefaultComboBoxModel comboBoxModelCompositeStds = new DefaultComboBoxModel();
    private ButtonGroup buttonGroupAge;
    private JButton jButtonChrono;
    private JCheckBox jCheckBoxInherited;
    private JComboBox<String> jComboBoxParentCmpStd;
    private JLabel jLabel1;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JRadioButton jRadioButtonAge;
    private JRadioButton jRadioButtonCSU;
    private JTextField jTextFieldBaseCSU;
    private JTextField jTextFieldChrono;
    private JTextField jTextFieldMaxAge;
    private JTextField jTextFieldMinAge;
    private JTextField jTextFieldName;
    private JTextField jTextFieldTopCSU;

    public JPanelCmpStdHeader() {
        this.initComponents();
    }

    public JPanelCmpStdHeader(Component parent, TableModelCmpStd model, SBdb sbdb, CompositeStandard std) throws SQLException {
        if (model == null) {
            throw new IllegalArgumentException("Attempt to create composite standard header panel with null table model");
        }
        this.model = model;
        this.sbdb = sbdb;
        this.std = std;
        this.parentDialog = parent instanceof JDialog ? (JDialog)parent : null;
        this.jComboBoxParentCmpStd.setModel(this.comboBoxModelCompositeStds);
        this.comboBoxModelCompositeStds.addElement("<None>");
        this.comboBoxModelCompositeStds.addAll(sbdb.getCompositeStandards(std != null ? std.getParentCmpStd() : null));
    }

    void init(Component parent, TableModelCmpStd model, SBdb sbdb, CompositeStandard std) throws SQLException {
        if (model == null) {
            throw new IllegalArgumentException("Attempt to create composite standard header panel with null table model");
        }
        this.model = model;
        this.sbdb = sbdb;
        this.std = std;
        this.parentDialog = parent instanceof JDialog ? (JDialog)parent : null;
        this.jComboBoxParentCmpStd.setModel(this.comboBoxModelCompositeStds);
        this.comboBoxModelCompositeStds.addElement("<None>");
        this.comboBoxModelCompositeStds.addAll(sbdb.getCompositeStandards(std != null ? std.getParentCmpStd() : null));
        model.initEvents(this.jCheckBoxInherited.isSelected());
    }

    public void setNameField(String name) {
        this.model.setNameField(name);
        this.jTextFieldName.setText(this.model.stdName);
    }

    public void setModelAge() {
        this.model.setAgeScale(this.jRadioButtonAge.isSelected());
    }

    public void setFields() throws SQLException {
        this.jTextFieldName.setText(this.model.stdName);
        if (!this.model.isAgeScale) {
            this.jRadioButtonCSU.setSelected(true);
            this.jTextFieldTopCSU.setText("" + this.model.topCSU);
            this.jTextFieldTopCSU.setEnabled(true);
            this.jTextFieldBaseCSU.setText("" + this.model.baseCSU);
            this.jTextFieldBaseCSU.setEnabled(true);
        } else {
            this.jRadioButtonAge.setSelected(true);
            this.jTextFieldTopCSU.setEnabled(false);
            this.jTextFieldTopCSU.setText("");
            this.jTextFieldBaseCSU.setEnabled(false);
            this.jTextFieldBaseCSU.setText("");
        }
        this.jTextFieldMinAge.setText("" + this.model.minAge);
        this.jTextFieldMaxAge.setText("" + this.model.maxAge);
        if (this.model.parentScheme != null) {
            this.jTextFieldChrono.setText(this.model.parentScheme.toString());
        }
        if (this.std != null) {
            this.comboBoxModelCompositeStds.removeElement(this.std);
            if (this.model.getParentCmpStd() != null) {
                this.comboBoxModelCompositeStds.setSelectedItem(this.model.getParentCmpStd());
            }
        }
        this.jComboBoxParentCmpStd.repaint();
    }

    public String getTopCSUString() {
        return this.jTextFieldTopCSU.getText().trim();
    }

    public String getBaseCSUString() {
        return this.jTextFieldBaseCSU.getText().trim();
    }

    public boolean isAgeScale() {
        return this.jRadioButtonAge.isSelected();
    }

    public void validateFields(SBdb db, CompositeStandard cmpStd) throws InvalidFieldException {
        CompositeStandard cs;
        String name = this.jTextFieldName.getText().trim();
        if (name.isEmpty()) {
            throw new InvalidFieldException("Enter a name");
        }
        if (this.model.parentScheme == null) {
            throw new InvalidFieldException("You must select a timescale");
        }
        try {
            for (CompositeStandard std : db.getAllCompositeStandards()) {
                if (cmpStd != null && std.getStdID() == cmpStd.getStdID() || !name.equalsIgnoreCase(std.getName())) continue;
                Object msg = "New name is already used by an existing composite standard.";
                if (std.isArchived()) {
                    msg = (String)msg + " (existing scheme is archived)";
                }
                throw new InvalidFieldException((String)msg);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
            return;
        }
        this.model.stdName = name;
        String minAgeString = this.jTextFieldMinAge.getText().trim();
        String maxAgeString = this.jTextFieldMaxAge.getText().trim();
        if (minAgeString.isEmpty() || maxAgeString.isEmpty()) {
            throw new InvalidFieldException("Enter minimum and maximum ages");
        }
        double minAge = Double.parseDouble(minAgeString);
        double maxAge = Double.parseDouble(maxAgeString);
        this.model.minAge = minAge;
        this.model.maxAge = maxAge;
        if (minAge < 0.0 || maxAge < 0.0 || maxAge - minAge <= 1.0E-6) {
            throw new InvalidFieldException("Invalid age range");
        }
        boolean isAgeScale = this.isAgeScale();
        if (!isAgeScale) {
            double baseCSU;
            String topCSUString = this.jTextFieldTopCSU.getText().trim();
            String baseCSUString = this.jTextFieldBaseCSU.getText().trim();
            if (topCSUString.isEmpty() || baseCSUString.isEmpty()) {
                throw new InvalidFieldException("Enter top and base CSU");
            }
            double topCSU = Double.parseDouble(topCSUString);
            if (Math.abs(topCSU - (baseCSU = Double.parseDouble(baseCSUString))) < 1.0) {
                throw new InvalidFieldException("No CSU range specified");
            }
            this.model.topCSU = topCSU;
            this.model.baseCSU = baseCSU;
        } else {
            this.model.baseCSU = 0.0;
            this.model.topCSU = 0.0;
        }
        Object o = this.jComboBoxParentCmpStd.getSelectedItem();
        if (o instanceof CompositeStandard && (cs = (CompositeStandard)o) != this.std) {
            this.model.setParentCmpStd(cs);
        }
    }

    private void initComponents() {
        this.buttonGroupAge = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldBaseCSU = new JTextField();
        this.jTextFieldTopCSU = new JTextField();
        this.jTextFieldName = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldMaxAge = new JTextField();
        this.jTextFieldMinAge = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jRadioButtonAge = new JRadioButton();
        this.jRadioButtonCSU = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.jTextFieldChrono = new JTextField();
        this.jButtonChrono = new JButton();
        this.jButtonChrono.putClientProperty("JComponent.sizeVariant", "small");
        this.jLabel13 = new JLabel();
        this.jComboBoxParentCmpStd = new JComboBox();
        this.jCheckBoxInherited = new JCheckBox();
        this.jLabel1.setText("Name:");
        this.jLabel2.setText("Top CSU:");
        this.jLabel3.setText("Base CSU:");
        this.jTextFieldBaseCSU.setEnabled(false);
        this.jTextFieldBaseCSU.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.jTextFieldBaseCSUFocusLost(evt);
            }
        });
        this.jTextFieldBaseCSU.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldBaseCSUKeyTyped(evt);
            }
        });
        this.jTextFieldTopCSU.setEnabled(false);
        this.jTextFieldTopCSU.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.jTextFieldTopCSUFocusLost(evt);
            }
        });
        this.jTextFieldTopCSU.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldTopCSUKeyTyped(evt);
            }
        });
        this.jTextFieldName.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.jTextFieldNameFocusLost(evt);
            }
        });
        this.jTextFieldName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jLabel5.setText("Min age:");
        this.jLabel6.setText("Max age:");
        this.jTextFieldMaxAge.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.jTextFieldMaxAgeFocusLost(evt);
            }
        });
        this.jTextFieldMaxAge.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldMaxAgeKeyTyped(evt);
            }
        });
        this.jTextFieldMinAge.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.jTextFieldMinAgeFocusLost(evt);
            }
        });
        this.jTextFieldMinAge.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldMinAgeKeyTyped(evt);
            }
        });
        this.jLabel7.setText("Ma");
        this.jLabel8.setText("Ma");
        this.buttonGroupAge.add(this.jRadioButtonAge);
        this.jRadioButtonAge.setSelected(true);
        this.jRadioButtonAge.setText("CSUs are ages");
        this.jRadioButtonAge.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonAgeActionPerformed(evt);
            }
        });
        this.buttonGroupAge.add(this.jRadioButtonCSU);
        this.jRadioButtonCSU.setText("Ages are derived from CSUs");
        this.jRadioButtonCSU.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonCSUActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Timescale:");
        this.jTextFieldChrono.setEditable(false);
        this.jTextFieldChrono.setBackground(new Color(255, 255, 204));
        this.jButtonChrono.setText("...");
        this.jButtonChrono.setToolTipText("Select a timescale");
        this.jButtonChrono.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonChronoActionPerformed(evt);
            }
        });
        this.jLabel13.setText("Parent Composite Standard:");
        this.jComboBoxParentCmpStd.setModel(this.comboBoxModelCompositeStds);
        this.jComboBoxParentCmpStd.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxParentCmpStdActionPerformed(evt);
            }
        });
        this.jCheckBoxInherited.setSelected(true);
        this.jCheckBoxInherited.setText("Display inherited events");
        this.jCheckBoxInherited.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelCmpStdHeader this$0;
            {
                JPanelCmpStdHeader jPanelCmpStdHeader = this$0;
                Objects.requireNonNull(jPanelCmpStdHeader);
                this.this$0 = jPanelCmpStdHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxInheritedActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3)).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldTopCSU).addComponent(this.jTextFieldBaseCSU, -2, 113, -2)).addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldMinAge).addComponent(this.jTextFieldMaxAge, -2, 99, -2))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jTextFieldChrono).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonChrono, -2, 30, -2)).addComponent(this.jTextFieldName))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxParentCmpStd, 0, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel7)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jRadioButtonAge, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonCSU, -1, -1, Short.MAX_VALUE))).addComponent(this.jCheckBoxInherited)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldTopCSU, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel5).addComponent(this.jTextFieldMinAge, -2, -1, -2).addComponent(this.jLabel7)).addGap(30, 30, 30)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldBaseCSU, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jTextFieldMaxAge, -2, -1, -2).addComponent(this.jLabel8)).addGap(5, 5, 5))).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonAge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonCSU).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldChrono, -2, -1, -2).addComponent(this.jLabel4)).addComponent(this.jButtonChrono)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jComboBoxParentCmpStd, -2, -1, -2).addComponent(this.jCheckBoxInherited)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jTextFieldMinAgeFocusLost(FocusEvent evt) {
        double minAge;
        try {
            minAge = Double.parseDouble(this.jTextFieldMinAge.getText().trim());
        }
        catch (NumberFormatException e) {
            minAge = -1.0;
        }
        this.model.setMinAge(minAge);
        this.model.fireTableDataChanged();
    }

    private void jTextFieldMinAgeKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMinAge, (int)7, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldMaxAgeFocusLost(FocusEvent evt) {
        double age;
        try {
            age = Double.parseDouble(this.jTextFieldMaxAge.getText().trim());
        }
        catch (NumberFormatException e) {
            age = -1.0;
        }
        this.model.setMaxAge(age);
        this.model.fireTableDataChanged();
    }

    private void jTextFieldMaxAgeKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMaxAge, (int)7, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTopCSUFocusLost(FocusEvent evt) {
        double csu;
        try {
            csu = Double.parseDouble(this.jTextFieldTopCSU.getText().trim());
        }
        catch (NumberFormatException e) {
            csu = -1.0;
        }
        this.model.setTopCSU(csu);
        this.model.fireTableDataChanged();
    }

    private void jTextFieldTopCSUKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldTopCSU, (int)5, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseCSUFocusLost(FocusEvent evt) {
        double csu;
        try {
            csu = Double.parseDouble(this.jTextFieldBaseCSU.getText().trim());
        }
        catch (NumberFormatException e) {
            csu = -1.0;
        }
        this.model.setBaseCSU(csu);
        this.model.fireTableDataChanged();
    }

    private void jTextFieldBaseCSUKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldBaseCSU, (int)5, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jRadioButtonAgeActionPerformed(ActionEvent evt) {
        if (this.jTextFieldTopCSU.isEnabled()) {
            this.jTextFieldTopCSU.setEnabled(false);
            this.jTextFieldBaseCSU.setEnabled(false);
            this.model.fireTableDataChanged();
        }
        this.model.setAgeScale(true);
    }

    private void jRadioButtonCSUActionPerformed(ActionEvent evt) {
        if (!this.jTextFieldTopCSU.isEnabled()) {
            this.jTextFieldTopCSU.setEnabled(true);
            this.jTextFieldBaseCSU.setEnabled(true);
            this.model.fireTableDataChanged();
        }
        this.model.setAgeScale(false);
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)100, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldNameFocusLost(FocusEvent evt) {
        this.model.setNameField(this.jTextFieldName.getText().trim());
    }

    private void jButtonChronoActionPerformed(ActionEvent evt) {
        try {
            LinkedList<IGDScheme> schemes = new LinkedList<IGDScheme>(this.sbdb.getIGDSchemes(3));
            Collections.sort(schemes);
            DialogList<IGDScheme> dialog = new DialogList<IGDScheme>(this.parentDialog, true, "Select Scheme", null, schemes, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            dialog.getOptionalSelection().ifPresent(selection -> {
                this.model.parentScheme = selection;
                this.jTextFieldChrono.setText(this.model.parentScheme.getName());
            });
        }
        catch (RuntimeException | SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parentDialog);
        }
    }

    private void jCheckBoxInheritedActionPerformed(ActionEvent evt) {
        this.model.initEvents(this.jCheckBoxInherited.isSelected());
    }

    private void jComboBoxParentCmpStdActionPerformed(ActionEvent evt) {
        CompositeStandard csItem;
        Object item = this.jComboBoxParentCmpStd.getSelectedItem();
        CompositeStandard selected = item instanceof CompositeStandard ? (csItem = (CompositeStandard)item) : null;
        this.model.setParentCmpStd(selected);
    }
}

