/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.igdscheme;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.SchemeBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartTemplate;
import jsbchart.core.PanelKey;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.core.PanelWellHeader;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelLithostratScheme;
import jsbchart.panel.PanelLithostratSchemeProperties;
import jsbchart.panel.PanelScale;
import jsbchart.panel.PanelScaleProperties;
import jsbchart.panel.SBPanel;
import jsbugs.ChartJPanel;
import jsbugs.DialogChartTemplates;
import jsbugs.FrameJsbugs;
import jsbugs.model2.igdscheme.LithostratTableModel;
import jsbugs.uiutil.CursorFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.LithostratUnit;
import model3.LithostratUnitClass;
import model3.SBdb;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsCompoundEdit;
import util.SbugsEdit;

public class InteractiveChartJPanelLithostrat
extends ChartJPanel {
    private final LithostratTableModel model;
    private PanelLithostratSchemeBuilder panel;
    private final SBdb sbdb;
    private final int schID;
    private boolean ctrlKeyDown = false;
    private boolean altKeyDown = false;
    private boolean shiftKeyDown = false;
    private UnitBuilderForegroundCorner cornerDragOrigin;
    private Float minDragY;
    private Float maxDragY;
    private Float minDragX;
    private Float maxDragX;
    private Point2D.Float lastDragPoint;
    private Point2D.Float newUnitDragOrigin;
    private Point2D.Float unitDragOriginPoint;
    private PanelLithostratSchemeBuilder.UnitBuilderForeground unitDragOrigin;
    private UndoManager undoManager = null;
    private UndoableEditSupport undoSupport = null;

    InteractiveChartJPanelLithostrat(LithostratTableModel model, SBdb sbdb, int schID, ChartManager chartManager) throws SQLException, SBException {
        super(new Chart());
        this.sbdb = sbdb;
        this.model = model;
        this.schID = schID;
        this.init(chartManager);
    }

    private void init(ChartManager chartManager) throws SQLException, SBException {
        BlockTemplate templ = null;
        if (this.schID > 0) {
            String sql = "SELECT block_id,b_prop,c_prop,header,cht_key FROM " + this.sbdb.DBTableName("CHTPREF_SCH") + " WHERE user_id=" + this.sbdb.getUserID() + " AND location=" + SB.DBString((String)this.getLocationString());
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    templ = chartManager.getBlockTemplate(rs.getInt("block_id"));
                    String bProp = rs.getString("b_prop");
                    String cProp = rs.getString("c_prop");
                    String header = rs.getString("header");
                    String key = rs.getString("cht_key");
                    if (templ != null) {
                        ChartTemplate.BlockOcc occ = new ChartTemplate.BlockOcc(templ.getID(), 0, 0, 0, bProp, null);
                        SchemeBlock block = this.getBlockWithReplacedPanel(templ, occ, chartManager);
                        this.chart.addBlock(block);
                        this.chart.setProperties(new ChartProperties(cProp, 0));
                        if (header != null && !header.isEmpty()) {
                            this.chart.getProperties().header = new PanelWellHeader(header);
                        }
                        if (key != null && !key.isEmpty()) {
                            this.chart.getProperties().key = new PanelKey(key);
                        }
                    }
                }
            }
            catch (SQLException sqle) {
                FrameJsbugs.showStackError("SQL Error", sqle, this.sbdb);
            }
        }
        if (templ == null) {
            this.setupChart(null, chartManager);
        }
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ InteractiveChartJPanelLithostrat this$0;
            {
                InteractiveChartJPanelLithostrat interactiveChartJPanelLithostrat = this$0;
                Objects.requireNonNull(interactiveChartJPanelLithostrat);
                this.this$0 = interactiveChartJPanelLithostrat;
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                this.this$0.mMoved(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ InteractiveChartJPanelLithostrat this$0;
            {
                InteractiveChartJPanelLithostrat interactiveChartJPanelLithostrat = this$0;
                Objects.requireNonNull(interactiveChartJPanelLithostrat);
                this.this$0 = interactiveChartJPanelLithostrat;
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                this.this$0.mDragged(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InteractiveChartJPanelLithostrat this$0;
            {
                InteractiveChartJPanelLithostrat interactiveChartJPanelLithostrat = this$0;
                Objects.requireNonNull(interactiveChartJPanelLithostrat);
                this.this$0 = interactiveChartJPanelLithostrat;
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.mReleased(evt);
            }
        });
        this.removeAltKeyListener();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(this){
            final /* synthetic */ InteractiveChartJPanelLithostrat this$0;
            {
                InteractiveChartJPanelLithostrat interactiveChartJPanelLithostrat = this$0;
                Objects.requireNonNull(interactiveChartJPanelLithostrat);
                this.this$0 = interactiveChartJPanelLithostrat;
            }

            @Override
            public boolean dispatchKeyEvent(KeyEvent ke) {
                switch (ke.getID()) {
                    case 401: {
                        if (ke.getKeyCode() == 17) {
                            this.this$0.ctrlKeyDown = true;
                            break;
                        }
                        if (ke.getKeyCode() == 18) {
                            this.this$0.altKeyDown = true;
                            break;
                        }
                        if (ke.getKeyCode() != 16) break;
                        this.this$0.shiftKeyDown = true;
                        break;
                    }
                    case 402: {
                        if (ke.getKeyCode() == 17) {
                            this.this$0.ctrlKeyDown = false;
                            break;
                        }
                        if (ke.getKeyCode() == 18) {
                            this.this$0.altKeyDown = false;
                            break;
                        }
                        if (ke.getKeyCode() != 16) break;
                        this.this$0.shiftKeyDown = false;
                    }
                }
                return false;
            }
        });
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
    }

    private void postEdit(UndoableEdit edit) {
        if (edit != null) {
            this.undoManager.addEdit(edit);
            this.undoSupport.postEdit(edit);
            this.repaint();
        }
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public UndoableEditSupport getUndoSupport() {
        return this.undoSupport;
    }

    private SchemeBlock getBlockWithReplacedPanel(BlockTemplate template, ChartTemplate.BlockOcc occ, ChartManager chartManager) throws SQLException, SBException {
        SchemeBlock block = (SchemeBlock)ChartFactory.createBlock(this.sbdb, template, occ);
        this.panel = new PanelLithostratSchemeBuilder(this, block);
        PanelLithostratScheme lithPanel = null;
        for (SBPanel p : block.getPanels()) {
            if (!(p instanceof PanelLithostratScheme) || ((PanelLithostratSchemeProperties)p.getProperties()).getIGDSchemeID() != this.schID) continue;
            lithPanel = (PanelLithostratScheme)p;
            break;
        }
        if (lithPanel != null) {
            int index = block.getPanels().indexOf(lithPanel);
            block.removePanel(lithPanel);
            this.panel = new PanelLithostratSchemeBuilder(this, chartManager.getPanelTemplate(lithPanel.getTemplateID()), block, lithPanel.getPanelOcc());
            this.panel.setProperties(lithPanel.getProperties());
            block.addPanelAt(index, this.panel);
        } else {
            block.addPanel(this.panel);
        }
        block.setSelectedPanel(this.panel);
        return block;
    }

    void setupChart(BlockTemplate template, ChartManager chartManager) {
        try {
            SchemeBlock block;
            if (template != null) {
                block = this.getBlockWithReplacedPanel(template, null, chartManager);
            } else {
                block = new SchemeBlock(this.sbdb);
                PanelScale panelScale = new PanelScale(block, new PanelScaleProperties(null));
                panelScale.getProperties().setProperty(1, (Object)PanelScaleProperties.ScaleType._AGE);
                block.addPanel(panelScale);
                this.panel = new PanelLithostratSchemeBuilder(this, block);
                block.addPanel(this.panel);
                block.setSelectedPanel(this.panel);
                IGDScheme scheme = this.sbdb.getIGDScheme(this.schID);
                if (scheme != null) {
                    float minAge = (float)scheme.getMinAge() - 5.0f;
                    float maxAge = (float)scheme.getMaxAge() + 5.0f;
                    block.getProp().setLimits(minAge, maxAge);
                }
                block.setIdealScale();
            }
            this.chart = new Chart();
            this.chart.getProperties().setPanelSubHeaderHeight(40.0f);
            this.chart.addBlock(block);
            this.chart.setData();
            this.updatePref();
        }
        catch (IOException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error setting up chart", e);
            this.chart = new Chart();
            this.panel = null;
        }
    }

    void updatePref() {
        BlockTemplate template;
        BlockTemplate blockTemplate = template = this.chart.getBlockSingle() != null ? this.chart.getBlockSingle().getTemplate() : null;
        if (template != null && this.getLocationString() != null) {
            String sql1 = "DELETE FROM " + this.sbdb.DBTableName("CHTPREF_SCH") + " WHERE location=" + SB.DBString((String)this.getLocationString()) + " AND block_id=" + template.getID() + " AND user_id=" + this.sbdb.getUserID();
            String sql2 = "INSERT INTO " + this.sbdb.DBTableName("CHTPREF_SCH") + "(block_id,user_id,location,b_prop,c_prop,header,cht_key,sch_id) VALUES (" + template.getID() + "," + this.sbdb.getUserID() + "," + SB.DBString((String)this.getLocationString()) + "," + SB.DBString((String)this.chart.getBlockSingle().getProperties()) + "," + SB.DBString((String)this.chart.getProperties().getProperties()) + "," + SB.DBString((String)this.chart.getProperties().getHeader()) + "," + SB.DBString((String)this.chart.getProperties().getKey()) + "," + String.valueOf(this.chart.getProperties().bgSchID > 0 ? Integer.valueOf(this.chart.getProperties().bgSchID) : "NULL") + ")";
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                stmt.executeUpdate(this.sbdb.modQuery(sql1));
                stmt.executeUpdate(this.sbdb.modQuery(sql2));
                this.sbdb.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void mDragged(MouseEvent evt) {
        Point2D.Float mmPoint = this.getPoint(evt.getPoint());
        Point2D.Float pInPanel = new Point2D.Float();
        if (this.chart.getPanel(mmPoint, this.hMode(), this.vMode(), pInPanel) != this.panel) {
            return;
        }
        Point2D.Float panelOrigin = this.chart.getMmPanelOrigin(this.panel, this.hMode(), this.vMode(), 0.0f);
        if (this.cornerDragOrigin == null && this.newUnitDragOrigin == null && this.unitDragOrigin == null) {
            UnitBuilderForegroundCorner corner = this.panel.getCorner(pInPanel.x, pInPanel.y);
            if (corner != null) {
                this.cornerDragOrigin = corner;
                this.setCursor(CursorFactory.getDragMoveCursor());
                float minX = 0.0f;
                float maxX = 1.0f;
                double minAge = 0.0;
                double maxAge = this.panel.getBlock().getAgeLimit(false);
                switch (corner.address) {
                    case 0: {
                        maxX = corner.unit.builder.getX(1);
                        maxAge = corner.unit.builder.getAge(3);
                        break;
                    }
                    case 1: {
                        minX = corner.unit.builder.getX(0);
                        maxAge = corner.unit.builder.getAge(2);
                        break;
                    }
                    case 3: {
                        maxX = corner.unit.builder.getX(2);
                        minAge = corner.unit.builder.getAge(0);
                        break;
                    }
                    case 2: {
                        minX = corner.unit.builder.getX(3);
                        minAge = corner.unit.builder.getAge(1);
                    }
                }
                this.minDragY = Float.valueOf(this.panel.getBlock().scale((float)minAge, BlockProperties.ScaleType.AGE) + panelOrigin.y);
                this.maxDragY = Float.valueOf(this.panel.getBlock().scale((float)maxAge, BlockProperties.ScaleType.AGE) + panelOrigin.y);
                this.minDragX = Float.valueOf(minX * this.panel.getColumnWidth() + panelOrigin.x);
                this.maxDragX = Float.valueOf(maxX * this.panel.getColumnWidth() + panelOrigin.x);
            } else if (this.ctrlKeyDown) {
                this.newUnitDragOrigin = new Point2D.Float(mmPoint.x, mmPoint.y);
            } else {
                PanelLithostratSchemeBuilder.UnitBuilderForeground toMove = this.panel.getChildAtPoint(new Point2D.Float(mmPoint.x - panelOrigin.x, mmPoint.y - panelOrigin.y));
                if (toMove != null) {
                    this.unitDragOrigin = toMove;
                    this.unitDragOriginPoint = new Point2D.Float(mmPoint.x, mmPoint.y);
                }
            }
        } else {
            Graphics g = this.getGraphics();
            AffineTransform tf = this.setRubberBandMode(g);
            if (this.lastDragPoint != null && this.shiftKeyDown) {
                mmPoint.x = this.lastDragPoint.x;
            }
            if (this.lastDragPoint != null && this.altKeyDown) {
                mmPoint.y = this.lastDragPoint.y;
            }
            if (this.cornerDragOrigin != null) {
                Point2D.Float mmPointi;
                PanelLithostratSchemeBuilder.UnitBuilderForeground parent = this.panel.getParentOf(this.cornerDragOrigin.unit);
                if (parent != null && !parent.area.contains(mmPointi = new Point2D.Float(mmPoint.x - panelOrigin.x, mmPoint.y - panelOrigin.y))) {
                    mmPoint.setLocation(this.lastDragPoint.x, this.lastDragPoint.y);
                }
                if (mmPoint.x < this.minDragX.floatValue()) {
                    mmPoint.x = this.minDragX.floatValue();
                } else if (mmPoint.x > this.maxDragX.floatValue()) {
                    mmPoint.x = this.maxDragX.floatValue();
                }
                if (mmPoint.y < this.minDragY.floatValue()) {
                    mmPoint.y = this.minDragY.floatValue();
                } else if (mmPoint.y > this.maxDragY.floatValue()) {
                    mmPoint.y = this.maxDragY.floatValue();
                }
                Point2D.Float cornerPointBefore = this.cornerDragOrigin.unit.getNeighbour(this.cornerDragOrigin.address, true);
                cornerPointBefore.setLocation(cornerPointBefore.x + panelOrigin.x, cornerPointBefore.y + panelOrigin.y);
                Point2D.Float cornerPointAfter = this.cornerDragOrigin.unit.getNeighbour(this.cornerDragOrigin.address, false);
                cornerPointAfter.setLocation(cornerPointAfter.x + panelOrigin.x, cornerPointAfter.y + panelOrigin.y);
                if (this.lastDragPoint != null) {
                    this.drawLine(g, cornerPointBefore, this.lastDragPoint);
                    this.drawLine(g, cornerPointAfter, this.lastDragPoint);
                }
                this.drawLine(g, cornerPointBefore, mmPoint);
                this.drawLine(g, cornerPointAfter, mmPoint);
            } else if (this.newUnitDragOrigin != null) {
                Point2D.Float p2;
                Point2D.Float p1;
                if (this.lastDragPoint != null) {
                    p1 = new Point2D.Float(this.newUnitDragOrigin.x, this.lastDragPoint.y);
                    p2 = new Point2D.Float(this.lastDragPoint.x, this.newUnitDragOrigin.y);
                    this.drawLine(g, this.newUnitDragOrigin, p1);
                    this.drawLine(g, this.newUnitDragOrigin, p2);
                    this.drawLine(g, this.lastDragPoint, p1);
                    this.drawLine(g, this.lastDragPoint, p2);
                }
                p1 = new Point2D.Float(this.newUnitDragOrigin.x, mmPoint.y);
                p2 = new Point2D.Float(mmPoint.x, this.newUnitDragOrigin.y);
                this.drawLine(g, this.newUnitDragOrigin, p1);
                this.drawLine(g, this.newUnitDragOrigin, p2);
                this.drawLine(g, mmPoint, p1);
                this.drawLine(g, mmPoint, p2);
            } else if (this.unitDragOrigin != null) {
                Point2D.Float[] toDraw;
                PanelLithostratSchemeBuilder.UnitBuilderForeground parent = this.panel.getParentOf(this.unitDragOrigin);
                Area confines = parent != null ? parent.area : new Area(new Rectangle2D.Float(0.0f, 0.0f, this.panel.getColumnWidth(), (this.panel.getBlock().getProp().getMax() - this.panel.getBlock().getProp().getMin()) * this.panel.getBlock().getProp().getScale()));
                float dx = this.unitDragOriginPoint.x - mmPoint.x;
                float dy = this.unitDragOriginPoint.y - mmPoint.y;
                float[] xPoints = new float[4];
                float[] yPoints = new float[4];
                for (int i = 0; i < yPoints.length; ++i) {
                    Point2D.Float corner = this.unitDragOrigin.getPoint(i);
                    xPoints[i] = corner.x - dx;
                    yPoints[i] = corner.y - dy;
                    if (confines.contains(new Point2D.Float(xPoints[i], yPoints[i]))) continue;
                    if (this.lastDragPoint != null) {
                        if (this.panel.getColumnWidth() - Math.abs(xPoints[1] - xPoints[0]) < 5.0f || this.panel.getColumnWidth() - Math.abs(xPoints[2] - xPoints[3]) < 5.0f) {
                            mmPoint.setLocation(this.lastDragPoint.x, mmPoint.y);
                            break;
                        }
                        mmPoint.setLocation(this.lastDragPoint.x, this.lastDragPoint.y);
                        break;
                    }
                    return;
                }
                for (Point2D.Float p : toDraw = new Point2D.Float[]{this.lastDragPoint, mmPoint}) {
                    if (p == null) continue;
                    float dx2 = this.unitDragOriginPoint.x - p.x;
                    float dy2 = this.unitDragOriginPoint.y - p.y;
                    float[] xPoints2 = new float[4];
                    float[] yPoints2 = new float[4];
                    for (int i = 0; i < yPoints2.length; ++i) {
                        Point2D.Float corner = this.unitDragOrigin.getPoint(i);
                        xPoints2[i] = corner.x + panelOrigin.x - dx2;
                        yPoints2[i] = corner.y + panelOrigin.y - dy2;
                    }
                    this.drawPolygon(g, xPoints2, yPoints2);
                }
            }
            this.lastDragPoint = mmPoint;
            this.clearRubberBandMode(g, tf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mReleased(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
        try {
            if (this.lastDragPoint != null) {
                if (this.chart.getPanel(this.lastDragPoint, this.hMode(), this.vMode()) != this.panel) {
                    return;
                }
                Point2D.Float panelOrigin = this.chart.getMmPanelOrigin(this.panel, this.hMode(), this.vMode(), 0.0f);
                this.lastDragPoint.setLocation(this.lastDragPoint.x - panelOrigin.x, this.lastDragPoint.y - panelOrigin.y);
                float x = this.lastDragPoint.x / this.panel.getColumnWidth();
                float age = this.panel.getAge(this.lastDragPoint.y);
                if (this.cornerDragOrigin != null) {
                    if (this.cornerDragOrigin.unit.checkCornerUpdate(this.cornerDragOrigin.address, this.lastDragPoint)) {
                        this.postEdit((UndoableEdit)((Object)new BuilderUpdate(this.cornerDragOrigin.unit.builder)));
                        if (!this.ctrlKeyDown) {
                            this.cornerDragOrigin.unit.builder.x(this.cornerDragOrigin.address, x);
                        }
                        if (!this.altKeyDown) {
                            this.cornerDragOrigin.unit.builder.age(this.cornerDragOrigin.address, age);
                        }
                    }
                } else if (this.unitDragOrigin != null) {
                    this.unitDragOriginPoint.setLocation(this.unitDragOriginPoint.x - panelOrigin.x, this.unitDragOriginPoint.y - panelOrigin.y);
                    float dx = this.unitDragOriginPoint.x - this.lastDragPoint.x;
                    float dy = this.unitDragOriginPoint.y - this.lastDragPoint.y;
                    SbugsCompoundEdit edit = new SbugsCompoundEdit("Move");
                    this.unitDragOrigin.move(edit, this.ctrlKeyDown ? 0.0f : (dx /= this.panel.getColumnWidth()), this.altKeyDown ? 0.0f : (dy *= this.panel.getBlock().getAgeScale()));
                    this.postEdit((UndoableEdit)edit);
                } else if (this.newUnitDragOrigin != null) {
                    double[] ageArr;
                    this.newUnitDragOrigin.setLocation(this.newUnitDragOrigin.x - panelOrigin.x, this.newUnitDragOrigin.y - panelOrigin.y);
                    LithostratUnit.Builder builder = this.model.newBuilder(this.sbdb);
                    PanelLithostratSchemeBuilder.UnitBuilderForeground parent = this.panel.getChildAtPoint(this.newUnitDragOrigin);
                    if (parent != null) {
                        int hier = parent.builder.getHier() + 1;
                        if (hier > IGDIntervalZone.getNHier(2, true)) {
                            return;
                        }
                        builder.hier(hier);
                    } else {
                        builder.hier(2);
                    }
                    float originX = this.newUnitDragOrigin.x / this.panel.getColumnWidth();
                    float orinAge = this.panel.getAge(this.newUnitDragOrigin.y);
                    ageArr = new double[]{Math.min(orinAge, age), ageArr[0], Math.max(orinAge, age), ageArr[2]};
                    builder.age(ageArr);
                    float[] xArr = new float[4];
                    xArr[0] = Math.min(originX, x);
                    xArr[3] = xArr[0];
                    xArr[1] = Math.max(originX, x);
                    xArr[2] = xArr[1];
                    builder.x(xArr);
                    if (this.panel.addBuilder(builder, parent)) {
                        String name = JOptionPane.showInputDialog(this, "Enter new unit name:", "New Unit", -1);
                        if (name == null || name.isEmpty()) {
                            this.panel.removeBuilder(builder);
                            return;
                        }
                        builder.name(name);
                    }
                }
            }
        }
        finally {
            this.cornerDragOrigin = null;
            this.lastDragPoint = null;
            this.newUnitDragOrigin = null;
            this.unitDragOrigin = null;
            this.unitDragOriginPoint = null;
            this.repaint();
        }
    }

    private void mMoved(MouseEvent evt) {
        Point2D.Float mmPoint = this.getPoint(evt.getPoint());
        if (this.chart.getPanel(mmPoint, this.hMode(), this.vMode()) == this.panel) {
            Point2D.Float panelOrigin = this.chart.getMmPanelOrigin(this.panel, this.hMode(), this.vMode(), 0.0f);
            UnitBuilderForegroundCorner corner = this.panel.getCorner(mmPoint.x - panelOrigin.x, mmPoint.y - panelOrigin.y);
            if (corner != null) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void chooseTemplate(Dialog parent, ChartManager chartManager) {
        DialogChartTemplates dialog = new DialogChartTemplates(parent, true, this.sbdb, chartManager, BlockType.SCHEME, null, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null && dialog.selection.size() == 1 && dialog.selection.get(0) instanceof BlockTemplate) {
            this.setupChart((BlockTemplate)dialog.selection.get(0), chartManager);
            this.repaint();
        }
    }

    String getLocationString() {
        if (this.schID == 0) {
            return null;
        }
        String s = "DSC" + this.schID;
        if (s.length() > 10) {
            return null;
        }
        return s;
    }

    private class PanelLithostratSchemeBuilder
    extends PanelLithostratScheme {
        List<UnitBuilderForeground> data;
        final /* synthetic */ InteractiveChartJPanelLithostrat this$0;

        UnitBuilderForegroundCorner getCorner(float x, float y) {
            if (this.data == null) {
                return null;
            }
            for (UnitBuilderForeground unit : this.data) {
                UnitBuilderForegroundCorner corner = unit.getCorner(x, y);
                if (corner == null) continue;
                return corner;
            }
            return null;
        }

        boolean addBuilder(LithostratUnit.Builder builder, UnitBuilderForeground parent) {
            if (parent != null) {
                UnitBuilderForeground f = this.checkAndTrim(builder, parent);
                if (f == null) {
                    return false;
                }
                parent.addChild(f);
            } else {
                this.data.add(this.createForeground(builder));
            }
            this.this$0.model.scheme.add(builder);
            this.this$0.model.fireTableDataChanged();
            return true;
        }

        void removeBuilder(LithostratUnit.Builder builder) {
            ListIterator<UnitBuilderForeground> it = this.data.listIterator();
            while (it.hasNext()) {
                UnitBuilderForeground f = (UnitBuilderForeground)it.next();
                if (f.builder == builder) {
                    it.remove();
                    return;
                }
                if (!f.removeChild(builder)) continue;
                return;
            }
        }

        UnitBuilderForeground getParentOf(UnitBuilderForeground f) {
            UnitBuilderForeground fg;
            UnitBuilderForeground parent = null;
            Iterator<UnitBuilderForeground> iterator = this.data.iterator();
            while (iterator.hasNext() && (parent = (fg = iterator.next()).getDirectParent(f)) == null) {
            }
            return parent;
        }

        private UnitBuilderForeground checkAndTrim(LithostratUnit.Builder builder, UnitBuilderForeground parent) {
            Area copyOfChild = new Area(builder.getArea());
            copyOfChild.intersect(parent.builder.getArea());
            if (!copyOfChild.equals(builder.getArea())) {
                double[] coords;
                int type;
                PathIterator pathIterator = copyOfChild.getPathIterator(null);
                float[] newXpoints = new float[4];
                double[] newYpoints = new double[4];
                int i = 0;
                while (!pathIterator.isDone() && (type = pathIterator.currentSegment(coords = new double[6])) != 4) {
                    System.out.println("coords: " + coords[0] + "," + coords[1] + "  type: " + type);
                    if (i < 4 && (i == 0 || Math.abs(coords[0] - (double)newXpoints[i - 1]) > 0.001 || Math.abs(coords[1] - newYpoints[i - 1]) > 0.01)) {
                        newXpoints[i] = (float)coords[0];
                        newYpoints[i] = coords[1];
                        ++i;
                    }
                    pathIterator.next();
                }
                float tempx = newXpoints[1];
                double tempy = newYpoints[1];
                newXpoints[1] = newXpoints[3];
                newYpoints[1] = newYpoints[3];
                newXpoints[3] = tempx;
                newYpoints[3] = tempy;
                double[] age = new double[4];
                float[] x = new float[4];
                for (int j = 0; j < 4; ++j) {
                    age[j] = newYpoints[j] / 1000000.0;
                    x[j] = newXpoints[j] / 100000.0f;
                }
                builder.age(age);
                builder.x(x);
                try {
                    IGDScheme.testLithostratUnits(builder, parent.builder);
                }
                catch (InvalidFieldException ife) {
                    System.out.println("It didn't work");
                    return null;
                }
            }
            return this.createForeground(builder);
        }

        UnitBuilderForeground getChildAtPoint(Point2D.Float p) {
            UnitBuilderForeground f = null;
            for (UnitBuilderForeground u : this.data) {
                f = u.getChildAtPoint(p);
                if (f == null) continue;
                return f;
            }
            return f;
        }

        public PanelLithostratSchemeBuilder(InteractiveChartJPanelLithostrat interactiveChartJPanelLithostrat, SchemeBlock block) throws SQLException, SBException {
            InteractiveChartJPanelLithostrat interactiveChartJPanelLithostrat2 = interactiveChartJPanelLithostrat;
            Objects.requireNonNull(interactiveChartJPanelLithostrat2);
            this.this$0 = interactiveChartJPanelLithostrat2;
            super(block, null);
        }

        public PanelLithostratSchemeBuilder(InteractiveChartJPanelLithostrat interactiveChartJPanelLithostrat, PanelTemplate template, SchemeBlock block, PanelOcc occ) throws SQLException, SBException {
            InteractiveChartJPanelLithostrat interactiveChartJPanelLithostrat2 = interactiveChartJPanelLithostrat;
            Objects.requireNonNull(interactiveChartJPanelLithostrat2);
            this.this$0 = interactiveChartJPanelLithostrat2;
            super(template, block, occ);
        }

        float getColumnWidth() {
            return ((Number)this.getProperties().getProperty(1)).floatValue();
        }

        private UnitBuilderForeground createForeground(LithostratUnitClass builder) {
            float columnWidth = this.getColumnWidth();
            LithostratUnitClass unit = builder;
            float[] xPoints = new float[4];
            for (int i = 0; i < xPoints.length; ++i) {
                xPoints[i] = unit.getX(i) * columnWidth;
            }
            float[] yPoints = new float[4];
            for (int i = 0; i < yPoints.length; ++i) {
                double age = unit.getAge(i);
                switch (i) {
                    case 0: 
                    case 1: {
                        if (!(age < (double)this.getBlock().getProp().getMin())) break;
                        age = this.getBlock().getProp().getMin();
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (!(age > (double)this.getBlock().getProp().getMax())) break;
                        age = this.getBlock().getProp().getMax();
                    }
                }
                yPoints[i] = this.getBlock().scale((float)age, BlockProperties.ScaleType.AGE);
            }
            return new UnitBuilderForeground(this, unit, xPoints, yPoints);
        }

        @Override
        protected List<PanelLithostratScheme.UnitForeground> setData(ChartProperties cp, double[][] sections, BlockProperties bp) throws SBException {
            ArrayList<LithostratUnitClass> bases = new ArrayList<LithostratUnitClass>();
            for (Object b : this.this$0.model.scheme) {
                bases.add((LithostratUnitClass)b);
            }
            Collections.sort(bases, new IGDScheme.UnitHierComparator());
            ArrayList<UnitBuilderForeground> foregrounds = new ArrayList<UnitBuilderForeground>();
            for (LithostratUnitClass base : bases) {
                if (!base.hasAges() || base.getLage() <= (double)bp.getMin() || base.getUage() >= (double)bp.getMax()) continue;
                UnitBuilderForeground unitF = this.createForeground(base);
                boolean isChild = false;
                for (UnitBuilderForeground f : foregrounds) {
                    if (!f.addChild(unitF)) continue;
                    isChild = true;
                    break;
                }
                if (isChild) continue;
                foregrounds.add(unitF);
            }
            this.data = foregrounds;
            LinkedList<PanelLithostratScheme.UnitForeground> list = new LinkedList<PanelLithostratScheme.UnitForeground>();
            list.addAll(foregrounds);
            return list;
        }

        @Override
        public String getLithostratCaption() {
            return "Caption";
        }

        float getAge(float yPos) {
            return yPos * this.getBlock().getAgeScale() + this.getBlock().getProp().getMin();
        }

        private class UnitBuilderForeground
        extends PanelLithostratScheme.UnitForeground {
            private final LithostratUnit.Builder builder;
            private final Area area;

            UnitBuilderForegroundCorner getCorner(float x, float y) {
                float tolerance = 1.5f;
                for (int i = 0; i < this.xPoints.length; ++i) {
                    if (!(Math.abs(this.xPoints[i] - x) < tolerance) || !(Math.abs(this.yPoints[i] - y) < tolerance)) continue;
                    return new UnitBuilderForegroundCorner(i, this);
                }
                if (this.containsPoint(x, y) != null && this.children != null) {
                    for (PanelLithostratScheme.UnitForeground uf : this.children) {
                        UnitBuilderForegroundCorner corner = ((UnitBuilderForeground)uf).getCorner(x, y);
                        if (corner == null) continue;
                        return corner;
                    }
                }
                return null;
            }

            Point2D.Float getNeighbour(int address, boolean before) {
                if (before) {
                    if (--address < 0) {
                        address = this.xPoints.length - 1;
                    }
                } else if (++address >= this.xPoints.length) {
                    address = 0;
                }
                return this.getPoint(address);
            }

            UnitBuilderForeground getDirectParent(UnitBuilderForeground child) {
                if (this.children == null) {
                    return null;
                }
                for (PanelLithostratScheme.UnitForeground c : this.children) {
                    if (c == child) {
                        return this;
                    }
                    UnitBuilderForeground parent = ((UnitBuilderForeground)c).getDirectParent(child);
                    if (parent == null) continue;
                    return parent;
                }
                return null;
            }

            UnitBuilderForeground getChildAtPoint(Point2D.Float p) {
                if (this.area.contains(p)) {
                    UnitBuilderForeground f = null;
                    if (this.children != null) {
                        PanelLithostratScheme.UnitForeground child;
                        Iterator iterator = this.children.iterator();
                        while (iterator.hasNext() && (f = ((UnitBuilderForeground)(child = (PanelLithostratScheme.UnitForeground)iterator.next())).getChildAtPoint(p)) == null) {
                        }
                    }
                    return f == null ? this : f;
                }
                return null;
            }

            Point2D.Float getPoint(int address) {
                return new Point2D.Float(this.xPoints[address], this.yPoints[address]);
            }

            public UnitBuilderForeground(PanelLithostratSchemeBuilder panelLithostratSchemeBuilder, LithostratUnitClass unit, float[] xPoints, float[] yPoints) {
                Objects.requireNonNull(panelLithostratSchemeBuilder);
                super(panelLithostratSchemeBuilder, unit, xPoints, yPoints);
                this.builder = (LithostratUnit.Builder)unit;
                GeneralPath path = new GeneralPath();
                for (int i = 0; i < yPoints.length; ++i) {
                    if (i == 0) {
                        path.moveTo(xPoints[i], yPoints[i]);
                        continue;
                    }
                    path.lineTo(xPoints[i], yPoints[i]);
                }
                this.area = new Area(path);
            }

            @Override
            protected float[][] draw(SBGraphics g, ChartProperties cp, Area parentArea, float x, float y) {
                float[][] points = super.draw(g, cp, parentArea, x, y);
                float[] ixPoints = points[0];
                float[] iyPoints = points[1];
                g.setColor(cp.foreground);
                float pointSize = 1.5f;
                for (int i = 0; i < iyPoints.length; ++i) {
                    g.fillEllipse(ixPoints[i] - 0.75f, iyPoints[i] - 0.75f, 1.5f, 1.5f, cp.foreground);
                }
                return points;
            }

            @Override
            protected boolean addChild(PanelLithostratScheme.UnitForeground child) {
                return super.addChild(child);
            }

            boolean removeChild(LithostratUnit.Builder builder) {
                if (this.children != null) {
                    ListIterator it = this.children.listIterator();
                    while (it.hasNext()) {
                        UnitBuilderForeground child = (UnitBuilderForeground)it.next();
                        if (child.builder == builder) {
                            it.remove();
                            return true;
                        }
                        if (!child.removeChild(builder)) continue;
                        return true;
                    }
                }
                return false;
            }

            boolean checkCornerUpdate(int address, Point2D.Float newLocation) {
                float[] newXPoints = Arrays.copyOf(this.xPoints, this.xPoints.length);
                newXPoints[address] = newLocation.x;
                float[] newYPoints = Arrays.copyOf(this.yPoints, this.yPoints.length);
                newYPoints[address] = newLocation.y;
                Line2D.Float upper = new Line2D.Float(newXPoints[0], newYPoints[0], newXPoints[1], newYPoints[1]);
                Line2D.Float lower = new Line2D.Float(newXPoints[3], newYPoints[3], newXPoints[2], newYPoints[2]);
                if (upper.intersectsLine(lower)) {
                    return false;
                }
                Line2D.Float west = new Line2D.Float(newXPoints[0], newYPoints[0], newXPoints[3], newYPoints[3]);
                Line2D.Float east = new Line2D.Float(newXPoints[1], newYPoints[1], newXPoints[2], newYPoints[2]);
                if (west.intersectsLine(east)) {
                    return false;
                }
                boolean[] extremeE = new boolean[]{newXPoints[0] > newXPoints[2], newXPoints[1] < newXPoints[3], newXPoints[2] < newXPoints[0], newXPoints[3] > newXPoints[1]};
                boolean[] extremeY = new boolean[]{newYPoints[0] > newYPoints[2], newYPoints[1] > newYPoints[3], newYPoints[2] < newYPoints[0], newYPoints[3] < newYPoints[1]};
                for (int i = 0; i < 4; ++i) {
                    if (!extremeE[i] || !extremeY[i]) continue;
                    return false;
                }
                return true;
            }

            private void move(SbugsCompoundEdit edit, float dX, float dAge) {
                edit.addEdit((UndoableEdit)((Object)new BuilderUpdate(this.builder)));
                for (int i = 0; i < 4; ++i) {
                    this.builder.x(i, this.builder.getX(i) - dX);
                    this.builder.age(i, this.builder.getAge(i) - (double)dAge);
                }
                if (this.children != null) {
                    for (PanelLithostratScheme.UnitForeground child : this.children) {
                        ((UnitBuilderForeground)child).move(edit, dX, dAge);
                    }
                }
            }
        }
    }

    private static class UnitBuilderForegroundCorner {
        final int address;
        final PanelLithostratSchemeBuilder.UnitBuilderForeground unit;

        public UnitBuilderForegroundCorner(int address, PanelLithostratSchemeBuilder.UnitBuilderForeground unit) {
            this.address = address;
            this.unit = unit;
        }
    }

    private static class BuilderUpdate
    extends SbugsEdit {
        private final LithostratUnit.Builder builder;
        private final float[] x = new float[4];
        private final double[] age = new double[4];

        BuilderUpdate(LithostratUnit.Builder builder) {
            this.builder = builder;
            for (int i = 0; i < this.x.length; ++i) {
                this.x[i] = builder.getX(i);
                this.age[i] = builder.getAge(i);
            }
        }

        public void doEdit() throws SBException, SQLException {
        }

        public void undo() {
            this.swap();
            super.undo();
        }

        public void redo() {
            this.swap();
            super.redo();
        }

        private void swap() {
            float[] xCopy = Arrays.copyOf(this.x, 4);
            double[] ageCopy = Arrays.copyOf(this.age, 4);
            for (int i = 0; i < this.x.length; ++i) {
                this.x[i] = this.builder.getX(i);
                this.age[i] = this.builder.getAge(i);
            }
            this.builder.x(xCopy);
            this.builder.age(ageCopy);
        }
    }
}

