/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.wellinterp;

import com.stratadata.model3.scheme.Boundary;
import javax.swing.JTable;
import jsbugs.model2.wellinterp.InterpItemTableModel;
import jsbugs.table.DepthRenderer;
import model3.Fault;
import model3.SBdb;
import model3.Sample;
import util.DepthUtils;

public class FaultsTableModel
extends InterpItemTableModel<Fault> {
    private static final String[] COL_TITLES = new String[]{"Sample", "Type", "Label", "Throw"};
    private static final int[] COL_WIDTHS = new int[]{30, 30, 30, 30};
    private static final int COL_SAMPLE = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_LABEL = 2;
    private static final int COL_THROW = 3;
    private DepthRenderer depthRenderer;

    public FaultsTableModel() {
        super(Fault.class);
    }

    @Override
    public int getColumnCount() {
        return COL_TITLES.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Fault fault = (Fault)this.getItem(row);
        switch (col) {
            case 0: {
                return fault.getSample();
            }
            case 1: {
                return fault.getBnd();
            }
            case 3: {
                return fault.getBnd().isFault() ? Double.valueOf(DepthUtils.convFromM((double)fault.getThrow(), (char)this.getUnits())) : null;
            }
            case 2: {
                return fault.getLabel();
            }
        }
        return "";
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Sample.class;
            }
            case 1: {
                return Boundary.class;
            }
            case 3: {
                return Double.class;
            }
        }
        return String.class;
    }

    @Override
    public void setupTable(JTable jTableFaults, SBdb sbdb) {
        this.init(jTableFaults, sbdb);
        jTableFaults.getColumnModel().getColumn(0).setCellRenderer(this.initTopSampleRenderer());
        this.depthRenderer = new DepthRenderer();
        jTableFaults.getColumnModel().getColumn(3).setCellRenderer(this.depthRenderer);
        this.restoreColumnOrder(jTableFaults);
    }

    @Override
    public String[] getColumnTitles() {
        return COL_TITLES;
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return COL_WIDTHS;
    }

    @Override
    public String getPrefString() {
        return "TMFAULTS";
    }

    @Override
    public String getPrefOrderString() {
        return "TOFAULTS";
    }

    @Override
    public final String getAutoResizeString() {
        return "TARFAULTS";
    }
}

