/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.wellinterp;

import java.util.List;
import jsbugs.TableModelSB;
import jsbugs.table.SampleRenderer;
import model3.wellinterp.InterpItem;
import model3.wellinterp.InterpListViewer;

public abstract class InterpItemTableModel<T extends InterpItem>
extends TableModelSB {
    private final Class<? extends InterpItem> typeParameterClass;
    private InterpListViewer<T> items;
    private SampleRenderer topSampleRenderer;
    private SampleRenderer baseSampleRenderer;
    private char units = (char)77;

    public InterpItemTableModel(Class<? extends InterpItem> typeParameterClass) {
        this.typeParameterClass = typeParameterClass;
    }

    public Class<? extends InterpItem> getTypeParameterClass() {
        return this.typeParameterClass;
    }

    public void setItems(InterpListViewer<T> items) {
        this.items = items;
    }

    public T getItem(int row) {
        if (row > this.items.size() - 1) {
            return null;
        }
        return this.items.get(row);
    }

    public List<T> getItems() {
        return this.items.getList();
    }

    @Override
    public int getRowCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public int indexOf(T item) {
        if (this.items == null) {
            return -1;
        }
        return this.items.getList().indexOf(item);
    }

    SampleRenderer initTopSampleRenderer() {
        if (this.topSampleRenderer != null) {
            throw new IllegalStateException("Top sample renderer already initialised");
        }
        this.topSampleRenderer = new SampleRenderer(this.units);
        return this.topSampleRenderer;
    }

    SampleRenderer initBaseSampleRenderer() {
        if (this.baseSampleRenderer != null) {
            throw new IllegalStateException("Base sample renderer already initialised");
        }
        this.baseSampleRenderer = new SampleRenderer(this.units);
        return this.baseSampleRenderer;
    }

    public void setUnits(char units) {
        if (units != this.units) {
            this.units = units;
            if (this.topSampleRenderer != null) {
                this.topSampleRenderer.setUnits(units);
            }
            if (this.baseSampleRenderer != null) {
                this.baseSampleRenderer.setUnits(units);
            }
        }
    }

    public char getUnits() {
        return this.units;
    }
}

