/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.organiser;

import com.stratadata.util.ui.HelpUtils;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Biocom;
import model3.IGDIntervalZone;
import model3.InterpHdr;
import model3.Lastval;
import model3.SBdb;
import model3.SQPick;
import model3.Smpdtl;
import model3.Surface;
import model3.TaxonOcc;
import model3.Well;
import model3.WellInterp;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogExportWord
extends JDialog {
    JFileChooser jFileChooser = null;
    SBdb db;
    Set<Integer> dataTypes;
    List<Well> wells;
    InterpHdr interp;
    char units;
    private ButtonGroup buttonGroupFormat;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectFile;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JTextField jTextFieldFile;

    public DialogExportWord(Frame parent, boolean modal, SBdb db, Set<Integer> dataTypes, List<Well> wells, InterpHdr interp, char units) {
        super(parent, modal);
        this.db = db;
        this.dataTypes = dataTypes;
        this.wells = wells;
        this.interp = interp;
        this.units = units;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Save Word File Options");
        if (this.jFileChooser == null) {
            this.jFileChooser = new JFileChooser();
            SbugsFileFilter filter = new SbugsFileFilter();
            filter.addExtension("docx");
            filter.setDescription("Microsoft Word");
            this.jFileChooser.setFileFilter((FileFilter)filter);
            this.jFileChooser.setAcceptAllFileFilterUsed(false);
            File setDir = null;
            try {
                setDir = new File(Lastval.getString(this.db, "WINDOCFILE", "UNXDOCFILE"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
                setDir = new File(".");
            }
            try {
                this.jFileChooser.setCurrentDirectory(setDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.buttonGroupFormat = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldFile = new JTextField();
        this.jButtonSelectFile = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportWord this$0;
            {
                DialogExportWord dialogExportWord = this$0;
                Objects.requireNonNull(dialogExportWord);
                this.this$0 = dialogExportWord;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportWord this$0;
            {
                DialogExportWord dialogExportWord = this$0;
                Objects.requireNonNull(dialogExportWord);
                this.this$0 = dialogExportWord;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportWord this$0;
            {
                DialogExportWord dialogExportWord = this$0;
                Objects.requireNonNull(dialogExportWord);
                this.this$0 = dialogExportWord;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel1.setText("File:");
        this.jTextFieldFile.setEditable(false);
        this.jTextFieldFile.setBackground(new Color(255, 255, 204));
        this.jButtonSelectFile.setText("...");
        this.jButtonSelectFile.setToolTipText("Select a file");
        this.jButtonSelectFile.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportWord this$0;
            {
                DialogExportWord dialogExportWord = this$0;
                Objects.requireNonNull(dialogExportWord);
                this.this$0 = dialogExportWord;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectFileActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Format", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 417, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 124, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectFile, -2, 33, -2)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFile, -2, -1, -2).addComponent(this.jButtonSelectFile).addComponent(this.jLabel1)).addGap(35, 35, 35).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogexportword.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String fileName = this.jTextFieldFile.getText().trim();
        if (fileName.isEmpty()) {
            JOptionPane.showMessageDialog(this, "File name blank", this.getTitle(), 2);
            return;
        }
        File file = new File(fileName);
        if (file.exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
            return;
        }
        try {
            Lastval.putString(this.db, "WINDOCFILE", "UNXDOCFILE", fileName);
            this.db.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.export(file);
            JOptionPane.showMessageDialog(this, "File written", this.getTitle(), 1);
            this.dispose();
        }
        catch (IOException | SQLException | SBException ex) {
            SbugsExceptionHandler.showDialogStackError(ex, this);
        }
    }

    private void export(File file) throws IOException, SQLException, SBException {
        XWPFDocument document = new XWPFDocument();
        FileOutputStream out = new FileOutputStream(file);
        char expUnits = 'M';
        Iterator<Well> it = this.wells.iterator();
        boolean first = true;
        while (it.hasNext()) {
            Well well = it.next();
            XWPFParagraph paragraph = document.createParagraph();
            if (!first) {
                paragraph.createRun().addBreak(BreakType.PAGE);
            }
            first = false;
            XWPFRun runWell = paragraph.createRun();
            runWell.setBold(true);
            runWell.setFontSize(14);
            runWell.setUnderline(UnderlinePatterns.SINGLE);
            runWell.setText(well.getWellName());
            runWell.addCarriageReturn();
            XWPFRun runWellInfo = paragraph.createRun();
            runWellInfo.setBold(false);
            runWellInfo.setText("Country: " + well.getHeader().getCountry());
            runWellInfo.addCarriageReturn();
            runWellInfo.setText("Field: " + well.getHeader().getField());
            runWellInfo.addCarriageReturn();
            runWellInfo.setText("TD: " + SB.floatString((double)DepthUtils.convFromM((double)well.getHeader().getTD(), (char)well.getWellUnits()), (int)2));
            runWellInfo.addCarriageReturn();
            runWellInfo.addBreak();
            if (this.units == 'D') {
                expUnits = well.getWellUnits();
            }
            WellInterp wellInterp = well.getInterp(this.interp.getInterpID());
            List<SQPick> picks = wellInterp.getSQPicks();
            LinkedList<Integer> orderedTypes = new LinkedList<Integer>();
            if (this.dataTypes.contains(10)) {
                orderedTypes.add(10);
            }
            if (this.dataTypes.contains(11)) {
                orderedTypes.add(11);
            }
            if (this.dataTypes.contains(3)) {
                orderedTypes.add(3);
            }
            for (Integer i : this.dataTypes) {
                if (orderedTypes.contains(i)) continue;
                orderedTypes.add(i);
            }
            for (Integer i : orderedTypes) {
                switch (i) {
                    case 10: 
                    case 11: 
                    case 12: {
                        XWPFRun runZonesHeader = document.createParagraph().createRun();
                        runZonesHeader.setUnderline(UnderlinePatterns.SINGLE);
                        runZonesHeader.setBold(true);
                        runZonesHeader.setText(SBdb.dTypeNames[i]);
                        runZonesHeader.addCarriageReturn();
                        runZonesHeader.addCarriageReturn();
                        XWPFTable table = document.createTable();
                        List<IGDIntervalZone> zones = wellInterp.getIGDList(IGDIntervalZone.dType2IGDtype(i));
                        XWPFTableRow tableRow = table.getRow(0);
                        XWPFParagraph p1 = (XWPFParagraph)table.getRow(0).getCell(0).getParagraphs().get(0);
                        XWPFRun r1 = p1.createRun();
                        r1.setBold(true);
                        r1.setText("Interval");
                        XWPFParagraph p2 = (XWPFParagraph)tableRow.addNewTableCell().getParagraphs().get(0);
                        XWPFRun r2 = p2.createRun();
                        r2.setBold(true);
                        r2.setText("Top Sample");
                        XWPFParagraph p3 = (XWPFParagraph)tableRow.addNewTableCell().getParagraphs().get(0);
                        XWPFRun r3 = p3.createRun();
                        r3.setBold(true);
                        r3.setText("Base Sample");
                        if (zones != null && !zones.isEmpty()) {
                            for (int zi = 0; zi < zones.size(); ++zi) {
                                IGDIntervalZone zone = zones.get(zi);
                                tableRow = table.createRow();
                                if (zone.getUnitColour(true) != null) {
                                    try {
                                        tableRow.getCell(0).setColor(this.conv2Hex(zone.getUnitColour(true)));
                                        tableRow.getCell(1).setColor(this.conv2Hex(zone.getUnitColour(true)));
                                        tableRow.getCell(2).setColor(this.conv2Hex(zone.getUnitColour(true)));
                                    }
                                    catch (XmlValueOutOfRangeException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                tableRow.getCell(0).setText(zone.toString());
                                tableRow.getCell(1).setText(zone.getTopSample().toString(expUnits, false, false, false, false, null, null) + " " + zone.getTopSample().getTypeString());
                                tableRow.getCell(2).setText(zone.getBaseSample().toString(expUnits, false, false, false, false, null, null) + " " + zone.getBaseSample().getTypeString());
                                for (SQPick pick : picks) {
                                    if (pick.getSurfaceType() != Surface.SurfaceType.SB || !(pick.getSample().getDepth() >= zone.getBaseSample().getDepth()) || zones.get(zi + 1) != null && !(pick.getSample().getDepth() <= zones.get(zi + 1).getTopSample().getDepth())) continue;
                                    tableRow = table.createRow();
                                    tableRow.removeCell(2);
                                    tableRow.removeCell(1);
                                    tableRow.getCell(0).setText("~~~~~~~~" + pick.toString() + "~~~~~~~~~~~");
                                }
                            }
                        }
                        XWPFRun run = document.createParagraph().createRun();
                        run.addCarriageReturn();
                        run.addBreak();
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 7: {
                        XWPFRun runZonesHeader = document.createParagraph().createRun();
                        runZonesHeader.setUnderline(UnderlinePatterns.SINGLE);
                        runZonesHeader.setBold(true);
                        runZonesHeader.setText(SBdb.dTypeNames[i]);
                        runZonesHeader.addCarriageReturn();
                        runZonesHeader.addCarriageReturn();
                        XWPFTable table = document.createTable();
                        List<Biocom> comments = wellInterp.getComments();
                        XWPFTableRow tableRow = table.getRow(0);
                        XWPFParagraph p1 = (XWPFParagraph)table.getRow(0).getCell(0).getParagraphs().get(0);
                        XWPFRun r1 = p1.createRun();
                        r1.setBold(true);
                        r1.setText("Depth");
                        XWPFParagraph p2 = (XWPFParagraph)tableRow.addNewTableCell().getParagraphs().get(0);
                        XWPFRun r2 = p2.createRun();
                        r2.setBold(true);
                        r2.setText("Discipline");
                        XWPFParagraph p3 = (XWPFParagraph)tableRow.addNewTableCell().getParagraphs().get(0);
                        XWPFRun r3 = p3.createRun();
                        r3.setBold(true);
                        r3.setText("Event/Comment");
                        if (comments != null && !comments.isEmpty()) {
                            for (Biocom comment : comments) {
                                tableRow = table.createRow();
                                tableRow.getCell(0).setText(comment.getTopSample().toString(expUnits, false, false, false, false, null, null) + " " + comment.getTopSample().getTypeString());
                                tableRow.getCell(1).setText("" + comment.getDiscID());
                                tableRow.getCell(2).setText(comment.getText());
                            }
                        }
                        XWPFRun run = document.createParagraph().createRun();
                        run.addCarriageReturn();
                        run.addBreak();
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        XWPFRun run;
                        XWPFParagraph p2;
                        XWPFParagraph p1;
                        XWPFRun runDiscHeader = document.createParagraph().createRun();
                        runDiscHeader.setUnderline(UnderlinePatterns.SINGLE);
                        runDiscHeader.setBold(true);
                        runDiscHeader.setText(SBdb.dTypeNames[i]);
                        runDiscHeader.addCarriageReturn();
                        runDiscHeader.addCarriageReturn();
                        List<Smpdtl> dtls = well.getAnalyses(SBdb.dt2discID(i), null, 0);
                        for (Smpdtl dtl : dtls) {
                            paragraph = document.createParagraph();
                            XWPFRun runSmpdtl = paragraph.createRun();
                            runSmpdtl.setText(dtl.getSample().toString());
                            runSmpdtl.addCarriageReturn();
                            runSmpdtl.setText(String.valueOf(dtl.getDiscipline()) + " analysed by: " + dtl.getAnalystAbr());
                            runSmpdtl.addCarriageReturn();
                            runSmpdtl.setText("Taxon list: ");
                            int row = 0;
                            paragraph = document.createParagraph();
                            XWPFTable tabled = document.createTable();
                            tabled.setCellMargins(50, 50, 50, 50);
                            tabled.setWidth(800);
                            tabled.getRow(0).addNewTableCell();
                            for (TaxonOcc occ : dtl.getOccurSorted()) {
                                if (row > 0) {
                                    tabled.createRow();
                                }
                                XWPFTableRow tableRowD = tabled.getRow(row);
                                p1 = (XWPFParagraph)tableRowD.getCell(0).getParagraphs().get(0);
                                XWPFRun runOcc = p1.createRun();
                                runOcc.setItalic(true);
                                runOcc.setText(occ.getTaxon().toString());
                                runOcc.setItalic(false);
                                p2 = (XWPFParagraph)tableRowD.getCell(1).getParagraphs().get(0);
                                XWPFRun runOccAbund = p2.createRun();
                                if (occ.getSubAbund().isEmpty()) {
                                    runOccAbund.setText(occ.getSplitCountString());
                                } else {
                                    runOccAbund.setText(occ.getSubAbund());
                                }
                                runOccAbund.setText(" " + occ.getAllQualifiers());
                                ++row;
                            }
                            run = document.createParagraph().createRun();
                            run.addCarriageReturn();
                            run.addBreak();
                        }
                        break;
                    }
                }
                paragraph.createRun().addCarriageReturn();
                paragraph.createRun().addBreak();
            }
        }
        document.write((OutputStream)out);
        out.close();
    }

    private String conv2Hex(Color c) {
        return (c.getRed() > 0 ? Integer.toHexString(c.getRed()) : "00") + (c.getGreen() > 0 ? Integer.toHexString(c.getGreen()) : "00") + (c.getBlue() > 0 ? Integer.toHexString(c.getBlue()) : "00");
    }

    private void jButtonSelectFileActionPerformed(ActionEvent evt) {
        if (0 == this.jFileChooser.showSaveDialog(this)) {
            Object path = this.jFileChooser.getSelectedFile().getPath();
            if (!((String)path).toLowerCase().endsWith(".doc") && !((String)path).toLowerCase().endsWith(".docx")) {
                path = (String)path + ".docx";
            }
            this.jTextFieldFile.setText((String)path);
        }
    }
}

